/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.client;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureInfo;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.client.FeathrClient$;
import com.linkedin.feathr.offline.config.ConflictsAutoCorrectionSetting;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.FeathrConfigLoader$;
import com.linkedin.feathr.offline.config.FeatureGroupsGenerator$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.generation.DataFrameFeatureGenerator;
import com.linkedin.feathr.offline.generation.FeatureGenKeyTagAnalyzer$;
import com.linkedin.feathr.offline.generation.StreamingFeatureGenerator;
import com.linkedin.feathr.offline.job.FeatureGenSpec;
import com.linkedin.feathr.offline.job.JoinJobContext;
import com.linkedin.feathr.offline.job.JoinJobContext$;
import com.linkedin.feathr.offline.join.DataFrameFeatureJoiner;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.logical.LogicalPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.util.AclCheckUtils$;
import com.linkedin.feathr.offline.util.AnchorUtils$;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata$;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import com.linkedin.feathr.sparkcommon.OutputProcessor;
import java.io.Serializable;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001\u0002*T\u0001yC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\te\u0002\u0011\t\u0011)A\u0005g\"A\u0011\u0010\u0001B\u0001B\u0003%!\u0010\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003\u007f\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003o\u0001!\u0011!Q\u0001\n\u0005e\u0002\u0002CA(\u0001\u0011\u0005Q+!\u0015\t\u0013\u0005\r\u0004A1A\u0005\n\u0005\u0015\u0004\u0002CA<\u0001\u0001\u0006I!a\u001a\u0006\r\u0005e\u0004\u0001AA>\u0011)\t\t\n\u0001b\u0001\n\u0003)\u00161\u0013\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002\u0016\"Q\u0011Q\u0016\u0001C\u0002\u0013\u0005Q+a,\t\u0011\u0005}\u0006\u0001)A\u0005\u0003cC!\"!1\u0001\u0005\u0004%\t!VAJ\u0011!\t\u0019\r\u0001Q\u0001\n\u0005U\u0005BCAc\u0001\t\u0007I\u0011A+\u0002\u0014\"A\u0011q\u0019\u0001!\u0002\u0013\t)\n\u0003\u0006\u0002J\u0002\u0011\r\u0011\"\u0001V\u0003_C\u0001\"a3\u0001A\u0003%\u0011\u0011\u0017\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011%\u0011Y\u0001AI\u0001\n\u0003\u0011i\u0001C\u0004\u0003$\u0001!\tA!\n\t\u000f\tm\u0002\u0001\"\u0003\u0003>!9!q\t\u0001\u0005\n\t%\u0003\u0002\u0003B)\u0001\u0011\u0005QKa\u0015\t\u0011\t-\u0004\u0001\"\u0001V\u0005[BqA!(\u0001\t\u0013\u0011y\n\u0003\u0005\u0003*\u0002!\t!\u0016BV\u0011!\u0011i\f\u0001C\u0001+\n}\u0006B\u0003Bk\u0001E\u0005I\u0011A+\u0003X\"A!1\u001c\u0001\u0005\u0002U\u0013i\u000e\u0003\u0005\u0003`\u0002!\t!\u0016Bq\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005KDqA!=\u0001\t\u0013\u0011\u0019pB\u0004\u0003|NC\tA!@\u0007\rI\u001b\u0006\u0012\u0001B\u0000\u0011\u001d\ty%\nC\u0001\u0007\u0003Aqaa\u0001&\t\u0003\u0019)A\u0002\u0004\u0004\f\u0015\u00021Q\u0002\u0005\tK\"\u0012\t\u0011)A\u0005M\"A\u0011q\n\u0015\u0005\u0002\u0015\u001ay\u0001C\u0005\u0004\u0014!\u0012\r\u0011\"\u0003\u0004\u0016!A1Q\u0004\u0015!\u0002\u0013\u00199\u0002C\u0005\u0004 !\u0002\r\u0011\"\u0003\u0004\"!I11\u0005\u0015A\u0002\u0013%1Q\u0005\u0005\t\u0007WA\u0003\u0015)\u0003\u0003v\"I1Q\u0006\u0015A\u0002\u0013%1\u0011\u0005\u0005\n\u0007_A\u0003\u0019!C\u0005\u0007cA\u0001b!\u000e)A\u0003&!Q\u001f\u0005\n\u0007oA\u0003\u0019!C\u0005\u0007CA\u0011b!\u000f)\u0001\u0004%Iaa\u000f\t\u0011\r}\u0002\u0006)Q\u0005\u0005kD\u0011b!\u0011)\u0001\u0004%Ia!\t\t\u0013\r\r\u0003\u00061A\u0005\n\r\u0015\u0003\u0002CB%Q\u0001\u0006KA!>\t\u0013\r-\u0003\u00061A\u0005\n\r5\u0003\"CB)Q\u0001\u0007I\u0011BB*\u0011!\u00199\u0006\u000bQ!\n\r=\u0003\"CA\u0007Q\u0001\u0007I\u0011BB-\u0011%\u0019Y\u0006\u000ba\u0001\n\u0013\u0019i\u0006\u0003\u0005\u0004b!\u0002\u000b\u0015BA\b\u0011%\t9\u0004\u000ba\u0001\n\u0013\u0019\u0019\u0007C\u0005\u0004f!\u0002\r\u0011\"\u0003\u0004h!A11\u000e\u0015!B\u0013\tI\u0004C\u0004\u0004n!\"\taa\u001c\t\u000f\rM\u0004\u0006\"\u0001\u0004v!911\u000f\u0015\u0005\u0002\rm\u0004bBBAQ\u0011\u000511\u0011\u0005\b\u0007\u0003CC\u0011ABD\u0011\u001d\u0019i\t\u000bC\u0001\u0007\u001fCqa!$)\t\u0003\u0019\u0019\nC\u0004\u0004\u0018\"\"\ta!'\t\u000f\r]\u0005\u0006\"\u0001\u0004\u001e\"91\u0011\u0015\u0015\u0005\u0002\r\r\u0006bBBQQ\u0011\u00051q\u0015\u0005\t\u0007WCC\u0011A+\u0004.\"A11\u0016\u0015\u0005\u0002U\u001b\u0019\fC\u0004\u00048\"\"\ta!/\t\u000f\r}\u0006\u0006\"\u0001\u0004B\"A11\u0019\u0015\u0005\u0002U\u001b)M\u0001\u0007GK\u0006$\bN]\"mS\u0016tGO\u0003\u0002U+\u000611\r\\5f]RT!AV,\u0002\u000f=4g\r\\5oK*\u0011\u0001,W\u0001\u0007M\u0016\fG\u000f\u001b:\u000b\u0005i[\u0016\u0001\u00037j].,G-\u001b8\u000b\u0003q\u000b1aY8n\u0007\u0001\u0019\"\u0001A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0003\t\fQa]2bY\u0006L!\u0001Z1\u0003\r\u0005s\u0017PU3g\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t9\u0007/D\u0001i\u0015\tI'.A\u0002tc2T!a\u001b7\u0002\u000bM\u0004\u0018M]6\u000b\u00055t\u0017AB1qC\u000eDWMC\u0001p\u0003\ry'oZ\u0005\u0003c\"\u0014Ab\u00159be.\u001cVm]:j_:\fQBZ3biV\u0014Xm\u0012:pkB\u001c\bC\u0001;x\u001b\u0005)(B\u0001<V\u0003\u001dawnZ5dC2L!\u0001_;\u0003\u001b\u0019+\u0017\r^;sK\u001e\u0013x.\u001e9t\u00039awnZ5dC2\u0004F.\u00198oKJ\u0004\"\u0001^>\n\u0005q,(!F'vYRL7\u000b^1hK*{\u0017N\u001c)mC:tWM]\u0001\u0015M\u0016\fG/\u001e:f\u000fJ|W\u000f]:Va\u0012\fG/\u001a:\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u001d\u0019x.\u001e:dKNT1!a\u0002V\u0003\u0019\u0019wN\u001c4jO&!\u00111BA\u0001\u0005Q1U-\u0019;ve\u0016<%o\\;qgV\u0003H-\u0019;fe\u0006\u0001B-\u0019;b!\u0006$\b\u000eS1oI2,'o\u001d\t\u0007\u0003#\t\t#a\n\u000f\t\u0005M\u0011Q\u0004\b\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D/\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0017bAA\u0010C\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003K\u0011A\u0001T5ti*\u0019\u0011qD1\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005A\u0011mY2fgN|'OC\u0002\u00022U\u000baa]8ve\u000e,\u0017\u0002BA\u001b\u0003W\u0011q\u0002R1uCB\u000bG\u000f\u001b%b]\u0012dWM]\u0001\f[Z,GnQ8oi\u0016DH\u000fE\u0003a\u0003w\ty$C\u0002\u0002>\u0005\u0014aa\u00149uS>t\u0007\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\ba2,x-\u001b8t\u0015\r\tI%V\u0001\u0005[Z,G.\u0003\u0003\u0002N\u0005\r#\u0001\t$fCRD'/\u0012=qe\u0016\u001c8/[8o\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDCDA*\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011\r\t\u0004\u0003+\u0002Q\"A*\t\u000b\u0015<\u0001\u0019\u00014\t\u000bI<\u0001\u0019A:\t\u000be<\u0001\u0019\u0001>\t\u000bu<\u0001\u0019\u0001@\t\u000f\u00055q\u00011\u0001\u0002\u0010!9\u0011qG\u0004A\u0002\u0005e\u0012a\u00017pOV\u0011\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u0015awn\u001a\u001bk\u0015\r\t\t\b\\\u0001\bY><w-\u001b8h\u0013\u0011\t)(a\u001b\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0003#-+\u0017\u0010V1h'R\u0014\u0018N\\4UkBdW\r\u0005\u0004\u0002\u0012\u0005u\u0014\u0011Q\u0005\u0005\u0003\u007f\n)CA\u0002TKF\u0004B!a!\u0002\f:!\u0011QQAD!\r\t)\"Y\u0005\u0004\u0003\u0013\u000b\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0006=%AB*ue&twMC\u0002\u0002\n\u0006\f1#\u00197m\u0003:\u001c\u0007n\u001c:fI\u001a+\u0017\r^;sKN,\"!!&\u0011\u0011\u0005\r\u0015qSAA\u00037KA!!'\u0002\u0010\n\u0019Q*\u00199\u0011\t\u0005u\u0015qU\u0007\u0003\u0003?SA!!)\u0002$\u00069a-Z1ukJ,'bAAS+\u0006A\u0011M\\2i_J,G-\u0003\u0003\u0002*\u0006}%a\u0006$fCR,(/Z!oG\"|'oV5uQN{WO]2f\u0003Q\tG\u000e\\!oG\"|'/\u001a3GK\u0006$XO]3tA\u0005\u0011\u0012\r\u001c7EKJLg/\u001a3GK\u0006$XO]3t+\t\t\t\f\u0005\u0005\u0002\u0004\u0006]\u0015\u0011QAZ!\u0011\t),a/\u000e\u0005\u0005]&bAA]+\u00069A-\u001a:jm\u0016$\u0017\u0002BA_\u0003o\u0013a\u0002R3sSZ,GMR3biV\u0014X-A\nbY2$UM]5wK\u00124U-\u0019;ve\u0016\u001c\b%\u0001\fbY2\u0004\u0016m]:uQJ|Wo\u001a5GK\u0006$XO]3t\u0003]\tG\u000e\u001c)bgN$\bN]8vO\"4U-\u0019;ve\u0016\u001c\b%\u0001\u000bbY2<\u0016N\u001c3po\u0006;wMR3biV\u0014Xm]\u0001\u0016C2dw+\u001b8e_^\fum\u001a$fCR,(/Z:!\u0003I\tG\u000e\\*fc*{\u0017N\u001c$fCR,(/Z:\u0002'\u0005dGnU3r\u0015>LgNR3biV\u0014Xm\u001d\u0011\u0002\u0019)|\u0017N\u001c$fCR,(/Z:\u0015\u0011\u0005E\u0017Q\\Au\u0003[\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/,\u0016\u0001B;uS2LA!a7\u0002V\n12\u000b]1sW\u001a+\u0017\r^;sSj,G\rR1uCN,G\u000fC\u0004\u0002`V\u0001\r!!9\u0002\u0015)|\u0017N\\\"p]\u001aLw\r\u0005\u0003\u0002d\u0006\u0015XBAA\u0003\u0013\u0011\t9/!\u0002\u0003#\u0019+\u0017\r^;sK*{\u0017N\\\"p]\u001aLw\rC\u0004\u0002lV\u0001\r!!5\u0002\u000f=\u00147\u000fR1uC\"I\u0011q^\u000b\u0011\u0002\u0003\u0007\u0011\u0011_\u0001\u000bU>\u00147i\u001c8uKb$\b\u0003BAz\u0003sl!!!>\u000b\u0007\u0005]X+A\u0002k_\nLA!a?\u0002v\nq!j\\5o\u0015>\u00147i\u001c8uKb$\bfA\u000b\u0002\u0000B!!\u0011\u0001B\u0004\u001b\t\u0011\u0019AC\u0002\u0003\u0006]\u000baaY8n[>t\u0017\u0002\u0002B\u0005\u0005\u0007\u00111\"\u00138uKJt\u0017\r\\!qS\u00061\"n\\5o\r\u0016\fG/\u001e:fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0010)\"\u0011\u0011\u001fB\tW\t\u0011\u0019\u0002\u0005\u0003\u0003\u0016\t}QB\u0001B\f\u0015\u0011\u0011IBa\u0007\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u000fC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005\"q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E4f]\u0016\u0014\u0018\r^3GK\u0006$XO]3t)\u0011\u00119Ca\f\u0011\u0011\u0005\r\u0015q\u0013B\u0015\u0003#\u0004BA!\u0001\u0003,%!!Q\u0006B\u0002\u0005E!\u0016mZ4fI\u001a+\u0017\r^;sK:\u000bW.\u001a\u0005\b\u0005c9\u0002\u0019\u0001B\u001a\u000391W-\u0019;ve\u0016<UM\\*qK\u000e\u0004B!a=\u00036%!!qGA{\u000591U-\u0019;ve\u0016<UM\\*qK\u000eD3aFA\u0000\u0003-I7o\u0015;sK\u0006l\u0017N\\4\u0015\t\t}\"Q\t\t\u0004A\n\u0005\u0013b\u0001B\"C\n9!i\\8mK\u0006t\u0007b\u0002B\u00191\u0001\u0007!1G\u0001\u0012aJ,\u0007/\u0019:f\u000bb,7-\u001e;f\u000b:4HC\u0001B&!\r\u0001'QJ\u0005\u0004\u0005\u001f\n'\u0001B+oSR\fAcZ3u\u00032dg)Z1ukJ,7k\\;sG\u0016\u001cH\u0003\u0002B+\u0005?\u0002b!!\u0005\u0002\"\t]\u0003\u0003\u0002B-\u00057j!!a\f\n\t\tu\u0013q\u0006\u0002\u000b\t\u0006$\u0018mU8ve\u000e,\u0007b\u0002B15\u0001\u0007!1M\u0001\u0012e\u0016\fX/Z:uK\u00124U-\u0019;ve\u0016\u001c\bCBA\t\u0003{\u0012)\u0007\u0005\u0003\u0003\u0002\t\u001d\u0014\u0002\u0002B5\u0005\u0007\u0011ACS8j]&twMR3biV\u0014X\rU1sC6\u001c\u0018\u0001\u00063p\u0015>Lgn\u00142t\u0003:$g)Z1ukJ,7\u000f\u0006\u0005\u0003p\t]%\u0011\u0014BN!\u001d\u0001'\u0011\u000fB;\u0005#K1Aa\u001db\u0005\u0019!V\u000f\u001d7feA!!q\u000fBF\u001d\u0011\u0011IH!#\u000f\t\tm$q\u0011\b\u0005\u0005{\u0012)I\u0004\u0003\u0003\u0000\t\re\u0002BA\u000b\u0005\u0003K\u0011a\\\u0005\u0003[:L!a\u001b7\n\u0005%T\u0017bAA\u0010Q&!!Q\u0012BH\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002 !\u0004BA!\u0001\u0003\u0014&!!Q\u0013B\u0002\u0005\u0019AU-\u00193fe\"9\u0011q\\\u000eA\u0002\u0005\u0005\bbBAx7\u0001\u0007\u0011\u0011\u001f\u0005\b\u0003W\\\u0002\u0019\u0001B;\u0003a1\u0017N\u001c3D_:4G.[2u\r\u0016\fG/\u001e:f\u001d\u0006lWm\u001d\u000b\u0007\u0003w\u0012\tK!*\t\u000f\t\rF\u00041\u0001\u0003d\u0005\t2.Z=UC\u001e<W\r\u001a$fCR,(/Z:\t\u000f\t\u001dF\u00041\u0001\u0002|\u0005Qa-[3mI:\u000bW.Z:\u0002%I,g.Y7f\r\u0016\fG/\u001e:f\u001d\u0006lWm\u001d\u000b\u000b\u0005_\u0012iK!-\u00036\ne\u0006b\u0002BX;\u0001\u0007!QO\u0001\u0003I\u001aDqAa-\u001e\u0001\u0004\u0011\t*\u0001\u0004iK\u0006$WM\u001d\u0005\b\u0005ok\u0002\u0019AA>\u0003Q\u0019wN\u001c4mS\u000e$h)Z1ukJ,g*Y7fg\"9!1X\u000fA\u0002\u0005\u0005\u0015AB:vM\u001aL\u00070\u0001\tk_&tg)Z1ukJ,7/Q:E\rRQ!q\u000eBa\u0005\u0007\u0014)M!3\t\u000f\u0005}g\u00041\u0001\u0002b\"9!1\u0015\u0010A\u0002\t\r\u0004b\u0002Bd=\u0001\u0007!QO\u0001\u0005Y\u00164G\u000fC\u0005\u0003Lz\u0001\n\u00111\u0001\u0003N\u00069\"o\\<CY>|WNR5mi\u0016\u0014H\u000b\u001b:fg\"|G\u000e\u001a\t\u0006A\u0006m\"q\u001a\t\u0004A\nE\u0017b\u0001BjC\n\u0019\u0011J\u001c;\u00025)|\u0017N\u001c$fCR,(/Z:Bg\u00123E\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\te'\u0006\u0002Bg\u0005#\t\u0001cZ3u\r\u0016\fG/\u001e:f\u000fJ|W\u000f]:\u0015\u0003M\f\u0011cZ3u\u0019><\u0017nY1m!2\fgN\\3s)\u0005Q\u0018!F:ue&tw-\u001b4z\r\u0016\fG/\u001e:f\u001d\u0006lWm\u001d\u000b\u0005\u0003\u0003\u00139\u000fC\u0004\u0003j\n\u0002\rAa;\u0002\u000f9\fW.Z*fiB1\u00111\u0011Bw\u0003\u0003KAAa<\u0002\u0010\n\u00191+\u001a;\u0002-\u0019Lg\u000eZ%om\u0006d\u0017\u000e\u001a$fCR,(/\u001a*fMN$BA!>\u0003xB1\u0011\u0011CA\u0011\u0003\u0003CqA!?$\u0001\u0004\u0011\u0019'\u0001\u0005gK\u0006$XO]3t\u000311U-\u0019;ie\u000ec\u0017.\u001a8u!\r\t)&J\n\u0003K}#\"A!@\u0002\u000f\t,\u0018\u000e\u001c3feR!1qABf!\r\u0019I\u0001K\u0007\u0002K\t9!)^5mI\u0016\u00148C\u0001\u0015`)\u0011\u00199a!\u0005\t\u000b\u0015T\u0003\u0019\u00014\u0002%\u0019,\u0017\r\u001e5s\u0007>tg-[4M_\u0006$WM]\u000b\u0003\u0007/\u0001B!a9\u0004\u001a%!11DA\u0003\u000511U-\u0019;ie\u000e{gNZ5h\u0003M1W-\u0019;ie\u000e{gNZ5h\u0019>\fG-\u001a:!\u0003)1W-\u0019;ve\u0016$UMZ\u000b\u0003\u0005k\faBZ3biV\u0014X\rR3g?\u0012*\u0017\u000f\u0006\u0003\u0003L\r\u001d\u0002\"CB\u0015]\u0005\u0005\t\u0019\u0001B{\u0003\rAH%M\u0001\fM\u0016\fG/\u001e:f\t\u00164\u0007%\u0001\tm_\u000e\fGn\u0014<feJLG-\u001a#fM\u0006!Bn\\2bY>3XM\u001d:jI\u0016$UMZ0%KF$BAa\u0013\u00044!I1\u0011F\u0019\u0002\u0002\u0003\u0007!Q_\u0001\u0012Y>\u001c\u0017\r\\(wKJ\u0014\u0018\u000eZ3EK\u001a\u0004\u0013A\u00044fCR,(/\u001a#fMB\u000bG\u000f[\u0001\u0013M\u0016\fG/\u001e:f\t\u00164\u0007+\u0019;i?\u0012*\u0017\u000f\u0006\u0003\u0003L\ru\u0002\"CB\u0015i\u0005\u0005\t\u0019\u0001B{\u0003=1W-\u0019;ve\u0016$UM\u001a)bi\"\u0004\u0013\u0001\u00067pG\u0006dwJ^3se&$W\rR3g!\u0006$\b.\u0001\rm_\u000e\fGn\u0014<feJLG-\u001a#fMB\u000bG\u000f[0%KF$BAa\u0013\u0004H!I1\u0011F\u001c\u0002\u0002\u0003\u0007!Q_\u0001\u0016Y>\u001c\u0017\r\\(wKJ\u0014\u0018\u000eZ3EK\u001a\u0004\u0016\r\u001e5!\u0003=1W-\u0019;ve\u0016$UMZ\"p]\u001a\u001cXCAB(!\u0019\t\t\"!\t\u0004\u0018\u0005\u0019b-Z1ukJ,G)\u001a4D_:47o\u0018\u0013fcR!!1JB+\u0011%\u0019ICOA\u0001\u0002\u0004\u0019y%\u0001\tgK\u0006$XO]3EK\u001a\u001cuN\u001c4tAU\u0011\u0011qB\u0001\u0015I\u0006$\u0018\rU1uQ\"\u000bg\u000e\u001a7feN|F%Z9\u0015\t\t-3q\f\u0005\n\u0007Si\u0014\u0011!a\u0001\u0003\u001f\t\u0011\u0003Z1uCB\u000bG\u000f\u001b%b]\u0012dWM]:!+\t\tI$A\bnm\u0016d7i\u001c8uKb$x\fJ3r)\u0011\u0011Ye!\u001b\t\u0013\r%\u0002)!AA\u0002\u0005e\u0012\u0001D7wK2\u001cuN\u001c;fqR\u0004\u0013aE1eI\u0012\u000bG/\u0019)bi\"D\u0015M\u001c3mKJ\u001cH\u0003BB\u0004\u0007cBq!!\u0004C\u0001\u0004\ty!\u0001\nbI\u0012$\u0015\r^1QCRD\u0007*\u00198eY\u0016\u0014H\u0003BB\u0004\u0007oBqa!\u001fD\u0001\u0004\t9#A\beCR\f\u0007+\u0019;i\u0011\u0006tG\r\\3s)\u0011\u00199a! \t\u000f\reD\t1\u0001\u0004\u0000A)\u0001-a\u000f\u0002(\u0005i\u0011\r\u001a3GK\u0006$XO]3EK\u001a$Baa\u0002\u0004\u0006\"91qD#A\u0002\u0005\u0005E\u0003BB\u0004\u0007\u0013Cqaa\bG\u0001\u0004\u0019Y\tE\u0003a\u0003w\t\t)A\nbI\u0012dunY1m\u001fZ,'O]5eK\u0012+g\r\u0006\u0003\u0004\b\rE\u0005bBB\u0017\u000f\u0002\u0007\u0011\u0011\u0011\u000b\u0005\u0007\u000f\u0019)\nC\u0004\u0004.!\u0003\raa#\u0002#\u0005$GMR3biV\u0014X\rR3g!\u0006$\b\u000e\u0006\u0003\u0004\b\rm\u0005bBB\u001c\u0013\u0002\u0007\u0011\u0011\u0011\u000b\u0005\u0007\u000f\u0019y\nC\u0004\u00048)\u0003\raa#\u0002/\u0005$G\rT8dC2|e/\u001a:sS\u0012,G)\u001a4QCRDG\u0003BB\u0004\u0007KCqa!\u0011L\u0001\u0004\t\t\t\u0006\u0003\u0004\b\r%\u0006bBB!\u0019\u0002\u000711R\u0001\u0013C\u0012$g)Z1ukJ,G)\u001a4D_:47\u000f\u0006\u0003\u0004\b\r=\u0006bBB&\u001b\u0002\u00071\u0011\u0017\t\u0006A\u0006m2q\n\u000b\u0005\u0007\u000f\u0019)\fC\u0004\u0004L9\u0003\raa\u0014\u00025\u0005$GMR3bi\"\u0014X\t\u001f9sKN\u001c\u0018n\u001c8D_:$X\r\u001f;\u0015\t\r\u001d11\u0018\u0005\b\u0007{{\u0005\u0019AA\u001d\u00031yVN^3m\u0007>tG/\u001a=u\u0003\u0015\u0011W/\u001b7e)\t\t\u0019&\u0001\u0007sK\u0006$\u0007\n\u001a4t\r&dW\r\u0006\u0003\u0004\f\u000e\u001d\u0007bBBe#\u0002\u000711R\u0001\u0005a\u0006$\b\u000eC\u0003fO\u0001\u0007a\r")
public class FeathrClient {
    private final SparkSession sparkSession;
    private final FeatureGroups featureGroups;
    private final MultiStageJoinPlanner logicalPlanner;
    private final FeatureGroupsUpdater featureGroupsUpdater;
    private final List<DataPathHandler> dataPathHandlers;
    private final Option<FeathrExpressionExecutionContext> mvelContext;
    private final Logger log;
    private final Map<String, FeatureAnchorWithSource> allAnchoredFeatures;
    private final Map<String, DerivedFeature> allDerivedFeatures;
    private final Map<String, FeatureAnchorWithSource> allPassthroughFeatures;
    private final Map<String, FeatureAnchorWithSource> allWindowAggFeatures;
    private final Map<String, DerivedFeature> allSeqJoinFeatures;

    public static Builder builder(SparkSession sparkSession) {
        return FeathrClient$.MODULE$.builder(sparkSession);
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, FeatureAnchorWithSource> allAnchoredFeatures() {
        return this.allAnchoredFeatures;
    }

    public Map<String, DerivedFeature> allDerivedFeatures() {
        return this.allDerivedFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allPassthroughFeatures() {
        return this.allPassthroughFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allWindowAggFeatures() {
        return this.allWindowAggFeatures;
    }

    public Map<String, DerivedFeature> allSeqJoinFeatures() {
        return this.allSeqJoinFeatures;
    }

    public SparkFeaturizedDataset joinFeatures(FeatureJoinConfig joinConfig, SparkFeaturizedDataset obsData, JoinJobContext jobContext) {
        SparkConf sparkConf = this.sparkSession.sparkContext().getConf();
        FeathrUtils$.MODULE$.enableDebugLogging(sparkConf);
        Tuple2<Dataset<Row>, Header> tuple2 = this.doJoinObsAndFeatures(joinConfig, jobContext, obsData.data());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple23 = tuple22;
        Dataset joinedDF2 = (Dataset)tuple23._1();
        Header header2 = (Header)tuple23._2();
        Some x$1 = new Some((Object)header2);
        Map<String, String> x$2 = FeaturizedDatasetMetadata$.MODULE$.apply$default$1();
        return new SparkFeaturizedDataset((Dataset<Row>)joinedDF2, new FeaturizedDatasetMetadata(x$2, (Option<Header>)x$1));
    }

    public JoinJobContext joinFeatures$default$3() {
        return new JoinJobContext(JoinJobContext$.MODULE$.apply$default$1(), JoinJobContext$.MODULE$.apply$default$2(), JoinJobContext$.MODULE$.apply$default$3(), JoinJobContext$.MODULE$.apply$default$4(), JoinJobContext$.MODULE$.apply$default$5());
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> generateFeatures(FeatureGenSpec featureGenSpec) {
        Map map;
        this.prepareExecuteEnv();
        Seq<JoiningFeatureParams> keyTaggedAnchoredFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForAnchoredFeatures(featureGenSpec, this.featureGroups);
        Seq<JoiningFeatureParams> keyTaggedDerivedFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForDerivedFeatures(featureGenSpec, this.featureGroups, keyTaggedAnchoredFeatures);
        Seq keyTaggedRequiredFeatures = (Seq)keyTaggedAnchoredFeatures.$plus$plus(keyTaggedDerivedFeatures, Seq$.MODULE$.canBuildFrom());
        if (this.isStreaming(featureGenSpec)) {
            StreamingFeatureGenerator streamingFeatureGenerator = new StreamingFeatureGenerator(this.dataPathHandlers);
            streamingFeatureGenerator.generateFeatures(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, keyTaggedRequiredFeatures);
            DataFrameFeatureGenerator dataFrameFeatureGenerator = new DataFrameFeatureGenerator((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext);
            Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> featureMap = dataFrameFeatureGenerator.generateFeaturesAsDF(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)featureMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                TaggedFeatureName taggedFeatureName;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        taggedFeatureName = (TaggedFeatureName)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Dataset df = (Dataset)tuple2._1();
                SparkFeaturizedDataset fds = new SparkFeaturizedDataset((Dataset<Row>)df, new FeaturizedDatasetMetadata(FeaturizedDatasetMetadata$.MODULE$.apply$default$1(), FeaturizedDatasetMetadata$.MODULE$.apply$default$2()));
                Tuple2 tuple23 = new Tuple2((Object)taggedFeatureName, (Object)fds);
                return tuple23;
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    private boolean isStreaming(FeatureGenSpec featureGenSpec) {
        Seq<OutputProcessor> outputProcessors = featureGenSpec.getProcessorList();
        return !outputProcessors.isEmpty() ? BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)outputProcessors.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$1(p)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$2(BoxesRunTime.unboxToBoolean((Object)x$2), BoxesRunTime.unboxToBoolean((Object)x$3))))) : false;
    }

    private void prepareExecuteEnv() {
        SQLConf$.MODULE$.get().setConfString("spark.sql.legacy.allowUntypedScalaUDF", "true");
    }

    public List<DataSource> getAllFeatureSources(Seq<JoiningFeatureParams> requestedFeatures) {
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, (Seq)requestedFeatures);
        Seq<ErasedEntityTaggedFeature> allRequiredFeatures = ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures();
        Seq sources = (Seq)((SeqLike)allRequiredFeatures.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FeathrClient $outer;

            public final <A1 extends ErasedEntityTaggedFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (this.$outer.allAnchoredFeatures().contains((Object)A1.getFeatureName())) {
                    String featureName = A1.getFeatureName();
                    object = ((FeatureAnchorWithSource)this.$outer.allAnchoredFeatures().apply((Object)featureName)).source();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ErasedEntityTaggedFeature x1) {
                ErasedEntityTaggedFeature erasedEntityTaggedFeature = x1;
                boolean bl = this.$outer.allAnchoredFeatures().contains((Object)erasedEntityTaggedFeature.getFeatureName());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        return sources.toList();
    }

    public Tuple2<Dataset<Row>, Header> doJoinObsAndFeatures(FeatureJoinConfig joinConfig, JoinJobContext jobContext, Dataset<Row> obsData) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        this.log().info(new StringBuilder(38).append("All anchored feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allAnchoredFeatures().keySet())).toString());
        this.log().info(new StringBuilder(37).append("All derived feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allDerivedFeatures().keySet())).toString());
        this.prepareExecuteEnv();
        boolean enableCheckPoint = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ENABLE_CHECKPOINT()))).toBoolean();
        String checkpointDir = FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH());
        if (enableCheckPoint) {
            if (checkpointDir.equals("")) {
                throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(46).append("Please set ").append(FeathrUtils$.MODULE$.FEATHR_PARAMS_PREFIX()).append(FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH()).append(" to a folder with write permission.").toString());
            }
            HdfsUtils$.MODULE$.deletePath(checkpointDir, true, HdfsUtils$.MODULE$.deletePath$default$3());
            this.sparkSession.sparkContext().setCheckpointDir(checkpointDir);
        }
        Map<String, Seq<JoiningFeatureParams>> featureGroupings = joinConfig.featureGroupings();
        this.log().info(new StringBuilder(19).append("Join job context: ").append(jobContext).append(")").toString());
        this.log().info(new StringBuilder(12).append("joinConfig: ").append(joinConfig).toString());
        this.log().info(new StringBuilder(28).append("featureGroupings passed in: ").append(featureGroupings).toString());
        int rowBloomFilterThreshold = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ROW_BLOOMFILTER_MAX_THRESHOLD()))).toInt();
        Seq joinFeatures = (Seq)((TraversableOnce)featureGroupings.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct();
        if (featureGroupings.isEmpty()) {
            this.log().warn("Feature groupings from the join config is empty, returning the obs data without joining any features.");
            tuple22 = new Tuple2(obsData, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        } else {
            tuple22 = tuple2 = this.joinFeaturesAsDF(joinConfig, (Seq<JoiningFeatureParams>)joinFeatures, obsData, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rowBloomFilterThreshold)));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple24 = tuple23;
        Dataset joinedDF2 = (Dataset)tuple24._1();
        Header header2 = (Header)tuple24._2();
        if (this.log().isDebugEnabled()) {
            this.log().debug("joinedDF:");
            joinedDF2.show(false);
            this.log().debug(new StringBuilder(23).append("header featureInfoMap: ").append(header2.featureInfoMap()).toString());
        }
        return new Tuple2((Object)joinedDF2, (Object)header2);
    }

    private Seq<String> findConflictFeatureNames(Seq<JoiningFeatureParams> keyTaggedFeatures, Seq<String> fieldNames) {
        return (Seq)((SeqLike)keyTaggedFeatures.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.featureName(), Seq$.MODULE$.canBuildFrom())).intersect(fieldNames);
    }

    public Tuple2<Dataset<Row>, Header> renameFeatureNames(Dataset<Row> df, Header header, Seq<String> conflictFeatureNames, String suffix) {
        UUID uuid = UUID.randomUUID();
        ObjectRef renamedDF = ObjectRef.create(df);
        conflictFeatureNames.foreach((Function1 & Serializable & scala.Serializable)name -> {
            FeathrClient.$anonfun$renameFeatureNames$1(renamedDF, uuid, suffix, name);
            return BoxedUnit.UNIT;
        });
        Map featuresInfoMap = (Map)header.featureInfoMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaggedFeatureName featureName = (TaggedFeatureName)tuple2._1();
            FeatureInfo featureInfo = (FeatureInfo)tuple2._2();
            String name = featureInfo.columnName();
            boolean conflict = conflictFeatureNames.contains((Object)name);
            FeatureInfo fi = conflict ? new FeatureInfo(new StringBuilder(0).append(name).append('_').append(suffix).toString(), featureInfo.featureType()) : featureInfo;
            TaggedFeatureName fn = conflict ? new TaggedFeatureName(featureName.getKeyTag(), new StringBuilder(0).append(name).append('_').append(suffix).toString()) : featureName;
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fn), (Object)fi);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new Tuple2((Object)((Dataset)renamedDF.elem), (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)featuresInfoMap));
    }

    public Tuple2<Dataset<Row>, Header> joinFeaturesAsDF(FeatureJoinConfig joinConfig, Seq<JoiningFeatureParams> keyTaggedFeatures, Dataset<Row> left, Option<Object> rowBloomFilterThreshold) {
        Tuple2<Dataset<Row>, Header> tuple2;
        Option<ConflictsAutoCorrectionSetting> conflictsAutoCorrectionSetting;
        BoxedUnit boxedUnit;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])left.head(1))).isEmpty()) {
            this.log().info("Observation is empty");
            return new Tuple2(left, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        }
        FeatureGroups updatedFeatureGroups = this.featureGroupsUpdater.updateFeatureGroups(this.featureGroups, keyTaggedFeatures);
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(updatedFeatureGroups, (Seq)keyTaggedFeatures);
        boolean shouldSkipFeature = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession.sparkContext().getConf(), FeathrUtils$.MODULE$.SKIP_MISSING_FEATURE()))).toBoolean();
        Map featureToPathsMap = ((TraversableOnce)((MultiStageJoinPlan)logicalPlan).allRequiredFeatures().flatMap((Function1 & Serializable & scala.Serializable)requiredFeature -> Option$.MODULE$.option2Iterable(this.allAnchoredFeatures().get((Object)requiredFeature.getFeatureName()).map((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)requiredFeature.getFeatureName()), (Object)featureAnchorWithSource.source().path()))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (!this.sparkSession.sparkContext().isLocal()) {
            Object object;
            Tuple2<Try<BoxedUnit>, Seq<String>> featurePathsTest = AclCheckUtils$.MODULE$.checkReadAuthorization(this.sparkSession, ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures(), this.allAnchoredFeatures());
            Try try_ = (Try)featurePathsTest._1();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (!shouldSkipFeature) {
                    throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, "Unable to verify read authorization on feature data, it can be due to the following reasons: 1) input not exist, 2) no permission.", exception);
                }
                FeatureGroups featureGroupsWithoutInvalidFeatures = FeatureGroupsUpdater$.MODULE$.apply().getUpdatedFeatureGroupsWithoutInvalidPaths((Map<String, String>)featureToPathsMap, updatedFeatureGroups, (Seq<String>)((Seq)featurePathsTest._2()));
                object = this.logicalPlanner.getLogicalPlan(featureGroupsWithoutInvalidFeatures, (Seq)keyTaggedFeatures);
            } else if (try_ instanceof Success) {
                this.log().debug("Checked read authorization on all feature data");
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<String> invalidFeatureNames = this.findInvalidFeatureRefs(keyTaggedFeatures);
        if (invalidFeatureNames.nonEmpty()) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(77).append("Feature names must conform to ").append("regular expression: ").append(AnchorUtils$.MODULE$.featureNamePattern()).append(", but found feature names: ").append(invalidFeatureNames).toString());
        }
        DataFrameFeatureJoiner joiner = new DataFrameFeatureJoiner((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext);
        Seq<String> conflictFeatureNames = this.findConflictFeatureNames(keyTaggedFeatures, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])left.schema().fieldNames()));
        Option<JoinConfigSettings> joinConfigSettings = joinConfig.settings();
        Option<ConflictsAutoCorrectionSetting> option = conflictsAutoCorrectionSetting = joinConfigSettings.isDefined() ? ((JoinConfigSettings)joinConfigSettings.get()).conflictsAutoCorrectionSetting() : None$.MODULE$;
        if (conflictFeatureNames.nonEmpty()) {
            if (!conflictsAutoCorrectionSetting.isDefined()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(152).append("Feature names must be different from field names in the observation data. ").append("Please rename feature ").append(conflictFeatureNames).append(" or rename the same field names in the observation data.").toString());
            }
            boolean renameFeatures = ((ConflictsAutoCorrectionSetting)conflictsAutoCorrectionSetting.get()).renameFeatureList();
            String suffix = ((ConflictsAutoCorrectionSetting)conflictsAutoCorrectionSetting.get()).suffix();
            this.log().warn(new StringBuilder(75).append("Found conflicted field names: ").append(conflictFeatureNames).append(". Will auto correct them by applying suffix: ").append(suffix).toString());
            ObjectRef leftRenamed = ObjectRef.create(left);
            conflictFeatureNames.foreach((Function1 & Serializable & scala.Serializable)name -> {
                leftRenamed.elem = ((Dataset)leftRenamed.elem).withColumnRenamed(name, new StringBuilder(0).append(name).append('_').append(suffix).toString());
                return BoxedUnit.UNIT;
            });
            Seq<String> conflictFeatureNames2 = this.findConflictFeatureNames(keyTaggedFeatures, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])((Dataset)leftRenamed.elem).schema().fieldNames()));
            if (conflictFeatureNames2.nonEmpty()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(176).append("Failed to apply auto correction to solve conflicts. Still got conflicts after applying provided suffix ").append(suffix).append(" for fields: ").append(conflictFeatureNames).append(". Please provide another suffix or solve conflicts manually.").toString());
            }
            Tuple2<Dataset<Row>, Header> tuple22 = joiner.joinFeaturesAsDF(this.sparkSession, joinConfig, updatedFeatureGroups, keyTaggedFeatures, (Dataset<Row>)((Dataset)leftRenamed.elem), rowBloomFilterThreshold);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Dataset df = (Dataset)tuple22._1();
            Header header = (Header)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)df, (Object)header);
            Tuple2 tuple24 = tuple23;
            Dataset df2 = (Dataset)tuple24._1();
            Header header2 = (Header)tuple24._2();
            if (renameFeatures) {
                this.log().warn(new StringBuilder(70).append("Suffix :").append(suffix).append(" is applied into feature names: ").append(conflictFeatureNames).append(" to avoid conflicts in outputs").toString());
                tuple2 = this.renameFeatureNames((Dataset<Row>)df2, header2, conflictFeatureNames, suffix);
            } else {
                this.log().warn(new StringBuilder(77).append("Suffix :").append(suffix).append(" is applied into dataset Column names: ").append(conflictFeatureNames).append(" to avoid conflicts in outputs").toString());
                tuple2 = new Tuple2<Dataset<Row>, Header>((Object)df2, (Object)header2);
            }
        } else {
            tuple2 = joiner.joinFeaturesAsDF(this.sparkSession, joinConfig, updatedFeatureGroups, keyTaggedFeatures, left, rowBloomFilterThreshold);
        }
        return tuple2;
    }

    public Option<Object> joinFeaturesAsDF$default$4() {
        return None$.MODULE$;
    }

    public FeatureGroups getFeatureGroups() {
        return this.featureGroups;
    }

    public MultiStageJoinPlanner getLogicalPlanner() {
        return this.logicalPlanner;
    }

    private String stringifyFeatureNames(Set<String> nameSet) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)nameSet.toSeq().sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)))).mkString("\n\t");
    }

    private List<String> findInvalidFeatureRefs(Seq<JoiningFeatureParams> features) {
        return (List)features.foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, f) -> {
            List list;
            String featureRefStr = f.featureName().toString();
            String featureRefStrInDF = DataFrameColName$.MODULE$.getEncodedFeatureRefStrForColName(featureRefStr);
            boolean isValidSyntax = AnchorUtils$.MODULE$.featureNamePattern().matcher(featureRefStrInDF).matches();
            if (isValidSyntax) {
                list = acc;
            } else {
                String string = featureRefStr;
                list = acc.$colon$colon((Object)string);
            }
            return list;
        });
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$1(OutputProcessor p) {
        return package$.MODULE$.RichConfig(p.outputProcessorConfig().getParams()).getBooleanWithDefault("streaming", false);
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$2(boolean x$2, boolean x$3) {
        return x$2 || x$3;
    }

    public static final /* synthetic */ void $anonfun$renameFeatureNames$1(ObjectRef renamedDF$1, UUID uuid$1, String suffix$1, String name) {
        renamedDF$1.elem = ((Dataset)renamedDF$1.elem).withColumnRenamed(name, new StringBuilder(0).append(name).append('_').append(uuid$1).toString());
        renamedDF$1.elem = ((Dataset)renamedDF$1.elem).withColumnRenamed(new StringBuilder(0).append(name).append('_').append(suffix$1).toString(), name);
        renamedDF$1.elem = ((Dataset)renamedDF$1.elem).withColumnRenamed(new StringBuilder(0).append(name).append('_').append(uuid$1).toString(), new StringBuilder(0).append(name).append('_').append(suffix$1).toString());
    }

    public FeathrClient(SparkSession sparkSession, FeatureGroups featureGroups, MultiStageJoinPlanner logicalPlanner, FeatureGroupsUpdater featureGroupsUpdater, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext) {
        this.sparkSession = sparkSession;
        this.featureGroups = featureGroups;
        this.logicalPlanner = logicalPlanner;
        this.featureGroupsUpdater = featureGroupsUpdater;
        this.dataPathHandlers = dataPathHandlers;
        this.mvelContext = mvelContext;
        this.log = LogManager.getLogger(this.getClass());
        this.allAnchoredFeatures = featureGroups.allAnchoredFeatures();
        this.allDerivedFeatures = featureGroups.allDerivedFeatures();
        this.allPassthroughFeatures = featureGroups.allPassthroughFeatures();
        this.allWindowAggFeatures = featureGroups.allWindowAggFeatures();
        this.allSeqJoinFeatures = featureGroups.allSeqJoinFeatures();
    }

    public static class Builder {
        private final SparkSession sparkSession;
        private final FeathrConfig feathrConfigLoader;
        private List<String> featureDef;
        private List<String> localOverrideDef;
        private List<String> featureDefPath;
        private List<String> localOverrideDefPath;
        private List<FeathrConfig> featureDefConfs;
        private List<DataPathHandler> dataPathHandlers;
        private Option<FeathrExpressionExecutionContext> mvelContext;

        private FeathrConfig feathrConfigLoader() {
            return this.feathrConfigLoader;
        }

        private List<String> featureDef() {
            return this.featureDef;
        }

        private void featureDef_$eq(List<String> x$1) {
            this.featureDef = x$1;
        }

        private List<String> localOverrideDef() {
            return this.localOverrideDef;
        }

        private void localOverrideDef_$eq(List<String> x$1) {
            this.localOverrideDef = x$1;
        }

        private List<String> featureDefPath() {
            return this.featureDefPath;
        }

        private void featureDefPath_$eq(List<String> x$1) {
            this.featureDefPath = x$1;
        }

        private List<String> localOverrideDefPath() {
            return this.localOverrideDefPath;
        }

        private void localOverrideDefPath_$eq(List<String> x$1) {
            this.localOverrideDefPath = x$1;
        }

        private List<FeathrConfig> featureDefConfs() {
            return this.featureDefConfs;
        }

        private void featureDefConfs_$eq(List<FeathrConfig> x$1) {
            this.featureDefConfs = x$1;
        }

        private List<DataPathHandler> dataPathHandlers() {
            return this.dataPathHandlers;
        }

        private void dataPathHandlers_$eq(List<DataPathHandler> x$1) {
            this.dataPathHandlers = x$1;
        }

        private Option<FeathrExpressionExecutionContext> mvelContext() {
            return this.mvelContext;
        }

        private void mvelContext_$eq(Option<FeathrExpressionExecutionContext> x$1) {
            this.mvelContext = x$1;
        }

        public Builder addDataPathHandlers(List<DataPathHandler> dataPathHandlers) {
            this.dataPathHandlers_$eq((List<DataPathHandler>)((List)dataPathHandlers.$plus$plus(this.dataPathHandlers(), List$.MODULE$.canBuildFrom())));
            return this;
        }

        public Builder addDataPathHandler(DataPathHandler dataPathHandler) {
            DataPathHandler dataPathHandler2 = dataPathHandler;
            this.dataPathHandlers_$eq((List<DataPathHandler>)this.dataPathHandlers().$colon$colon((Object)dataPathHandler2));
            return this;
        }

        public Builder addDataPathHandler(Option<DataPathHandler> dataPathHandler) {
            return dataPathHandler.isDefined() ? this.addDataPathHandler((DataPathHandler)dataPathHandler.get()) : this;
        }

        public Builder addFeatureDef(String featureDef) {
            String string = featureDef;
            this.featureDef_$eq((List<String>)this.featureDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDef(Option<String> featureDef) {
            return featureDef.isDefined() ? this.addFeatureDef((String)featureDef.get()) : this;
        }

        public Builder addLocalOverrideDef(String localOverrideDef) {
            String string = localOverrideDef;
            this.localOverrideDef_$eq((List<String>)this.localOverrideDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDef(Option<String> localOverrideDef) {
            return localOverrideDef.isDefined() ? this.addFeatureDef((String)localOverrideDef.get()) : this;
        }

        public Builder addFeatureDefPath(String featureDefPath) {
            String string = featureDefPath;
            this.featureDefPath_$eq((List<String>)this.featureDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDefPath(Option<String> featureDefPath) {
            return featureDefPath.isDefined() ? this.addFeatureDefPath((String)featureDefPath.get()) : this;
        }

        public Builder addLocalOverrideDefPath(String localOverrideDefPath) {
            String string = localOverrideDefPath;
            this.localOverrideDefPath_$eq((List<String>)this.localOverrideDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDefPath(Option<String> localOverrideDefPath) {
            return localOverrideDefPath.isDefined() ? this.addLocalOverrideDefPath((String)localOverrideDefPath.get()) : this;
        }

        public Builder addFeatureDefConfs(Option<List<FeathrConfig>> featureDefConfs) {
            return featureDefConfs.isDefined() ? this.addFeatureDefConfs((List<FeathrConfig>)((List)featureDefConfs.get())) : this;
        }

        public Builder addFeatureDefConfs(List<FeathrConfig> featureDefConfs) {
            this.featureDefConfs_$eq(featureDefConfs);
            return this;
        }

        public Builder addFeathrExpressionContext(Option<FeathrExpressionExecutionContext> _mvelContext) {
            this.mvelContext_$eq(_mvelContext);
            return this;
        }

        public FeathrClient build() {
            Predef$.MODULE$.require(!this.localOverrideDefPath().isEmpty() || !this.localOverrideDef().isEmpty() || !this.featureDefPath().isEmpty() || !this.featureDef().isEmpty() || !this.featureDefConfs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot build feathrClient without a feature def conf file/string or local override def conf file/string");
            ObjectRef featureDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            ObjectRef localDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            Object object = this.featureDefPath().nonEmpty() ? this.featureDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$2(this, featureDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object2 = this.featureDef().nonEmpty() ? this.featureDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$4(this, featureDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object3 = this.localOverrideDefPath().nonEmpty() ? this.localOverrideDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$5(this, localDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object4 = this.localOverrideDef().nonEmpty() ? this.localOverrideDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$7(this, localDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            featureDefConfigs.elem = (List)((List)featureDefConfigs.elem).$plus$plus(this.featureDefConfs(), List$.MODULE$.canBuildFrom());
            FeatureGroups featureGroups = FeatureGroupsGenerator$.MODULE$.apply((Seq<FeathrConfig>)((List)featureDefConfigs.elem), (Option<Seq<FeathrConfig>>)new Some((Object)((List)localDefConfigs.elem))).getFeatureGroups();
            FeathrClient feathrClient = new FeathrClient(this.sparkSession, featureGroups, MultiStageJoinPlanner$.MODULE$.apply(), FeatureGroupsUpdater$.MODULE$.apply(), this.dataPathHandlers(), this.mvelContext());
            return feathrClient;
        }

        public Option<String> readHdfsFile(Option<String> path) {
            return path.map((Function1 & Serializable & scala.Serializable)p -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.sparkSession.sparkContext().textFile(p, $this.sparkSession.sparkContext().textFile$default$2()).collect())).mkString("\n"));
        }

        public static final /* synthetic */ void $anonfun$build$3(Builder $this, ObjectRef featureDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$2(Builder $this, ObjectRef featureDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$3($this, featureDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$4(Builder $this, ObjectRef featureDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$6(Builder $this, ObjectRef localDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$5(Builder $this, ObjectRef localDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$6($this, localDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$7(Builder $this, ObjectRef localDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public Builder(SparkSession sparkSession) {
            this.sparkSession = sparkSession;
            this.feathrConfigLoader = FeathrConfigLoader$.MODULE$.apply();
            this.featureDef = Nil$.MODULE$;
            this.localOverrideDef = Nil$.MODULE$;
            this.featureDefPath = Nil$.MODULE$;
            this.localOverrideDefPath = Nil$.MODULE$;
            this.featureDefConfs = Nil$.MODULE$;
            this.dataPathHandlers = Nil$.MODULE$;
            this.mvelContext = None$.MODULE$;
        }
    }
}

