/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.ConfigLoaderUtils$;
import com.linkedin.feathr.offline.config.location.DataLocation;
import com.linkedin.feathr.offline.config.location.KafkaEndpoint;
import com.linkedin.feathr.offline.config.location.LocationUtils$;
import com.linkedin.feathr.offline.config.location.SimplePath;
import com.linkedin.feathr.offline.config.location.Snowflake;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.DataSource$;
import com.linkedin.feathr.offline.source.SourceFormatType$;
import com.linkedin.feathr.offline.source.TimeWindowParams;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M2Qa\u0001\u0003\u0001\r9AQa\b\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005B\u0015\u0012\u0001\u0003R1uCN{WO]2f\u0019>\fG-\u001a:\u000b\u0005\u00151\u0011AB2p]\u001aLwM\u0003\u0002\b\u0011\u00059qN\u001a4mS:,'BA\u0005\u000b\u0003\u00191W-\u0019;ie*\u00111\u0002D\u0001\tY&t7.\u001a3j]*\tQ\"A\u0002d_6\u001c\"\u0001A\b\u0011\u0007A9\u0012$D\u0001\u0012\u0015\t\u00112#\u0001\u0005eCR\f'-\u001b8e\u0015\t!R#A\u0004kC\u000e\\7o\u001c8\u000b\u0005Ya\u0011!\u00034bgR,'\u000f_7m\u0013\tA\u0012C\u0001\tKg>tG)Z:fe&\fG.\u001b>feB\u0011!$H\u0007\u00027)\u0011ADB\u0001\u0007g>,(oY3\n\u0005yY\"A\u0003#bi\u0006\u001cv.\u001e:dK\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001#!\t\u0019\u0003!D\u0001\u0005\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007e1c\u0006C\u0003(\u0005\u0001\u0007\u0001&A\u0001q!\tIC&D\u0001+\u0015\tY3#\u0001\u0003d_J,\u0017BA\u0017+\u0005)Q5o\u001c8QCJ\u001cXM\u001d\u0005\u0006_\t\u0001\r\u0001M\u0001\u0005GRDH\u000f\u0005\u0002\u0011c%\u0011!'\u0005\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]\u000e{g\u000e^3yi\u0002")
public class DataSourceLoader
extends JsonDeserializer<DataSource> {
    public DataSource deserialize(JsonParser p, DeserializationContext ctxt) {
        TimeWindowParams timeWindowParams;
        Some some;
        ObjectNode node;
        None$ timeWindowParameterNode;
        None$ none$;
        Some some2;
        JsonNode field;
        DataLocation dataLocation;
        String dataSourceType;
        String string;
        Some some3;
        JsonNode field2;
        ObjectCodec codec = p.getCodec();
        ObjectNode node2 = (ObjectNode)codec.readTree(p);
        Option option = Option$.MODULE$.apply((Object)node2.get("type"));
        if (option instanceof Some && (field2 = (JsonNode)(some3 = (Some)option).value()) instanceof TextNode) {
            TextNode textNode = (TextNode)field2;
            string = textNode.textValue();
        } else {
            string = "HDFS";
        }
        String string2 = dataSourceType = string;
        String string3 = "HDFS";
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            String string4 = dataSourceType;
            String string5 = "PASSTHROUGH";
            if (string4 == null ? string5 != null : !string4.equals(string5)) {
                String string6 = dataSourceType;
                String string7 = "KAFKA";
                if (string6 == null ? string7 != null : !string6.equals(string7)) {
                    String string8 = dataSourceType;
                    String string9 = "SNOWFLAKE";
                    if (string8 == null ? string9 != null : !string8.equals(string9)) {
                        throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(38).append("Unknown source type parameter ").append(dataSourceType).append(" is used").toString());
                    }
                }
            }
        }
        Option timePartitionPattern = Option$.MODULE$.apply((Object)node2.get("timePartitionPattern")).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.textValue());
        Option postfixPath = Option$.MODULE$.apply((Object)node2.get("postfixPath")).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.textValue());
        Enumeration.Value sourceFormatType = timePartitionPattern.isDefined() || ConfigLoaderUtils$.MODULE$.getBoolean(node2, "hasTimeSnapshot") || ConfigLoaderUtils$.MODULE$.getBoolean(node2, "isTimeSeries") ? SourceFormatType$.MODULE$.TIME_SERIES_PATH() : SourceFormatType$.MODULE$.FIXED_PATH();
        String string10 = dataSourceType;
        if ("KAFKA".equals(string10)) {
            Some some4;
            JsonNode field3;
            Option option2 = Option$.MODULE$.apply((Object)node2.get("config"));
            if (!(option2 instanceof Some) || !((field3 = (JsonNode)(some4 = (Some)option2).value()) instanceof ObjectNode)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(45).append("Kafka config is not defined for Kafka source ").append(node2.toPrettyString()).toString());
                }
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(47).append("Illegal setting for Kafka source ").append(node2.toPrettyString()).append(", expected map").toString());
            }
            ObjectNode objectNode = (ObjectNode)field3;
            DataLocation dataLocation2 = (DataLocation)LocationUtils$.MODULE$.getMapper().treeToValue((TreeNode)objectNode, KafkaEndpoint.class);
            dataLocation = dataLocation2;
        } else if ("PASSTHROUGH".equals(string10)) {
            dataLocation = new SimplePath("PASSTHROUGH");
        } else if ("SNOWFLAKE".equals(string10)) {
            Some some5;
            JsonNode field4;
            Option option3 = Option$.MODULE$.apply((Object)node2.get("location"));
            if (!(option3 instanceof Some) || !((field4 = (JsonNode)(some5 = (Some)option3).value()) instanceof ObjectNode)) {
                if (None$.MODULE$.equals(option3)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(53).append("Snowflake config is not defined for Snowflake source ").append(node2.toPrettyString()).toString());
                }
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(51).append("Illegal setting for Snowflake source ").append(node2.toPrettyString()).append(", expected map").toString());
            }
            ObjectNode objectNode = (ObjectNode)field4;
            DataLocation dataLocation3 = (DataLocation)LocationUtils$.MODULE$.getMapper().treeToValue((TreeNode)objectNode, Snowflake.class);
            dataLocation = dataLocation3;
        } else {
            Some some6;
            JsonNode field5;
            Option option4 = Option$.MODULE$.apply((Object)node2.get("location"));
            if (!(option4 instanceof Some) || !((field5 = (JsonNode)(some6 = (Some)option4).value()) instanceof ObjectNode)) {
                if (None$.MODULE$.equals(option4)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(45).append("Data location is not defined for data source ").append(node2.toPrettyString()).toString());
                }
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(59).append("Illegal setting for location for data source ").append(node2.toPrettyString()).append(", expected map").toString());
            }
            ObjectNode objectNode = (ObjectNode)field5;
            DataLocation dataLocation4 = (DataLocation)LocationUtils$.MODULE$.getMapper().treeToValue((TreeNode)objectNode, DataLocation.class);
            dataLocation = dataLocation4;
        }
        SimplePath path = dataLocation;
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("Source location is: ").append(path).toString());
        Option option5 = Option$.MODULE$.apply((Object)node2.get("timeWindowParameters"));
        if (option5 instanceof Some && (field = (JsonNode)(some2 = (Some)option5).value()) instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)field;
            none$ = Option$.MODULE$.apply((Object)objectNode);
        } else if (None$.MODULE$.equals(option5)) {
            none$ = None$.MODULE$;
        } else {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(55).append("Illegal setting for timeWindowParameters ").append(node2.toPrettyString()).append(", expected map").toString());
        }
        None$ none$2 = timeWindowParameterNode = none$;
        if (none$2 instanceof Some && (node = (ObjectNode)(some = (Some)none$2).value()) != null) {
            TimeWindowParams timeWindowParams2;
            ObjectNode objectNode = node;
            if (objectNode.has("timestamp")) {
                JsonNode jsonNode = objectNode.get("timestamp");
                if (!(jsonNode instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "field 'timestamp is not correctly set");
                }
                TextNode textNode = (TextNode)jsonNode;
                String string11 = textNode.textValue();
                JsonNode jsonNode2 = objectNode.get("timestamp_format");
                if (!(jsonNode2 instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "field 'timestamp_format' is not correctly set");
                }
                TextNode textNode2 = (TextNode)jsonNode2;
                String string12 = textNode2.textValue();
                TimeWindowParams timeWindowParams3 = new TimeWindowParams(string11, string12);
                timeWindowParams2 = timeWindowParams3;
            } else {
                JsonNode jsonNode = objectNode.get("timestampColumn");
                if (!(jsonNode instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "field 'timestampColumn is not correctly set");
                }
                TextNode textNode = (TextNode)jsonNode;
                String string13 = textNode.textValue();
                JsonNode jsonNode3 = objectNode.get("timestampColumnFormat");
                if (!(jsonNode3 instanceof TextNode)) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "field 'timestampColumnFormat' is not correctly set");
                }
                TextNode textNode3 = (TextNode)jsonNode3;
                String string14 = textNode3.textValue();
                TimeWindowParams timeWindowParams4 = new TimeWindowParams(string13, string14);
                timeWindowParams2 = timeWindowParams4;
            }
            timeWindowParams = timeWindowParams2;
        } else if (None$.MODULE$.equals(none$2)) {
            timeWindowParams = null;
        } else {
            throw new MatchError((Object)none$2);
        }
        TimeWindowParams timeWindowParameters = timeWindowParams;
        return path instanceof KafkaEndpoint ? DataSource$.MODULE$.apply(path, sourceFormatType) : new DataSource(path, sourceFormatType, (Option<TimeWindowParams>)Option$.MODULE$.apply(timeWindowParameters), (Option<String>)timePartitionPattern, (Option<String>)postfixPath);
    }
}

