/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureDerivationFunctionBase;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.ErasedEntityTaggedFeature$;
import com.linkedin.feathr.offline.client.plugins.FeathrUdfPluginContext$;
import com.linkedin.feathr.offline.client.plugins.FeatureDerivationFunctionAdaptor;
import com.linkedin.feathr.offline.client.plugins.UdfAdaptor;
import com.linkedin.feathr.offline.config.BaseTaggedDependency;
import com.linkedin.feathr.offline.config.ConfigLoaderUtils$;
import com.linkedin.feathr.offline.config.CustomDerivedFeatureConfig;
import com.linkedin.feathr.offline.config.DerivedFeatureConfig;
import com.linkedin.feathr.offline.config.FeathrConfigLoader$;
import com.linkedin.feathr.offline.config.SeqJoinFeatureConfig;
import com.linkedin.feathr.offline.config.TaggedDependency;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.derived.DerivedFeature$;
import com.linkedin.feathr.offline.derived.functions.MvelFeatureDerivationFunction;
import com.linkedin.feathr.offline.derived.functions.SQLFeatureDerivationFunction;
import com.linkedin.feathr.offline.derived.functions.SQLFeatureDerivationFunction$;
import com.linkedin.feathr.offline.derived.functions.SeqJoinDerivationFunction;
import com.linkedin.feathr.offline.derived.functions.SimpleMvelDerivationFunction;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.convert.package$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3QAB\u0004\u0001\u0013EAQA\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u00046\u0001\u0001\u0006I!\u000b\u0005\u0006m\u0001!\te\u000e\u0005\u0007\u000b\u0002!\ta\u0002$\u0003!\u0011+'/\u001b<bi&|g\u000eT8bI\u0016\u0014(B\u0001\u0005\n\u0003\u0019\u0019wN\u001c4jO*\u0011!bC\u0001\b_\u001a4G.\u001b8f\u0015\taQ\"\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003\u001d=\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002!\u0005\u00191m\\7\u0014\u0005\u0001\u0011\u0002cA\n\u001b95\tAC\u0003\u0002\u0016-\u0005AA-\u0019;bE&tGM\u0003\u0002\u00181\u00059!.Y2lg>t'BA\r\u0010\u0003%1\u0017m\u001d;feblG.\u0003\u0002\u001c)\t\u0001\"j]8o\t\u0016\u001cXM]5bY&TXM\u001d\t\u0003;\u0001j\u0011A\b\u0006\u0003?%\tq\u0001Z3sSZ,G-\u0003\u0002\"=\tqA)\u001a:jm\u0016$g)Z1ukJ,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003\u001d\t1\u0001\\8h+\u0005I\u0003C\u0001\u00164\u001b\u0005Y#B\u0001\u0017.\u0003\u0015awn\u001a\u001bk\u0015\tqs&A\u0004m_\u001e<\u0017N\\4\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0005\u0003i-\u0012a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\n1\u0002Z3tKJL\u0017\r\\5{KR\u0019A\u0004\u000f!\t\u000be\"\u0001\u0019\u0001\u001e\u0002\u0003A\u0004\"a\u000f \u000e\u0003qR!!\u0010\f\u0002\t\r|'/Z\u0005\u0003\u007fq\u0012!BS:p]B\u000b'o]3s\u0011\u0015\tE\u00011\u0001C\u0003\u0011\u0019G\u000f\u001f;\u0011\u0005M\u0019\u0015B\u0001#\u0015\u0005Y!Um]3sS\u0006d\u0017N_1uS>t7i\u001c8uKb$\u0018A\u00077pC\u0012\fEM^1oG\u0016$G)\u001a:jm\u0016$g)Z1ukJ,Gc\u0001\u000fH\u001d\")\u0001*\u0002a\u0001\u0013\u0006!an\u001c3f!\tQE*D\u0001L\u0015\tAE#\u0003\u0002N\u0017\nQqJ\u00196fGRtu\u000eZ3\t\u000b=+\u0001\u0019\u0001)\u0002\u000b\r|G-Z2\u0011\u0005m\n\u0016B\u0001*=\u0005-y%M[3di\u000e{G-Z2")
public class DerivationLoader
extends JsonDeserializer<DerivedFeature> {
    private final Logger log = LogManager.getLogger((Class)this.getClass());

    public Logger log() {
        return this.log;
    }

    public DerivedFeature deserialize(JsonParser p, DeserializationContext ctxt) {
        DerivedFeature derivedFeature;
        ObjectCodec codec = p.getCodec();
        String featureName = p.getParsingContext().getCurrentName();
        Seq producedFeatures = (Seq)new .colon.colon((Object)featureName, (List)Nil$.MODULE$);
        TreeNode node = codec.readTree(p);
        Option<FeatureTypeConfig> typeConfig = ConfigLoaderUtils$.MODULE$.getTypeConfig(node);
        Map featureTypeConfigMap = (Map)typeConfig.map((Function1 & Serializable & scala.Serializable)featureTypeConfig -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), featureTypeConfig)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        TreeNode treeNode = node;
        if (treeNode instanceof TextNode) {
            TextNode textNode = (TextNode)treeNode;
            SimpleMvelDerivationFunction derivationFunction = new SimpleMvelDerivationFunction(textNode.textValue(), featureName, (Option<FeatureTypeConfig>)featureTypeConfigMap.get((Object)featureName));
            Seq keyTag = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
            Seq consumedFeatures = (Seq)derivationFunction.dependencyFeatureNames().map((Function1 & Serializable & scala.Serializable)x$8 -> ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)keyTag, (String)x$8), Seq$.MODULE$.canBuildFrom());
            derivedFeature = new DerivedFeature((Seq<ErasedEntityTaggedFeature>)consumedFeatures, (Seq<String>)producedFeatures, derivationFunction, (Option<Seq<String>>)None$.MODULE$, (Map<String, FeatureTypeConfig>)featureTypeConfigMap);
        } else if (treeNode instanceof ObjectNode) {
            DerivedFeature derivedFeature2;
            ObjectNode objectNode = (ObjectNode)treeNode;
            if (objectNode.has("features")) {
                derivedFeature2 = this.loadAdvancedDerivedFeature(objectNode, codec);
            } else if (objectNode.has("class")) {
                Object object;
                Some some;
                UdfAdaptor adaptor;
                CustomDerivedFeatureConfig config = (CustomDerivedFeatureConfig)codec.treeToValue((TreeNode)objectNode, CustomDerivedFeatureConfig.class);
                Class<?> derivationFunctionClass = config.class();
                Object derivationFunction = derivationFunctionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Option<UdfAdaptor<?>> option = FeathrUdfPluginContext$.MODULE$.getRegisteredUdfAdaptor(derivationFunctionClass);
                if (option instanceof Some && (adaptor = (UdfAdaptor)(some = (Some)option).value()) instanceof FeatureDerivationFunctionAdaptor) {
                    FeatureDerivationFunctionAdaptor featureDerivationFunctionAdaptor = (FeatureDerivationFunctionAdaptor)adaptor;
                    object = featureDerivationFunctionAdaptor.adaptUdf(derivationFunction);
                } else {
                    object = derivationFunction;
                }
                Object maybeAdaptedDerivationFunction = object;
                IndexedSeq consumedFeatures = ((TraversableOnce)config.inputs().map((Function1 & Serializable & scala.Serializable)x -> ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)x.key().map((Function1)((TraversableOnce)config.key().zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom())), x.feature()), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
                derivedFeature2 = new DerivedFeature((Seq<ErasedEntityTaggedFeature>)consumedFeatures, (Seq<String>)producedFeatures, maybeAdaptedDerivationFunction, config.parameterNames(), (Map<String, FeatureTypeConfig>)featureTypeConfigMap);
            } else if (objectNode.has("join")) {
                SeqJoinFeatureConfig config = (SeqJoinFeatureConfig)codec.treeToValue((TreeNode)objectNode, SeqJoinFeatureConfig.class);
                if (config.aggregation().isEmpty()) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(232).append("Feathr does not support empty aggregation function.").append("Sequential+Join+Features+in+Feathr#SequentialJoinFeaturesinFeathr-ExpansionFeatureTypesandAggregation ").append("to provide the right default aggregation (based on the base feature value type)").toString());
                }
                BaseTaggedDependency baseFeature = config.join().base();
                TaggedDependency expansionFeature = config.join().expansion();
                Seq consumedFeatures = (Seq)new .colon.colon((Object)ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)baseFeature.key().map((Function1)((TraversableOnce)config.key().zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom())), baseFeature.feature()), (List)new .colon.colon((Object)ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)Nil$.MODULE$), expansionFeature.feature()), (List)Nil$.MODULE$));
                SeqJoinDerivationFunction seqJoinDerivationFunction = new SeqJoinDerivationFunction(baseFeature, expansionFeature, config.aggregation());
                derivedFeature2 = new DerivedFeature((Seq<ErasedEntityTaggedFeature>)consumedFeatures, (Seq<String>)producedFeatures, seqJoinDerivationFunction, (Option<Seq<String>>)None$.MODULE$, (Map<String, FeatureTypeConfig>)featureTypeConfigMap);
            } else if (objectNode.has("sqlExpr")) {
                String definition = objectNode.get("sqlExpr").textValue();
                Seq keyTag = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
                SQLFeatureDerivationFunction derivationFunction = new SQLFeatureDerivationFunction(definition, SQLFeatureDerivationFunction$.MODULE$.$lessinit$greater$default$2());
                Seq consumedFeatures = (Seq)derivationFunction.dependencyFeatureNames().map((Function1 & Serializable & scala.Serializable)x$9 -> ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)keyTag, (String)x$9), Seq$.MODULE$.canBuildFrom());
                derivedFeature2 = new DerivedFeature((Seq<ErasedEntityTaggedFeature>)consumedFeatures, (Seq<String>)producedFeatures, derivationFunction, (Option<Seq<String>>)None$.MODULE$, (Map<String, FeatureTypeConfig>)featureTypeConfigMap);
            } else if (objectNode.has("definition") && !objectNode.has("inputs")) {
                String definition = objectNode.get("definition").textValue();
                Seq keyTag = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
                SimpleMvelDerivationFunction derivationFunction = new SimpleMvelDerivationFunction(definition, featureName, (Option<FeatureTypeConfig>)featureTypeConfigMap.get((Object)featureName));
                Seq consumedFeatures = (Seq)derivationFunction.dependencyFeatureNames().map((Function1 & Serializable & scala.Serializable)x$10 -> ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)keyTag, (String)x$10), Seq$.MODULE$.canBuildFrom());
                derivedFeature2 = new DerivedFeature((Seq<ErasedEntityTaggedFeature>)consumedFeatures, (Seq<String>)producedFeatures, derivationFunction, (Option<Seq<String>>)None$.MODULE$, (Map<String, FeatureTypeConfig>)featureTypeConfigMap);
            } else {
                DerivedFeatureConfig config = (DerivedFeatureConfig)codec.treeToValue((TreeNode)objectNode, DerivedFeatureConfig.class);
                IndexedSeq consumedFeatures = ((TraversableOnce)config.inputs().values().map((Function1 & Serializable & scala.Serializable)x -> ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)x.key().map((Function1)((TraversableOnce)config.key().zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom())), x.feature()), Iterable$.MODULE$.canBuildFrom())).toIndexedSeq();
                Option<String> option = config.SQLExpr();
                None$ none$ = None$.MODULE$;
                FeatureDerivationFunctionBase derivationFunction = (option == null ? none$ != null : !option.equals((Object)none$)) ? new SQLFeatureDerivationFunction((String)config.SQLExpr().get(), (Option<Seq<String>>)new Some((Object)config.inputs().keys().toIndexedSeq())) : new MvelFeatureDerivationFunction(config.inputs(), (String)config.definition().get(), featureName, (Option<FeatureTypeConfig>)featureTypeConfigMap.get((Object)featureName));
                Some parameterNames = new Some((Object)config.inputs().keys().toIndexedSeq());
                derivedFeature2 = new DerivedFeature((Seq<ErasedEntityTaggedFeature>)consumedFeatures, (Seq<String>)producedFeatures, derivationFunction, (Option<Seq<String>>)parameterNames, (Map<String, FeatureTypeConfig>)featureTypeConfigMap);
            }
            derivedFeature = derivedFeature2;
        } else {
            throw new MatchError((Object)treeNode);
        }
        DerivedFeature derivedFeature3 = derivedFeature;
        Seq<String> configProvidedFeatures = derivedFeature3.producedFeatureNames();
        try {
            Seq<String> extractorProvidedFeatures = derivedFeature3.getOutputFeatureList();
            if (!package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList(extractorProvidedFeatures).containsAll(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList(configProvidedFeatures))) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(130).append("Derivation ").append(p.getParsingContext().getCurrentName()).append(" configured for some features different").append("from its transformer claims to provide. Derivation returned: ").append(extractorProvidedFeatures).append("; config provided: ").append(configProvidedFeatures).toString());
            }
            if (!configProvidedFeatures.equals((Object)extractorProvidedFeatures.toSet())) {
                this.log().warn(new StringBuilder(123).append("Derivation ").append(p.getParsingContext().getCurrentName()).append(" extractor's getOutputFeatureList and feature definition are different. Derivation ").append("returned: ").append(extractorProvidedFeatures).append("; config provided: ").append(configProvidedFeatures).toString());
            }
        }
        catch (RuntimeException runtimeException) {}
        return derivedFeature3;
    }

    public DerivedFeature loadAdvancedDerivedFeature(ObjectNode node, ObjectCodec codec) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2<Seq<TaggedDependency>, Option<Seq<String>>> tuple23;
        Tuple2 tuple24;
        Seq keys = (Seq)FeathrConfigLoader$.MODULE$.extractStringList(node.get("key")).zipWithIndex(Seq$.MODULE$.canBuildFrom());
        if (node.get("class").isTextual()) {
            tuple24 = new Tuple2((Object)node.get("class").textValue(), (Object)None$.MODULE$);
        } else if (node.get("class").isObject()) {
            Config config = ConfigFactory.parseString((String)node.get("class").toString());
            tuple24 = new Tuple2((Object)config.getString("name"), (Object)new Some((Object)config));
        } else {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(52).append("the class of ").append(node).append(" should be either an object or a string").toString());
        }
        Tuple2 tuple25 = tuple24;
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        String derivationClassName = (String)tuple25._1();
        Option paramsConfigsOpt = (Option)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)derivationClassName, (Object)paramsConfigsOpt);
        Tuple2 tuple27 = tuple26;
        String derivationClassName2 = (String)tuple27._1();
        Option paramsConfigsOpt2 = (Option)tuple27._2();
        FeatureDerivationFunctionBase derivationFunction = (FeatureDerivationFunctionBase)Class.forName(derivationClassName2).newInstance();
        if (paramsConfigsOpt2.isDefined()) {
            derivationFunction.init((Config)paramsConfigsOpt2.get());
        }
        if ((tuple23 = FeathrConfigLoader$.MODULE$.extractTaggedDependency(node.get("inputs"), codec)) == null) {
            throw new MatchError(tuple23);
        }
        Seq inputs = (Seq)tuple23._1();
        Option parameterNamesInConfig = (Option)tuple23._2();
        Tuple2 tuple28 = new Tuple2((Object)inputs, (Object)parameterNamesInConfig);
        Tuple2 tuple29 = tuple28;
        Seq inputs2 = (Seq)tuple29._1();
        Option parameterNamesInConfig2 = (Option)tuple29._2();
        if (inputs2.isEmpty()) {
            Seq<JoiningFeatureParams> dependFeatureList = derivationFunction.getInputFeatureList();
            IndexedSeq features = ((TraversableOnce)dependFeatureList.map((Function1 & Serializable & scala.Serializable)stringTaggedFeature -> {
                TaggedDependency taggedDependency = new TaggedDependency(stringTaggedFeature.keyTags(), stringTaggedFeature.featureName());
                return ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)taggedDependency.key().map((Function1)keys.toMap(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom())), taggedDependency.feature());
            }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
            Some parameterNames = new Some(dependFeatureList.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.featureName(), Seq$.MODULE$.canBuildFrom()));
            tuple22 = new Tuple2((Object)features, (Object)parameterNames);
        } else {
            IndexedSeq features = ((TraversableOnce)inputs2.map((Function1 & Serializable & scala.Serializable)x -> ErasedEntityTaggedFeature$.MODULE$.apply((Seq<Object>)((Seq)x.key().map((Function1)keys.toMap(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom())), x.feature()), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
            tuple22 = tuple2 = new Tuple2((Object)features, (Object)parameterNamesInConfig2);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexedSeq consumedFeatures = (IndexedSeq)tuple2._1();
        Option parameterNames = (Option)tuple2._2();
        Tuple2 tuple210 = new Tuple2((Object)consumedFeatures, (Object)parameterNames);
        Tuple2 tuple211 = tuple210;
        IndexedSeq consumedFeatures2 = (IndexedSeq)tuple211._1();
        Option parameterNames2 = (Option)tuple211._2();
        Seq<String> producedFeatures = derivationFunction.getOutputFeatureList();
        Seq<String> outputFeaturesInConfig = FeathrConfigLoader$.MODULE$.extractStringList(node.get("features"));
        if (!package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList(producedFeatures).containsAll(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList(outputFeaturesInConfig))) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(106).append("getOutputFeatureList of ").append(derivationClassName2).append(" should contain all feature names listed in config ").append(node).append(", but found ").append(producedFeatures).append(" and ").append(outputFeaturesInConfig).append(", respectively").toString());
        }
        return new DerivedFeature((Seq<ErasedEntityTaggedFeature>)consumedFeatures2, outputFeaturesInConfig, derivationFunction, (Option<Seq<String>>)parameterNames2, DerivedFeature$.MODULE$.apply$default$5());
    }
}

