/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.FeatureGroupsGenerator$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.derived.functions.SeqJoinDerivationFunction;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!B\u000b\u0017\u0001a\u0001\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u0011e\u0002!\u0011!Q\u0001\niBQ!\u0010\u0001\u0005\u0002yBqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0012\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019\u0019\u0006\u0001)A\u0005S!)A\u000b\u0001C\u0001+\")A\f\u0001C\u0005;\")\u0011\u000f\u0001C\u0005e\")!\u0010\u0001C\u0005w\")a\u0010\u0001C\u0005\u007f\"9\u00111\u0001\u0001\u0005\n\u0005\u0015q\u0001CA\u0006-!\u0005\u0001$!\u0004\u0007\u000fU1\u0002\u0012\u0001\r\u0002\u0010!1Qh\u0004C\u0001\u0003#Aq!a\u0005\u0010\t\u0003\t)\u0002C\u0005\u0002 =\t\n\u0011\"\u0001\u0002\"!9\u00111C\b\u0005\u0002\u0005]\u0002\"CA\u001e\u001fE\u0005I\u0011AA\u0011\u0005Y1U-\u0019;ve\u0016<%o\\;qg\u001e+g.\u001a:bi>\u0014(BA\f\u0019\u0003\u0019\u0019wN\u001c4jO*\u0011\u0011DG\u0001\b_\u001a4G.\u001b8f\u0015\tYB$\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003;y\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002?\u0005\u00191m\\7\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-A\tgK\u0006$XO]3EK\u001a\u001cuN\u001c4jON\u001c\u0001\u0001E\u0002+eUr!a\u000b\u0019\u000f\u00051zS\"A\u0017\u000b\u00059B\u0013A\u0002\u001fs_>$h(C\u0001%\u0013\t\t4%A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$aA*fc*\u0011\u0011g\t\t\u0003m]j\u0011AF\u0005\u0003qY\u0011ABR3bi\"\u00148i\u001c8gS\u001e\fq\u0003\\8dC2|e/\u001a:sS\u0012,G)\u001a4D_:4\u0017nZ:\u0011\u0007\tZ\u0014&\u0003\u0002=G\t1q\n\u001d;j_:\fa\u0001P5oSRtDcA A\u0003B\u0011a\u0007\u0001\u0005\u0006O\r\u0001\r!\u000b\u0005\bs\r\u0001\n\u00111\u0001;\u0003\rawnZ\u000b\u0002\tB\u0011QIT\u0007\u0002\r*\u0011q\tS\u0001\u0006Y><GG\u001b\u0006\u0003\u0013*\u000bq\u0001\\8hO&twM\u0003\u0002L\u0019\u00061\u0011\r]1dQ\u0016T\u0011!T\u0001\u0004_J<\u0017BA(G\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u001d\u0019wN\u001c4jON,\u0012!K\u0001\tG>tg-[4tA\u0005\u0001r-\u001a;GK\u0006$XO]3He>,\bo\u001d\u000b\u0002-B\u0011qKW\u0007\u00021*\u0011\u0011\fG\u0001\bY><\u0017nY1m\u0013\tY\u0006LA\u0007GK\u0006$XO]3He>,\bo]\u0001\u0017O\u0016$\u0018I\\2i_J,GMR3biV\u0014Xm]'baR\ta\f\u0005\u0003`G\u001aLgB\u00011b!\ta3%\u0003\u0002cG\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\u00075\u000b\u0007O\u0003\u0002cGA\u0011qlZ\u0005\u0003Q\u0016\u0014aa\u0015;sS:<\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u001d1W-\u0019;ve\u0016T!A\u001c\r\u0002\u0011\u0005t7\r[8sK\u0012L!\u0001]6\u0003/\u0019+\u0017\r^;sK\u0006s7\r[8s/&$\bnU8ve\u000e,\u0017!F4fi\u0012+'/\u001b<fI\u001a+\u0017\r^;sKNl\u0015\r\u001d\u000b\u0002gB!ql\u00194u!\t)\b0D\u0001w\u0015\t9\b$A\u0004eKJLg/\u001a3\n\u0005e4(A\u0004#fe&4X\r\u001a$fCR,(/Z\u0001\u001aO\u0016$\b+Y:t)\"\u0014x.^4i\r\u0016\fG/\u001e:fg6\u000b\u0007\u000f\u0006\u0002_y\")Qp\u0003a\u0001=\u00061\u0012\r\u001c7B]\u000eDwN]3e\r\u0016\fG/\u001e:fg6\u000b\u0007/\u0001\u000bhKR<\u0016N\u001c3po\u001a+\u0017\r^;sKNl\u0015\r\u001d\u000b\u0004=\u0006\u0005\u0001\"B?\r\u0001\u0004q\u0016!F4fiN+\u0017OS8j]\u001a+\u0017\r^;sKNl\u0015\r\u001d\u000b\u0004g\u0006\u001d\u0001BBA\u0005\u001b\u0001\u00071/A\u000bbY2$UM]5wK\u00124U-\u0019;ve\u0016\u001cX*\u00199\u0002-\u0019+\u0017\r^;sK\u001e\u0013x.\u001e9t\u000f\u0016tWM]1u_J\u0004\"AN\b\u0014\u0005=\tCCAA\u0007\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u0014qCA\u000e\u0011\u0019\tI\"\u0005a\u0001S\u0005\tb-Z1ukJ,G)\u001a4d_:4\u0017nZ:\t\u0011\u0005u\u0011\u0003%AA\u0002i\nq\u0002\\8dC2$UMZ\"p]\u001aLwm]\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0005\u0016\u0004u\u0005\u00152FAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E2%\u0001\u0006b]:|G/\u0019;j_:LA!!\u000e\u0002,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015\u0007}\nI\u0004\u0003\u0004\u0002\u001aM\u0001\r!K\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a")
public class FeatureGroupsGenerator {
    private final Option<Seq<FeathrConfig>> localOverrideDefConfigs;
    private final Logger log;
    private final Seq<FeathrConfig> configs;

    public static Option<Seq<FeathrConfig>> $lessinit$greater$default$2() {
        return FeatureGroupsGenerator$.MODULE$.$lessinit$greater$default$2();
    }

    public static FeatureGroupsGenerator apply(Seq<FeathrConfig> seq) {
        return FeatureGroupsGenerator$.MODULE$.apply(seq);
    }

    public static Option<Seq<FeathrConfig>> apply$default$2() {
        return FeatureGroupsGenerator$.MODULE$.apply$default$2();
    }

    public static FeatureGroupsGenerator apply(Seq<FeathrConfig> seq, Option<Seq<FeathrConfig>> option) {
        return FeatureGroupsGenerator$.MODULE$.apply(seq, option);
    }

    private Logger log() {
        return this.log;
    }

    private Seq<FeathrConfig> configs() {
        return this.configs;
    }

    public FeatureGroups getFeatureGroups() {
        Map<String, FeatureAnchorWithSource> allAnchoredFeatures = this.getAnchoredFeaturesMap();
        Map<String, DerivedFeature> allDerivedFeatures = this.getDerivedFeaturesMap();
        Map<String, FeatureAnchorWithSource> allPassThroughFeatures = this.getPassThroughFeaturesMap(allAnchoredFeatures);
        Map<String, FeatureAnchorWithSource> allWindowAggFeatures = this.getWindowFeaturesMap(allAnchoredFeatures);
        Map<String, DerivedFeature> allSeqJoinFeatures = this.getSeqJoinFeaturesMap(allDerivedFeatures);
        return new FeatureGroups(allAnchoredFeatures, allDerivedFeatures, allWindowAggFeatures, allPassThroughFeatures, allSeqJoinFeatures);
    }

    private Map<String, FeatureAnchorWithSource> getAnchoredFeaturesMap() {
        HashMap result;
        block0: {
            result = HashMap$.MODULE$.empty();
            HashSet localOverrideAnchorFeatureNames = HashSet$.MODULE$.empty();
            ((IterableLike)this.configs().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.anchoredFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    FeatureAnchorWithSource v;
                    String k;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (FeatureAnchorWithSource)tuple2._2();
                        Option exist = result$1.get((Object)k);
                        if (exist.isDefined()) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(118).append("We detected a duplicate Anchor feature '").append(k).append("' in your feature def config. Please remove one of them or rename the feature.").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$1.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
            if (this.localOverrideDefConfigs.isEmpty()) break block0;
            ((IterableLike)((TraversableLike)this.localOverrideDefConfigs.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.anchoredFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    FeatureAnchorWithSource v;
                    String k;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (FeatureAnchorWithSource)tuple2._2();
                        if (localOverrideAnchorFeatureNames$1.contains((Object)k)) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(125).append("We detected a duplicate Anchor feature '").append(k).append("' in your local override def config. Please remove one of them or rename the feature.").toString());
                        }
                        localOverrideAnchorFeatureNames$1.add((Object)k);
                        Option exist = result$1.get((Object)k);
                        if (exist.isDefined()) {
                            $this.log().info(new StringBuilder(43).append("Anchor feature '").append(k).append("' is being overridden by '").append(exist.get()).append("'").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$1.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
        }
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, DerivedFeature> getDerivedFeaturesMap() {
        HashMap result;
        block0: {
            result = HashMap$.MODULE$.empty();
            HashSet localOverrideDerivedFeatureNames = HashSet$.MODULE$.empty();
            ((IterableLike)this.configs().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.derivedFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    DerivedFeature v;
                    String k;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (DerivedFeature)tuple2._2();
                        Option exist = result$2.get((Object)k);
                        if (exist.isDefined()) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(119).append("We detected a duplicate derived feature '").append(k).append("' in your feature def config. Please remove one of them or rename the feature.").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$2.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
            if (this.localOverrideDefConfigs.isEmpty()) break block0;
            ((IterableLike)((TraversableLike)this.localOverrideDefConfigs.get()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.derivedFeatures(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
                m.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    DerivedFeature v;
                    String k;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        k = (String)tuple2._1();
                        v = (DerivedFeature)tuple2._2();
                        if (localOverrideDerivedFeatureNames$1.contains((Object)k)) {
                            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(126).append("We detected a duplicate derived feature '").append(k).append("' in your local override def config. Please remove one of them or rename the feature.").toString());
                        }
                        localOverrideDerivedFeatureNames$1.add((Object)k);
                        Option exist = result$2.get((Object)k);
                        if (exist.isDefined()) {
                            $this.log().info(new StringBuilder(44).append("Derived feature '").append(k).append("' is being overridden by '").append(exist.get()).append("'").toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Option option = result$2.put((Object)k, (Object)v);
                    return option;
                });
                return BoxedUnit.UNIT;
            });
        }
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, FeatureAnchorWithSource> getPassThroughFeaturesMap(Map<String, FeatureAnchorWithSource> allAnchoredFeaturesMap) {
        return (Map)allAnchoredFeaturesMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FeatureGroupsGenerator.$anonfun$getPassThroughFeaturesMap$1(x0$1)));
    }

    private Map<String, FeatureAnchorWithSource> getWindowFeaturesMap(Map<String, FeatureAnchorWithSource> allAnchoredFeaturesMap) {
        return (Map)allAnchoredFeaturesMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FeatureGroupsGenerator.$anonfun$getWindowFeaturesMap$1(x0$1)));
    }

    private Map<String, DerivedFeature> getSeqJoinFeaturesMap(Map<String, DerivedFeature> allDerivedFeaturesMap) {
        return (Map)allDerivedFeaturesMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FeatureGroupsGenerator.$anonfun$getSeqJoinFeaturesMap$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getPassThroughFeaturesMap$1(Tuple2 x0$1) {
        FeatureAnchorWithSource anchorConfig;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                anchorConfig = (FeatureAnchorWithSource)tuple2._2();
                if (tuple2._1() != null && anchorConfig != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        FeatureAnchorWithSource featureAnchorWithSource = anchorConfig;
        String string = featureAnchorWithSource.source().path();
        String string2 = "PASSTHROUGH";
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getWindowFeaturesMap$1(Tuple2 x0$1) {
        FeatureAnchorWithSource anchorConfig;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$1;
                if (tuple2 == null) break block2;
                String featureName = (String)tuple2._1();
                anchorConfig = (FeatureAnchorWithSource)tuple2._2();
                if (featureName != null && anchorConfig != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        FeatureAnchorWithSource featureAnchorWithSource = anchorConfig;
        boolean bl = SlidingWindowFeatureUtils$.MODULE$.isWindowAggAnchor(featureAnchorWithSource);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getSeqJoinFeaturesMap$1(Tuple2 x0$1) {
        DerivedFeature featureObj;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null || (featureObj = (DerivedFeature)tuple2._2()) == null) {
            throw new MatchError((Object)tuple2);
        }
        DerivedFeature derivedFeature = featureObj;
        boolean bl = derivedFeature.derivation() instanceof SeqJoinDerivationFunction;
        return bl;
    }

    public FeatureGroupsGenerator(Seq<FeathrConfig> featureDefConfigs, Option<Seq<FeathrConfig>> localOverrideDefConfigs) {
        this.localOverrideDefConfigs = localOverrideDefConfigs;
        this.log = LogManager.getLogger(this.getClass());
        this.configs = featureDefConfigs.isEmpty() ? (Seq)localOverrideDefConfigs.get() : featureDefConfigs;
    }
}

