/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.ConflictsAutoCorrectionSetting;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.KeyedFeatureList;
import com.linkedin.feathr.offline.config.ObservationDataTimeSetting;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194Aa\u0003\u0007\u0005/!)a\u0005\u0001C\u0001O\u0015!\u0011\u0006\u0001\u0001+\u0011\u001d1\u0005A1A\u0005\n\u001dCaa\u0014\u0001!\u0002\u0013A\u0005b\u0002)\u0001\u0005\u0004%Ia\u0012\u0005\u0007#\u0002\u0001\u000b\u0011\u0002%\t\u000fI\u0003!\u0019!C\u0005\u000f\"11\u000b\u0001Q\u0001\n!CQ\u0001\u0016\u0001\u0005BUCQa\u0019\u0001\u0005\n\u0011\u0014QDR3biV\u0014XMS8j]\u000e{gNZ5h\t\u0016\u001cXM]5bY&TXM\u001d\u0006\u0003\u001b9\taaY8oM&<'BA\b\u0011\u0003\u001dygM\u001a7j]\u0016T!!\u0005\n\u0002\r\u0019,\u0017\r\u001e5s\u0015\t\u0019B#\u0001\u0005mS:\\W\rZ5o\u0015\u0005)\u0012aA2p[\u000e\u00011C\u0001\u0001\u0019!\rI\u0002EI\u0007\u00025)\u00111\u0004H\u0001\tI\u0006$\u0018MY5oI*\u0011QDH\u0001\bU\u0006\u001c7n]8o\u0015\tyB#A\u0005gCN$XM\u001d=nY&\u0011\u0011E\u0007\u0002\u0011\u0015N|g\u000eR3tKJL\u0017\r\\5{KJ\u0004\"a\t\u0013\u000e\u00031I!!\n\u0007\u0003#\u0019+\u0017\r^;sK*{\u0017N\\\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u00111\u0005\u0001\u0002\u0004\u0003J<\u0007\u0003B\u00165oir!\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=2\u0012A\u0002\u001fs_>$hHC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u00121!T1q\u0015\t\u0019\u0004\u0007\u0005\u0002,q%\u0011\u0011H\u000e\u0002\u0007'R\u0014\u0018N\\4\u0011\u0007m\u00025I\u0004\u0002=}9\u0011Q&P\u0005\u0002c%\u0011q\bM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%IA\u0002TKFT!a\u0010\u0019\u0011\u0005\r\"\u0015BA#\r\u0005AYU-_3e\r\u0016\fG/\u001e:f\u0019&\u001cH/\u0001\u0010P\u0005N+%KV!U\u0013>su\fR!U\u0003~#\u0016*T#`'\u0016#F+\u0013(H'V\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006!A.\u00198h\u0015\u0005i\u0015\u0001\u00026bm\u0006L!!\u000f&\u0002?=\u00135+\u0012*W\u0003RKuJT0E\u0003R\u000bu\fV%N\u000b~\u001bV\t\u0016+J\u001d\u001e\u001b\u0006%\u0001\nK\u001f&su\fV%N\u000b~\u001bV\t\u0016+J\u001d\u001e\u001b\u0016a\u0005&P\u0013:{F+S'F?N+E\u000bV%O\u000fN\u0003\u0013AI\"P\u001d\u001ac\u0015j\u0011+T?\u0006+FkT0D\u001fJ\u0013Vi\u0011+J\u001f:{6+\u0012+U\u0013:;5+A\u0012D\u001f:3E*S\"U'~\u000bU\u000bV(`\u0007>\u0013&+R\"U\u0013>sulU#U)&sui\u0015\u0011\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004EYs\u0006\"B,\n\u0001\u0004A\u0016A\u00016q!\tIF,D\u0001[\u0015\tYF$\u0001\u0003d_J,\u0017BA/[\u0005)Q5o\u001c8QCJ\u001cXM\u001d\u0005\u0006?&\u0001\r\u0001Y\u0001\u0005GRDH\u000f\u0005\u0002\u001aC&\u0011!M\u0007\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]\u000e{g\u000e^3yi\u0006q\u0002/\u0019:tK\u001a+\u0017\r^;sK*{\u0017N\\\"p]\u001aLwmU3ui&twm\u001d\u000b\u0004K\"l\u0007CA\u0012g\u0013\t9GB\u0001\nK_&t7i\u001c8gS\u001e\u001cV\r\u001e;j]\u001e\u001c\b\"B5\u000b\u0001\u0004Q\u0017\u0001D:fiRLgnZ:O_\u0012,\u0007CA\rl\u0013\ta'D\u0001\u0005Kg>tgj\u001c3f\u0011\u00159&\u00021\u0001Y\u0001")
public class FeatureJoinConfigDeserializer
extends JsonDeserializer<FeatureJoinConfig> {
    private final String OBSERVATION_DATA_TIME_SETTINGS;
    private final String JOIN_TIME_SETTINGS;
    private final String CONFLICTS_AUTO_CORRECTION_SETTINGS;

    private String OBSERVATION_DATA_TIME_SETTINGS() {
        return this.OBSERVATION_DATA_TIME_SETTINGS;
    }

    private String JOIN_TIME_SETTINGS() {
        return this.JOIN_TIME_SETTINGS;
    }

    private String CONFLICTS_AUTO_CORRECTION_SETTINGS() {
        return this.CONFLICTS_AUTO_CORRECTION_SETTINGS;
    }

    public FeatureJoinConfig deserialize(JsonParser jp, DeserializationContext ctxt) {
        JsonNode settingsNode;
        JsonNode rootNode = (JsonNode)jp.readValueAsTree();
        ((ObjectNode)rootNode).remove("observationPath");
        ((ObjectNode)rootNode).remove("outputPath");
        JsonNode jsonNode = settingsNode = ((ObjectNode)rootNode).remove("settings");
        Object object = jsonNode == null ? None$.MODULE$ : new Some((Object)this.parseFeatureJoinConfigSettings(settingsNode, jp));
        None$ settingsConfig = object;
        TreeTraversingParser featuresTreeParser = new TreeTraversingParser(rootNode, jp.getCodec());
        Map groupFeatures = (Map)featuresTreeParser.getCodec().readValue((JsonParser)featuresTreeParser, (TypeReference)new TypeReference<Map<String, Seq<KeyedFeatureList>>>(null){});
        return new FeatureJoinConfig((Map<String, Seq<KeyedFeatureList>>)groupFeatures, (Option<JoinConfigSettings>)settingsConfig);
    }

    private JoinConfigSettings parseFeatureJoinConfigSettings(JsonNode settingsNode, JsonParser jp) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        Set supportedSettingFields = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.OBSERVATION_DATA_TIME_SETTINGS(), this.JOIN_TIME_SETTINGS(), this.CONFLICTS_AUTO_CORRECTION_SETTINGS()}));
        Set unrecognizedFields = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(settingsNode.fieldNames()).asScala()).toSet().$minus$minus((GenTraversableOnce)supportedSettingFields);
        if (unrecognizedFields.nonEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(72).append("unrecognized: ").append(unrecognizedFields.mkString(" ")).append(" in 'settings'. current supported configurations include ").append(supportedSettingFields).append(".").toString());
        }
        JsonNode jsonNode = settingsNode.get(this.OBSERVATION_DATA_TIME_SETTINGS());
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            TreeTraversingParser observationDataTimeConfigTreeParser = new TreeTraversingParser((JsonNode)objectNode, jp.getCodec());
            none$3 = new Some(observationDataTimeConfigTreeParser.getCodec().readValue((JsonParser)observationDataTimeConfigTreeParser, ObservationDataTimeSetting.class));
        } else {
            none$3 = None$.MODULE$;
        }
        None$ observationDataTimeSettingsDefinition = none$3;
        JsonNode jsonNode2 = settingsNode.get(this.JOIN_TIME_SETTINGS());
        if (jsonNode2 instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode2;
            TreeTraversingParser joinTimeConfigTreeParser = new TreeTraversingParser((JsonNode)objectNode, jp.getCodec());
            none$2 = new Some(joinTimeConfigTreeParser.getCodec().readValue((JsonParser)joinTimeConfigTreeParser, JoinTimeSetting.class));
        } else {
            none$2 = None$.MODULE$;
        }
        None$ joinTimeSettingsDefinition = none$2;
        JsonNode jsonNode3 = settingsNode.get(this.CONFLICTS_AUTO_CORRECTION_SETTINGS());
        if (jsonNode3 instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode3;
            TreeTraversingParser autoCorrectionTreeParser = new TreeTraversingParser((JsonNode)objectNode, jp.getCodec());
            none$ = new Some(autoCorrectionTreeParser.getCodec().readValue((JsonParser)autoCorrectionTreeParser, ConflictsAutoCorrectionSetting.class));
        } else {
            none$ = None$.MODULE$;
        }
        None$ conflictsAutoCorrectionSetting = none$;
        return new JoinConfigSettings((Option<ObservationDataTimeSetting>)observationDataTimeSettingsDefinition, (Option<JoinTimeSetting>)joinTimeSettingsDefinition, (Option<ConflictsAutoCorrectionSetting>)conflictsAutoCorrectionSetting);
    }

    public FeatureJoinConfigDeserializer() {
        this.OBSERVATION_DATA_TIME_SETTINGS = "observationDataTimeSettings";
        this.JOIN_TIME_SETTINGS = "joinTimeSettings";
        this.CONFLICTS_AUTO_CORRECTION_SETTINGS = "conflictsAutoCorrectionSettings";
    }
}

