/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.ConfigLoaderUtils$;
import com.linkedin.feathr.offline.config.SQLFeatureDefinition;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A2Aa\u0001\u0003\u0001\u001f!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E\t\u00013+\u0015'GK\u0006$XO]3EK\u001aLg.\u001b;j_:$Um]3sS\u0006d\u0017N_3s\u0015\t)a!\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u000f!\tqa\u001c4gY&tWM\u0003\u0002\n\u0015\u00051a-Z1uQJT!a\u0003\u0007\u0002\u00111Lgn[3eS:T\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u00012!\u0005\r\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003!!\u0017\r^1cS:$'BA\u000b\u0017\u0003\u001dQ\u0017mY6t_:T!a\u0006\u0007\u0002\u0013\u0019\f7\u000f^3sq6d\u0017BA\r\u0013\u0005AQ5o\u001c8EKN,'/[1mSj,'\u000f\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\t!2+\u0015'GK\u0006$XO]3EK\u001aLg.\u001b;j_:\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005m\u0001\u0011a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2AG\u0012,\u0011\u0015!#\u00011\u0001&\u0003\u0005\u0001\bC\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0015\u0003\u0011\u0019wN]3\n\u0005):#A\u0003&t_:\u0004\u0016M]:fe\")AF\u0001a\u0001[\u0005!1\r\u001e=u!\t\tb&\u0003\u00020%\t1B)Z:fe&\fG.\u001b>bi&|gnQ8oi\u0016DH\u000f")
public class SQLFeatureDefinitionDeserializer
extends JsonDeserializer<SQLFeatureDefinition> {
    public SQLFeatureDefinition deserialize(JsonParser p, DeserializationContext ctxt) {
        String string;
        ObjectCodec codec = p.getCodec();
        TreeNode node = codec.readTree(p);
        Option<FeatureTypeConfig> typeConfig = ConfigLoaderUtils$.MODULE$.getTypeConfig(node);
        TreeNode treeNode = node;
        if (treeNode instanceof ObjectNode) {
            ObjectNode objectNode;
            TreeNode treeNode2 = node.get("def");
            if (treeNode2 instanceof TextNode) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(239).append("Trying to deserialize the config into SQLFeatureDefinition.").append("Invalid anchor config ").append(node).append(" is found. Should not use 'def' ").append("field with string value, since'def' field with a string value is reserved for MVEL expression").append("Please provide def.sqlExpr field.").toString());
            }
            if (treeNode2 instanceof ObjectNode) {
                objectNode = (ObjectNode)treeNode2;
                if (objectNode.size() != 1) {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(267).append("Trying to deserialize the config into SQLFeatureDefinition.").append("Invalid anchor config ").append(node).append(" found: 'def' can only has one child node which ").append("is 'sqlExpr'.").append("Please only specify sqlExpr under def node and for all other field, such as default/type, please set as sibling node of 'def'").toString());
                }
            } else {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(181).append("Trying to deserialize the config into SQLFeatureDefinition.").append("Invalid anchor config ").append(node).append(" found: 'def' field with 'sqlExpr' is required in SQL based feature").append("Please provide def.sqlExpr field.").toString());
            }
            string = objectNode.get("sqlExpr").textValue();
        } else {
            throw new MatchError((Object)treeNode);
        }
        SQLFeatureDefinition sQLFeatureDefinition = new SQLFeatureDefinition(string, typeConfig);
        return sQLFeatureDefinition;
    }
}

