/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.evaluator.aggregation;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.compute.Aggregation;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.exception.ErrorLabel;
import com.linkedin.feathr.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.WindowTimeUnit$;
import com.linkedin.feathr.offline.client.NOT_VISITED$;
import com.linkedin.feathr.offline.client.VISITED$;
import com.linkedin.feathr.offline.client.VisitedState;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.evaluator.NodeEvaluator;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata$;
import com.linkedin.feathr.offline.graph.FCMGraphTraverser;
import com.linkedin.feathr.offline.graph.NodeGrouper$;
import com.linkedin.feathr.offline.graph.NodeUtils$;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.DataFrameDefaultValueSubstituter$;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.swj.FactData;
import com.linkedin.feathr.swj.GroupBySpec;
import com.linkedin.feathr.swj.LabelData;
import com.linkedin.feathr.swj.LateralViewParams;
import com.linkedin.feathr.swj.SlidingWindowFeature;
import com.linkedin.feathr.swj.SlidingWindowJoin$;
import com.linkedin.feathr.swj.WindowSpec;
import com.linkedin.feathr.swj.aggregate.AggregationSpec;
import com.linkedin.feathr.swj.aggregate.AggregationType$;
import com.linkedin.feathr.swj.aggregate.AvgAggregate;
import com.linkedin.feathr.swj.aggregate.AvgAggregate$;
import com.linkedin.feathr.swj.aggregate.AvgPoolingAggregate;
import com.linkedin.feathr.swj.aggregate.AvgPoolingAggregate$;
import com.linkedin.feathr.swj.aggregate.CountAggregate;
import com.linkedin.feathr.swj.aggregate.LatestAggregate;
import com.linkedin.feathr.swj.aggregate.MaxAggregate;
import com.linkedin.feathr.swj.aggregate.MaxPoolingAggregate;
import com.linkedin.feathr.swj.aggregate.MinAggregate;
import com.linkedin.feathr.swj.aggregate.MinPoolingAggregate;
import com.linkedin.feathr.swj.aggregate.SumAggregate;
import java.io.Serializable;
import java.time.Duration;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class AggregationNodeEvaluator$
implements NodeEvaluator {
    public static AggregationNodeEvaluator$ MODULE$;

    static {
        new AggregationNodeEvaluator$();
    }

    private LabelData getLabelData(Aggregation aggregation, Option<JoinConfigSettings> joinConfigSettings, Dataset<Row> df, Map<Object, DataframeAndColumnMetadata> nodeIdToDataframeAndColumnMetadataMap) {
        Buffer concreteKeys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)aggregation.getConcreteKey().getKey()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x -> ((DataframeAndColumnMetadata)nodeIdToDataframeAndColumnMetadataMap.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).keyExpression(), Buffer$.MODULE$.canBuildFrom());
        Buffer obsKeys = (Buffer)concreteKeys.map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(17).append("CAST (").append((String)k).append(" AS string)").toString(), Buffer$.MODULE$.canBuildFrom());
        String timestampCol = SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr(((JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get()).timestampColumn().name(), ((JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get()).timestampColumn().format(), SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr$default$3());
        String updatedTimestampExpr = joinConfigSettings.isDefined() && ((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().isDefined() && ((JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get()).useLatestFeatureData() ? "unix_timestamp()" : timestampCol;
        return new LabelData(df, (Seq<String>)obsKeys, updatedTimestampExpr);
    }

    private Option<LateralViewParams> getLateralViewParams(Aggregation aggregation) {
        None$ none$;
        None$ none$2;
        String string = (String)aggregation.getFunction().getParameters().get((Object)"lateral_view_expression_0");
        if (string != null) {
            String string2 = string;
            none$2 = new Some((Object)string2);
        } else if (string == null) {
            none$2 = None$.MODULE$;
        } else {
            throw new MatchError((Object)string);
        }
        None$ lateralViewDef = none$2;
        String string3 = (String)aggregation.getFunction().getParameters().get((Object)"lateral_view_table_alias_0");
        if (string3 != null) {
            String string4 = string3;
            none$ = new Some((Object)string4);
        } else if (string3 == null) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)string3);
        }
        None$ lateralViewAlias = none$;
        None$ lateralViewParams = lateralViewDef.isDefined() && lateralViewAlias.isDefined() ? new Some((Object)new LateralViewParams((String)lateralViewDef.get(), (String)lateralViewAlias.get(), (Option<String>)None$.MODULE$)) : None$.MODULE$;
        return lateralViewParams;
    }

    private AggregationSpec getAggSpec(Enumeration.Value aggType, String featureDef) {
        AggregationSpec aggregationSpec;
        Enumeration.Value value = aggType;
        Enumeration.Value value2 = AggregationType$.MODULE$.SUM();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            aggregationSpec = new SumAggregate(featureDef);
        } else {
            Enumeration.Value value4 = AggregationType$.MODULE$.COUNT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String rewrittenDef = new StringBuilder(40).append("CASE WHEN ").append(featureDef).append(" IS NOT NULL THEN 1 ELSE 0 END").toString();
                aggregationSpec = new CountAggregate(rewrittenDef);
            } else {
                Enumeration.Value value6 = AggregationType$.MODULE$.AVG();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    aggregationSpec = new AvgAggregate(featureDef, AvgAggregate$.MODULE$.$lessinit$greater$default$2());
                } else {
                    Enumeration.Value value8 = AggregationType$.MODULE$.MAX();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        aggregationSpec = new MaxAggregate(featureDef);
                    } else {
                        Enumeration.Value value10 = AggregationType$.MODULE$.MIN();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            aggregationSpec = new MinAggregate(featureDef);
                        } else {
                            Enumeration.Value value12 = AggregationType$.MODULE$.LATEST();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                aggregationSpec = new LatestAggregate(featureDef);
                            } else {
                                Enumeration.Value value14 = AggregationType$.MODULE$.MAX_POOLING();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    aggregationSpec = new MaxPoolingAggregate(featureDef);
                                } else {
                                    Enumeration.Value value16 = AggregationType$.MODULE$.MIN_POOLING();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        aggregationSpec = new MinPoolingAggregate(featureDef);
                                    } else {
                                        Enumeration.Value value18 = AggregationType$.MODULE$.AVG_POOLING();
                                        Enumeration.Value value19 = value;
                                        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                            aggregationSpec = new AvgPoolingAggregate(featureDef, AvgPoolingAggregate$.MODULE$.$lessinit$greater$default$2());
                                        } else {
                                            throw new MatchError((Object)value);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return aggregationSpec;
    }

    private Duration getSimTimeDelay(String featureName, Option<JoinConfigSettings> joinConfigSettings, scala.collection.immutable.Map<String, String> featuresToTimeDelayMap) {
        Duration duration;
        if (featuresToTimeDelayMap.contains((Object)featureName)) {
            if (joinConfigSettings.isEmpty() || ((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().isEmpty() || ((JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get()).simulateTimeDelay().isEmpty()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "overrideTimeDelay cannot be defined without setting a simulateTimeDelay in the joinTimeSettings");
            }
            duration = WindowTimeUnit$.MODULE$.parseWindowTime((String)featuresToTimeDelayMap.apply((Object)featureName));
        } else {
            duration = joinConfigSettings.isDefined() && ((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().isDefined() && ((JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get()).simulateTimeDelay().isDefined() ? (Duration)((JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get()).simulateTimeDelay().get() : Duration.ZERO;
        }
        return duration;
    }

    private List<FactData> getFactDataSet(scala.collection.immutable.Map<Integer, AnyNode> swaNodeIdToNode, scala.collection.immutable.Map<Integer, Seq<Integer>> swaMegaNodeMap, Aggregation aggregation, Map<Object, DataframeAndColumnMetadata> nodeIdToDataframeAndColumnMetadataMap, HashMap<String, Enumeration.Value> featureColumnFormatsMap, Option<JoinConfigSettings> joinConfigSettings, scala.collection.immutable.Map<String, String> featuresToTimeDelayMap, scala.collection.immutable.Map<Integer, String> nodeIdToFeatureName) {
        Seq allSwaFeatures = (Seq)swaMegaNodeMap.apply((Object)aggregation.getId());
        Seq nodes = (Seq)allSwaFeatures.map((Function1 & Serializable & scala.Serializable)x$1 -> (AnyNode)swaNodeIdToNode.apply(x$1), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map groupedNodes = nodes.groupBy((Function1 & Serializable & scala.Serializable)x -> {
            Option<LateralViewParams> lateralViewParams = MODULE$.getLateralViewParams(x.getAggregation());
            return new Tuple3(((DataframeAndColumnMetadata)nodeIdToDataframeAndColumnMetadataMap.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x.getAggregation().getInput().getId())))).dataSource(), ((DataframeAndColumnMetadata)nodeIdToDataframeAndColumnMetadataMap.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x.getAggregation().getInput().getId())))).keyExpression(), lateralViewParams);
        });
        return (List)((List)groupedNodes.values().toList().sortBy((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)p.size()), (Ordering)Ordering.Int$.MODULE$)).reverse().map((Function1 & Serializable & scala.Serializable)nodesAtSameLevel -> {
            Aggregation exampleNode = ((AnyNode)((IterableLike)nodesAtSameLevel.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)nodeIdToDataframeAndColumnMetadataMap.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x.getAggregation().getInput().getId())))))).head()).getAggregation();
            Dataset<Row> featureDf = ((DataframeAndColumnMetadata)nodeIdToDataframeAndColumnMetadataMap.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(exampleNode.getInput().getId())))).df();
            Seq<String> featureKeys = ((DataframeAndColumnMetadata)nodeIdToDataframeAndColumnMetadataMap.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(exampleNode.getInput().getId())))).keyExpression();
            String timestampExpr = (String)((DataframeAndColumnMetadata)nodeIdToDataframeAndColumnMetadataMap.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(exampleNode.getInput().getId())))).timestampColumn().get();
            Seq featureKeysAsString = (Seq)featureKeys.map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(17).append("CAST (").append((String)k).append(" AS string)").toString(), Seq$.MODULE$.canBuildFrom());
            Option<LateralViewParams> lateralViewParams = MODULE$.getLateralViewParams(exampleNode);
            Seq slidingWindowFeatureList = (Seq)nodesAtSameLevel.map((Function1 & Serializable & scala.Serializable)node -> {
                Some some;
                None$ none$;
                None$ none$2;
                Aggregation aggNode = node.getAggregation();
                String featureName = (String)nodeIdToFeatureName.apply((Object)aggNode.getId());
                Enumeration.Value aggType = AggregationType$.MODULE$.withName((String)aggNode.getFunction().getParameters().get((Object)"aggregation_type"));
                String featureDef = (String)aggNode.getFunction().getParameters().get((Object)"target_column");
                Tuple2 rewrittenFeatureDef = featureDef.contains(FeatureTransformation$.MODULE$.USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME()) ? new Tuple2((Object)FeatureTransformation$.MODULE$.parseMultiDimTensorExpr(featureDef), (Object)FeatureColumnFormat$.MODULE$.FDS_TENSOR()) : new Tuple2((Object)featureDef, (Object)FeatureColumnFormat$.MODULE$.RAW());
                AggregationSpec aggregationSpec = MODULE$.getAggSpec(aggType, (String)rewrittenFeatureDef._1());
                Duration window = Duration.parse((CharSequence)aggNode.getFunction().getParameters().get((Object)"window_size"));
                Duration simTimeDelay = MODULE$.getSimTimeDelay(featureName, joinConfigSettings, featuresToTimeDelayMap);
                String string = (String)aggNode.getFunction().getParameters().get((Object)"filter_expression");
                if (string != null) {
                    String string2 = string;
                    none$2 = new Some((Object)string2);
                } else if (string == null) {
                    none$2 = None$.MODULE$;
                } else {
                    throw new MatchError((Object)string);
                }
                None$ filterCondition = none$2;
                String string3 = (String)aggNode.getFunction().getParameters().get((Object)"group_by_expression");
                if (string3 != null) {
                    String string4 = string3;
                    none$ = new Some((Object)string4);
                } else if (string3 == null) {
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError((Object)string3);
                }
                None$ groupBy = none$;
                String string5 = (String)aggNode.getFunction().getParameters().get((Object)"max_number_groups");
                if (string5 != null) {
                    String string6 = string5;
                    some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(string6)).toInt()));
                } else if (string5 == null) {
                    some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                } else {
                    throw new MatchError((Object)string5);
                }
                Some limit = some;
                None$ groupbySpec = groupBy.isDefined() ? new Some((Object)new GroupBySpec((String)groupBy.get(), BoxesRunTime.unboxToInt((Object)limit.get()))) : None$.MODULE$;
                featureColumnFormatsMap.update((Object)featureName, rewrittenFeatureDef._2());
                return new SlidingWindowFeature(featureName, aggregationSpec, new WindowSpec(window, simTimeDelay), (Option<String>)filterCondition, (Option<GroupBySpec>)groupbySpec, lateralViewParams);
            }, Seq$.MODULE$.canBuildFrom());
            return new FactData(featureDf, (Seq<String>)featureKeysAsString, timestampExpr, (List<SlidingWindowFeature>)slidingWindowFeatureList.toList());
        }, List$.MODULE$.canBuildFrom());
    }

    @Override
    public Dataset<Row> batchEvaluate(Seq<AnyNode> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        HashMap<Integer, Seq<Integer>> groupedAggregationNodeMap = NodeGrouper$.MODULE$.groupSWANodes(nodes);
        scala.collection.immutable.Map swaNodeIdToNode = ((TraversableOnce)((TraversableLike)graphTraverser.nodes().filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)node.isAggregation()))).map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node.getAggregation().getId()), node), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        HashMap<String, Enumeration.Value> featureColumnFormatsMap = graphTraverser.featureColumnFormatsMap();
        scala.collection.immutable.Map<String, FeatureValue> defaultConverter = NodeUtils$.MODULE$.getDefaultConverter(nodes);
        scala.collection.immutable.Map<String, FeatureTypeConfig> featureTypeConfigs = NodeUtils$.MODULE$.getFeatureTypeConfigsMap(nodes);
        ObjectRef df = ObjectRef.create(contextDf);
        VisitedState[] processedState = (VisitedState[])Array$.MODULE$.fill(graphTraverser.nodes().length(), (Function0 & Serializable & scala.Serializable)() -> NOT_VISITED$.MODULE$, ClassTag$.MODULE$.apply(VisitedState.class));
        ((List)groupedAggregationNodeMap.values().toList().sortBy((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)p.size()), (Ordering)Ordering.Int$.MODULE$)).reverse().map((Function1 & Serializable & scala.Serializable)listOfnodeIds -> {
            Object object;
            AnyNode node = (AnyNode)swaNodeIdToNode.apply(listOfnodeIds.head());
            VisitedState visitedState = processedState[Predef$.MODULE$.Integer2int(node.getAggregation().getId())];
            VISITED$ vISITED$ = VISITED$.MODULE$;
            if (visitedState == null ? vISITED$ != null : !visitedState.equals(vISITED$)) {
                LabelData labelData = MODULE$.getLabelData(node.getAggregation(), graphTraverser.timeConfigSettings().timeConfigSettings(), (Dataset<Row>)((Dataset)df$1.elem), (Map<Object, DataframeAndColumnMetadata>)graphTraverser.nodeIdToDataframeAndColumnMetadataMap());
                List<FactData> featureDataSet = MODULE$.getFactDataSet((scala.collection.immutable.Map<Integer, AnyNode>)swaNodeIdToNode, (scala.collection.immutable.Map<Integer, Seq<Integer>>)groupedAggregationNodeMap.toMap(Predef$.MODULE$.$conforms()), node.getAggregation(), (Map<Object, DataframeAndColumnMetadata>)graphTraverser.nodeIdToDataframeAndColumnMetadataMap(), featureColumnFormatsMap, graphTraverser.timeConfigSettings().timeConfigSettings(), graphTraverser.timeConfigSettings().featuresToTimeDelayMap(), graphTraverser.nodeIdToFeatureName());
                df$1.elem = SlidingWindowJoin$.MODULE$.join(labelData, featureDataSet, SlidingWindowJoin$.MODULE$.join$default$3());
                Seq allSwaFeatures = (Seq)groupedAggregationNodeMap.apply((Object)node.getAggregation().getId());
                object = allSwaFeatures.map((Function1 & Serializable & scala.Serializable)nId -> {
                    AggregationNodeEvaluator$.$anonfun$batchEvaluate$6(graphTraverser, df, featureColumnFormatsMap, featureTypeConfigs, defaultConverter, processedState, nId);
                    return BoxedUnit.UNIT;
                }, Seq$.MODULE$.canBuildFrom());
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        }, List$.MODULE$.canBuildFrom());
        return (Dataset)df.elem;
    }

    @Override
    public Dataset<Row> evaluate(AnyNode node, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        return this.batchEvaluate((Seq<AnyNode>)((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)), graphTraverser, contextDf, dataPathHandlers);
    }

    public static final /* synthetic */ void $anonfun$batchEvaluate$6(FCMGraphTraverser graphTraverser$1, ObjectRef df$1, HashMap featureColumnFormatsMap$2, scala.collection.immutable.Map featureTypeConfigs$1, scala.collection.immutable.Map defaultConverter$1, VisitedState[] processedState$1, Integer nId) {
        String featureName = (String)graphTraverser$1.nodeIdToFeatureName().apply((Object)nId);
        df$1.elem = SlidingWindowFeatureUtils$.MODULE$.convertSWADFToFDS((Dataset<Row>)((Dataset)df$1.elem), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{featureName}))), (scala.collection.immutable.Map<String, Enumeration.Value>)featureColumnFormatsMap$2.toMap(Predef$.MODULE$.$conforms()), (scala.collection.immutable.Map<String, FeatureTypeConfig>)featureTypeConfigs$1).df();
        featureColumnFormatsMap$2.update((Object)featureName, (Object)FeatureColumnFormat$.MODULE$.FDS_TENSOR());
        df$1.elem = DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults((Dataset<Row>)((Dataset)df$1.elem), (Seq<String>)((Seq)new .colon.colon((Object)featureName, (List)Nil$.MODULE$)), (scala.collection.immutable.Map<String, FeatureValue>)defaultConverter$1, (scala.collection.immutable.Map<String, FeatureTypeConfig>)featureTypeConfigs$1, graphTraverser$1.ss(), DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults$default$6());
        df$1.elem = ((Dataset)df$1.elem).withColumnRenamed(featureName, new StringBuilder(9).append(featureName).append("__dummy__").toString());
        df$1.elem = ((Dataset)df$1.elem).withColumn(featureName, functions$.MODULE$.col(new StringBuilder(9).append(featureName).append("__dummy__").toString()));
        df$1.elem = ((Dataset)df$1.elem).drop(new StringBuilder(9).append(featureName).append("__dummy__").toString());
        graphTraverser$1.nodeIdToDataframeAndColumnMetadataMap().update((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(nId)), (Object)new DataframeAndColumnMetadata((Dataset<Row>)((Dataset)df$1.elem), (Seq<String>)((Seq)Nil$.MODULE$), (Option<String>)new Some((Object)featureName), DataframeAndColumnMetadata$.MODULE$.apply$default$4(), DataframeAndColumnMetadata$.MODULE$.apply$default$5()));
        processedState$1[Predef$.MODULE$.Integer2int((Integer)nId)] = VISITED$.MODULE$;
    }

    private AggregationNodeEvaluator$() {
        MODULE$ = this;
    }
}

