/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.evaluator.transformation;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.compute.NodeReference;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SQLConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SQLKeys;
import com.linkedin.feathr.offline.anchored.keyExtractor.SQLSourceKeyExtractor;
import com.linkedin.feathr.offline.anchored.keyExtractor.SQLSourceKeyExtractor$;
import com.linkedin.feathr.offline.config.SQLFeatureDefinition;
import com.linkedin.feathr.offline.config.SQLFeatureDefinition$;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationOperator;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationOperatorUtils$;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata;
import com.linkedin.feathr.offline.graph.FCMGraphTraverser;
import com.linkedin.feathr.offline.graph.NodeUtils$;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AnchorSQLOperator$
implements TransformationOperator {
    public static AnchorSQLOperator$ MODULE$;
    private final String USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME;

    static {
        new AnchorSQLOperator$();
    }

    private String USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME() {
        return this.USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME;
    }

    public Tuple2<Dataset<Row>, Seq<String>> computeSQLResult(Seq<Transformation> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, boolean appendKeyColumns) {
        Integer inputNodeId = ((NodeReference)((Transformation)nodes.head()).getInputs().get(0)).getId();
        Seq<String> keySeq = ((DataframeAndColumnMetadata)graphTraverser.nodeIdToDataframeAndColumnMetadataMap().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(inputNodeId)))).keyExpression();
        Dataset<Row> inputDf = appendKeyColumns ? ((DataframeAndColumnMetadata)graphTraverser.nodeIdToDataframeAndColumnMetadataMap().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(inputNodeId)))).df() : contextDf;
        Map<String, FeatureTypeConfig> featureTypeConfigs = NodeUtils$.MODULE$.getFeatureTypeConfigsMapForTransformationNodes(nodes);
        Map featureNameToSqlExpr = ((TraversableOnce)nodes.map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(graphTraverser.nodeIdToFeatureName().apply((Object)node.getId())), (Object)new SQLFeatureDefinition((String)node.getFunction().getParameters().get((Object)"expression"), SQLFeatureDefinition$.MODULE$.apply$default$2())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq featureNamesInBatch = featureNameToSqlExpr.keys().toSeq();
        Map featureSchemas = ((TraversableOnce)featureNamesInBatch.map((Function1 & Serializable & scala.Serializable)featureName -> {
            TensorType tensorType = FeaturizedDatasetUtils$.MODULE$.lookupTensorTypeForFeatureRef((String)featureName, (Option<DataType>)None$.MODULE$, (FeatureTypeConfig)featureTypeConfigs.getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG));
            DataType schema = FeaturizedDatasetUtils$.MODULE$.tensorTypeToDataFrameSchema(tensorType);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(featureName), (Object)schema);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        SQLConfigurableAnchorExtractor sqlExtractor = new SQLConfigurableAnchorExtractor(new SQLKeys(keySeq), (Map<String, SQLFeatureDefinition>)featureNameToSqlExpr);
        Map<Tuple2<String, Column>, Enumeration.Value> transformedCols = sqlExtractor.getTensorFeatures(inputDf, (Map<String, DataType>)featureSchemas);
        SQLSourceKeyExtractor sqlKeyExtractor = new SQLSourceKeyExtractor(keySeq, SQLSourceKeyExtractor$.MODULE$.$lessinit$greater$default$2(), SQLSourceKeyExtractor$.MODULE$.$lessinit$greater$default$3());
        Dataset<Row> withKeyColumnDF = appendKeyColumns ? sqlKeyExtractor.appendKeyColumns(inputDf) : inputDf;
        Dataset<Row> withFeaturesDf = TransformationOperatorUtils$.MODULE$.createFeatureDF(withKeyColumnDF, (Seq<Tuple2<String, Column>>)transformedCols.keys().toSeq());
        Seq<String> outputJoinKeyColumnNames = FeatureTransformation$.MODULE$.getFeatureKeyColumnNames(sqlKeyExtractor, withFeaturesDf);
        ((IterableLike)featureNameToSqlExpr.filter((Function1 & Serializable & scala.Serializable)ele -> BoxesRunTime.boxToBoolean((boolean)AnchorSQLOperator$.$anonfun$computeSQLResult$4(ele)))).foreach((Function1 & Serializable & scala.Serializable)nameToSql -> {
            AnchorSQLOperator$.$anonfun$computeSQLResult$5(graphTraverser, nameToSql);
            return BoxedUnit.UNIT;
        });
        return new Tuple2(withFeaturesDf, outputJoinKeyColumnNames);
    }

    @Override
    public Dataset<Row> batchCompute(Seq<Transformation> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        Tuple2<Dataset<Row>, Seq<String>> tuple2 = this.computeSQLResult(nodes, graphTraverser, contextDf, true);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset transformationResult = (Dataset)tuple2._1();
        Seq outputJoinKeyColumnNames = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transformationResult, (Object)outputJoinKeyColumnNames);
        Tuple2 tuple23 = tuple22;
        Dataset transformationResult2 = (Dataset)tuple23._1();
        Seq outputJoinKeyColumnNames2 = (Seq)tuple23._2();
        Seq featureNamesInBatch = (Seq)nodes.map((Function1 & Serializable & scala.Serializable)node -> (String)graphTraverser.nodeIdToFeatureName().apply((Object)node.getId()), Seq$.MODULE$.canBuildFrom());
        Tuple2<Dataset<Row>, Seq<String>> tuple24 = TransformationOperatorUtils$.MODULE$.dropAndRenameCols((Dataset<Row>)transformationResult2, (Seq<String>)outputJoinKeyColumnNames2, (Seq<String>)featureNamesInBatch);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        Dataset prunedResult = (Dataset)tuple24._1();
        Seq keyColumns = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)prunedResult, (Object)keyColumns);
        Tuple2 tuple26 = tuple25;
        Dataset prunedResult2 = (Dataset)tuple26._1();
        Seq keyColumns2 = (Seq)tuple26._2();
        return TransformationOperatorUtils$.MODULE$.joinResultToContextDfAndApplyDefaults(nodes, graphTraverser, (Dataset<Row>)prunedResult2, (Seq<String>)keyColumns2, contextDf);
    }

    @Override
    public Dataset<Row> compute(Transformation node, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        return this.batchCompute((Seq<Transformation>)((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)), graphTraverser, contextDf, dataPathHandlers);
    }

    public static final /* synthetic */ boolean $anonfun$computeSQLResult$4(Tuple2 ele) {
        return ((SQLFeatureDefinition)ele._2()).featureExpr().contains(MODULE$.USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME());
    }

    public static final /* synthetic */ void $anonfun$computeSQLResult$5(FCMGraphTraverser graphTraverser$1, Tuple2 nameToSql) {
        graphTraverser$1.featureColumnFormatsMap().update(nameToSql._1(), (Object)FeatureColumnFormat$.MODULE$.FDS_TENSOR());
    }

    private AnchorSQLOperator$() {
        MODULE$ = this;
        this.USER_FACING_MULTI_DIM_FDS_TENSOR_UDF_NAME = "FDSExtract";
    }
}

