/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.join.algorithms;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrFeatureJoinException;
import com.linkedin.feathr.offline.join.algorithms.JoinType$;
import com.linkedin.feathr.offline.join.algorithms.SparkJoin;
import com.linkedin.feathr.offline.join.algorithms.SparkJoinConditionBuilder;
import com.linkedin.feathr.offline.join.algorithms.SparkJoinWithJoinCondition$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Enumeration;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0005\u000b\u000191\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u000b\u0019\u0002A\u0011B\u0014\t\u000b5\u0001A\u0011\t\u0016\b\rIT\u0001\u0012\u0001\bt\r\u0019I!\u0002#\u0001\u000fi\")a%\u0002C\u0001q\")\u00110\u0002C\u0001u\"9A0BA\u0001\n\u0013i(AG*qCJ\\'j\\5o/&$\bNS8j]\u000e{g\u000eZ5uS>t'BA\u0006\r\u0003)\tGnZ8sSRDWn\u001d\u0006\u0003\u001b9\tAA[8j]*\u0011q\u0002E\u0001\b_\u001a4G.\u001b8f\u0015\t\t\"#\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003'Q\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002+\u0005\u00191m\\7\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011AC\u0005\u0003A)\u0011\u0011b\u00159be.Tu.\u001b8\u0002))|\u0017N\\\"p]\u0012LG/[8o\u0005VLG\u000eZ3s\u0007\u0001\u0001\"A\b\u0013\n\u0005\u0015R!!G*qCJ\\'j\\5o\u0007>tG-\u001b;j_:\u0014U/\u001b7eKJ\fa\u0001P5oSRtDC\u0001\u0015*!\tq\u0002\u0001C\u0003\"\u0005\u0001\u00071\u0005\u0006\u0004,\u000b^K6,\u0018\t\u0003Y\ts!!L \u000f\u00059bdBA\u0018:\u001d\t\u0001dG\u0004\u00022i5\t!G\u0003\u00024E\u00051AH]8pizJ\u0011!N\u0001\u0004_J<\u0017BA\u001c9\u0003\u0019\t\u0007/Y2iK*\tQ'\u0003\u0002;w\u0005)1\u000f]1sW*\u0011q\u0007O\u0005\u0003{y\n1a]9m\u0015\tQ4(\u0003\u0002A\u0003\u00069\u0001/Y2lC\u001e,'BA\u001f?\u0013\t\u0019EIA\u0005ECR\fgI]1nK*\u0011\u0001)\u0011\u0005\u0006\r\u000e\u0001\raR\u0001\u0010Y\u00164GOS8j]\u000e{G.^7ogB\u0019\u0001\nT(\u000f\u0005%[eBA\u0019K\u0013\u0005Q\u0012B\u0001!\u001a\u0013\tieJA\u0002TKFT!\u0001Q\r\u0011\u0005A#fBA)S!\t\t\u0014$\u0003\u0002T3\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019\u0016\u0004C\u0003Y\u0007\u0001\u00071&\u0001\u0004mK\u001a$HI\u0012\u0005\u00065\u000e\u0001\raR\u0001\u0011e&<\u0007\u000e\u001e&pS:\u001cu\u000e\\;n]NDQ\u0001X\u0002A\u0002-\nqA]5hQR$e\tC\u0003_\u0007\u0001\u0007q,\u0001\u0005k_&tG+\u001f9f!\t\u0001wN\u0004\u0002b[:\u0011!\r\u001c\b\u0003G.t!\u0001\u001a6\u000f\u0005\u0015LgB\u00014i\u001d\t\tt-C\u0001\u0016\u0013\t\u0019B#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u00059T\u0011\u0001\u0003&pS:$\u0016\u0010]3\n\u0005A\f(\u0001\u0003&pS:$\u0016\u0010]3\u000b\u00059T\u0011AG*qCJ\\'j\\5o/&$\bNS8j]\u000e{g\u000eZ5uS>t\u0007C\u0001\u0010\u0006'\r)q#\u001e\t\u00031YL!a^\r\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003M\fQ!\u00199qYf$\"\u0001K>\t\u000b\u0005:\u0001\u0019A\u0012\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002}B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA\u0001\\1oO*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!AB(cU\u0016\u001cG\u000f")
public class SparkJoinWithJoinCondition
implements SparkJoin {
    private final SparkJoinConditionBuilder joinConditionBuilder;

    public static SparkJoinWithJoinCondition apply(SparkJoinConditionBuilder sparkJoinConditionBuilder) {
        return SparkJoinWithJoinCondition$.MODULE$.apply(sparkJoinConditionBuilder);
    }

    @Override
    public Dataset<Row> join(Seq<String> leftJoinColumns, Dataset<Row> leftDF, Seq<String> rightJoinColumns, Dataset<Row> rightDF, Enumeration.Value joinType) {
        if (leftJoinColumns.size() != rightJoinColumns.size()) {
            throw new FeathrFeatureJoinException(ErrorLabel.FEATHR_ERROR, new StringBuilder(115).append("left join key column size is not equal to right join key column size. ").append("Left join columns: [").append(leftJoinColumns.mkString(", ")).append("], Right join columns: [").append(rightJoinColumns.mkString(", ")).append("]").toString());
        }
        if (!joinType.equals((Object)JoinType$.MODULE$.left_outer()) && !joinType.equals((Object)JoinType$.MODULE$.inner())) {
            throw new FeathrFeatureJoinException(ErrorLabel.FEATHR_ERROR, new StringBuilder(44).append("Feathr currently does not support join type ").append(joinType.toString()).toString());
        }
        Dataset withoutDupRightDF = rightDF.dropDuplicates(rightJoinColumns);
        Column joinConditions = (Column)this.joinConditionBuilder.buildJoinCondition(leftJoinColumns, leftDF, rightJoinColumns, rightDF);
        return leftDF.join(withoutDupRightDF, joinConditions, joinType.toString());
    }

    public SparkJoinWithJoinCondition(SparkJoinConditionBuilder joinConditionBuilder) {
        this.joinConditionBuilder = joinConditionBuilder;
    }
}

