/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.accessor;

import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataSourceAccessor;
import com.linkedin.feathr.offline.source.accessor.DatePartition;
import com.linkedin.feathr.offline.source.accessor.PathPartitionedTimeSeriesSourceAccessor$;
import com.linkedin.feathr.offline.source.accessor.TimeBasedDataSourceAccessor;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderFactory;
import com.linkedin.feathr.offline.source.pathutil.PathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathInfo;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.DataFrameExt$;
import com.linkedin.feathr.offline.util.PartitionLimiter;
import com.linkedin.feathr.offline.util.SourceUtils$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!\u0002\u000b\u0016\u0001e\t\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011Q\u0002!\u0011!Q\u0001\nUB\u0011\u0002\u0007\u0001\u0003\u0002\u0003\u0006IA\u0012&\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"AQ\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u00026\u0001!I!a\u000e\b\u0011\u0005\u001dS\u0003#\u0001\u001a\u0003\u00132q\u0001F\u000b\t\u0002e\tY\u0005\u0003\u0004t\u001f\u0011\u0005\u00111\u000b\u0005\n\u0003+z!\u0019!C\u0005\u0003/B\u0001\"!\u001b\u0010A\u0003%\u0011\u0011\f\u0005\b\u0003WzA\u0011AA7\u0005\u001d\u0002\u0016\r\u001e5QCJ$\u0018\u000e^5p]\u0016$G+[7f'\u0016\u0014\u0018.Z:T_V\u00148-Z!dG\u0016\u001c8o\u001c:\u000b\u0005Y9\u0012\u0001C1dG\u0016\u001c8o\u001c:\u000b\u0005aI\u0012AB:pkJ\u001cWM\u0003\u0002\u001b7\u00059qN\u001a4mS:,'B\u0001\u000f\u001e\u0003\u00191W-\u0019;ie*\u0011adH\u0001\tY&t7.\u001a3j]*\t\u0001%A\u0002d_6\u001c\"\u0001\u0001\u0012\u0011\u0005\r\"S\"A\u000b\n\u0005\u0015*\"a\u0007+j[\u0016\u0014\u0015m]3e\t\u0006$\u0018mU8ve\u000e,\u0017iY2fgN|'/\u0001\u0002tg\u000e\u0001\u0001CA\u00153\u001b\u0005Q#BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO&\u00111G\u000b\u0002\r'B\f'o[*fgNLwN\\\u0001\u000fI\u0006$X\rU1si&$\u0018n\u001c8t!\r1\u0004i\u0011\b\u0003our!\u0001O\u001e\u000e\u0003eR!AO\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014!B:dC2\f\u0017B\u0001 @\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001P\u0005\u0003\u0003\n\u00131aU3r\u0015\tqt\b\u0005\u0002$\t&\u0011Q)\u0006\u0002\u000e\t\u0006$X\rU1si&$\u0018n\u001c8\u0011\u0005\u001dCU\"A\f\n\u0005%;\"A\u0003#bi\u0006\u001cv.\u001e:dK&\u0011\u0001dS\u0005\u0003\u0019V\u0011!\u0003R1uCN{WO]2f\u0003\u000e\u001cWm]:pe\u0006\u00112o\\;sG\u0016$\u0016.\\3J]R,'O^1m!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0005eCR,G/[7f\u0015\t\u0019\u0016$\u0001\u0003vi&d\u0017BA+Q\u0005A!\u0015\r^3US6,\u0017J\u001c;feZ\fG.\u0001\neCR,G+[7f%\u0016\u001cx\u000e\\;uS>t\u0007C\u0001-f\u001d\tI&M\u0004\u0002[A:\u00111l\u0018\b\u00039zs!\u0001O/\n\u0003\u0001J!AH\u0010\n\u0005qi\u0012BA1\u001c\u0003\u0019\u0019w.\\7p]&\u00111\rZ\u0001\u0013\t\u0006$X\rV5nKJ+7o\u001c7vi&|gN\u0003\u0002b7%\u0011am\u001a\u0002\u0013\t\u0006$X\rV5nKJ+7o\u001c7vi&|gN\u0003\u0002dI\u00061b-Y5m\u001f:l\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002kW6\tq(\u0003\u0002m\u007f\t9!i\\8mK\u0006t\u0017AE1eIRKW.Z:uC6\u00048i\u001c7v[:\f\u0001\u0003]1si&$\u0018n\u001c8MS6LG/\u001a:\u0011\u0005A\fX\"\u0001*\n\u0005I\u0014&\u0001\u0005)beRLG/[8o\u0019&l\u0017\u000e^3s\u0003\u0019a\u0014N\\5u}QIQO^<ysj\\H0 \t\u0003G\u0001AQAJ\u0005A\u0002!BQ\u0001N\u0005A\u0002UBQ\u0001G\u0005A\u0002\u0019CQ!T\u0005A\u00029CQAV\u0005A\u0002]CQ\u0001[\u0005A\u0002%DQ!\\\u0005A\u0002%DQA\\\u0005A\u0002=\f1aZ3u)\u0011\t\t!!\b\u0011\t\u0005\r\u0011q\u0003\b\u0005\u0003\u000b\t)B\u0004\u0003\u0002\b\u0005Ma\u0002BA\u0005\u0003#qA!a\u0003\u0002\u00109\u0019\u0001(!\u0004\n\u0003EJ!a\f\u0019\n\u00055r\u0013BA\u0016-\u0013\tq$&\u0003\u0003\u0002\u001a\u0005m!!\u0003#bi\u00064%/Y7f\u0015\tq$\u0006C\u0004\u0002 )\u0001\r!!\t\u0002\u001fQLW.Z%oi\u0016\u0014h/\u00197PaR\u0004BA[A\u0012\u001d&\u0019\u0011QE \u0003\r=\u0003H/[8o\u0003y9W\r\u001e#bi\u0016\u0004\u0016M\u001d;ji&|gnV5uQ&t\u0017J\u001c;feZ\fG\u000eF\u00026\u0003WAq!a\b\f\u0001\u0004\t\t#A\npm\u0016\u0014H.\u00199XSRD\u0017J\u001c;feZ\fG\u000eF\u0002j\u0003cAa!a\r\r\u0001\u0004q\u0015\u0001C5oi\u0016\u0014h/\u00197\u0002+Y\fG.\u001b3bi\u0016$\u0015\r^3QCJ$\u0018\u000e^5p]R1\u0011\u0011HA \u0003\u0007\u00022A[A\u001e\u0013\r\tid\u0010\u0002\u0005+:LG\u000f\u0003\u0004\u0002B5\u0001\r!N\u0001\u0017g\u0016dWm\u0019;fI\u0012\u000bG/\u001a)beRLG/[8og\"1\u0011QI\u0007A\u00029\u000bA\u0002^5nK&sG/\u001a:wC2\fq\u0005U1uQB\u000b'\u000f^5uS>tW\r\u001a+j[\u0016\u001cVM]5fgN{WO]2f\u0003\u000e\u001cWm]:peB\u00111eD\n\u0004\u001f\u00055\u0003c\u00016\u0002P%\u0019\u0011\u0011K \u0003\r\u0005s\u0017PU3g)\t\tI%A\u0002m_\u001e,\"!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005)An\\45U*\u0019\u00111\r\u0018\u0002\u000f1|wmZ5oO&!\u0011qMA/\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u0015\t\u0007\u000f\u001d7z)Q\ty'!\u001d\u0002t\u0005\r\u00151SAK\u0003?\u000b\t+a)\u0002&B\u00111e\u0013\u0005\u0006MM\u0001\r\u0001\u000b\u0005\b\u0003k\u001a\u0002\u0019AA<\u0003-\u0001\u0018\r\u001e5DQ\u0016\u001c7.\u001a:\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \u0018\u0003!\u0001\u0018\r\u001e5vi&d\u0017\u0002BAA\u0003w\u00121\u0002U1uQ\u000eCWmY6fe\"9\u0011QQ\nA\u0002\u0005\u001d\u0015!\u00054jY\u0016du.\u00193fe\u001a\u000b7\r^8ssB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e^\t!\u0002Z1uC2|\u0017\rZ3s\u0013\u0011\t\t*a#\u0003#\u0011\u000bG/\u0019'pC\u0012,'OR1di>\u0014\u0018\u0010C\u0003o'\u0001\u0007q\u000eC\u0004\u0002\u0018N\u0001\r!!'\u0002\u0011A\fG\u000f[%oM>\u0004B!!\u001f\u0002\u001c&!\u0011QTA>\u0005!\u0001\u0016\r\u001e5J]\u001a|\u0007\"\u0002\r\u0014\u0001\u00041\u0005BBA#'\u0001\u0007a\nC\u0003i'\u0001\u0007\u0011\u000eC\u0003n'\u0001\u0007\u0011\u000e")
public class PathPartitionedTimeSeriesSourceAccessor
extends TimeBasedDataSourceAccessor {
    private final SparkSession ss;
    private final Seq<DatePartition> datePartitions;
    private final Enumeration.Value dateTimeResolution;
    private final boolean failOnMissingPartition;
    private final boolean addTimestampColumn;
    private final PartitionLimiter partitionLimiter;

    public static DataSourceAccessor apply(SparkSession sparkSession, PathChecker pathChecker, DataLoaderFactory dataLoaderFactory, PartitionLimiter partitionLimiter, PathInfo pathInfo, DataSource dataSource, DateTimeInterval dateTimeInterval, boolean bl, boolean bl2) {
        return PathPartitionedTimeSeriesSourceAccessor$.MODULE$.apply(sparkSession, pathChecker, dataLoaderFactory, partitionLimiter, pathInfo, dataSource, dateTimeInterval, bl, bl2);
    }

    @Override
    public Dataset<Row> get(Option<DateTimeInterval> timeIntervalOpt) {
        Seq seq;
        Seq<DatePartition> selectedDatePartitions = this.getDatePartitionWithinInterval(timeIntervalOpt);
        if (timeIntervalOpt.isDefined() && this.failOnMissingPartition) {
            this.validateDatePartition(selectedDatePartitions, (DateTimeInterval)timeIntervalOpt.get());
        }
        if (this.addTimestampColumn) {
            PathPartitionedTimeSeriesSourceAccessor$.MODULE$.com$linkedin$feathr$offline$source$accessor$PathPartitionedTimeSeriesSourceAccessor$$log().info(new StringBuilder(34).append("added timestamp column to source ").append(super.source().path()).append(".").toString());
            seq = (Seq)selectedDatePartitions.map((Function1 & Serializable & scala.Serializable)partition -> partition.df().withColumn(SlidingWindowFeatureUtils$.MODULE$.TIMESTAMP_PARTITION_COLUMN(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)partition.dateInterval().getStart().toEpochSecond()))), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)selectedDatePartitions.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.df(), Seq$.MODULE$.canBuildFrom());
        }
        Seq dataFrames = seq;
        Dataset df = (Dataset)dataFrames.reduce((Function2 & Serializable & scala.Serializable)(x, y) -> DataFrameExt$.MODULE$.DataFrameMethods((Dataset<Row>)x).fuzzyUnion((Dataset<Row>)y));
        return SourceUtils$.MODULE$.processSanityCheckMode(this.ss, this.partitionLimiter.limitPartition((Dataset<Row>)df));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<DatePartition> getDatePartitionWithinInterval(Option<DateTimeInterval> timeIntervalOpt) {
        void var3_6;
        Seq seq;
        Option<DateTimeInterval> option = timeIntervalOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            DateTimeInterval interval = (DateTimeInterval)some.value();
            seq = (Seq)this.datePartitions.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PathPartitionedTimeSeriesSourceAccessor.$anonfun$getDatePartitionWithinInterval$1(interval, x$2)));
        } else if (None$.MODULE$.equals(option)) {
            seq = this.datePartitions;
        } else {
            throw new MatchError(option);
        }
        Seq selectedPartitions = seq;
        if (selectedPartitions.isEmpty()) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(106).append("Trying to create TimeSeriesSource but no data ").append("is found to create source data. Source path: ").append(super.source().path()).append(", source type: ").append(super.source().sourceType()).toString());
        }
        return var3_6;
    }

    @Override
    public boolean overlapWithInterval(DateTimeInterval interval) {
        return this.datePartitions.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PathPartitionedTimeSeriesSourceAccessor.$anonfun$overlapWithInterval$1(interval, x$3)));
    }

    private void validateDatePartition(Seq<DatePartition> selectedDatePartitions, DateTimeInterval timeInterval) {
        Seq availableDates;
        Set allDates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeInterval.getAllTimeWithinInterval(this.dateTimeResolution))).toSet();
        Set missingDates = (Set)allDates.$minus$minus((GenTraversableOnce)(availableDates = (Seq)selectedDatePartitions.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dateInterval().getStart(), Seq$.MODULE$.canBuildFrom())));
        if (missingDates.nonEmpty()) {
            String missingDateStr = missingDates.mkString(",");
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(93).append("The following date partitions ").append(missingDateStr).append(" are missing from the source data. ").append("Source path: ").append(super.source().path()).append(", source type: ").append(super.source().sourceType()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getDatePartitionWithinInterval$1(DateTimeInterval interval$1, DatePartition x$2) {
        return x$2.dateInterval().overlaps(interval$1);
    }

    public static final /* synthetic */ boolean $anonfun$overlapWithInterval$1(DateTimeInterval interval$2, DatePartition x$3) {
        return x$3.dateInterval().overlaps(interval$2);
    }

    public PathPartitionedTimeSeriesSourceAccessor(SparkSession ss, Seq<DatePartition> datePartitions, DataSource source, DateTimeInterval sourceTimeInterval, Enumeration.Value dateTimeResolution, boolean failOnMissingPartition, boolean addTimestampColumn, PartitionLimiter partitionLimiter) {
        this.ss = ss;
        this.datePartitions = datePartitions;
        this.dateTimeResolution = dateTimeResolution;
        this.failOnMissingPartition = failOnMissingPartition;
        this.addTimestampColumn = addTimestampColumn;
        this.partitionLimiter = partitionLimiter;
        super(source, sourceTimeInterval, failOnMissingPartition);
    }
}

