/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.linkedin.avroutil1.compatibility.AvroCompatibilityHelper;
import com.linkedin.feathr.offline.source.dataloader.DataLoader;
import com.linkedin.feathr.offline.util.DelimiterUtils$;
import com.linkedin.feathr.offline.util.SourceUtils$;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4Q!\u0003\u0006\u0001\u001dYA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)1\b\u0001C\u0001y!)\u0001\t\u0001C!\u0003\")\u0001\n\u0001C!\u0013\")\u0011\f\u0001C\u00055\")A\u000e\u0001C\u0005[\")Q\u000f\u0001C\u0005m\ni1i\u001d<ECR\fGj\\1eKJT!a\u0003\u0007\u0002\u0015\u0011\fG/\u00197pC\u0012,'O\u0003\u0002\u000e\u001d\u000511o\\;sG\u0016T!a\u0004\t\u0002\u000f=4g\r\\5oK*\u0011\u0011CE\u0001\u0007M\u0016\fG\u000f\u001b:\u000b\u0005M!\u0012\u0001\u00037j].,G-\u001b8\u000b\u0003U\t1aY8n'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yyR\"\u0001\u0006\n\u0005\u0001R!A\u0003#bi\u0006du.\u00193fe\u0006\u00111o]\u0002\u0001!\t!S&D\u0001&\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0005\u0003]\u0015\u0012Ab\u00159be.\u001cVm]:j_:\fA\u0001]1uQB\u0011\u0011\u0007\u000f\b\u0003eY\u0002\"aM\r\u000e\u0003QR!!\u000e\u0012\u0002\rq\u0012xn\u001c;?\u0013\t9\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c\u001a\u0003\u0019a\u0014N\\5u}Q\u0019QHP \u0011\u0005y\u0001\u0001\"B\u0011\u0004\u0001\u0004\u0019\u0003\"B\u0018\u0004\u0001\u0004\u0001\u0014A\u00037pC\u0012\u001c6\r[3nCR\t!\t\u0005\u0002D\r6\tAI\u0003\u0002FS\u0005!\u0011M\u001e:p\u0013\t9EI\u0001\u0004TG\",W.Y\u0001\u000eY>\fG\rR1uC\u001a\u0013\u0018-\\3\u0015\u0003)\u0003\"a\u0013,\u000f\u00051#fBA'T\u001d\tq%K\u0004\u0002P#:\u00111\u0007U\u0005\u0002Y%\u0011!fK\u0005\u0003Q%J!AJ\u0014\n\u0005U+\u0013a\u00029bG.\fw-Z\u0005\u0003/b\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005U+\u0013!\u00073p\u0019>\fGmQ:w\t>\u001cW/\\3oi2K7.Z!we>$\u0012a\u0017\t\u00051qs&)\u0003\u0002^3\t1A+\u001e9mKJ\u00022aX2g\u001d\t\u0001'M\u0004\u00024C&\t!$\u0003\u0002V3%\u0011A-\u001a\u0002\u0004'\u0016\f(BA+\u001a!\t9'.D\u0001i\u0015\tIG)A\u0004hK:,'/[2\n\u0005-D'!D$f]\u0016\u0014\u0018n\u0019*fG>\u0014H-\u0001\u0007d_\u0016\u00148-\u001a+p\u0003Z\u0014x\u000eF\u0002ocN\u0004\"\u0001G8\n\u0005AL\"aA!os\")!o\u0002a\u0001\u0005\u000611o\u00195f[\u0006DQ\u0001^\u0004A\u00029\f1a\u001c2k\u0003Y9W\r^!sE&$(/\u0019:z%\u0016\u001cwN\u001d3OC6,GC\u0001\u0019x\u0011\u0015A\b\u00021\u0001\u0018\u0003\u0005A\b")
public class CsvDataLoader
implements DataLoader {
    private final SparkSession ss;
    private final String path;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        CsvDataLoader csvDataLoader = this;
        synchronized (csvDataLoader) {
            if (!this.bitmap$trans$0) {
                this.log = DataLoader.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public Schema loadSchema() {
        return (Schema)this.doLoadCsvDocumentLikeAvro()._2();
    }

    @Override
    public Dataset<Row> loadDataFrame() {
        Dataset<Row> dataset;
        String csvDelimiterOption = DelimiterUtils$.MODULE$.checkDelimiterOption(this.ss.sqlContext().getConf("spark.feathr.inputFormat.csvOptions.sep", ","));
        try {
            this.log().debug(new StringBuilder(18).append("Loading CSV path :").append(this.path).toString());
            String absolutePath = new File(this.path).getPath();
            this.log().debug(new StringBuilder(34).append("Got absolute CSV path: ").append(absolutePath).append(", loading..").toString());
            Dataset df = this.ss.read().format("csv").option("header", "true").option("delimiter", csvDelimiterOption).load(absolutePath);
            dataset = SourceUtils$.MODULE$.processSanityCheckMode(this.ss, (Dataset<Row>)df);
        }
        catch (Throwable throwable) {
            this.log().debug("Loading CSV failed, retry with class loader..");
            String absolutePath = this.getClass().getClassLoader().getResource(this.path).getPath();
            this.log().debug(new StringBuilder(55).append("Got absolution CSV path from class loader: ").append(absolutePath).append(", loading.. ").toString());
            Dataset df = this.ss.read().format("csv").option("header", "true").option("delimiter", csvDelimiterOption).load(absolutePath);
            dataset = SourceUtils$.MODULE$.processSanityCheckMode(this.ss, (Dataset<Row>)df);
        }
        return dataset;
    }

    private Tuple2<Seq<GenericRecord>, Schema> doLoadCsvDocumentLikeAvro() {
        String contents = Source$.MODULE$.fromInputStream(this.getClass().getClassLoader().getResourceAsStream(this.path), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        CsvSchema schema = CsvSchema.emptySchema().withHeader();
        ObjectReader reader = new CsvMapper().readerWithSchemaFor(java.util.Map.class).with((FormatSchema)schema);
        Seq rows = ((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020asScalaIterator((Iterator)reader.readValues(contents)).toSeq();
        Predef$.MODULE$.require(rows.nonEmpty());
        Seq fields = (Seq)((TraversableOnce)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020mapAsScalaMap((java.util.Map)rows.head()).keys().map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        Seq rowsCleaned = (Seq)rows.map((Function1 & Serializable & scala.Serializable)x$2 -> (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020mapAsScalaMap(x$2).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CsvDataLoader.$anonfun$doLoadCsvDocumentLikeAvro$3(x$3)))).toMap(Predef$.MODULE$.$conforms())).asJava(), Seq$.MODULE$.canBuildFrom());
        Schema avroSchema = Schema.createRecord((String)this.getArbitraryRecordName(fields), null, null, (boolean)false);
        avroSchema.setFields(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList((Seq)fields.map((Function1 & Serializable & scala.Serializable)x$4 -> AvroCompatibilityHelper.createSchemaField((String)x$4, (Schema)Schema.createUnion((java.util.List)package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Schema.create((Schema.Type)Schema.Type.STRING), (List)new .colon.colon((Object)Schema.create((Schema.Type)Schema.Type.NULL), (List)Nil$.MODULE$)))), null, null), Seq$.MODULE$.canBuildFrom())));
        Seq genericRecords = (Seq)rowsCleaned.map((Function1 & Serializable & scala.Serializable)x$5 -> (GenericRecord)this.coerceToAvro(avroSchema, x$5), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)genericRecords, (Object)avroSchema);
    }

    private Object coerceToAvro(Schema schema, Object obj) {
        Object object;
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            GenericData.Record record = new GenericData.Record(schema);
            ((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020asScalaBuffer(schema.getFields()).foreach((Function1 & Serializable & scala.Serializable)field -> {
                record.put(field.name(), this.coerceToAvro(field.schema(), ((java.util.Map)obj).get(field.name())));
                return BoxedUnit.UNIT;
            });
            object = record;
        } else if (Schema.Type.ARRAY.equals(type)) {
            java.util.List list = (java.util.List)obj;
            GenericData.Array array = new GenericData.Array(list.size(), schema.getElementType());
            ((IterableLike)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020asScalaBuffer(list).map((Function1 & Serializable & scala.Serializable)x$6 -> this.coerceToAvro(schema.getElementType(), x$6), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)array.add(x$1)));
            object = array;
        } else {
            object = Schema.Type.STRING.equals(type) ? new Utf8((String)obj) : obj;
        }
        return object;
    }

    private String getArbitraryRecordName(Object x) {
        return new StringBuilder(11).append("AnonRecord_").append(Integer.toHexString(x.hashCode())).toString();
    }

    public static final /* synthetic */ boolean $anonfun$doLoadCsvDocumentLikeAvro$3(Tuple2 x$3) {
        String string = x$3._2().toString();
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public CsvDataLoader(SparkSession ss, String path) {
        this.ss = ss;
        this.path = path;
        DataLoader.$init$(this);
    }
}

