/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jasonclawson.jackson.dataformat.hocon.HoconFactory;
import com.linkedin.feathr.offline.source.dataloader.AvroJsonDataLoader$;
import com.linkedin.feathr.offline.source.dataloader.DataLoader;
import com.linkedin.feathr.offline.util.SourceUtils$;
import org.apache.avro.Schema;
import org.apache.logging.log4j.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4Q\u0001C\u0005\u0001\u001bUA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)!\b\u0001C\u0001w!)q\b\u0001C!\u0001\")q\t\u0001C!\u0011\")\u0001\f\u0001C\u00053\")1\f\u0001C\u00059\nA\"j]8o/&$\bnU2iK6\fG)\u0019;b\u0019>\fG-\u001a:\u000b\u0005)Y\u0011A\u00033bi\u0006dw.\u00193fe*\u0011A\"D\u0001\u0007g>,(oY3\u000b\u00059y\u0011aB8gM2Lg.\u001a\u0006\u0003!E\taAZ3bi\"\u0014(B\u0001\n\u0014\u0003!a\u0017N\\6fI&t'\"\u0001\u000b\u0002\u0007\r|WnE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f\u001f\u001b\u0005I\u0011BA\u0010\n\u0005)!\u0015\r^1M_\u0006$WM]\u0001\u0003gN\u001c\u0001\u0001\u0005\u0002$Y5\tAE\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001eL!!\f\u0013\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\tA\fG\u000f\u001b\t\u0003a]r!!M\u001b\u0011\u0005IBR\"A\u001a\u000b\u0005Q\n\u0013A\u0002\u001fs_>$h(\u0003\u000271\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0004$\u0001\u0004=S:LGO\u0010\u000b\u0004yur\u0004CA\u000f\u0001\u0011\u0015\u00013\u00011\u0001#\u0011\u0015q3\u00011\u00010\u0003)aw.\u00193TG\",W.\u0019\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011A\tK\u0001\u0005CZ\u0014x.\u0003\u0002G\u0007\n11k\u00195f[\u0006\fQ\u0002\\8bI\u0012\u000bG/\u0019$sC6,G#A%\u0011\u0005)+fBA&T\u001d\ta%K\u0004\u0002N#:\u0011a\n\u0015\b\u0003e=K\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0005\u00152\u0013B\u0001+%\u0003\u001d\u0001\u0018mY6bO\u0016L!AV,\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001+%\u0003Aaw.\u00193GS2,\u0017i]*ue&tw\r\u0006\u000205\")aF\u0002a\u0001_\u0005\u0011\u0002/\u0019:tK*\u001bxN\\!t\u0003Z\u0014xN\u0015#E+\tiV\u0010F\u0001_)\tyF\u000f\u0005\u0003\u0018A\n\f\u0015BA1\u0019\u0005\u0019!V\u000f\u001d7feA\u00121m\u001b\t\u0004I\u001eLW\"A3\u000b\u0005\u00194\u0013a\u0001:eI&\u0011\u0001.\u001a\u0002\u0004%\u0012#\u0005C\u00016l\u0019\u0001!\u0011\u0002\\\u0004\u0002\u0002\u0003\u0005)\u0011A7\u0003\u0007}#\u0013'\u0005\u0002ocB\u0011qc\\\u0005\u0003ab\u0011qAT8uQ&tw\r\u0005\u0002\u0018e&\u00111\u000f\u0007\u0002\u0004\u0003:L\b\"B;\b\u0001\b1\u0018a\u0001;bOB\u0019qO\u001f?\u000e\u0003aT!!\u001f\r\u0002\u000fI,g\r\\3di&\u00111\u0010\u001f\u0002\t\u00072\f7o\u001d+bOB\u0011!. \u0003\u0006}\u001e\u0011\r!\u001c\u0002\u0002)\u0002")
public class JsonWithSchemaDataLoader
implements DataLoader {
    private final SparkSession ss;
    private final String path;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        JsonWithSchemaDataLoader jsonWithSchemaDataLoader = this;
        synchronized (jsonWithSchemaDataLoader) {
            if (!this.bitmap$trans$0) {
                this.log = DataLoader.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public Schema loadSchema() {
        String schemaPath = new StringBuilder(12).append(this.path).append("/schema.avsc").toString();
        String schemaAsString = this.loadFileAsString(schemaPath);
        return new Schema.Parser().parse(schemaAsString);
    }

    @Override
    public Dataset<Row> loadDataFrame() {
        Tuple2<RDD<?>, Schema> res = this.parseJsonAsAvroRDD(ClassTag$.MODULE$.Nothing());
        Dataset<Row> df = AvroJsonDataLoader$.MODULE$.convertRDD2DF(this.ss, res);
        return SourceUtils$.MODULE$.processSanityCheckMode(this.ss, df);
    }

    /*
     * WARNING - void declaration
     */
    private String loadFileAsString(String path) {
        void var3_3;
        BufferedSource bufferedSource = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());
        String content = bufferedSource.mkString();
        bufferedSource.close();
        return var3_3;
    }

    private <T> Tuple2<RDD<?>, Schema> parseJsonAsAvroRDD(ClassTag<T> tag) {
        Schema schema = this.loadSchema();
        String dataPath = new StringBuilder(14).append(this.path).append("/mockData.json").toString();
        String dataArrayAsJson = this.loadFileAsString(dataPath);
        ObjectMapper jackson = new ObjectMapper((JsonFactory)new HoconFactory());
        JsonNode jsonDataArray = jackson.readTree(new StringBuilder(9).append("{ data:").append(dataArrayAsJson).append(" }").toString()).get("data");
        return AvroJsonDataLoader$.MODULE$.parseJsonAsAvroRDD(this.ss, jsonDataArray, schema.toString(), tag);
    }

    public JsonWithSchemaDataLoader(SparkSession ss, String path) {
        this.ss = ss;
        this.path = path;
        DataLoader.$init$(this);
    }
}

