/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader;

import com.linkedin.feathr.offline.config.location.DataLocation;
import com.linkedin.feathr.offline.config.location.KafkaEndpoint;
import com.linkedin.feathr.offline.config.location.SimplePath;
import com.linkedin.feathr.offline.source.dataloader.AvroJsonDataLoader;
import com.linkedin.feathr.offline.source.dataloader.BatchDataLoader;
import com.linkedin.feathr.offline.source.dataloader.CsvDataLoader;
import com.linkedin.feathr.offline.source.dataloader.DataLoader;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderFactory;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.source.dataloader.JdbcDataLoader;
import com.linkedin.feathr.offline.source.dataloader.JsonWithSchemaDataLoader;
import com.linkedin.feathr.offline.source.dataloader.ParquetDataLoader;
import com.linkedin.feathr.offline.source.dataloader.stream.KafkaDataLoader;
import com.linkedin.feathr.offline.util.LocalFeatureJoinUtils$;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q\u0001C\u0005\u0001\u001bUA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)a\b\u0001C\u0001\u007f!91\t\u0001b\u0001\n\u0013!\u0005BB'\u0001A\u0003%Q\tC\u0003O\u0001\u0011\u0005s\nC\u0003]\u0001\u0011\u0005SL\u0001\fM_\u000e\fG\u000eR1uC2{\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0015\tQ1\"\u0001\u0006eCR\fGn\\1eKJT!\u0001D\u0007\u0002\rM|WO]2f\u0015\tqq\"A\u0004pM\u001ad\u0017N\\3\u000b\u0005A\t\u0012A\u00024fCRD'O\u0003\u0002\u0013'\u0005AA.\u001b8lK\u0012LgNC\u0001\u0015\u0003\r\u0019w.\\\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\t\u0011\"\u0003\u0002 \u0013\t\tB)\u0019;b\u0019>\fG-\u001a:GC\u000e$xN]=\u0002\u0005M\u001c8\u0001\u0001\t\u0003G1j\u0011\u0001\n\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017%\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003I!\u0017\r^1M_\u0006$WM\u001d%b]\u0012dWM]:\u0011\u0007AB4H\u0004\u00022m9\u0011!'N\u0007\u0002g)\u0011A'I\u0001\u0007yI|w\u000e\u001e \n\u0003eI!a\u000e\r\u0002\u000fA\f7m[1hK&\u0011\u0011H\u000f\u0002\u0005\u0019&\u001cHO\u0003\u000281A\u0011Q\u0004P\u0005\u0003{%\u0011\u0011\u0003R1uC2{\u0017\rZ3s\u0011\u0006tG\r\\3s\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005u\u0001\u0001\"\u0002\u0011\u0004\u0001\u0004\u0011\u0003\"\u0002\u0018\u0004\u0001\u0004y\u0013a\u0005+F'R{\u0016I\u0016*P?*\u001bvJT0G\u00132+U#A#\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00027b]\u001eT\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u0002M\u000f\n11\u000b\u001e:j]\u001e\fA\u0003V#T)~\u000beKU(`\u0015N{ej\u0018$J\u0019\u0016\u0003\u0013AB2sK\u0006$X\r\u0006\u0002Q'B\u0011Q$U\u0005\u0003%&\u0011!\u0002R1uC2{\u0017\rZ3s\u0011\u0015!f\u00011\u0001V\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005YSfBA,Y!\t\u0011\u0004$\u0003\u0002Z1\u00051\u0001K]3eK\u001aL!\u0001T.\u000b\u0005eC\u0012AE2sK\u0006$XM\u0012:p[2{7-\u0019;j_:$\"\u0001\u00150\t\u000b};\u0001\u0019\u00011\u0002\u001b%t\u0007/\u001e;M_\u000e\fG/[8o!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0005m_\u000e\fG/[8o\u0015\t)W\"\u0001\u0004d_:4\u0017nZ\u0005\u0003O\n\u0014A\u0002R1uC2{7-\u0019;j_:\u0004")
public class LocalDataLoaderFactory
implements DataLoaderFactory {
    private final SparkSession ss;
    private final List<DataLoaderHandler> dataLoaderHandlers;
    private final String TEST_AVRO_JSON_FILE;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        LocalDataLoaderFactory localDataLoaderFactory = this;
        synchronized (localDataLoaderFactory) {
            if (!this.bitmap$trans$0) {
                this.log = DataLoaderFactory.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private String TEST_AVRO_JSON_FILE() {
        return this.TEST_AVRO_JSON_FILE;
    }

    @Override
    public DataLoader create(String path) {
        DataLoader dataLoader;
        this.log().info(new StringBuilder(37).append("Creating local data loader for path: ").append(path).toString());
        Option workspaceDir = this.ss.conf().getOption("mockdata_dir");
        if (path.endsWith(".csv")) {
            CsvDataLoader csvDataLoader;
            Option<String> option = LocalFeatureJoinUtils$.MODULE$.getMockPathIfExist(path, this.ss.sparkContext().hadoopConfiguration(), (Option<String>)workspaceDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                String mockData = (String)some.value();
                csvDataLoader = new CsvDataLoader(this.ss, mockData);
            } else if (None$.MODULE$.equals(option)) {
                csvDataLoader = new CsvDataLoader(this.ss, path);
            } else {
                throw new MatchError(option);
            }
            dataLoader = csvDataLoader;
        } else if (path.endsWith(".parquet")) {
            ParquetDataLoader parquetDataLoader;
            Option<String> option = LocalFeatureJoinUtils$.MODULE$.getMockPathIfExist(path, this.ss.sparkContext().hadoopConfiguration(), (Option<String>)workspaceDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                String mockData = (String)some.value();
                parquetDataLoader = new ParquetDataLoader(this.ss, mockData);
            } else if (None$.MODULE$.equals(option)) {
                parquetDataLoader = new ParquetDataLoader(this.ss, path);
            } else {
                throw new MatchError(option);
            }
            dataLoader = parquetDataLoader;
        } else if (path.endsWith(".avro.json")) {
            dataLoader = new AvroJsonDataLoader(this.ss, path);
        } else if (path.startsWith("jdbc")) {
            JdbcDataLoader jdbcDataLoader;
            Option<String> option = LocalFeatureJoinUtils$.MODULE$.getMockPathIfExist(path, this.ss.sparkContext().hadoopConfiguration(), (Option<String>)workspaceDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                String mockData = (String)some.value();
                jdbcDataLoader = new JdbcDataLoader(this.ss, mockData);
            } else if (None$.MODULE$.equals(option)) {
                jdbcDataLoader = new JdbcDataLoader(this.ss, path);
            } else {
                throw new MatchError(option);
            }
            dataLoader = jdbcDataLoader;
        } else if (this.getClass().getClassLoader().getResource(new StringBuilder(0).append(path).append(this.TEST_AVRO_JSON_FILE()).toString()) != null) {
            dataLoader = new AvroJsonDataLoader(this.ss, new StringBuilder(0).append(path).append(this.TEST_AVRO_JSON_FILE()).toString());
        } else {
            DataLoader dataLoader2;
            Option<String> option = LocalFeatureJoinUtils$.MODULE$.getMockPathIfExist(path, this.ss.sparkContext().hadoopConfiguration(), (Option<String>)workspaceDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                String mockData = (String)some.value();
                dataLoader2 = new JsonWithSchemaDataLoader(this.ss, mockData);
            } else if (None$.MODULE$.equals(option)) {
                dataLoader2 = new BatchDataLoader(this.ss, new SimplePath(path), this.dataLoaderHandlers);
            } else {
                throw new MatchError(option);
            }
            dataLoader = dataLoader2;
        }
        return dataLoader;
    }

    @Override
    public DataLoader createFromLocation(DataLocation inputLocation) {
        DataLoader dataLoader;
        if (inputLocation instanceof KafkaEndpoint) {
            dataLoader = new KafkaDataLoader(this.ss, (KafkaEndpoint)inputLocation);
        } else {
            String path = inputLocation.getPath();
            dataLoader = this.create(path);
        }
        return dataLoader;
    }

    public LocalDataLoaderFactory(SparkSession ss, List<DataLoaderHandler> dataLoaderHandlers) {
        this.ss = ss;
        this.dataLoaderHandlers = dataLoaderHandlers;
        DataLoaderFactory.$init$(this);
        this.TEST_AVRO_JSON_FILE = "/data.avro.json";
    }
}

