/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.dataloader.hdfs;

import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.offline.source.dataloader.AvroJsonDataLoader;
import com.linkedin.feathr.offline.source.dataloader.ParquetDataLoader;
import com.linkedin.feathr.offline.source.dataloader.jdbc.JdbcUtils$;
import com.linkedin.feathr.offline.source.dataloader.jdbc.SnowflakeUtils$;
import com.linkedin.feathr.offline.util.DelimiterUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class FileFormat$ {
    public static FileFormat$ MODULE$;
    private SparkSession ss;
    private final String CSV;
    private final String AVRO_JSON;
    private final String AVRO;
    private final String ORC;
    private final String PARQUET;
    private final String PATHLIST;
    private final String JDBC;
    private final String SNOWFLAKE;
    private final String AVRO_DATASOURCE;
    private final String ORC_DATASOURCE;
    private final String DATA_FORMAT;
    private volatile boolean bitmap$0;

    static {
        new FileFormat$();
    }

    private SparkSession ss$lzycompute() {
        FileFormat$ fileFormat$ = this;
        synchronized (fileFormat$) {
            if (!this.bitmap$0) {
                this.ss = SparkSession$.MODULE$.builder().getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.ss;
    }

    private SparkSession ss() {
        return !this.bitmap$0 ? this.ss$lzycompute() : this.ss;
    }

    public String CSV() {
        return this.CSV;
    }

    public String AVRO_JSON() {
        return this.AVRO_JSON;
    }

    public String AVRO() {
        return this.AVRO;
    }

    public String ORC() {
        return this.ORC;
    }

    public String PARQUET() {
        return this.PARQUET;
    }

    public String PATHLIST() {
        return this.PATHLIST;
    }

    public String JDBC() {
        return this.JDBC;
    }

    public String SNOWFLAKE() {
        return this.SNOWFLAKE;
    }

    private String AVRO_DATASOURCE() {
        return this.AVRO_DATASOURCE;
    }

    private String ORC_DATASOURCE() {
        return this.ORC_DATASOURCE;
    }

    public String DATA_FORMAT() {
        return this.DATA_FORMAT;
    }

    public String getType(String path) {
        String p = path.toLowerCase();
        String string = p;
        String string2 = string.endsWith(".csv") ? this.CSV() : (string.endsWith(".parquet") ? this.PARQUET() : (string.endsWith(".orc") ? this.ORC() : (string.endsWith(".avro.json") ? this.AVRO_JSON() : (string.endsWith(".avro") ? this.AVRO() : (string.startsWith("jdbc:") ? this.JDBC() : (string.startsWith("snowflake:") ? this.SNOWFLAKE() : (new StringOps(Predef$.MODULE$.augmentString(this.ss().conf().get("spark.feathr.inputFormat", ""))).nonEmpty() ? this.ss().conf().get("spark.feathr.inputFormat") : this.PATHLIST())))))));
        return string2;
    }

    public Dataset<Row> loadDataFrame(SparkSession ss, String path, String format) {
        Dataset<Row> dataset;
        String csvDelimiterOption = DelimiterUtils$.MODULE$.checkDelimiterOption(ss.sqlContext().getConf("spark.feathr.inputFormat.csvOptions.sep", ","));
        String string = format;
        String string2 = this.AVRO();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            dataset = new AvroJsonDataLoader(ss, path).loadDataFrame();
        } else {
            String string4 = this.CSV();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                dataset = ss.read().format("csv").option("header", "true").option("delimiter", csvDelimiterOption).load(path);
            } else {
                String string6 = this.PARQUET();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    dataset = new ParquetDataLoader(ss, path).loadDataFrame();
                } else {
                    throw Predef$.MODULE$.$qmark$qmark$qmark();
                }
            }
        }
        return dataset;
    }

    public String loadDataFrame$default$3() {
        return this.CSV();
    }

    public String getTypeForUnionDF(Seq<String> existingHdfsPaths, Map<String, String> dataIOParameters) {
        String p = ((String)existingHdfsPaths.head()).toLowerCase();
        String string = p;
        String string2 = string.endsWith(".csv") ? this.CSV() : (string.endsWith(".tsv") ? this.CSV() : (string.endsWith(".parquet") ? this.PARQUET() : (string.endsWith(".orc") ? this.ORC() : (string.endsWith(".avro.json") ? this.AVRO_JSON() : (string.endsWith(".avro") ? this.AVRO() : (string.startsWith("jdbc:") ? this.JDBC() : (string.startsWith("snowflake:") ? this.SNOWFLAKE() : ((String)dataIOParameters.getOrElse((Object)this.DATA_FORMAT(), (Function0 & java.io.Serializable & Serializable)() -> MODULE$.ss().conf().get("spark.feathr.inputFormat", MODULE$.AVRO()))).toUpperCase())))))));
        return string2;
    }

    public Map<String, String> getTypeForUnionDF$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Dataset<Row> loadHdfsDataFrame(String format, Seq<String> existingHdfsPaths) {
        Dataset dataset;
        String csvDelimiterOption = DelimiterUtils$.MODULE$.checkDelimiterOption(this.ss().sqlContext().getConf("spark.feathr.inputFormat.csvOptions.sep", ","));
        String string = format;
        String string2 = this.CSV();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            dataset = this.ss().read().format("csv").option("header", "true").option("delimiter", csvDelimiterOption).load(existingHdfsPaths);
        } else {
            String string4 = this.AVRO();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                dataset = this.ss().read().format(this.AVRO_DATASOURCE()).load(existingHdfsPaths);
            } else {
                String string6 = this.ORC();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    dataset = this.ss().read().format(this.ORC_DATASOURCE()).load(existingHdfsPaths);
                } else {
                    String string8 = this.PARQUET();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        dataset = this.ss().read().format(this.PARQUET()).load(existingHdfsPaths);
                    } else {
                        String string10 = this.JDBC();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            dataset = JdbcUtils$.MODULE$.loadDataFrame(this.ss(), (String)existingHdfsPaths.head());
                        } else {
                            String string12 = this.SNOWFLAKE();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                dataset = SnowflakeUtils$.MODULE$.loadDataFrame(this.ss(), (String)existingHdfsPaths.head());
                            } else {
                                if (!this.ss().conf().getOption("spark.feathr.inputFormat").nonEmpty()) {
                                    throw new FeathrException(new StringBuilder(64).append("Unsupported data format ").append(format).append(" and 'spark.feathr.inputFormat' not set.").toString());
                                }
                                dataset = this.ss().read().format(this.ss().conf().get("spark.feathr.inputFormat")).load(existingHdfsPaths);
                            }
                        }
                    }
                }
            }
        }
        Dataset df = dataset;
        return df;
    }

    private FileFormat$() {
        MODULE$ = this;
        this.CSV = "CSV";
        this.AVRO_JSON = "AVRO_JSON";
        this.AVRO = "AVRO";
        this.ORC = "ORC";
        this.PARQUET = "PARQUET";
        this.PATHLIST = "PATHLIST";
        this.JDBC = "JDBC";
        this.SNOWFLAKE = "SNOWFLAKE";
        this.AVRO_DATASOURCE = "avro";
        this.ORC_DATASOURCE = "orc";
        this.DATA_FORMAT = "data.format";
    }
}

