/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.source.pathutil;

import com.linkedin.feathr.common.DateTimeResolution$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.source.pathutil.LocalPathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathChecker;
import com.linkedin.feathr.offline.source.pathutil.PathInfo;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\r4QAD\b\u0001'mA\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)1\b\u0001C\u0001y!9\u0001\t\u0001b\u0001\n\u0003\t\u0005B\u0002&\u0001A\u0003%!\tC\u0004L\u0001\t\u0007I\u0011A!\t\r1\u0003\u0001\u0015!\u0003C\u0011\u001di\u0005A1A\u0005\u0002\u0005CaA\u0014\u0001!\u0002\u0013\u0011\u0005bB(\u0001\u0005\u0004%\t!\u0011\u0005\u0007!\u0002\u0001\u000b\u0011\u0002\"\t\u000bE\u0003A\u0011\u0001*\t\u000bE\u0003A\u0011A0\u00033QKW.\u001a\"bg\u0016$\u0007\n\u001a4t!\u0006$\b.\u00118bYfTXM\u001d\u0006\u0003!E\t\u0001\u0002]1uQV$\u0018\u000e\u001c\u0006\u0003%M\taa]8ve\u000e,'B\u0001\u000b\u0016\u0003\u001dygM\u001a7j]\u0016T!AF\f\u0002\r\u0019,\u0017\r\u001e5s\u0015\tA\u0012$\u0001\u0005mS:\\W\rZ5o\u0015\u0005Q\u0012aA2p[N\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0017A\fG\u000f[\"iK\u000e\\WM]\u0002\u0001!\t)c%D\u0001\u0010\u0013\t9sBA\u0006QCRD7\t[3dW\u0016\u0014\u0018A\u00053bi\u0006du.\u00193fe\"\u000bg\u000e\u001a7feN\u00042A\u000b\u001a6\u001d\tY\u0003G\u0004\u0002-_5\tQF\u0003\u0002/G\u00051AH]8pizJ\u0011aH\u0005\u0003cy\tq\u0001]1dW\u0006<W-\u0003\u00024i\t!A*[:u\u0015\t\td\u0004\u0005\u00027s5\tqG\u0003\u00029#\u0005QA-\u0019;bY>\fG-\u001a:\n\u0005i:$!\u0005#bi\u0006du.\u00193fe\"\u000bg\u000e\u001a7fe\u00061A(\u001b8jiz\"2!\u0010 @!\t)\u0003\u0001C\u0003#\u0007\u0001\u0007A\u0005C\u0003)\u0007\u0001\u0007\u0011&A\u0006eC&d\u0017PR8mI\u0016\u0014X#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00027b]\u001eT\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\t\n11\u000b\u001e:j]\u001e\fA\u0002Z1jYf4u\u000e\u001c3fe\u0002\nA\u0002[8ve2Lhi\u001c7eKJ\fQ\u0002[8ve2Lhi\u001c7eKJ\u0004\u0013\u0001\u00043bS2L\b+\u0019;uKJt\u0017!\u00043bS2L\b+\u0019;uKJt\u0007%A\u0007i_V\u0014H.\u001f)biR,'O\\\u0001\u000fQ>,(\u000f\\=QCR$XM\u001d8!\u0003\u001d\tg.\u00197zu\u0016$\"a\u0015,\u0011\u0005\u0015\"\u0016BA+\u0010\u0005!\u0001\u0016\r\u001e5J]\u001a|\u0007\"B,\r\u0001\u0004A\u0016\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0011\u0005ekfB\u0001.\\!\tac$\u0003\u0002]=\u00051\u0001K]3eK\u001aL!!\u00130\u000b\u0005qsBcA*aC\")q+\u0004a\u00011\")!-\u0004a\u00011\u0006!B/[7f!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e;fe:\u0004")
public class TimeBasedHdfsPathAnalyzer {
    private final PathChecker pathChecker;
    private final List<DataLoaderHandler> dataLoaderHandlers;
    private final String dailyFolder;
    private final String hourlyFolder;
    private final String dailyPattern;
    private final String hourlyPattern;

    public String dailyFolder() {
        return this.dailyFolder;
    }

    public String hourlyFolder() {
        return this.hourlyFolder;
    }

    public String dailyPattern() {
        return this.dailyPattern;
    }

    public String hourlyPattern() {
        return this.hourlyPattern;
    }

    public PathInfo analyze(String filePath) {
        String fileFolder = filePath.endsWith("/") ? filePath : new StringBuilder(1).append(filePath).append("/").toString();
        ObjectRef pathInfoOpt = ObjectRef.create((Object)None$.MODULE$);
        if (this.pathChecker instanceof LocalPathChecker) {
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dataLoaderHandlers.foreach((Function1 & Serializable & scala.Serializable)dataLoaderHandler -> {
                TimeBasedHdfsPathAnalyzer.$anonfun$analyze$2(this, fileFolder, pathInfoOpt, dataLoaderHandler);
                return BoxedUnit.UNIT;
            }));
        }
        return ((Option)pathInfoOpt.elem).isDefined() ? (PathInfo)((Option)pathInfoOpt.elem).get() : (fileFolder.endsWith(this.dailyFolder()) ? new PathInfo(fileFolder, DateTimeResolution$.MODULE$.DAILY(), this.dailyPattern()) : (fileFolder.endsWith(this.hourlyFolder()) ? new PathInfo(fileFolder, DateTimeResolution$.MODULE$.HOURLY(), this.hourlyPattern()) : (this.pathChecker.exists(new StringBuilder(0).append(fileFolder).append(this.dailyFolder()).toString()) ? new PathInfo(new StringBuilder(0).append(fileFolder).append(this.dailyFolder()).toString(), DateTimeResolution$.MODULE$.DAILY(), this.dailyPattern()) : (this.pathChecker.exists(new StringBuilder(0).append(fileFolder).append(this.hourlyFolder()).toString()) ? new PathInfo(new StringBuilder(0).append(fileFolder).append(this.hourlyFolder()).toString(), DateTimeResolution$.MODULE$.HOURLY(), this.hourlyPattern()) : new PathInfo(fileFolder, DateTimeResolution$.MODULE$.DAILY(), this.dailyPattern())))));
    }

    public PathInfo analyze(String filePath, String timePartitionPattern) {
        String basePath = filePath.endsWith("/") || filePath.endsWith("=") ? filePath : new StringBuilder(1).append(filePath).append("/").toString();
        Enumeration.Value dateTimeResolution = OfflineDateTimeUtils$.MODULE$.getDateTimeResolutionFromPattern(timePartitionPattern);
        return basePath.endsWith(this.dailyFolder()) ? new PathInfo(basePath, dateTimeResolution, timePartitionPattern) : (basePath.endsWith(this.hourlyFolder()) ? new PathInfo(basePath, dateTimeResolution, timePartitionPattern) : (this.pathChecker.exists(new StringBuilder(0).append(basePath).append(this.dailyFolder()).toString()) ? new PathInfo(new StringBuilder(0).append(basePath).append(this.dailyFolder()).toString(), dateTimeResolution, timePartitionPattern) : (this.pathChecker.exists(new StringBuilder(0).append(basePath).append(this.hourlyFolder()).toString()) ? new PathInfo(new StringBuilder(0).append(basePath).append(this.hourlyFolder()).toString(), dateTimeResolution, timePartitionPattern) : new PathInfo(filePath, dateTimeResolution, timePartitionPattern))));
    }

    public static final /* synthetic */ void $anonfun$analyze$2(TimeBasedHdfsPathAnalyzer $this, String fileFolder$1, ObjectRef pathInfoOpt$1, DataLoaderHandler dataLoaderHandler) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)dataLoaderHandler.validatePath().apply((Object)fileFolder$1))) break block0;
            pathInfoOpt$1.elem = new Some((Object)new PathInfo(fileFolder$1, DateTimeResolution$.MODULE$.DAILY(), $this.dailyPattern()));
        }
    }

    public TimeBasedHdfsPathAnalyzer(PathChecker pathChecker, List<DataLoaderHandler> dataLoaderHandlers) {
        this.pathChecker = pathChecker;
        this.dataLoaderHandlers = dataLoaderHandlers;
        this.dailyFolder = "daily/";
        this.hourlyFolder = "hourly/";
        this.dailyPattern = "yyyy/MM/dd";
        this.hourlyPattern = "yyyy/MM/dd/HH";
    }
}

