/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.GenericTypedTensor;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.common.exception.FeathrFeatureTransformationException;
import com.linkedin.feathr.common.featurizeddataset.FeatureDeserializer;
import com.linkedin.feathr.common.featurizeddataset.SparkDeserializerFactory;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.util.CoercionUtils;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CoercionUtilsScala$ {
    public static CoercionUtilsScala$ MODULE$;

    static {
        new CoercionUtilsScala$();
    }

    public String safeToString(Object item) {
        return CoercionUtils.safeToString(item);
    }

    public FeatureValue coerceToFeatureValue(Object item) {
        FeatureValue featureValue;
        Object object = item;
        if (object instanceof FeatureValue) {
            FeatureValue featureValue2;
            featureValue = featureValue2 = (FeatureValue)object;
        } else {
            FeatureTypes featureType = CoercionUtils.getCoercedFeatureType(object);
            featureValue = new FeatureValue(object, featureType);
        }
        return featureValue;
    }

    public FeatureValue coerceToFeatureValue(Object item, FeatureTypes featureType) {
        FeatureValue featureValue;
        Object object = item;
        FeatureValue featureValue2 = object instanceof FeatureValue ? (featureValue = (FeatureValue)object) : new FeatureValue(item, featureType);
        return featureValue2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> coerceFeatureValueToStringKey(FeatureValue featureValue) {
        Seq seq;
        if (featureValue.size() == 1) {
            Tuple2 tuple2 = (Tuple2)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020mapAsScalaMap(featureValue.getValue()).iterator().next();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String term = (String)tuple2._1();
            Float value = (Float)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)term, (Object)value);
            Tuple2 tuple23 = tuple22;
            String term2 = (String)tuple23._1();
            Float value2 = (Float)tuple23._2();
            if (term2.equals("") && value2 instanceof Number) {
                seq = (Seq)new .colon.colon((Object)Long.toString((long)Predef$.MODULE$.Float2float(value2)), (List)Nil$.MODULE$);
                return seq;
            } else if (value2.equals(BoxesRunTime.boxToFloat((float)1.0f))) {
                seq = (Seq)new .colon.colon((Object)term2, (List)Nil$.MODULE$);
                return seq;
            } else {
                if (!term2.equals("0")) throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(52).append("Cannot coerce FeatureValue to String keys for join: ").append(featureValue).toString());
                seq = (Seq)new .colon.colon((Object)Long.toString((long)Predef$.MODULE$.Float2float(value2)), (List)Nil$.MODULE$);
            }
            return seq;
        } else {
            Set valueSet = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(featureValue.getValue().values()).asScala()).toSet();
            if (valueSet.size() == 1 && valueSet.contains((Object)Predef$.MODULE$.float2Float(1.0f))) {
                seq = ((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020asScalaSet(featureValue.getValue().keySet()).toSeq();
                return seq;
            } else {
                boolean isCategoricalSet;
                boolean isDenseVector = ((SeqLike)((TraversableLike)((IterableLike)((SeqLike)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020mapAsScalaMap(featureValue.getValue()).keys().toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)CoercionUtilsScala$.$anonfun$coerceFeatureValueToStringKey$1(x$2)), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$)).zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)pr -> BoxesRunTime.boxToBoolean((boolean)CoercionUtilsScala$.$anonfun$coerceFeatureValueToStringKey$2(pr)))).size() == 0;
                boolean bl = isCategoricalSet = ((TraversableOnce)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020collectionAsScalaIterable(featureValue.getValue().values()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CoercionUtilsScala$.$anonfun$coerceFeatureValueToStringKey$3(x$3)))).size() == 0;
                if (isDenseVector) {
                    seq = (Seq)((TraversableLike)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020mapAsScalaMap(featureValue.getValue()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)CoercionUtilsScala$.$anonfun$coerceFeatureValueToStringKey$4(x$4)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> Long.toString((long)Predef$.MODULE$.Float2float((Float)x$5._2())), Seq$.MODULE$.canBuildFrom());
                    return seq;
                } else {
                    if (!isCategoricalSet) throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(52).append("Cannot coerce FeatureValue to String keys for join: ").append(featureValue).toString());
                    seq = ((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020mapAsScalaMap(featureValue.getValue()).keys().toSeq();
                }
            }
        }
        return seq;
    }

    public FeatureValue coerceFieldToFeatureValue(Row row, StructType schema, String fieldName, FeatureTypeConfig featureTypeConfig) {
        FeatureValue featureValue;
        Predef$.MODULE$.print((Object)new StringBuilder(54).append("ROW IS ").append(row).append(" and featureTypeConfig is ").append(featureTypeConfig).append(" and feature name is ").append(fieldName).toString());
        int fieldIndex = schema.fieldIndex(fieldName);
        StructField fieldType = (StructField)schema.toList().apply(fieldIndex);
        if (row.get(fieldIndex) == null) {
            featureValue = null;
        } else if (featureTypeConfig.getFeatureType().equals((Object)FeatureTypes.TENSOR)) {
            TensorType tensorType = featureTypeConfig.getTensorType();
            FeatureDeserializer featureDeserializer = SparkDeserializerFactory.getFeatureDeserializer(tensorType);
            TensorData tensorData = featureDeserializer.deserialize(row.getAs(fieldIndex));
            GenericTypedTensor genericTypedTensor = new GenericTypedTensor(tensorData, tensorType);
            featureValue = new FeatureValue(genericTypedTensor);
        } else {
            FeatureValue featureValue2;
            DataType dataType = fieldType.dataType();
            if (dataType instanceof StringType) {
                String value = (String)row.getAs(fieldIndex);
                featureValue2 = FeatureValue.createCategorical(value);
            } else if (dataType instanceof BooleanType) {
                featureValue2 = FeatureValue.createBoolean(Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)row.getAs(fieldIndex))));
            } else if (dataType instanceof NumericType) {
                float value = ((Number)row.getAs(fieldIndex)).floatValue();
                featureValue2 = FeatureValue.createNumeric(Predef$.MODULE$.float2Float(value));
            } else if (dataType instanceof MapType) {
                FeatureValue featureValue3;
                Option option = Option$.MODULE$.apply((Object)row.getJavaMap(fieldIndex));
                if (None$.MODULE$.equals(option)) {
                    featureValue3 = null;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    java.util.Map value = (java.util.Map)some.value();
                    featureValue3 = new FeatureValue((Object)value);
                } else {
                    throw new MatchError((Object)option);
                }
                featureValue2 = featureValue3;
            } else if (dataType instanceof ArrayType) {
                FeatureValue featureValue4;
                ArrayType arrayType = (ArrayType)dataType;
                DataType dataType2 = arrayType.elementType();
                if (dataType2 instanceof ShortType) {
                    throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(189).append("Cannot convert Array of Short type in ").append(fieldName).append(" to name-term-value FeatureValue,").append(" as it is ambiguous, could be CATEGORICAL_SET or DENSE_VECTOR. Please use Spark-dataframe based derivation expression.").toString());
                }
                if (dataType2 instanceof IntegerType) {
                    throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(191).append("Cannot convert Array of Integer type in ").append(fieldName).append(" to name-term-value FeatureValue,").append(" as it is ambiguous, could be CATEGORICAL_SET or DENSE_VECTOR. Please use Spark-dataframe based derivation expression.").toString());
                }
                if (dataType2 instanceof LongType) {
                    throw new FeathrFeatureTransformationException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(188).append("Cannot convert Array of Long type in ").append(fieldName).append(" to name-term-value FeatureValue,").append(" as it is ambiguous, could be CATEGORICAL_SET or DENSE_VECTOR. Please use Spark-dataframe based derivation expression.").toString());
                }
                if (dataType2 instanceof NumericType) {
                    java.util.List elements = (java.util.List)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)row.getAs(fieldIndex)).asJava();
                    featureValue4 = new FeatureValue((Object)elements, FeatureTypes.DENSE_VECTOR);
                } else if (dataType2 instanceof StringType) {
                    java.util.List elements = (java.util.List)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)row.getAs(fieldIndex)).asJava();
                    featureValue4 = new FeatureValue((Object)elements, FeatureTypes.CATEGORICAL_SET);
                } else {
                    throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(118).append("Cannot convert Array of {").append(dataType2).append("} to name-term-value FeatureValue for column ").append(fieldName).append(",").append(" only array of float/double/string is supported").toString());
                }
                featureValue2 = featureValue4;
            } else if (dataType instanceof StructType) {
                float[] fArray;
                String[] stringArray;
                Row fdsFeature = (Row)row.getAs(fieldIndex);
                Object object = fdsFeature.get(0);
                if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                    Object object2 = object;
                    stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toArray(ClassTag$.MODULE$.apply(String.class));
                } else if (object instanceof Seq) {
                    Seq seq = (Seq)object;
                    stringArray = (String[])((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                } else if (object instanceof WrappedArray) {
                    WrappedArray wrappedArray = (WrappedArray)object;
                    stringArray = (String[])((WrappedArray)wrappedArray.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString(), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
                } else {
                    throw new MatchError(object);
                }
                String[] terms = stringArray;
                Object object3 = fdsFeature.get(1);
                if (object3 instanceof float[]) {
                    float[] fArray2;
                    fArray = fArray2 = (float[])object3;
                } else if (object3 instanceof Seq) {
                    Seq seq = (Seq)object3;
                    fArray = (float[])seq.toArray(ClassTag$.MODULE$.Float());
                } else if (object3 instanceof WrappedArray) {
                    WrappedArray wrappedArray = (WrappedArray)object3;
                    fArray = (float[])wrappedArray.toArray(ClassTag$.MODULE$.Float());
                } else {
                    throw new MatchError(object3);
                }
                float[] values = fArray;
                java.util.Map termValues = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])terms)).zip((GenIterable)Predef$.MODULE$.wrapFloatArray(values), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())).asJava();
                featureValue2 = new FeatureValue((Object)termValues, FeatureTypes.TERM_VECTOR);
            } else {
                throw new MatchError((Object)dataType);
            }
            featureValue = featureValue2;
        }
        FeatureValue valueMap = featureValue;
        return valueMap;
    }

    public static final /* synthetic */ int $anonfun$coerceFeatureValueToStringKey$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$coerceFeatureValueToStringKey$2(Tuple2 pr) {
        return pr._1$mcI$sp() != pr._2$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$coerceFeatureValueToStringKey$3(Float x$3) {
        return !x$3.equals(BoxesRunTime.boxToFloat((float)1.0f));
    }

    public static final /* synthetic */ int $anonfun$coerceFeatureValueToStringKey$4(Tuple2 x$4) {
        return new StringOps(Predef$.MODULE$.augmentString((String)x$4._1())).toInt();
    }

    private CoercionUtilsScala$() {
        MODULE$ = this;
    }
}

