/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.linkedin.feathr.offline.config.datasource.DataSourceConfigUtils$;
import com.linkedin.feathr.offline.config.datasource.DataSourceConfigs;
import com.linkedin.feathr.offline.config.datasource.DataSourceConfigs$;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import com.linkedin.feathr.offline.util.Transformations$;
import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FeathrTestUtils$ {
    public static FeathrTestUtils$ MODULE$;

    static {
        new FeathrTestUtils$();
    }

    public void assertFDSApproximatelyEquals(SparkFeaturizedDataset actual, SparkFeaturizedDataset expected, Function1<Row, String> cmpFunc) {
        Predef$.MODULE$.assert(actual != null);
        Predef$.MODULE$.assert(expected != null);
        this.assertDataFrameApproximatelyEquals(actual.data(), expected.data(), cmpFunc);
    }

    public void assertDataFrameApproximatelyEquals(Dataset<Row> actual, Dataset<Row> expected, Function1<Row, String> cmpFunc) {
        Predef$.MODULE$.assert(actual != null);
        Predef$.MODULE$.assert(expected != null);
        Dataset orderedActual = actual.transform((Function1 & Serializable & scala.Serializable)df -> Transformations$.MODULE$.sortColumns("asc", (Dataset<Row>)df));
        Dataset orderedExpected = expected.transform((Function1 & Serializable & scala.Serializable)df -> Transformations$.MODULE$.sortColumns("asc", (Dataset<Row>)df));
        List actualRows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orderedActual.collect())).sortBy(cmpFunc, (Ordering)Ordering.String$.MODULE$))).toList();
        List expectedRows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orderedExpected.collect())).sortBy(cmpFunc, (Ordering)Ordering.String$.MODULE$))).toList();
        Predef$.MODULE$.assert(actualRows.equals((Object)expectedRows), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("DataFrames contents aren't equal,").append("\nactual:\n").append(MODULE$.toDebugString((Dataset<Row>)orderedActual)).append(", ").append("\nexpected:\n").append(MODULE$.toDebugString((Dataset<Row>)orderedExpected)).append(".").toString());
    }

    public SparkSession getSparkSession() {
        SparkConf sparkConf = new SparkConf();
        sparkConf.registerKryoClasses((Class[])((Object[])new Class[]{GenericRecord.class}));
        sparkConf.set("spark.default.parallelism", "4");
        sparkConf.set("spark.sql.shuffle.partitions", "4");
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.driver.host", "localhost");
        return this.createSparkSession(true, this.getClass().getName(), "*", sparkConf);
    }

    private String toDebugString(Dataset<Row> df) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)row -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames())).zip((GenIterable)row.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).mkString(","), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public SparkSession createSparkSession(boolean enableHiveSupport, String appName, Object numThreads, SparkConf sparkConf) {
        String path = "";
        SparkConf conf = sparkConf;
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        SQLConf$.MODULE$.get().setConfString("spark.sql.legacy.allowUntypedScalaUDF", "true");
        conf.set("spark.kryo.mllib.register", "false");
        conf.set("spark.driver.host", "localhost");
        conf.set("spark.isolated.classloader", "true");
        conf.set("spark.isolated.classes", "org.apache.hadoop.hive.ql.io.CombineHiveInputFormat$CombineHiveInputSplit");
        conf.set("spark.isolated.classloader.driver.jar", path);
        conf.set("spark.expressionencoder.org.apache.avro.specific.SpecificRecord", "org.apache.spark.sql.avro.AvroEncoder$");
        DataSourceConfigUtils$.MODULE$.setupSparkConf(conf, new DataSourceConfigs(DataSourceConfigs$.MODULE$.$lessinit$greater$default$1(), DataSourceConfigs$.MODULE$.$lessinit$greater$default$2(), DataSourceConfigs$.MODULE$.$lessinit$greater$default$3(), DataSourceConfigs$.MODULE$.$lessinit$greater$default$4(), DataSourceConfigs$.MODULE$.$lessinit$greater$default$5(), DataSourceConfigs$.MODULE$.$lessinit$greater$default$6(), DataSourceConfigs$.MODULE$.$lessinit$greater$default$7(), DataSourceConfigs$.MODULE$.$lessinit$greater$default$8()));
        if (!(numThreads instanceof Integer) && !numThreads.equals("*")) {
            throw new IllegalArgumentException(new StringBuilder(72).append("Invalid arguments: The number of threads (").append(numThreads).append(") ").append("can only be integers or '*'.").toString());
        }
        SparkSession.Builder sessionBuilder = SparkSession$.MODULE$.builder().appName(appName).master(new StringBuilder(7).append("local[").append(numThreads).append("]").toString()).config(conf);
        return sessionBuilder.getOrCreate();
    }

    public boolean createSparkSession$default$1() {
        return false;
    }

    public String createSparkSession$default$2() {
        return "localtest";
    }

    public Object createSparkSession$default$3() {
        return BoxesRunTime.boxToInteger((int)4);
    }

    public SparkConf createSparkSession$default$4() {
        return new SparkConf();
    }

    private FeathrTestUtils$() {
        MODULE$ = this;
    }
}

