/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.tensor.PrimitiveDimensionType;
import com.linkedin.feathr.common.tensor.TensorCategory;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.types.PrimitiveType;
import java.util.Collections;
import java.util.Optional;

public class AutoTensorizableTypes {
    static final TensorType SCALAR_BOOLEAN_TENSOR_TYPE = new TensorType(TensorCategory.DENSE, PrimitiveType.BOOLEAN, Collections.emptyList());
    static final TensorType SCALAR_FLOAT_TENSOR_TYPE = new TensorType(TensorCategory.DENSE, PrimitiveType.FLOAT, Collections.emptyList());
    static final TensorType TERM_VECTOR_TENSOR_TYPE = new TensorType(PrimitiveType.FLOAT, Collections.singletonList(PrimitiveDimensionType.STRING));
    static final TensorType DENSE_1D_FLOAT_TENSOR_TYPE = new TensorType(TensorCategory.DENSE, PrimitiveType.FLOAT, Collections.singletonList(PrimitiveDimensionType.INT));

    private AutoTensorizableTypes() {
    }

    public static Optional<TensorType> getDefaultTensorType(FeatureTypes featureType) {
        switch (featureType) {
            case BOOLEAN: {
                return Optional.of(SCALAR_BOOLEAN_TENSOR_TYPE);
            }
            case NUMERIC: {
                return Optional.of(SCALAR_FLOAT_TENSOR_TYPE);
            }
            case CATEGORICAL: 
            case CATEGORICAL_SET: 
            case TERM_VECTOR: 
            case UNSPECIFIED: {
                return Optional.of(TERM_VECTOR_TENSOR_TYPE);
            }
            case DENSE_VECTOR: {
                return Optional.of(DENSE_1D_FLOAT_TENSOR_TYPE);
            }
        }
        return Optional.empty();
    }
}

