/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linkedin.feathr.common.AutoTensorizableTypes;
import com.linkedin.feathr.common.FeatureTypeConfigDeserializer;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.tensor.TensorType;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonDeserialize(using=FeatureTypeConfigDeserializer.class)
public class FeatureTypeConfig
implements Serializable {
    private final FeatureTypes _featureType;
    private final TensorType _tensorType;
    private final String _documentation;
    public static final FeatureTypeConfig UNDEFINED_TYPE_CONFIG = new FeatureTypeConfig(FeatureTypes.UNSPECIFIED);
    public static final FeatureTypeConfig NUMERIC_TYPE_CONFIG = new FeatureTypeConfig(FeatureTypes.NUMERIC);
    public static final FeatureTypeConfig DENSE_VECTOR_TYPE_CONFIG = new FeatureTypeConfig(FeatureTypes.DENSE_VECTOR);
    public static final FeatureTypeConfig TERM_VECTOR_TYPE_CONFIG = new FeatureTypeConfig(FeatureTypes.TERM_VECTOR);
    public static final FeatureTypeConfig CATEGORICAL_TYPE_CONFIG = new FeatureTypeConfig(FeatureTypes.CATEGORICAL);
    public static final FeatureTypeConfig CATEGORICAL_SET_TYPE_CONFIG = new FeatureTypeConfig(FeatureTypes.CATEGORICAL_SET);

    public FeatureTypeConfig() {
        this(FeatureTypes.UNSPECIFIED);
    }

    public FeatureTypeConfig(FeatureTypes featureType) {
        this._featureType = featureType;
        this._tensorType = featureType != FeatureTypes.UNSPECIFIED ? (TensorType)AutoTensorizableTypes.getDefaultTensorType(featureType).orElse(null) : null;
        this._documentation = null;
    }

    public String getDocumentation() {
        return this._documentation;
    }

    public FeatureTypeConfig(@Nonnull TensorType tensorType) {
        Objects.requireNonNull(tensorType, "tensorType must be non-null when using the tensor type constructor");
        this._featureType = FeatureTypes.TENSOR;
        this._tensorType = tensorType;
        this._documentation = null;
    }

    public FeatureTypeConfig(@Nonnull FeatureTypes featureType, @Nonnull TensorType tensorType, String documentation) {
        Objects.requireNonNull(featureType, "featureType must be non-null");
        this._featureType = featureType;
        this._tensorType = tensorType;
        this._documentation = documentation;
    }

    public boolean hasTensorType() {
        return this._tensorType != null;
    }

    public FeatureTypes getFeatureType() {
        return this._featureType;
    }

    public TensorType getTensorType() {
        return this._tensorType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureTypeConfig that = (FeatureTypeConfig)o;
        return this._featureType == that._featureType && Objects.equals(this._tensorType, that._tensorType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._featureType, this._tensorType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureTypeConfig{");
        sb.append("_featureType=").append((Object)this._featureType);
        sb.append(", _tensorType=").append(this._tensorType);
        sb.append('}');
        return sb.toString();
    }
}

