/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.TypedTensor;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.types.ValueType;
import com.linkedin.feathr.common.util.CoercionUtils;
import org.mvel2.integration.impl.SimpleValueResolver;

public class FeatureVariableResolver
extends SimpleValueResolver {
    private FeatureValue _featureValue;

    public FeatureVariableResolver(FeatureValue featureValue) {
        super((Object)featureValue);
        this._featureValue = featureValue;
    }

    public Object getValue() {
        if (this._featureValue == null) {
            return null;
        }
        switch (this._featureValue.getFeatureType().getBasicType()) {
            case NUMERIC: {
                return this._featureValue.getAsNumeric();
            }
            case TERM_VECTOR: {
                return this.getValueFromTermVector();
            }
            case BOOLEAN: 
            case CATEGORICAL: 
            case CATEGORICAL_SET: 
            case DENSE_VECTOR: 
            case TENSOR: {
                return this.getValueFromTensor();
            }
        }
        throw new IllegalArgumentException("Unexpected feature type: " + (Object)((Object)this._featureValue.getFeatureType().getBasicType()));
    }

    private Object getValueFromTensor() {
        TypedTensor tensor = this._featureValue.getAsTypedTensor();
        int rank = tensor.getType().getDimensionTypes().size();
        if (rank == 0) {
            ValueType valueType = tensor.getType().getValueType();
            Primitive primitive = valueType.getRepresentation();
            TensorIterator iterator = tensor.getData().iterator();
            iterator.start();
            int colIndex = 0;
            switch (primitive) {
                case DOUBLE: {
                    return iterator.getDouble(colIndex);
                }
                case FLOAT: {
                    return Float.valueOf(iterator.getFloat(colIndex));
                }
                case INT: {
                    return iterator.getInt(colIndex);
                }
                case LONG: {
                    return iterator.getLong(colIndex);
                }
            }
            return this._featureValue;
        }
        return this._featureValue;
    }

    private Object getValueFromTermVector() {
        if (CoercionUtils.isNumeric(this._featureValue)) {
            return this._featureValue.getAsNumeric();
        }
        return this._featureValue;
    }
}

