/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.linkedin.feathr.common.Equal;
import com.linkedin.feathr.common.Hasher;
import com.linkedin.feathr.common.TensorUtils;
import com.linkedin.feathr.common.TypedTensor;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorType;
import java.util.Objects;

public class GenericTypedTensor
implements TypedTensor {
    private static final UnsupportedOperationException UNSUPPORTED_OPERATION_EXCEPTION = new UnsupportedOperationException("");
    protected final TensorData _data;
    protected final TensorType _type;

    public GenericTypedTensor(TensorData data, TensorType type) {
        this._type = type;
        this._data = data;
    }

    @Override
    public TensorData getData() {
        return this._data;
    }

    @Override
    public TensorType getType() {
        return this._type;
    }

    @Override
    public TypedTensor slice(Object val) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public TypedTensor subSlice(Object val) {
        throw UNSUPPORTED_OPERATION_EXCEPTION;
    }

    @Override
    public String toDebugString() {
        return this.toDebugString(10240);
    }

    @Override
    public String toDebugString(int maxStringLenLimit) {
        return TensorUtils.getDebugString(this._type, this._data, maxStringLenLimit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericTypedTensor that = (GenericTypedTensor)o;
        return Objects.equals(this._type, that._type) && Equal.INSTANCE.apply(this._data, that._data);
    }

    public int hashCode() {
        return Objects.hash(Hasher.INSTANCE.apply(this._data, false), this._type);
    }
}

