/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common;

import com.google.common.annotations.VisibleForTesting;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.PegasusFeatureTypeResolver;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.types.PrimitiveType;
import com.linkedin.feathr.compute.FeatureVersion;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PegasusDefaultFeatureValueResolver {
    private static final String DEFAULT_VALUE_PATH = "MOCK_DEFAULT_VALUE_PATH";
    private static final String HOCON_PREFIX = "{ ";
    private static final String HOCON_SUFFIX = " }";
    private static final String HOCON_DELIM = " : ";
    private static final PegasusDefaultFeatureValueResolver INSTANCE = new PegasusDefaultFeatureValueResolver(PegasusFeatureTypeResolver.getInstance());
    private final PegasusFeatureTypeResolver _pegasusFeatureTypeResolver;
    private static final Logger LOG = LoggerFactory.getLogger((String)PegasusDefaultFeatureValueResolver.class.getSimpleName());

    public static PegasusDefaultFeatureValueResolver getInstance() {
        return INSTANCE;
    }

    PegasusDefaultFeatureValueResolver(PegasusFeatureTypeResolver pegasusFeatureTypeResolver) {
        this._pegasusFeatureTypeResolver = pegasusFeatureTypeResolver;
    }

    public Optional<FeatureValue> resolveDefaultValue(String featureName, FeatureVersion featureVersion) {
        if (!featureVersion.hasDefaultValue()) {
            return Optional.empty();
        }
        if (!Objects.requireNonNull(featureVersion.getDefaultValue()).isString()) {
            throw new RuntimeException("The default value type for " + featureName + " is not supported, currently only support HOCON string");
        }
        String rawExpr = featureVersion.getDefaultValue().getString();
        StringBuilder hoconStringBuilder = new StringBuilder();
        hoconStringBuilder.append(HOCON_PREFIX).append(DEFAULT_VALUE_PATH).append(HOCON_DELIM).append(rawExpr).append(HOCON_SUFFIX);
        String hoconFullString = hoconStringBuilder.toString();
        Config config = ConfigFactory.parseString((String)hoconFullString);
        FeatureTypeConfig featureTypeConfig = this._pegasusFeatureTypeResolver.resolveFeatureType(featureVersion);
        Optional<FeatureValue> featureValue = this.resolveDefaultValue(featureTypeConfig, config);
        if (!featureValue.isPresent()) {
            String errMessage = String.join((CharSequence)"", "Fail to extract default FeatureValue for ", featureName, " from raw expression:\n", rawExpr);
            throw new RuntimeException(errMessage);
        }
        LOG.info("The default value for feature {} is resolved as {}", (Object)featureName, (Object)featureValue.get());
        return featureValue;
    }

    private Optional<FeatureValue> resolveDefaultValue(FeatureTypeConfig featureTypeConfig, Config config) {
        ConfigValue defaultConfigValue = config.getValue(DEFAULT_VALUE_PATH);
        Object defaultValueObj = defaultConfigValue.unwrapped();
        Optional<Object> normalizedDefaultValue = this.normalize(defaultValueObj);
        if (!normalizedDefaultValue.isPresent()) {
            return Optional.empty();
        }
        Object defaultData = normalizedDefaultValue.get();
        FeatureTypes featureType = featureTypeConfig.getFeatureType();
        if (featureType != FeatureTypes.TENSOR) {
            FeatureValue featureValue = new FeatureValue(defaultData, featureType);
            return Optional.of(featureValue);
        }
        if (featureTypeConfig.getTensorType() != null) {
            TensorType tensorType = featureTypeConfig.getTensorType();
            Object coercedDefault = defaultData;
            if (tensorType.getDimensionTypes().size() == 0 && defaultData instanceof Number) {
                Number num = (Number)defaultData;
                if (tensorType.getValueType() == PrimitiveType.FLOAT) {
                    coercedDefault = Float.valueOf(num.floatValue());
                } else if (tensorType.getValueType() == PrimitiveType.DOUBLE) {
                    coercedDefault = num.doubleValue();
                } else if (tensorType.getValueType() == PrimitiveType.INT) {
                    coercedDefault = num.intValue();
                } else if (tensorType.getValueType() == PrimitiveType.LONG) {
                    coercedDefault = num.longValue();
                }
            }
            FeatureValue featureValue = FeatureValue.createTensor(coercedDefault, featureTypeConfig.getTensorType());
            return Optional.of(featureValue);
        }
        throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, "Unknown default value ");
    }

    @VisibleForTesting
    Optional<Object> normalize(Object defaultValue) {
        if (defaultValue instanceof Number) {
            return Optional.of(this.normalizeNumber(defaultValue));
        }
        if (defaultValue instanceof List) {
            return this.normalizeList(defaultValue);
        }
        if (defaultValue instanceof Map) {
            return this.normalizeMap(defaultValue);
        }
        return Optional.of(defaultValue);
    }

    private Optional<Object> normalizeList(Object defaultValue) {
        ArrayList defaultList = new ArrayList();
        List list = (List)defaultValue;
        for (Object elem : list) {
            if (elem instanceof String) {
                defaultList.add(elem);
                continue;
            }
            if (elem instanceof Number) {
                defaultList.add(this.normalizeNumber(elem));
                continue;
            }
            if (elem instanceof Boolean) {
                defaultList.add(Boolean.valueOf(elem.toString()));
                continue;
            }
            LOG.error("List element type not supported when resolving default value: {} .\nOnly List<String> and List<Numeric> are supported when defining List type default value.", elem);
            return Optional.empty();
        }
        return Optional.of(defaultList);
    }

    private Optional<Object> normalizeMap(Object defaultValue) {
        HashMap<String, Constable> defaultMap = new HashMap<String, Constable>();
        HashMap map = (HashMap)defaultValue;
        for (String key : map.keySet()) {
            Object valueObj = map.get(key);
            if (valueObj instanceof Number) {
                Number num = (Number)valueObj;
                defaultMap.put(key, Float.valueOf(num.floatValue()));
                continue;
            }
            if (valueObj instanceof Boolean) {
                defaultMap.put(key, Boolean.valueOf(valueObj.toString()));
                continue;
            }
            LOG.error("Only Map<String, Number> type is supported when defining Map typed default value. The value type is not supported: " + valueObj);
            return Optional.empty();
        }
        return Optional.of(defaultMap);
    }

    private Double normalizeNumber(Object defaultValue) {
        Number num = (Number)defaultValue;
        return num.doubleValue();
    }
}

