/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.featurizeddataset;

import com.linkedin.feathr.common.featurizeddataset.BaseDenseTensorIterator;
import com.linkedin.feathr.common.featurizeddataset.DenseTensorList;
import com.linkedin.feathr.common.tensor.DenseTensor;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorIterator;
import java.util.List;
import scala.collection.Seq;

class FDSDenseTensorWrapper
extends DenseTensor {
    private final Representable[] _columnTypes;
    private final int _rank;
    private final boolean _regular;
    private final Seq<?> _featureValue;
    private transient Integer _count;
    private transient long[] _shape;

    FDSDenseTensorWrapper(Representable[] columnTypes, boolean regular, Seq<Object> featureValue) {
        this._columnTypes = columnTypes;
        this._rank = columnTypes.length - 1;
        this._regular = regular;
        this._featureValue = featureValue;
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public int estimatedCardinality() {
        return this.cardinality();
    }

    @Override
    public int cardinality() {
        if (this._count == null) {
            int count;
            if (this._regular) {
                Seq<?> array;
                count = 1;
                Object value = this._featureValue;
                while (value instanceof Seq && (count *= (array = value).size()) != 0) {
                    value = array.apply(0);
                }
            } else {
                count = 0;
                TensorIterator iterator = this.iterator();
                iterator.start();
                while (iterator.isValid()) {
                    ++count;
                    iterator.next();
                }
            }
            this._count = count;
        }
        return this._count;
    }

    @Override
    public TensorIterator iterator() {
        return new FDSTensorIterator();
    }

    @Override
    public long[] getShape() {
        if (this._shape != null) {
            return this._shape;
        }
        if (this._regular) {
            long[] shape = new long[this._columnTypes.length - 1];
            Object value = this._featureValue;
            for (int i = 0; i < shape.length; ++i) {
                Seq<?> array = value;
                shape[i] = array.size();
                value = array.apply(0);
            }
            this._shape = shape;
            return shape;
        }
        throw new UnsupportedOperationException("getShape is not supported on RAGGED tensors.");
    }

    @Override
    public List<?> asList() {
        return new DenseTensorList(this);
    }

    private class FDSTensorIterator
    extends BaseDenseTensorIterator {
        private final Seq<?>[] _cachedArrays;

        FDSTensorIterator() {
            super(FDSDenseTensorWrapper.this._rank);
            this._cachedArrays = new Seq[FDSDenseTensorWrapper.this._rank];
            this.start();
        }

        FDSTensorIterator(FDSTensorIterator original) {
            super(original);
            this._cachedArrays = original._cachedArrays;
        }

        @Override
        public TensorData getTensorData() {
            return FDSDenseTensorWrapper.this;
        }

        @Override
        protected boolean cache(int level, int childIndex) {
            if (childIndex >= this._cachedArrays[level - 1].size()) {
                return false;
            }
            if (level < FDSDenseTensorWrapper.this._rank) {
                this._cachedArrays[level] = (Seq)this._cachedArrays[level - 1].apply(childIndex);
            }
            return true;
        }

        @Override
        protected void cacheRoot() {
            this._cachedArrays[0] = FDSDenseTensorWrapper.this._featureValue;
        }

        @Override
        public TensorIterator getCopy() {
            return new FDSTensorIterator(this);
        }

        @Override
        public Object getValue(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                return this.getIndex(column);
            }
            return this._cachedArrays[FDSDenseTensorWrapper.this._rank - 1].apply(this.getIndex(FDSDenseTensorWrapper.this._rank - 1));
        }

        @Override
        public int getInt(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                return this.getIndex(column);
            }
            return (Integer)this.getValue(column);
        }

        @Override
        public long getLong(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                return this.getIndex(column);
            }
            return (Long)this.getValue(column);
        }

        @Override
        public float getFloat(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                throw new IllegalArgumentException("Dimensions of dense tensors cannot be accessed as a float, requested dimension: " + column);
            }
            return ((Float)this.getValue(column)).floatValue();
        }

        @Override
        public String getString(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                throw new IllegalArgumentException("Dimensions of dense tensors cannot be accessed as a String, requested dimension: " + column);
            }
            return (String)this.getValue(column);
        }

        @Override
        public double getDouble(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                throw new IllegalArgumentException("Dimensions of dense tensors cannot be accessed as a double, requested dimension: " + column);
            }
            return (Double)this.getValue(column);
        }

        @Override
        public boolean getBoolean(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                throw new IllegalArgumentException("Dimensions of dense tensors cannot be accessed as a boolean, requested dimension: " + column);
            }
            return (Boolean)this.getValue(column);
        }

        @Override
        public byte[] getBytes(int column) {
            if (column < FDSDenseTensorWrapper.this._rank) {
                throw new IllegalArgumentException("Dimensions of dense tensors cannot be accessed as a byte[], requested dimension: " + column);
            }
            return (byte[])this.getValue(column);
        }
    }
}

