/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.featurizeddataset;

import com.linkedin.feathr.common.featurizeddataset.FDSDenseTensorWrapper;
import com.linkedin.feathr.common.featurizeddataset.FDSSparseTensorWrapper;
import com.linkedin.feathr.common.featurizeddataset.FeatureDeserializer;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorCategory;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.tensor.scalar.ScalarTensor;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import scala.collection.Seq;

public final class SparkDeserializerFactory {
    private SparkDeserializerFactory() {
    }

    public static FeatureDeserializer getFeatureDeserializer(TensorType tensorType) {
        FeatureDeserializer converter;
        TensorCategory tensorCategory = tensorType.getTensorCategory();
        if (tensorCategory == TensorCategory.DENSE) {
            converter = tensorType.getDimensionTypes().isEmpty() ? new ScalarDeserializer() : new DenseDeserializer(tensorType.getColumnTypes(), tensorCategory == TensorCategory.DENSE);
        } else if (tensorCategory == TensorCategory.SPARSE) {
            converter = new SparseDeserializer(tensorType.getColumnTypes());
        } else {
            throw new IllegalArgumentException("Unsupported tensor category " + (Object)((Object)tensorCategory));
        }
        return converter;
    }

    private static class SparseDeserializer
    implements FeatureDeserializer {
        private final Representable[] _columnTypes;

        SparseDeserializer(Representable[] columnTypes) {
            this._columnTypes = columnTypes;
        }

        @Override
        public TensorData deserialize(Object featureValue) {
            if (featureValue == null) {
                return null;
            }
            return new FDSSparseTensorWrapper(this._columnTypes, (GenericRowWithSchema)featureValue);
        }
    }

    private static class DenseDeserializer
    implements FeatureDeserializer {
        private final Representable[] _columnTypes;
        private final boolean _regular;

        DenseDeserializer(Representable[] columnTypes, boolean regular) {
            this._columnTypes = columnTypes;
            this._regular = regular;
        }

        @Override
        public TensorData deserialize(Object featureValue) {
            if (featureValue == null) {
                return null;
            }
            return new FDSDenseTensorWrapper(this._columnTypes, this._regular, (Seq<Object>)((Seq)featureValue));
        }
    }

    private static class ScalarDeserializer
    implements FeatureDeserializer {
        private ScalarDeserializer() {
        }

        @Override
        public TensorData deserialize(Object featureValue) {
            if (featureValue == null) {
                return null;
            }
            return ScalarTensor.wrap(featureValue);
        }
    }
}

