/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.dense.ByteBufferDenseTensor;
import com.linkedin.feathr.common.tensorbuilder.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DenseBytesTensor
extends ByteBufferDenseTensor {
    private final int _endOfOffsets;

    public DenseBytesTensor(ByteBuffer byteBuffer, long[] shape) {
        super(byteBuffer, shape, Primitive.BYTES, 8);
        this._endOfOffsets = this._cardinality * 8;
    }

    public DenseBytesTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality) {
        super(byteBuffer, shape, types, cardinality, 8);
        this._endOfOffsets = this._cardinality * 8;
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    @Override
    public List<?> asList() {
        ByteBuffer view = this._byteBuffer.asReadOnlyBuffer();
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(this._cardinality);
        for (int i = 0; i < this._cardinality; ++i) {
            int offset = (int)view.getLong(i * 8);
            view.position(offset);
            int length = BufferUtils.decodeVarint(view);
            view.limit(view.position() + length);
            ByteBuffer slice = view.slice();
            view.limit(this._byteBuffer.limit());
            list.add(slice);
        }
        return list;
    }

    private class MyIterator
    extends ByteBufferDenseTensor.ByteBufferDenseTensorIterator {
        MyIterator() {
            super(DenseBytesTensor.this);
        }

        MyIterator(ByteBufferDenseTensor.ByteBufferDenseTensorIterator other) {
            super(DenseBytesTensor.this, other);
        }

        @Override
        public boolean isValid() {
            return this._position < DenseBytesTensor.this._endOfOffsets;
        }

        @Override
        public Object getValue() {
            return this.getBytes(this._indices.length);
        }

        @Override
        public byte[] getBytes(int index) {
            ByteBuffer view = DenseBytesTensor.this._byteBuffer.asReadOnlyBuffer();
            int offset = (int)DenseBytesTensor.this._byteBuffer.getLong(this._position);
            view.position(offset);
            int length = BufferUtils.decodeVarint(view);
            view.limit(view.position() + length);
            byte[] array = new byte[view.remaining()];
            view.get(array);
            return array;
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator((ByteBufferDenseTensor.ByteBufferDenseTensorIterator)this);
        }
    }
}

