/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.google.common.primitives.Doubles;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.dense.ByteBufferDenseTensor;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.List;

public class DenseDoubleTensor
extends ByteBufferDenseTensor {
    public DenseDoubleTensor(ByteBuffer byteBuffer, long[] shape) {
        super(byteBuffer, shape, Primitive.DOUBLE, 8);
    }

    public DenseDoubleTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality) {
        super(byteBuffer, shape, types, cardinality, 8);
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    @Override
    public List<?> asList() {
        DoubleBuffer doubleBuffer = this._byteBuffer.asDoubleBuffer();
        double[] doubleArray = new double[doubleBuffer.remaining()];
        doubleBuffer.get(doubleArray);
        return Doubles.asList((double[])doubleArray);
    }

    private class MyIterator
    extends ByteBufferDenseTensor.ByteBufferDenseTensorIterator {
        MyIterator() {
            super(DenseDoubleTensor.this);
        }

        MyIterator(ByteBufferDenseTensor.ByteBufferDenseTensorIterator other) {
            super(DenseDoubleTensor.this, other);
        }

        @Override
        public Object getValue() {
            return this.getDouble(this._indices.length);
        }

        @Override
        public double getDouble(int index) {
            return DenseDoubleTensor.this._byteBuffer.getDouble(this._position);
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator((ByteBufferDenseTensor.ByteBufferDenseTensorIterator)this);
        }
    }
}

