/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.google.common.primitives.Floats;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.dense.ByteBufferDenseTensor;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.List;

public class DenseFloatTensor
extends ByteBufferDenseTensor {
    public DenseFloatTensor(ByteBuffer byteBuffer, long[] shape) {
        super(byteBuffer, shape, Primitive.FLOAT, 4);
    }

    public DenseFloatTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality) {
        super(byteBuffer, shape, types, cardinality, 4);
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    @Override
    public List<?> asList() {
        FloatBuffer floatBuffer = this._byteBuffer.asFloatBuffer();
        float[] floatArray = new float[floatBuffer.remaining()];
        floatBuffer.get(floatArray);
        return Floats.asList((float[])floatArray);
    }

    private class MyIterator
    extends ByteBufferDenseTensor.ByteBufferDenseTensorIterator {
        MyIterator() {
            super(DenseFloatTensor.this);
        }

        MyIterator(ByteBufferDenseTensor.ByteBufferDenseTensorIterator other) {
            super(DenseFloatTensor.this, other);
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.getFloat(this._indices.length));
        }

        @Override
        public float getFloat(int index) {
            return DenseFloatTensor.this._byteBuffer.getFloat(this._position);
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator((ByteBufferDenseTensor.ByteBufferDenseTensorIterator)this);
        }
    }
}

