/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.dense;

import com.google.common.primitives.Ints;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.dense.ByteBufferDenseTensor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;

public class DenseIntTensor
extends ByteBufferDenseTensor {
    public DenseIntTensor(ByteBuffer byteBuffer, long[] shape) {
        super(byteBuffer, shape, Primitive.INT, 4);
    }

    public DenseIntTensor(ByteBuffer byteBuffer, long[] shape, Representable[] types, int cardinality) {
        super(byteBuffer, shape, types, cardinality, 4);
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator();
    }

    @Override
    public List<?> asList() {
        IntBuffer intBuffer = this._byteBuffer.asIntBuffer();
        int[] intArray = new int[intBuffer.remaining()];
        intBuffer.get(intArray);
        return Ints.asList((int[])intArray);
    }

    private class MyIterator
    extends ByteBufferDenseTensor.ByteBufferDenseTensorIterator {
        MyIterator() {
        }

        MyIterator(ByteBufferDenseTensor.ByteBufferDenseTensorIterator other) {
            super(other);
        }

        @Override
        public Object getValue() {
            return this.getInt(this._indices.length);
        }

        @Override
        public int getInt(int index) {
            if (index >= 0 && index < this._indices.length) {
                return this._indices[index];
            }
            if (index == this._indices.length) {
                return DenseIntTensor.this._byteBuffer.getInt(this._position);
            }
            throw new IndexOutOfBoundsException("The index " + index + " is out of the expected range 0 <= index <= " + this._indices.length + ".");
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator((ByteBufferDenseTensor.ByteBufferDenseTensorIterator)this);
        }
    }
}

