/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensor.scalar;

import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorIterator;
import com.linkedin.feathr.common.tensor.scalar.ScalarTensor;

public class ScalarFloatTensor
extends ScalarTensor {
    private static final Representable[] TYPES = new Representable[]{Primitive.FLOAT};
    private final float _value;

    public ScalarFloatTensor(float value) {
        this._value = value;
    }

    @Override
    public Representable[] getTypes() {
        return TYPES;
    }

    @Override
    public TensorIterator iterator() {
        return new MyIterator(0);
    }

    private final class MyIterator
    extends ScalarTensor.BaseIterator {
        private MyIterator(int i) {
            super(ScalarFloatTensor.this, i);
        }

        @Override
        public Object getValue(int column) {
            return Float.valueOf(this.getFloat(column));
        }

        @Override
        public float getFloat(int column) {
            this.checkColumn(column);
            return ScalarFloatTensor.this._value;
        }

        @Override
        public TensorIterator getCopy() {
            return new MyIterator(this._i);
        }
    }
}

