/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensorbuilder;

import com.linkedin.feathr.common.TensorUtils;
import com.linkedin.feathr.common.tensor.Primitive;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.SimpleWriteableTuple;
import com.linkedin.feathr.common.tensor.TensorCategory;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.common.tensor.dense.DenseBooleanTensor;
import com.linkedin.feathr.common.tensor.dense.DenseBytesTensor;
import com.linkedin.feathr.common.tensor.dense.DenseDoubleTensor;
import com.linkedin.feathr.common.tensor.dense.DenseFloatTensor;
import com.linkedin.feathr.common.tensor.dense.DenseIntTensor;
import com.linkedin.feathr.common.tensor.dense.DenseLongTensor;
import com.linkedin.feathr.common.tensor.dense.DenseStringTensor;
import com.linkedin.feathr.common.tensorbuilder.BufferUtils;
import com.linkedin.feathr.common.tensorbuilder.BulkTensorBuilder;
import com.linkedin.feathr.common.tensorbuilder.TensorBuilder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class DenseTensorBuilder
implements TensorBuilder,
BulkTensorBuilder {
    private final long[] _shape;
    private final Primitive _valueType;
    private final Representable[] _columnTypes;
    private final int _valColumn;
    private final int _staticCardinality;
    private final SimpleWriteableTuple _simpleWriteableTuple;
    private Object[] _buffer;
    private int _dynamicCardinality;
    private final int _indexOfUnknown;

    public DenseTensorBuilder(Representable[] columnTypes, long[] shape) {
        int indexOfUnknown = -1;
        for (int i = 0; i < columnTypes.length - 1; ++i) {
            if (shape[i] == -1L) {
                if (indexOfUnknown >= 0) {
                    throw new IllegalArgumentException("DenseTensor can only have at most one unbounded dimension.");
                }
                indexOfUnknown = i;
            }
            if (columnTypes[i].getRepresentation() == Primitive.INT) continue;
            throw new IllegalArgumentException("DenseTensor can only have INT dimensions.");
        }
        this._indexOfUnknown = indexOfUnknown;
        this._valueType = columnTypes[columnTypes.length - 1].getRepresentation();
        this._columnTypes = columnTypes;
        long cardinality = 1L;
        this._shape = shape;
        this._valColumn = shape.length;
        for (int i = 0; i < this._shape.length; ++i) {
            if (i == this._indexOfUnknown) continue;
            long n = this._shape[i];
            cardinality *= n;
        }
        this._staticCardinality = (int)cardinality;
        this._simpleWriteableTuple = new SimpleWriteableTuple(columnTypes);
    }

    public DenseTensorBuilder(TensorType tensorType) {
        this(tensorType.getColumnTypes(), TensorUtils.getShape(tensorType));
        if (tensorType.getTensorCategory() != TensorCategory.DENSE) {
            throw new IllegalArgumentException("Not a DENSE TensorType: " + tensorType);
        }
    }

    @Override
    public int getStaticCardinality() {
        return this._staticCardinality;
    }

    @Override
    public boolean hasVariableCardinality() {
        return this._indexOfUnknown > -1;
    }

    public TensorBuilder append() {
        int index = 0;
        for (int i = 0; i < this._valColumn; ++i) {
            index = index * (int)this._shape[i] + this._simpleWriteableTuple.getInt(i);
        }
        this._buffer[index] = this._columnTypes[this._valColumn].getRepresentation().toObject(this._simpleWriteableTuple, this._valColumn);
        this._simpleWriteableTuple.resetColumns();
        return this;
    }

    public TensorBuilder start(int estimatedRows) {
        if (this._indexOfUnknown != -1) {
            throw new IllegalStateException("Tensors with statically unknown dimensions can only be built by using build(*[]).");
        }
        this._dynamicCardinality = 1;
        this._buffer = new Object[this._staticCardinality];
        return this;
    }

    @Override
    public Representable[] getOutputTypes() {
        return this._columnTypes;
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public TensorBuilder setInt(int column, int value) {
        if (column < this._valColumn && (long)value >= this._shape[column]) {
            throw new IllegalArgumentException(String.format("Cannot have column value %d larger than shape value %d", value, this._shape[column]));
        }
        this._simpleWriteableTuple.setInt(column, value);
        return this;
    }

    @Override
    public TensorBuilder setLong(int column, long value) {
        if (column != this._valColumn) {
            throw new IllegalArgumentException(String.format("Cannot write long value in column %d", column));
        }
        this._simpleWriteableTuple.setLong(column, value);
        return this;
    }

    @Override
    public TensorBuilder setFloat(int column, float value) {
        if (column != this._valColumn) {
            throw new IllegalArgumentException(String.format("Cannot write float value in column %d", column));
        }
        this._simpleWriteableTuple.setFloat(column, value);
        return this;
    }

    @Override
    public TensorBuilder setDouble(int column, double value) {
        if (column != this._valColumn) {
            throw new IllegalArgumentException(String.format("Cannot write double value in column %d", column));
        }
        this._simpleWriteableTuple.setDouble(column, value);
        return this;
    }

    @Override
    public TensorBuilder setBoolean(int column, boolean value) {
        if (column != this._valColumn) {
            throw new IllegalArgumentException(String.format("Cannot write boolean value in column %d", column));
        }
        this._simpleWriteableTuple.setBoolean(column, value);
        return this;
    }

    @Override
    public TensorBuilder setString(int column, String value) {
        if (column != this._valColumn) {
            throw new IllegalArgumentException(String.format("Cannot write boolean value in column %d", column));
        }
        this._simpleWriteableTuple.setString(column, value);
        return this;
    }

    @Override
    public TensorBuilder setBytes(int column, byte[] value) {
        if (column != this._valColumn) {
            throw new IllegalArgumentException(String.format("Cannot write bytes value in column %d", column));
        }
        this._simpleWriteableTuple.setBytes(column, value);
        return this;
    }

    @Override
    public TensorData build(float[] floats) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(floats, this._valueType);
        return this.build(floats.length, byteBuffer);
    }

    @Override
    public TensorData build(int[] ints) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(ints, this._valueType);
        return this.build(ints.length, byteBuffer);
    }

    @Override
    public TensorData build(long[] longs) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(longs, this._valueType);
        return this.build(longs.length, byteBuffer);
    }

    @Override
    public TensorData build(double[] doubles) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(doubles, this._valueType);
        return this.build(doubles.length, byteBuffer);
    }

    @Override
    public TensorData build(boolean[] booleans) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(booleans, this._valueType);
        return this.build(booleans.length, byteBuffer);
    }

    @Override
    public TensorData build(List<?> values) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(values, this._valueType);
        return this.build(values.size(), byteBuffer);
    }

    @Override
    public TensorData build(ByteBuffer values) {
        if (this._indexOfUnknown != -1) {
            throw new IllegalStateException("Tensors with statically unknown dimensions can only be built by using build(*[]).");
        }
        this._dynamicCardinality = 1;
        return this.buildFromShape(this._shape, values);
    }

    private TensorData build(int cardinality, ByteBuffer byteBuffer) {
        long[] shape;
        if (this._indexOfUnknown == -1) {
            this._dynamicCardinality = 1;
            shape = this._shape;
        } else {
            shape = new long[this._shape.length];
            for (int i = 0; i < shape.length; ++i) {
                if (i != this._indexOfUnknown) {
                    shape[i] = this._shape[i];
                    continue;
                }
                this._dynamicCardinality = cardinality / this._staticCardinality;
                shape[i] = this._dynamicCardinality;
            }
        }
        return this.buildFromShape(shape, byteBuffer);
    }

    @Override
    public TensorData build(boolean sort) {
        if (this._indexOfUnknown != -1) {
            throw new IllegalStateException("Tensors with statically unknown dimensions can only be built by using build(*[]).");
        }
        this._dynamicCardinality = 1;
        Object defaultVal = this.generateDefaultValue();
        for (int i = 0; i < this._buffer.length; ++i) {
            if (this._buffer[i] != null) continue;
            this._buffer[i] = defaultVal;
        }
        return this.build(Arrays.asList(this._buffer));
    }

    private TensorData buildFromShape(long[] shape, ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        int cardinality = this._staticCardinality * this._dynamicCardinality;
        switch (this._valueType) {
            case INT: {
                return new DenseIntTensor(byteBuffer, shape, this._columnTypes, cardinality);
            }
            case DOUBLE: {
                return new DenseDoubleTensor(byteBuffer, shape, this._columnTypes, cardinality);
            }
            case LONG: {
                return new DenseLongTensor(byteBuffer, shape, this._columnTypes, cardinality);
            }
            case FLOAT: {
                return new DenseFloatTensor(byteBuffer, shape, this._columnTypes, cardinality);
            }
            case STRING: {
                return new DenseStringTensor(byteBuffer, shape, this._columnTypes, cardinality);
            }
            case BOOLEAN: {
                return new DenseBooleanTensor(byteBuffer, shape, this._columnTypes, cardinality);
            }
            case BYTES: {
                return new DenseBytesTensor(byteBuffer, shape, this._columnTypes, cardinality);
            }
        }
        throw new IllegalArgumentException("Cannot support dense tensor with value type: " + this._valueType);
    }

    private Object generateDefaultValue() {
        switch (this._columnTypes[this._valColumn].getRepresentation()) {
            case INT: {
                return 0;
            }
            case LONG: {
                return 0L;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case STRING: {
                return "";
            }
            case BOOLEAN: {
                return false;
            }
            case BYTES: {
                return new byte[0];
            }
        }
        throw new IllegalArgumentException("Cannot handle value of type: " + this._columnTypes[this._valColumn].getRepresentation());
    }
}

