/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.tensorbuilder;

import com.linkedin.feathr.common.ColumnUtils;
import com.linkedin.feathr.common.TensorUtils;
import com.linkedin.feathr.common.tensor.Representable;
import com.linkedin.feathr.common.tensor.TensorData;
import com.linkedin.feathr.common.tensorbuilder.TensorBuilder;
import com.linkedin.feathr.common.tensorbuilder.UniversalTensor;
import java.util.Arrays;

public final class UniversalTensorBuilder
extends ColumnUtils
implements TensorBuilder<UniversalTensorBuilder> {
    private static final int GROWTH_FACTOR = 2;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private static final Object[] EMPTY_BYTES_ARRAY = new Object[0];
    private final int _valueArity;
    private int[] _intArray = EMPTY_INT_ARRAY;
    private long[] _longArray = EMPTY_LONG_ARRAY;
    private String[] _stringArray = EMPTY_STRING_ARRAY;
    private float[] _floatArray = EMPTY_FLOAT_ARRAY;
    private double[] _doubleArray = EMPTY_DOUBLE_ARRAY;
    private boolean[] _booleanArray = EMPTY_BOOLEAN_ARRAY;
    private Object[] _bytesArray = EMPTY_BYTES_ARRAY;
    private int _intPosition;
    private int _longPosition;
    private int _stringPosition;
    private int _floatPosition;
    private int _doublePosition;
    private int _booleanPosition;
    private int _bytesPosition;

    public UniversalTensorBuilder(Representable ... columnTypes) {
        super(columnTypes);
        this._valueArity = 1;
    }

    public UniversalTensorBuilder(int valueArity, Representable ... columnTypes) {
        super(columnTypes);
        this._valueArity = valueArity;
    }

    @Override
    public UniversalTensorBuilder start(int estimatedRows) {
        if (this._intArity != 0) {
            this._intArray = new int[estimatedRows * this._intArity];
            this._intPosition = 0;
        }
        if (this._longArity != 0) {
            this._longArray = new long[estimatedRows * this._longArity];
            this._longPosition = 0;
        }
        if (this._stringArity != 0) {
            this._stringArray = new String[estimatedRows * this._stringArity];
            this._stringPosition = 0;
        }
        if (this._floatArity != 0) {
            this._floatArray = new float[estimatedRows * this._floatArity];
            this._floatPosition = 0;
        }
        if (this._doubleArity != 0) {
            this._doubleArray = new double[estimatedRows * this._doubleArity];
            this._doublePosition = 0;
        }
        if (this._booleanArity != 0) {
            this._booleanArray = new boolean[estimatedRows * this._booleanArity];
            this._booleanPosition = 0;
        }
        if (this._bytesArity != 0) {
            this._bytesArray = new Object[estimatedRows * this._bytesArity];
            this._bytesPosition = 0;
        }
        return this;
    }

    @Override
    public UniversalTensorBuilder setInt(int index, int value) {
        int intIndex = this._intPosition + this._columnIndex[index];
        if (intIndex >= this._intArray.length) {
            this._intArray = Arrays.copyOf(this._intArray, UniversalTensorBuilder.getNewLength(intIndex, this._intArray.length));
        }
        this._intArray[intIndex] = value;
        return this;
    }

    @Override
    public UniversalTensorBuilder setLong(int index, long value) {
        int longIndex = this._longPosition + this._columnIndex[index];
        if (longIndex >= this._longArray.length) {
            this._longArray = Arrays.copyOf(this._longArray, UniversalTensorBuilder.getNewLength(longIndex, this._longArray.length));
        }
        this._longArray[longIndex] = value;
        return this;
    }

    @Override
    public UniversalTensorBuilder setString(int index, String value) {
        int stringIndex = this._stringPosition + this._columnIndex[index];
        if (stringIndex >= this._stringArray.length) {
            this._stringArray = Arrays.copyOf(this._stringArray, UniversalTensorBuilder.getNewLength(stringIndex, this._stringArray.length));
        }
        this._stringArray[stringIndex] = value;
        return this;
    }

    @Override
    public UniversalTensorBuilder setFloat(int index, float value) {
        int floatIndex = this._floatPosition + this._columnIndex[index];
        if (floatIndex >= this._floatArray.length) {
            this._floatArray = Arrays.copyOf(this._floatArray, UniversalTensorBuilder.getNewLength(floatIndex, this._floatArray.length));
        }
        this._floatArray[floatIndex] = value;
        return this;
    }

    @Override
    public UniversalTensorBuilder setDouble(int index, double value) {
        int doubleIndex = this._doublePosition + this._columnIndex[index];
        if (doubleIndex >= this._doubleArray.length) {
            this._doubleArray = Arrays.copyOf(this._doubleArray, UniversalTensorBuilder.getNewLength(doubleIndex, this._doubleArray.length));
        }
        this._doubleArray[doubleIndex] = value;
        return this;
    }

    @Override
    public UniversalTensorBuilder setBoolean(int index, boolean value) {
        int booleanIndex = this._booleanPosition + this._columnIndex[index];
        if (booleanIndex >= this._booleanArray.length) {
            this._booleanArray = Arrays.copyOf(this._booleanArray, UniversalTensorBuilder.getNewLength(booleanIndex, this._booleanArray.length));
        }
        this._booleanArray[booleanIndex] = value;
        return this;
    }

    @Override
    public UniversalTensorBuilder setBytes(int index, byte[] value) {
        int bytesIndex = this._bytesPosition + this._columnIndex[index];
        if (bytesIndex >= this._bytesArray.length) {
            this._bytesArray = Arrays.copyOf(this._bytesArray, UniversalTensorBuilder.getNewLength(bytesIndex, this._bytesArray.length));
        }
        this._bytesArray[bytesIndex] = value;
        return this;
    }

    @Override
    public UniversalTensorBuilder append() {
        this._intPosition += this._intArity;
        this._longPosition += this._longArity;
        this._floatPosition += this._floatArity;
        this._stringPosition += this._stringArity;
        this._doublePosition += this._doubleArity;
        this._booleanPosition += this._booleanArity;
        this._bytesPosition += this._bytesArity;
        return this;
    }

    @Override
    public Representable[] getTypes() {
        return this._columnTypes;
    }

    @Override
    public TensorData build(boolean sort) {
        return new UniversalTensor(this._intArity, this._longArity, this._stringArity, this._floatArity, this._doubleArity, this._booleanArity, this._bytesArity, this._valueArity, this._intArray, this._longArray, this._stringArray, this._floatArray, this._doubleArray, this._booleanArray, this._bytesArray, this._columnTypes, TensorUtils.safeRatio(this._floatPosition + this._doublePosition + this._intPosition + this._longPosition + this._stringPosition + this._booleanPosition + this._bytesPosition, this._floatArity + this._doubleArity + this._intArity + this._longArity + this._stringArity + this._booleanArity + this._bytesArity), sort, this._columnIndex);
    }

    @Override
    public Representable[] getOutputTypes() {
        return this._columnTypes;
    }

    private static int getNewLength(int index, int curLen) {
        int estNewLen = 2 * curLen;
        return index >= estNewLen ? index + 1 : estNewLen;
    }
}

