/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.common.value;

import com.google.common.primitives.Floats;
import com.linkedin.feathr.common.types.DenseVectorFeatureType;
import com.linkedin.feathr.common.types.FeatureType;
import com.linkedin.feathr.common.value.FeatureValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class DenseVectorFeatureValue
implements FeatureValue {
    private static final FeatureType TYPE = DenseVectorFeatureType.withUnknownSize();
    private final float[] _floatArray;

    private DenseVectorFeatureValue(float[] floatArray) {
        this._floatArray = Objects.requireNonNull(floatArray);
    }

    private DenseVectorFeatureValue(Collection<? extends Number> numbers) {
        Objects.requireNonNull(numbers);
        this._floatArray = Floats.toArray(numbers);
    }

    public static DenseVectorFeatureValue fromFloatArray(float[] floatArray) {
        return new DenseVectorFeatureValue(floatArray);
    }

    public static DenseVectorFeatureValue fromNumberList(Collection<? extends Number> numbers) {
        return new DenseVectorFeatureValue(numbers);
    }

    public float[] getFloatArray() {
        return this._floatArray;
    }

    @Override
    public FeatureType getFeatureType() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseVectorFeatureValue that = (DenseVectorFeatureValue)o;
        return Arrays.equals(this._floatArray, that._floatArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this._floatArray);
    }

    public String toString() {
        return "DenseVectorFeatureValue{_floatArray=" + Arrays.toString(this._floatArray) + '}';
    }
}

