/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.client;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureInfo;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.common.exception.FeathrException;
import com.linkedin.feathr.common.exception.FeathrInputDataException;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.client.FeathrClient$;
import com.linkedin.feathr.offline.config.ConflictsAutoCorrectionSetting;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.FeathrConfigLoader$;
import com.linkedin.feathr.offline.config.FeatureGroupsGenerator$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater;
import com.linkedin.feathr.offline.config.sources.FeatureGroupsUpdater$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.generation.DataFrameFeatureGenerator;
import com.linkedin.feathr.offline.generation.FeatureGenKeyTagAnalyzer$;
import com.linkedin.feathr.offline.generation.StreamingFeatureGenerator;
import com.linkedin.feathr.offline.job.FeatureGenSpec;
import com.linkedin.feathr.offline.job.JoinJobContext;
import com.linkedin.feathr.offline.job.JoinJobContext$;
import com.linkedin.feathr.offline.join.DataFrameFeatureJoiner;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.logical.LogicalPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlan;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlanner$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.swa.SWAHandler;
import com.linkedin.feathr.offline.util.AclCheckUtils$;
import com.linkedin.feathr.offline.util.AnchorUtils$;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata;
import com.linkedin.feathr.offline.util.FeaturizedDatasetMetadata$;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import com.linkedin.feathr.sparkcommon.OutputProcessor;
import java.io.Serializable;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rmh\u0001B,Y\u0001\rD\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\to\u0002\u0011\t\u0011)A\u0005q\"Aa\u0010\u0001B\u0001B\u0003%q\u0010\u0003\u0006\u0002\u0006\u0001\u0011\t\u0011)A\u0005\u0003\u000fA!\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t\t\u0005\u0001B\u0001B\u0003%\u00111\t\u0005\u000b\u00033\u0002!\u0011!Q\u0001\n\u0005m\u0003\u0002CA5\u0001\u0011\u0005!,a\u001b\t\u0013\u0005}\u0004A1A\u0005\n\u0005\u0005\u0005\u0002CAJ\u0001\u0001\u0006I!a!\u0006\r\u0005U\u0005\u0001AAL\u0011)\ti\u000b\u0001b\u0001\n\u0003Q\u0016q\u0016\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u00022\"Q\u0011\u0011\u001a\u0001C\u0002\u0013\u0005!,a3\t\u0011\u0005m\u0007\u0001)A\u0005\u0003\u001bD!\"!8\u0001\u0005\u0004%\tAWAX\u0011!\ty\u000e\u0001Q\u0001\n\u0005E\u0006BCAq\u0001\t\u0007I\u0011\u0001.\u00020\"A\u00111\u001d\u0001!\u0002\u0013\t\t\f\u0003\u0006\u0002f\u0002\u0011\r\u0011\"\u0001[\u0003\u0017D\u0001\"a:\u0001A\u0003%\u0011Q\u001a\u0005\b\u0003S\u0004A\u0011AAv\u0011%\u00119\u0003AI\u0001\n\u0003\u0011I\u0003C\u0004\u0003@\u0001!\tA!\u0011\t\u000f\t]\u0003\u0001\"\u0003\u0003Z!9!1\r\u0001\u0005\n\t\u0015\u0004\u0002\u0003B7\u0001\u0011\u0005!La\u001c\t\u0011\t\u001d\u0005\u0001\"\u0001[\u0005\u0013CqA!/\u0001\t\u0013\u0011Y\f\u0003\u0005\u0003F\u0002!\tA\u0017Bd\u0011!\u0011I\u000e\u0001C\u00015\nm\u0007B\u0003By\u0001E\u0005I\u0011\u0001.\u0003t\"A!q\u001f\u0001\u0005\u0002i\u0013I\u0010\u0003\u0005\u0003|\u0002!\tA\u0017B\u007f\u0011\u001d\u0011y\u0010\u0001C\u0005\u0007\u0003Aqa!\u0004\u0001\t\u0013\u0019yaB\u0004\u0004\u0018aC\ta!\u0007\u0007\r]C\u0006\u0012AB\u000e\u0011\u001d\tIG\nC\u0001\u0007;Aqaa\b'\t\u0003\u0019\tC\u0002\u0004\u0004(\u0019\u00021\u0011\u0006\u0005\tU&\u0012\t\u0011)A\u0005W\"A\u0011\u0011N\u0015\u0005\u0002\u0019\u001aY\u0003C\u0005\u00040%\u0012\r\u0011\"\u0003\u00042!A1\u0011H\u0015!\u0002\u0013\u0019\u0019\u0004C\u0005\u0004<%\u0002\r\u0011\"\u0003\u0004>!I1qH\u0015A\u0002\u0013%1\u0011\t\u0005\t\u0007\u000fJ\u0003\u0015)\u0003\u0004\u0012!I1\u0011J\u0015A\u0002\u0013%1Q\b\u0005\n\u0007\u0017J\u0003\u0019!C\u0005\u0007\u001bB\u0001b!\u0015*A\u0003&1\u0011\u0003\u0005\n\u0007'J\u0003\u0019!C\u0005\u0007{A\u0011b!\u0016*\u0001\u0004%Iaa\u0016\t\u0011\rm\u0013\u0006)Q\u0005\u0007#A\u0011b!\u0018*\u0001\u0004%Ia!\u0010\t\u0013\r}\u0013\u00061A\u0005\n\r\u0005\u0004\u0002CB3S\u0001\u0006Ka!\u0005\t\u0013\r\u001d\u0014\u00061A\u0005\n\r%\u0004\"CB7S\u0001\u0007I\u0011BB8\u0011!\u0019\u0019(\u000bQ!\n\r-\u0004\"CA\fS\u0001\u0007I\u0011BB;\u0011%\u00199(\u000ba\u0001\n\u0013\u0019I\b\u0003\u0005\u0004~%\u0002\u000b\u0015BA\r\u0011%\t\t%\u000ba\u0001\n\u0013\u0019y\bC\u0005\u0004\u0002&\u0002\r\u0011\"\u0003\u0004\u0004\"A1qQ\u0015!B\u0013\t\u0019\u0005C\u0005\u0002Z%\u0002\r\u0011\"\u0003\u0004\n\"I11R\u0015A\u0002\u0013%1Q\u0012\u0005\t\u0007#K\u0003\u0015)\u0003\u0002\\!911S\u0015\u0005\u0002\rU\u0005bBBMS\u0011\u000511\u0014\u0005\b\u00073KC\u0011ABQ\u0011\u001d\u00199+\u000bC\u0001\u0007SCqaa**\t\u0003\u0019i\u000bC\u0004\u00044&\"\ta!.\t\u000f\rM\u0016\u0006\"\u0001\u0004:\"91QX\u0015\u0005\u0002\r}\u0006bBB_S\u0011\u000511\u0019\u0005\b\u0007\u000fLC\u0011ABe\u0011\u001d\u00199-\u000bC\u0001\u0007\u001bD\u0001b!5*\t\u0003Q61\u001b\u0005\t\u0007#LC\u0011\u0001.\u0004Z\"91Q\\\u0015\u0005\u0002\r}\u0007bBBsS\u0011\u00051q\u001d\u0005\b\u0007[LC\u0011ABx\u0011!\u0019\t0\u000bC\u00015\u000eM(\u0001\u0004$fCRD'o\u00117jK:$(BA-[\u0003\u0019\u0019G.[3oi*\u00111\fX\u0001\b_\u001a4G.\u001b8f\u0015\tif,\u0001\u0004gK\u0006$\bN\u001d\u0006\u0003?\u0002\f\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002C\u0006\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0002O\u0006)1oY1mC&\u0011\u0011N\u001a\u0002\u0007\u0003:L(+\u001a4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u00051,X\"A7\u000b\u00059|\u0017aA:rY*\u0011\u0001/]\u0001\u0006gB\f'o\u001b\u0006\u0003eN\fa!\u00199bG\",'\"\u0001;\u0002\u0007=\u0014x-\u0003\u0002w[\na1\u000b]1sWN+7o]5p]\u0006ia-Z1ukJ,wI]8vaN\u0004\"!\u001f?\u000e\u0003iT!a\u001f.\u0002\u000f1|w-[2bY&\u0011QP\u001f\u0002\u000e\r\u0016\fG/\u001e:f\u000fJ|W\u000f]:\u0002\u001d1|w-[2bYBc\u0017M\u001c8feB\u0019\u00110!\u0001\n\u0007\u0005\r!PA\u000bNk2$\u0018n\u0015;bO\u0016Tu.\u001b8QY\u0006tg.\u001a:\u0002)\u0019,\u0017\r^;sK\u001e\u0013x.\u001e9t+B$\u0017\r^3s!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tqa]8ve\u000e,7OC\u0002\u0002\u0012i\u000baaY8oM&<\u0017\u0002BA\u000b\u0003\u0017\u0011ACR3biV\u0014Xm\u0012:pkB\u001cX\u000b\u001d3bi\u0016\u0014\u0018\u0001\u00053bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:t!\u0019\tY\"a\u000b\u000229!\u0011QDA\u0014\u001d\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012E\u00061AH]8pizJ\u0011aZ\u0005\u0004\u0003S1\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003[\tyC\u0001\u0003MSN$(bAA\u0015MB!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001C1dG\u0016\u001c8o\u001c:\u000b\u0007\u0005m\",\u0001\u0004t_V\u00148-Z\u0005\u0005\u0003\u007f\t)DA\bECR\f\u0007+\u0019;i\u0011\u0006tG\r\\3s\u0003-ig/\u001a7D_:$X\r\u001f;\u0011\u000b\u0015\f)%!\u0013\n\u0007\u0005\u001dcM\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u001d\u0001H.^4j]NT1!a\u0015[\u0003\u0011ig/\u001a7\n\t\u0005]\u0013Q\n\u0002!\r\u0016\fG\u000f\u001b:FqB\u0014Xm]:j_:,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0006to\u0006D\u0015M\u001c3mKJ\u0004R!ZA#\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003GR\u0016aA:xC&!\u0011qMA1\u0005)\u0019v+\u0011%b]\u0012dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u00055\u0014\u0011OA:\u0003k\n9(!\u001f\u0002|\u0005u\u0004cAA8\u00015\t\u0001\fC\u0003k\u0011\u0001\u00071\u000eC\u0003x\u0011\u0001\u0007\u0001\u0010C\u0003\u007f\u0011\u0001\u0007q\u0010C\u0004\u0002\u0006!\u0001\r!a\u0002\t\u000f\u0005]\u0001\u00021\u0001\u0002\u001a!9\u0011\u0011\t\u0005A\u0002\u0005\r\u0003bBA-\u0011\u0001\u0007\u00111L\u0001\u0004Y><WCAAB!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bQ\u0001\\8hi)T1!!$r\u0003\u001dawnZ4j]\u001eLA!!%\u0002\b\n1Aj\\4hKJ\fA\u0001\\8hA\t\t2*Z=UC\u001e\u001cFO]5oOR+\b\u000f\\3\u0011\r\u0005m\u0011\u0011TAO\u0013\u0011\tY*a\f\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002 \u0006\u001df\u0002BAQ\u0003G\u00032!a\bg\u0013\r\t)KZ\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00161\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015f-A\nbY2\fen\u00195pe\u0016$g)Z1ukJ,7/\u0006\u0002\u00022BA\u0011qTAZ\u0003;\u000b9,\u0003\u0003\u00026\u0006-&aA'baB!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016a\u00024fCR,(/\u001a\u0006\u0004\u0003\u0003T\u0016\u0001C1oG\"|'/\u001a3\n\t\u0005\u0015\u00171\u0018\u0002\u0018\r\u0016\fG/\u001e:f\u0003:\u001c\u0007n\u001c:XSRD7k\\;sG\u0016\fA#\u00197m\u0003:\u001c\u0007n\u001c:fI\u001a+\u0017\r^;sKN\u0004\u0013AE1mY\u0012+'/\u001b<fI\u001a+\u0017\r^;sKN,\"!!4\u0011\u0011\u0005}\u00151WAO\u0003\u001f\u0004B!!5\u0002X6\u0011\u00111\u001b\u0006\u0004\u0003+T\u0016a\u00023fe&4X\rZ\u0005\u0005\u00033\f\u0019N\u0001\bEKJLg/\u001a3GK\u0006$XO]3\u0002'\u0005dG\u000eR3sSZ,GMR3biV\u0014Xm\u001d\u0011\u0002-\u0005dG\u000eU1tgRD'o\\;hQ\u001a+\u0017\r^;sKN\fq#\u00197m!\u0006\u001c8\u000f\u001e5s_V<\u0007NR3biV\u0014Xm\u001d\u0011\u0002)\u0005dGnV5oI><\u0018iZ4GK\u0006$XO]3t\u0003U\tG\u000e\\,j]\u0012|w/Q4h\r\u0016\fG/\u001e:fg\u0002\n!#\u00197m'\u0016\f(j\\5o\r\u0016\fG/\u001e:fg\u0006\u0019\u0012\r\u001c7TKFTu.\u001b8GK\u0006$XO]3tA\u0005a!n\\5o\r\u0016\fG/\u001e:fgRA\u0011Q^A}\u0005\u000b\u0011I\u0001\u0005\u0003\u0002p\u0006UXBAAy\u0015\r\t\u0019PW\u0001\u0005kRLG.\u0003\u0003\u0002x\u0006E(AF*qCJ\\g)Z1ukJL'0\u001a3ECR\f7/\u001a;\t\u000f\u0005mh\u00031\u0001\u0002~\u0006Q!n\\5o\u0007>tg-[4\u0011\t\u0005}(\u0011A\u0007\u0003\u0003\u001fIAAa\u0001\u0002\u0010\t\tb)Z1ukJ,'j\\5o\u0007>tg-[4\t\u000f\t\u001da\u00031\u0001\u0002n\u00069qNY:ECR\f\u0007\"\u0003B\u0006-A\u0005\t\u0019\u0001B\u0007\u0003)QwNY\"p]R,\u0007\u0010\u001e\t\u0005\u0005\u001f\u0011)\"\u0004\u0002\u0003\u0012)\u0019!1\u0003.\u0002\u0007)|'-\u0003\u0003\u0003\u0018\tE!A\u0004&pS:TuNY\"p]R,\u0007\u0010\u001e\u0015\u0004-\tm\u0001\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\u0007\t\u0005B,\u0001\u0004d_6lwN\\\u0005\u0005\u0005K\u0011yBA\u0006J]R,'O\\1m\u0003BL\u0017A\u00066pS:4U-\u0019;ve\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t-\"\u0006\u0002B\u0007\u0005[Y#Aa\f\u0011\t\tE\"1H\u0007\u0003\u0005gQAA!\u000e\u00038\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005s1\u0017AC1o]>$\u0018\r^5p]&!!Q\bB\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011O\u0016tWM]1uK\u001a+\u0017\r^;sKN$BAa\u0011\u0003LAA\u0011qTAZ\u0005\u000b\ni\u000f\u0005\u0003\u0003\u001e\t\u001d\u0013\u0002\u0002B%\u0005?\u0011\u0011\u0003V1hO\u0016$g)Z1ukJ,g*Y7f\u0011\u001d\u0011i\u0005\u0007a\u0001\u0005\u001f\naBZ3biV\u0014XmR3o'B,7\r\u0005\u0003\u0003\u0010\tE\u0013\u0002\u0002B*\u0005#\u0011aBR3biV\u0014XmR3o'B,7\rK\u0002\u0019\u00057\t1\"[:TiJ,\u0017-\\5oOR!!1\fB1!\r)'QL\u0005\u0004\u0005?2'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u001bJ\u0002\u0019\u0001B(\u0003E\u0001(/\u001a9be\u0016,\u00050Z2vi\u0016,eN\u001e\u000b\u0003\u0005O\u00022!\u001aB5\u0013\r\u0011YG\u001a\u0002\u0005+:LG/\u0001\u000bhKR\fE\u000e\u001c$fCR,(/Z*pkJ\u001cWm\u001d\u000b\u0005\u0005c\u0012Y\b\u0005\u0004\u0002\u001c\u0005-\"1\u000f\t\u0005\u0005k\u00129(\u0004\u0002\u0002:%!!\u0011PA\u001d\u0005)!\u0015\r^1T_V\u00148-\u001a\u0005\b\u0005{Z\u0002\u0019\u0001B@\u0003E\u0011X-];fgR,GMR3biV\u0014Xm\u001d\t\u0007\u00037\tIJ!!\u0011\t\tu!1Q\u0005\u0005\u0005\u000b\u0013yB\u0001\u000bK_&t\u0017N\\4GK\u0006$XO]3QCJ\fWn]\u0001\u0015I>Tu.\u001b8PEN\fe\u000e\u001a$fCR,(/Z:\u0015\u0011\t-%1\u0017B[\u0005o\u0003r!\u001aBG\u0005#\u0013i+C\u0002\u0003\u0010\u001a\u0014a\u0001V;qY\u0016\u0014\u0004\u0003\u0002BJ\u0005OsAA!&\u0003&:!!q\u0013BR\u001d\u0011\u0011IJ!)\u000f\t\tm%q\u0014\b\u0005\u0003?\u0011i*C\u0001u\u0013\t\u00118/\u0003\u0002qc&\u0011an\\\u0005\u0004\u0003Si\u0017\u0002\u0002BU\u0005W\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005%R\u000e\u0005\u0003\u0003\u001e\t=\u0016\u0002\u0002BY\u0005?\u0011a\u0001S3bI\u0016\u0014\bbBA~9\u0001\u0007\u0011Q \u0005\b\u0005\u0017a\u0002\u0019\u0001B\u0007\u0011\u001d\u00119\u0001\ba\u0001\u0005#\u000b\u0001DZ5oI\u000e{gN\u001a7jGR4U-\u0019;ve\u0016t\u0015-\\3t)\u0019\t9J!0\u0003B\"9!qX\u000fA\u0002\t}\u0014!E6fsR\u000bwmZ3e\r\u0016\fG/\u001e:fg\"9!1Y\u000fA\u0002\u0005]\u0015A\u00034jK2$g*Y7fg\u0006\u0011\"/\u001a8b[\u00164U-\u0019;ve\u0016t\u0015-\\3t))\u0011YI!3\u0003N\nE'Q\u001b\u0005\b\u0005\u0017t\u0002\u0019\u0001BI\u0003\t!g\rC\u0004\u0003Pz\u0001\rA!,\u0002\r!,\u0017\rZ3s\u0011\u001d\u0011\u0019N\ba\u0001\u0003/\u000bAcY8oM2L7\r\u001e$fCR,(/\u001a(b[\u0016\u001c\bb\u0002Bl=\u0001\u0007\u0011QT\u0001\u0007gV4g-\u001b=\u0002!)|\u0017N\u001c$fCR,(/Z:Bg\u00123EC\u0003BF\u0005;\u0014yN!9\u0003f\"9\u00111`\u0010A\u0002\u0005u\bb\u0002B`?\u0001\u0007!q\u0010\u0005\b\u0005G|\u0002\u0019\u0001BI\u0003\u0011aWM\u001a;\t\u0013\t\u001dx\u0004%AA\u0002\t%\u0018a\u0006:po\ncwn\\7GS2$XM\u001d+ie\u0016\u001c\bn\u001c7e!\u0015)\u0017Q\tBv!\r)'Q^\u0005\u0004\u0005_4'aA%oi\u0006Q\"n\\5o\r\u0016\fG/\u001e:fg\u0006\u001bHI\u0012\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u001f\u0016\u0005\u0005S\u0014i#\u0001\thKR4U-\u0019;ve\u0016<%o\\;qgR\t\u00010A\thKRdunZ5dC2\u0004F.\u00198oKJ$\u0012a`\u0001\u0016gR\u0014\u0018N\\4jMf4U-\u0019;ve\u0016t\u0015-\\3t)\u0011\tija\u0001\t\u000f\r\u00151\u00051\u0001\u0004\b\u00059a.Y7f'\u0016$\bCBAP\u0007\u0013\ti*\u0003\u0003\u0004\f\u0005-&aA*fi\u00061b-\u001b8e\u0013:4\u0018\r\\5e\r\u0016\fG/\u001e:f%\u001647\u000f\u0006\u0003\u0004\u0012\rM\u0001CBA\u000e\u0003W\ti\nC\u0004\u0004\u0016\u0011\u0002\rAa \u0002\u0011\u0019,\u0017\r^;sKN\fABR3bi\"\u00148\t\\5f]R\u00042!a\u001c''\t1C\r\u0006\u0002\u0004\u001a\u00059!-^5mI\u0016\u0014H\u0003BB\u0012\u0007s\u00042a!\n*\u001b\u00051#a\u0002\"vS2$WM]\n\u0003S\u0011$Baa\t\u0004.!)!n\u000ba\u0001W\u0006\u0011b-Z1uQJ\u001cuN\u001c4jO2{\u0017\rZ3s+\t\u0019\u0019\u0004\u0005\u0003\u0002\u0000\u000eU\u0012\u0002BB\u001c\u0003\u001f\u0011ABR3bi\"\u00148i\u001c8gS\u001e\f1CZ3bi\"\u00148i\u001c8gS\u001edu.\u00193fe\u0002\n!BZ3biV\u0014X\rR3g+\t\u0019\t\"\u0001\bgK\u0006$XO]3EK\u001a|F%Z9\u0015\t\t\u001d41\t\u0005\n\u0007\u000bz\u0013\u0011!a\u0001\u0007#\t1\u0001\u001f\u00132\u0003-1W-\u0019;ve\u0016$UM\u001a\u0011\u0002!1|7-\u00197Pm\u0016\u0014(/\u001b3f\t\u00164\u0017\u0001\u00067pG\u0006dwJ^3se&$W\rR3g?\u0012*\u0017\u000f\u0006\u0003\u0003h\r=\u0003\"CB#e\u0005\u0005\t\u0019AB\t\u0003EawnY1m\u001fZ,'O]5eK\u0012+g\rI\u0001\u000fM\u0016\fG/\u001e:f\t\u00164\u0007+\u0019;i\u0003I1W-\u0019;ve\u0016$UM\u001a)bi\"|F%Z9\u0015\t\t\u001d4\u0011\f\u0005\n\u0007\u000b*\u0014\u0011!a\u0001\u0007#\tqBZ3biV\u0014X\rR3g!\u0006$\b\u000eI\u0001\u0015Y>\u001c\u0017\r\\(wKJ\u0014\u0018\u000eZ3EK\u001a\u0004\u0016\r\u001e5\u000211|7-\u00197Pm\u0016\u0014(/\u001b3f\t\u00164\u0007+\u0019;i?\u0012*\u0017\u000f\u0006\u0003\u0003h\r\r\u0004\"CB#q\u0005\u0005\t\u0019AB\t\u0003UawnY1m\u001fZ,'O]5eK\u0012+g\rU1uQ\u0002\nqBZ3biV\u0014X\rR3g\u0007>tgm]\u000b\u0003\u0007W\u0002b!a\u0007\u0002,\rM\u0012a\u00054fCR,(/\u001a#fM\u000e{gNZ:`I\u0015\fH\u0003\u0002B4\u0007cB\u0011b!\u0012<\u0003\u0003\u0005\raa\u001b\u0002!\u0019,\u0017\r^;sK\u0012+gmQ8oMN\u0004SCAA\r\u0003Q!\u0017\r^1QCRD\u0007*\u00198eY\u0016\u00148o\u0018\u0013fcR!!qMB>\u0011%\u0019)EPA\u0001\u0002\u0004\tI\"A\teCR\f\u0007+\u0019;i\u0011\u0006tG\r\\3sg\u0002*\"!a\u0011\u0002\u001f54X\r\\\"p]R,\u0007\u0010^0%KF$BAa\u001a\u0004\u0006\"I1QI!\u0002\u0002\u0003\u0007\u00111I\u0001\r[Z,GnQ8oi\u0016DH\u000fI\u000b\u0003\u00037\nab]<b\u0011\u0006tG\r\\3s?\u0012*\u0017\u000f\u0006\u0003\u0003h\r=\u0005\"CB#\t\u0006\u0005\t\u0019AA.\u0003-\u0019x/\u0019%b]\u0012dWM\u001d\u0011\u0002'\u0005$G\rR1uCB\u000bG\u000f\u001b%b]\u0012dWM]:\u0015\t\r\r2q\u0013\u0005\b\u0003/1\u0005\u0019AA\r\u0003I\tG\r\u001a#bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:\u0015\t\r\r2Q\u0014\u0005\b\u0007?;\u0005\u0019AA\u0019\u0003=!\u0017\r^1QCRD\u0007*\u00198eY\u0016\u0014H\u0003BB\u0012\u0007GCqaa(I\u0001\u0004\u0019)\u000bE\u0003f\u0003\u000b\n\t$A\u0007bI\u00124U-\u0019;ve\u0016$UM\u001a\u000b\u0005\u0007G\u0019Y\u000bC\u0004\u0004<%\u0003\r!!(\u0015\t\r\r2q\u0016\u0005\b\u0007wQ\u0005\u0019ABY!\u0015)\u0017QIAO\u0003M\tG\r\u001a'pG\u0006dwJ^3se&$W\rR3g)\u0011\u0019\u0019ca.\t\u000f\r%3\n1\u0001\u0002\u001eR!11EB^\u0011\u001d\u0019I\u0005\u0014a\u0001\u0007c\u000b\u0011#\u00193e\r\u0016\fG/\u001e:f\t\u00164\u0007+\u0019;i)\u0011\u0019\u0019c!1\t\u000f\rMS\n1\u0001\u0002\u001eR!11EBc\u0011\u001d\u0019\u0019F\u0014a\u0001\u0007c\u000bq#\u00193e\u0019>\u001c\u0017\r\\(wKJ\u0014\u0018\u000eZ3EK\u001a\u0004\u0016\r\u001e5\u0015\t\r\r21\u001a\u0005\b\u0007;z\u0005\u0019AAO)\u0011\u0019\u0019ca4\t\u000f\ru\u0003\u000b1\u0001\u00042\u0006\u0011\u0012\r\u001a3GK\u0006$XO]3EK\u001a\u001cuN\u001c4t)\u0011\u0019\u0019c!6\t\u000f\r\u001d\u0014\u000b1\u0001\u0004XB)Q-!\u0012\u0004lQ!11EBn\u0011\u001d\u00199G\u0015a\u0001\u0007W\n!$\u00193e\r\u0016\fG\u000f\u001b:FqB\u0014Xm]:j_:\u001cuN\u001c;fqR$Baa\t\u0004b\"911]*A\u0002\u0005\r\u0013\u0001D0nm\u0016d7i\u001c8uKb$\u0018!D1eIN;\u0016\tS1oI2,'\u000f\u0006\u0003\u0004$\r%\bbBBv)\u0002\u0007\u00111L\u0001\f?N<\u0018\rS1oI2,'/A\u0003ck&dG\r\u0006\u0002\u0002n\u0005a!/Z1e\u0011\u001247OR5mKR!1\u0011WB{\u0011\u001d\u00199P\u0016a\u0001\u0007c\u000bA\u0001]1uQ\")!\u000e\u000ba\u0001W\u0002")
public class FeathrClient {
    private final SparkSession sparkSession;
    private final FeatureGroups featureGroups;
    private final MultiStageJoinPlanner logicalPlanner;
    private final FeatureGroupsUpdater featureGroupsUpdater;
    private final List<DataPathHandler> dataPathHandlers;
    private final Option<FeathrExpressionExecutionContext> mvelContext;
    private final Option<SWAHandler> swaHandler;
    private final Logger log;
    private final Map<String, FeatureAnchorWithSource> allAnchoredFeatures;
    private final Map<String, DerivedFeature> allDerivedFeatures;
    private final Map<String, FeatureAnchorWithSource> allPassthroughFeatures;
    private final Map<String, FeatureAnchorWithSource> allWindowAggFeatures;
    private final Map<String, DerivedFeature> allSeqJoinFeatures;

    public static Builder builder(SparkSession sparkSession) {
        return FeathrClient$.MODULE$.builder(sparkSession);
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, FeatureAnchorWithSource> allAnchoredFeatures() {
        return this.allAnchoredFeatures;
    }

    public Map<String, DerivedFeature> allDerivedFeatures() {
        return this.allDerivedFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allPassthroughFeatures() {
        return this.allPassthroughFeatures;
    }

    public Map<String, FeatureAnchorWithSource> allWindowAggFeatures() {
        return this.allWindowAggFeatures;
    }

    public Map<String, DerivedFeature> allSeqJoinFeatures() {
        return this.allSeqJoinFeatures;
    }

    public SparkFeaturizedDataset joinFeatures(FeatureJoinConfig joinConfig, SparkFeaturizedDataset obsData, JoinJobContext jobContext) {
        SparkConf sparkConf = this.sparkSession.sparkContext().getConf();
        FeathrUtils$.MODULE$.enableDebugLogging(sparkConf);
        Tuple2<Dataset<Row>, Header> tuple2 = this.doJoinObsAndFeatures(joinConfig, jobContext, obsData.data());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple23 = tuple22;
        Dataset joinedDF2 = (Dataset)tuple23._1();
        Header header2 = (Header)tuple23._2();
        Some x$1 = new Some((Object)header2);
        Map<String, String> x$2 = FeaturizedDatasetMetadata$.MODULE$.apply$default$1();
        return new SparkFeaturizedDataset((Dataset<Row>)joinedDF2, new FeaturizedDatasetMetadata(x$2, (Option<Header>)x$1));
    }

    public JoinJobContext joinFeatures$default$3() {
        return new JoinJobContext(JoinJobContext$.MODULE$.apply$default$1(), JoinJobContext$.MODULE$.apply$default$2(), JoinJobContext$.MODULE$.apply$default$3(), JoinJobContext$.MODULE$.apply$default$4(), JoinJobContext$.MODULE$.apply$default$5());
    }

    public Map<TaggedFeatureName, SparkFeaturizedDataset> generateFeatures(FeatureGenSpec featureGenSpec) {
        Map map;
        this.prepareExecuteEnv();
        Seq<JoiningFeatureParams> keyTaggedAnchoredFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForAnchoredFeatures(featureGenSpec, this.featureGroups);
        Seq<JoiningFeatureParams> keyTaggedDerivedFeatures = FeatureGenKeyTagAnalyzer$.MODULE$.inferKeyTagsForDerivedFeatures(featureGenSpec, this.featureGroups, keyTaggedAnchoredFeatures);
        Seq keyTaggedRequiredFeatures = (Seq)keyTaggedAnchoredFeatures.$plus$plus(keyTaggedDerivedFeatures, Seq$.MODULE$.canBuildFrom());
        if (this.isStreaming(featureGenSpec)) {
            StreamingFeatureGenerator streamingFeatureGenerator = new StreamingFeatureGenerator(this.dataPathHandlers);
            streamingFeatureGenerator.generateFeatures(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, keyTaggedRequiredFeatures);
            DataFrameFeatureGenerator dataFrameFeatureGenerator = new DataFrameFeatureGenerator((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext);
            Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> featureMap = dataFrameFeatureGenerator.generateFeaturesAsDF(this.sparkSession, featureGenSpec, this.featureGroups, (Seq<JoiningFeatureParams>)keyTaggedRequiredFeatures);
            map = (Map)featureMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                TaggedFeatureName taggedFeatureName;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        taggedFeatureName = (TaggedFeatureName)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Dataset df = (Dataset)tuple2._1();
                SparkFeaturizedDataset fds = new SparkFeaturizedDataset((Dataset<Row>)df, new FeaturizedDatasetMetadata(FeaturizedDatasetMetadata$.MODULE$.apply$default$1(), FeaturizedDatasetMetadata$.MODULE$.apply$default$2()));
                Tuple2 tuple23 = new Tuple2((Object)taggedFeatureName, (Object)fds);
                return tuple23;
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    private boolean isStreaming(FeatureGenSpec featureGenSpec) {
        Seq<OutputProcessor> outputProcessors = featureGenSpec.getProcessorList();
        return !outputProcessors.isEmpty() ? BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)outputProcessors.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$1(p)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)FeathrClient.$anonfun$isStreaming$2(BoxesRunTime.unboxToBoolean((Object)x$2), BoxesRunTime.unboxToBoolean((Object)x$3))))) : false;
    }

    private void prepareExecuteEnv() {
        SQLConf$.MODULE$.get().setConfString("spark.sql.legacy.allowUntypedScalaUDF", "true");
    }

    public List<DataSource> getAllFeatureSources(Seq<JoiningFeatureParams> requestedFeatures) {
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(this.featureGroups, (Seq)requestedFeatures);
        Seq<ErasedEntityTaggedFeature> allRequiredFeatures = ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures();
        Seq sources = (Seq)((SeqLike)allRequiredFeatures.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FeathrClient $outer;

            public final <A1 extends ErasedEntityTaggedFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (this.$outer.allAnchoredFeatures().contains((Object)A1.getFeatureName())) {
                    String featureName = A1.getFeatureName();
                    object = ((FeatureAnchorWithSource)this.$outer.allAnchoredFeatures().apply((Object)featureName)).source();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ErasedEntityTaggedFeature x1) {
                ErasedEntityTaggedFeature erasedEntityTaggedFeature = x1;
                boolean bl = this.$outer.allAnchoredFeatures().contains((Object)erasedEntityTaggedFeature.getFeatureName());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        return sources.toList();
    }

    public Tuple2<Dataset<Row>, Header> doJoinObsAndFeatures(FeatureJoinConfig joinConfig, JoinJobContext jobContext, Dataset<Row> obsData) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        this.log().info(new StringBuilder(38).append("All anchored feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allAnchoredFeatures().keySet())).toString());
        this.log().info(new StringBuilder(37).append("All derived feature names (sorted):\n\t").append(this.stringifyFeatureNames((Set<String>)this.allDerivedFeatures().keySet())).toString());
        this.prepareExecuteEnv();
        boolean enableCheckPoint = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ENABLE_CHECKPOINT()))).toBoolean();
        String checkpointDir = FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH());
        if (enableCheckPoint) {
            if (checkpointDir.equals("")) {
                throw new FeathrException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(46).append("Please set ").append(FeathrUtils$.MODULE$.FEATHR_PARAMS_PREFIX()).append(FeathrUtils$.MODULE$.CHECKPOINT_OUTPUT_PATH()).append(" to a folder with write permission.").toString());
            }
            HdfsUtils$.MODULE$.deletePath(checkpointDir, true, HdfsUtils$.MODULE$.deletePath$default$3());
            this.sparkSession.sparkContext().setCheckpointDir(checkpointDir);
        }
        Map<String, Seq<JoiningFeatureParams>> featureGroupings = joinConfig.featureGroupings();
        this.log().info(new StringBuilder(19).append("Join job context: ").append(jobContext).append(")").toString());
        this.log().info(new StringBuilder(12).append("joinConfig: ").append(joinConfig).toString());
        this.log().info(new StringBuilder(28).append("featureGroupings passed in: ").append(featureGroupings).toString());
        int rowBloomFilterThreshold = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession, FeathrUtils$.MODULE$.ROW_BLOOMFILTER_MAX_THRESHOLD()))).toInt();
        Seq joinFeatures = (Seq)((TraversableOnce)featureGroupings.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct();
        if (featureGroupings.isEmpty()) {
            this.log().warn("Feature groupings from the join config is empty, returning the obs data without joining any features.");
            tuple22 = new Tuple2(obsData, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        } else {
            tuple22 = tuple2 = this.joinFeaturesAsDF(joinConfig, (Seq<JoiningFeatureParams>)joinFeatures, obsData, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rowBloomFilterThreshold)));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset joinedDF = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)joinedDF, (Object)header);
        Tuple2 tuple24 = tuple23;
        Dataset joinedDF2 = (Dataset)tuple24._1();
        Header header2 = (Header)tuple24._2();
        if (this.log().isDebugEnabled()) {
            this.log().debug("joinedDF:");
            joinedDF2.show(false);
            this.log().debug(new StringBuilder(23).append("header featureInfoMap: ").append(header2.featureInfoMap()).toString());
        }
        return new Tuple2((Object)joinedDF2, (Object)header2);
    }

    private Seq<String> findConflictFeatureNames(Seq<JoiningFeatureParams> keyTaggedFeatures, Seq<String> fieldNames) {
        return (Seq)((SeqLike)keyTaggedFeatures.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.featureName(), Seq$.MODULE$.canBuildFrom())).intersect(fieldNames);
    }

    public Tuple2<Dataset<Row>, Header> renameFeatureNames(Dataset<Row> df, Header header, Seq<String> conflictFeatureNames, String suffix) {
        UUID uuid = UUID.randomUUID();
        ObjectRef renamedDF = ObjectRef.create(df);
        conflictFeatureNames.foreach((Function1 & Serializable & scala.Serializable)name -> {
            FeathrClient.$anonfun$renameFeatureNames$1(renamedDF, uuid, suffix, name);
            return BoxedUnit.UNIT;
        });
        Map featuresInfoMap = (Map)header.featureInfoMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaggedFeatureName featureName = (TaggedFeatureName)tuple2._1();
            FeatureInfo featureInfo = (FeatureInfo)tuple2._2();
            String name = featureInfo.columnName();
            boolean conflict = conflictFeatureNames.contains((Object)name);
            FeatureInfo fi = conflict ? new FeatureInfo(new StringBuilder(0).append(name).append('_').append(suffix).toString(), featureInfo.featureType()) : featureInfo;
            TaggedFeatureName fn = conflict ? new TaggedFeatureName(featureName.getKeyTag(), new StringBuilder(0).append(name).append('_').append(suffix).toString()) : featureName;
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fn), (Object)fi);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new Tuple2((Object)((Dataset)renamedDF.elem), (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)featuresInfoMap));
    }

    public Tuple2<Dataset<Row>, Header> joinFeaturesAsDF(FeatureJoinConfig joinConfig, Seq<JoiningFeatureParams> keyTaggedFeatures, Dataset<Row> left, Option<Object> rowBloomFilterThreshold) {
        Tuple2<Dataset<Row>, Header> tuple2;
        Option<ConflictsAutoCorrectionSetting> conflictsAutoCorrectionSetting;
        BoxedUnit boxedUnit;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])left.head(1))).isEmpty()) {
            this.log().info("Observation is empty");
            return new Tuple2(left, (Object)new Header((Map<TaggedFeatureName, FeatureInfo>)Predef$.MODULE$.Map().empty()));
        }
        FeatureGroups updatedFeatureGroups = this.featureGroupsUpdater.updateFeatureGroups(this.featureGroups, keyTaggedFeatures);
        LogicalPlan logicalPlan = this.logicalPlanner.getLogicalPlan(updatedFeatureGroups, (Seq)keyTaggedFeatures);
        boolean shouldSkipFeature = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(this.sparkSession.sparkContext().getConf(), FeathrUtils$.MODULE$.SKIP_MISSING_FEATURE()))).toBoolean();
        Map featureToPathsMap = ((TraversableOnce)((MultiStageJoinPlan)logicalPlan).allRequiredFeatures().flatMap((Function1 & Serializable & scala.Serializable)requiredFeature -> Option$.MODULE$.option2Iterable(this.allAnchoredFeatures().get((Object)requiredFeature.getFeatureName()).map((Function1 & Serializable & scala.Serializable)featureAnchorWithSource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)requiredFeature.getFeatureName()), (Object)featureAnchorWithSource.source().path()))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (!this.sparkSession.sparkContext().isLocal()) {
            Object object;
            Tuple2<Try<BoxedUnit>, Seq<String>> featurePathsTest = AclCheckUtils$.MODULE$.checkReadAuthorization(this.sparkSession, ((MultiStageJoinPlan)logicalPlan).allRequiredFeatures(), this.allAnchoredFeatures());
            Try try_ = (Try)featurePathsTest._1();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (!shouldSkipFeature) {
                    throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, "Unable to verify read authorization on feature data, it can be due to the following reasons: 1) input not exist, 2) no permission.", exception);
                }
                FeatureGroups featureGroupsWithoutInvalidFeatures = FeatureGroupsUpdater$.MODULE$.apply().getUpdatedFeatureGroupsWithoutInvalidPaths((Map<String, String>)featureToPathsMap, updatedFeatureGroups, (Seq<String>)((Seq)featurePathsTest._2()));
                object = this.logicalPlanner.getLogicalPlan(featureGroupsWithoutInvalidFeatures, (Seq)keyTaggedFeatures);
            } else if (try_ instanceof Success) {
                this.log().debug("Checked read authorization on all feature data");
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<String> invalidFeatureNames = this.findInvalidFeatureRefs(keyTaggedFeatures);
        if (invalidFeatureNames.nonEmpty()) {
            throw new FeathrInputDataException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(77).append("Feature names must conform to ").append("regular expression: ").append(AnchorUtils$.MODULE$.featureNamePattern()).append(", but found feature names: ").append(invalidFeatureNames).toString());
        }
        DataFrameFeatureJoiner joiner = new DataFrameFeatureJoiner((MultiStageJoinPlan)logicalPlan, this.dataPathHandlers, this.mvelContext, this.swaHandler);
        Seq<String> conflictFeatureNames = this.findConflictFeatureNames(keyTaggedFeatures, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])left.schema().fieldNames()));
        Option<JoinConfigSettings> joinConfigSettings = joinConfig.settings();
        Option<ConflictsAutoCorrectionSetting> option = conflictsAutoCorrectionSetting = joinConfigSettings.isDefined() ? ((JoinConfigSettings)joinConfigSettings.get()).conflictsAutoCorrectionSetting() : None$.MODULE$;
        if (conflictFeatureNames.nonEmpty()) {
            if (!conflictsAutoCorrectionSetting.isDefined()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(152).append("Feature names must be different from field names in the observation data. ").append("Please rename feature ").append(conflictFeatureNames).append(" or rename the same field names in the observation data.").toString());
            }
            boolean renameFeatures = ((ConflictsAutoCorrectionSetting)conflictsAutoCorrectionSetting.get()).renameFeatureList();
            String suffix = ((ConflictsAutoCorrectionSetting)conflictsAutoCorrectionSetting.get()).suffix();
            this.log().warn(new StringBuilder(75).append("Found conflicted field names: ").append(conflictFeatureNames).append(". Will auto correct them by applying suffix: ").append(suffix).toString());
            ObjectRef leftRenamed = ObjectRef.create(left);
            conflictFeatureNames.foreach((Function1 & Serializable & scala.Serializable)name -> {
                leftRenamed.elem = ((Dataset)leftRenamed.elem).withColumnRenamed(name, new StringBuilder(0).append(name).append('_').append(suffix).toString());
                return BoxedUnit.UNIT;
            });
            Seq<String> conflictFeatureNames2 = this.findConflictFeatureNames(keyTaggedFeatures, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])((Dataset)leftRenamed.elem).schema().fieldNames()));
            if (conflictFeatureNames2.nonEmpty()) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(176).append("Failed to apply auto correction to solve conflicts. Still got conflicts after applying provided suffix ").append(suffix).append(" for fields: ").append(conflictFeatureNames).append(". Please provide another suffix or solve conflicts manually.").toString());
            }
            Tuple2<Dataset<Row>, Header> tuple22 = joiner.joinFeaturesAsDF(this.sparkSession, joinConfig, updatedFeatureGroups, keyTaggedFeatures, (Dataset<Row>)((Dataset)leftRenamed.elem), rowBloomFilterThreshold);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Dataset df = (Dataset)tuple22._1();
            Header header = (Header)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)df, (Object)header);
            Tuple2 tuple24 = tuple23;
            Dataset df2 = (Dataset)tuple24._1();
            Header header2 = (Header)tuple24._2();
            if (renameFeatures) {
                this.log().warn(new StringBuilder(70).append("Suffix :").append(suffix).append(" is applied into feature names: ").append(conflictFeatureNames).append(" to avoid conflicts in outputs").toString());
                tuple2 = this.renameFeatureNames((Dataset<Row>)df2, header2, conflictFeatureNames, suffix);
            } else {
                this.log().warn(new StringBuilder(77).append("Suffix :").append(suffix).append(" is applied into dataset Column names: ").append(conflictFeatureNames).append(" to avoid conflicts in outputs").toString());
                tuple2 = new Tuple2<Dataset<Row>, Header>((Object)df2, (Object)header2);
            }
        } else {
            tuple2 = joiner.joinFeaturesAsDF(this.sparkSession, joinConfig, updatedFeatureGroups, keyTaggedFeatures, left, rowBloomFilterThreshold);
        }
        return tuple2;
    }

    public Option<Object> joinFeaturesAsDF$default$4() {
        return None$.MODULE$;
    }

    public FeatureGroups getFeatureGroups() {
        return this.featureGroups;
    }

    public MultiStageJoinPlanner getLogicalPlanner() {
        return this.logicalPlanner;
    }

    private String stringifyFeatureNames(Set<String> nameSet) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)nameSet.toSeq().sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)))).mkString("\n\t");
    }

    private List<String> findInvalidFeatureRefs(Seq<JoiningFeatureParams> features) {
        return (List)features.foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, f) -> {
            List list;
            String featureRefStr = f.featureName().toString();
            String featureRefStrInDF = DataFrameColName$.MODULE$.getEncodedFeatureRefStrForColName(featureRefStr);
            boolean isValidSyntax = AnchorUtils$.MODULE$.featureNamePattern().matcher(featureRefStrInDF).matches();
            if (isValidSyntax) {
                list = acc;
            } else {
                String string = featureRefStr;
                list = acc.$colon$colon((Object)string);
            }
            return list;
        });
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$1(OutputProcessor p) {
        return package$.MODULE$.RichConfig(p.outputProcessorConfig().getParams()).getBooleanWithDefault("streaming", false);
    }

    public static final /* synthetic */ boolean $anonfun$isStreaming$2(boolean x$2, boolean x$3) {
        return x$2 || x$3;
    }

    public static final /* synthetic */ void $anonfun$renameFeatureNames$1(ObjectRef renamedDF$1, UUID uuid$1, String suffix$1, String name) {
        renamedDF$1.elem = ((Dataset)renamedDF$1.elem).withColumnRenamed(name, new StringBuilder(0).append(name).append('_').append(uuid$1).toString());
        renamedDF$1.elem = ((Dataset)renamedDF$1.elem).withColumnRenamed(new StringBuilder(0).append(name).append('_').append(suffix$1).toString(), name);
        renamedDF$1.elem = ((Dataset)renamedDF$1.elem).withColumnRenamed(new StringBuilder(0).append(name).append('_').append(uuid$1).toString(), new StringBuilder(0).append(name).append('_').append(suffix$1).toString());
    }

    public FeathrClient(SparkSession sparkSession, FeatureGroups featureGroups, MultiStageJoinPlanner logicalPlanner, FeatureGroupsUpdater featureGroupsUpdater, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext, Option<SWAHandler> swaHandler) {
        this.sparkSession = sparkSession;
        this.featureGroups = featureGroups;
        this.logicalPlanner = logicalPlanner;
        this.featureGroupsUpdater = featureGroupsUpdater;
        this.dataPathHandlers = dataPathHandlers;
        this.mvelContext = mvelContext;
        this.swaHandler = swaHandler;
        this.log = LogManager.getLogger(this.getClass());
        this.allAnchoredFeatures = featureGroups.allAnchoredFeatures();
        this.allDerivedFeatures = featureGroups.allDerivedFeatures();
        this.allPassthroughFeatures = featureGroups.allPassthroughFeatures();
        this.allWindowAggFeatures = featureGroups.allWindowAggFeatures();
        this.allSeqJoinFeatures = featureGroups.allSeqJoinFeatures();
    }

    public static class Builder {
        private final SparkSession sparkSession;
        private final FeathrConfig feathrConfigLoader;
        private List<String> featureDef;
        private List<String> localOverrideDef;
        private List<String> featureDefPath;
        private List<String> localOverrideDefPath;
        private List<FeathrConfig> featureDefConfs;
        private List<DataPathHandler> dataPathHandlers;
        private Option<FeathrExpressionExecutionContext> mvelContext;
        private Option<SWAHandler> swaHandler;

        private FeathrConfig feathrConfigLoader() {
            return this.feathrConfigLoader;
        }

        private List<String> featureDef() {
            return this.featureDef;
        }

        private void featureDef_$eq(List<String> x$1) {
            this.featureDef = x$1;
        }

        private List<String> localOverrideDef() {
            return this.localOverrideDef;
        }

        private void localOverrideDef_$eq(List<String> x$1) {
            this.localOverrideDef = x$1;
        }

        private List<String> featureDefPath() {
            return this.featureDefPath;
        }

        private void featureDefPath_$eq(List<String> x$1) {
            this.featureDefPath = x$1;
        }

        private List<String> localOverrideDefPath() {
            return this.localOverrideDefPath;
        }

        private void localOverrideDefPath_$eq(List<String> x$1) {
            this.localOverrideDefPath = x$1;
        }

        private List<FeathrConfig> featureDefConfs() {
            return this.featureDefConfs;
        }

        private void featureDefConfs_$eq(List<FeathrConfig> x$1) {
            this.featureDefConfs = x$1;
        }

        private List<DataPathHandler> dataPathHandlers() {
            return this.dataPathHandlers;
        }

        private void dataPathHandlers_$eq(List<DataPathHandler> x$1) {
            this.dataPathHandlers = x$1;
        }

        private Option<FeathrExpressionExecutionContext> mvelContext() {
            return this.mvelContext;
        }

        private void mvelContext_$eq(Option<FeathrExpressionExecutionContext> x$1) {
            this.mvelContext = x$1;
        }

        private Option<SWAHandler> swaHandler() {
            return this.swaHandler;
        }

        private void swaHandler_$eq(Option<SWAHandler> x$1) {
            this.swaHandler = x$1;
        }

        public Builder addDataPathHandlers(List<DataPathHandler> dataPathHandlers) {
            this.dataPathHandlers_$eq((List<DataPathHandler>)((List)dataPathHandlers.$plus$plus(this.dataPathHandlers(), List$.MODULE$.canBuildFrom())));
            return this;
        }

        public Builder addDataPathHandler(DataPathHandler dataPathHandler) {
            DataPathHandler dataPathHandler2 = dataPathHandler;
            this.dataPathHandlers_$eq((List<DataPathHandler>)this.dataPathHandlers().$colon$colon((Object)dataPathHandler2));
            return this;
        }

        public Builder addDataPathHandler(Option<DataPathHandler> dataPathHandler) {
            return dataPathHandler.isDefined() ? this.addDataPathHandler((DataPathHandler)dataPathHandler.get()) : this;
        }

        public Builder addFeatureDef(String featureDef) {
            String string = featureDef;
            this.featureDef_$eq((List<String>)this.featureDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDef(Option<String> featureDef) {
            return featureDef.isDefined() ? this.addFeatureDef((String)featureDef.get()) : this;
        }

        public Builder addLocalOverrideDef(String localOverrideDef) {
            String string = localOverrideDef;
            this.localOverrideDef_$eq((List<String>)this.localOverrideDef().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDef(Option<String> localOverrideDef) {
            return localOverrideDef.isDefined() ? this.addFeatureDef((String)localOverrideDef.get()) : this;
        }

        public Builder addFeatureDefPath(String featureDefPath) {
            String string = featureDefPath;
            this.featureDefPath_$eq((List<String>)this.featureDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addFeatureDefPath(Option<String> featureDefPath) {
            return featureDefPath.isDefined() ? this.addFeatureDefPath((String)featureDefPath.get()) : this;
        }

        public Builder addLocalOverrideDefPath(String localOverrideDefPath) {
            String string = localOverrideDefPath;
            this.localOverrideDefPath_$eq((List<String>)this.localOverrideDefPath().$colon$colon((Object)string));
            return this;
        }

        public Builder addLocalOverrideDefPath(Option<String> localOverrideDefPath) {
            return localOverrideDefPath.isDefined() ? this.addLocalOverrideDefPath((String)localOverrideDefPath.get()) : this;
        }

        public Builder addFeatureDefConfs(Option<List<FeathrConfig>> featureDefConfs) {
            return featureDefConfs.isDefined() ? this.addFeatureDefConfs((List<FeathrConfig>)((List)featureDefConfs.get())) : this;
        }

        public Builder addFeatureDefConfs(List<FeathrConfig> featureDefConfs) {
            this.featureDefConfs_$eq(featureDefConfs);
            return this;
        }

        public Builder addFeathrExpressionContext(Option<FeathrExpressionExecutionContext> _mvelContext) {
            this.mvelContext_$eq(_mvelContext);
            return this;
        }

        public Builder addSWAHandler(Option<SWAHandler> _swaHandler) {
            this.swaHandler_$eq(_swaHandler);
            return this;
        }

        public FeathrClient build() {
            Predef$.MODULE$.require(!this.localOverrideDefPath().isEmpty() || !this.localOverrideDef().isEmpty() || !this.featureDefPath().isEmpty() || !this.featureDef().isEmpty() || !this.featureDefConfs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot build feathrClient without a feature def conf file/string or local override def conf file/string");
            ObjectRef featureDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            ObjectRef localDefConfigs = ObjectRef.create((Object)List$.MODULE$.empty());
            Object object = this.featureDefPath().nonEmpty() ? this.featureDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$2(this, featureDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object2 = this.featureDef().nonEmpty() ? this.featureDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$4(this, featureDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object3 = this.localOverrideDefPath().nonEmpty() ? this.localOverrideDefPath().map((Function1 & Serializable & scala.Serializable)path -> {
                Builder.$anonfun$build$5(this, localDefConfigs, path);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            Object object4 = this.localOverrideDef().nonEmpty() ? this.localOverrideDef().map((Function1 & Serializable & scala.Serializable)confStr -> {
                Builder.$anonfun$build$7(this, localDefConfigs, confStr);
                return BoxedUnit.UNIT;
            }, List$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
            featureDefConfigs.elem = (List)((List)featureDefConfigs.elem).$plus$plus(this.featureDefConfs(), List$.MODULE$.canBuildFrom());
            FeatureGroups featureGroups = FeatureGroupsGenerator$.MODULE$.apply((Seq<FeathrConfig>)((List)featureDefConfigs.elem), (Option<Seq<FeathrConfig>>)new Some((Object)((List)localDefConfigs.elem))).getFeatureGroups();
            FeathrClient feathrClient = new FeathrClient(this.sparkSession, featureGroups, MultiStageJoinPlanner$.MODULE$.apply(), FeatureGroupsUpdater$.MODULE$.apply(), this.dataPathHandlers(), this.mvelContext(), this.swaHandler());
            return feathrClient;
        }

        public Option<String> readHdfsFile(Option<String> path) {
            return path.map((Function1 & Serializable & scala.Serializable)p -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.sparkSession.sparkContext().textFile(p, $this.sparkSession.sparkContext().textFile$default$2()).collect())).mkString("\n"));
        }

        public static final /* synthetic */ void $anonfun$build$3(Builder $this, ObjectRef featureDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$2(Builder $this, ObjectRef featureDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$3($this, featureDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$4(Builder $this, ObjectRef featureDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            featureDefConfigs$1.elem = ((List)featureDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$6(Builder $this, ObjectRef localDefConfigs$1, String cfg) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(cfg);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public static final /* synthetic */ void $anonfun$build$5(Builder $this, ObjectRef localDefConfigs$1, String path) {
            $this.readHdfsFile((Option<String>)new Some((Object)path)).foreach((Function1 & Serializable & scala.Serializable)cfg -> {
                Builder.$anonfun$build$6($this, localDefConfigs$1, cfg);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$build$7(Builder $this, ObjectRef localDefConfigs$1, String confStr) {
            FeathrConfig feathrConfig = $this.feathrConfigLoader().load(confStr);
            localDefConfigs$1.elem = ((List)localDefConfigs$1.elem).$colon$colon((Object)feathrConfig);
        }

        public Builder(SparkSession sparkSession) {
            this.sparkSession = sparkSession;
            this.feathrConfigLoader = FeathrConfigLoader$.MODULE$.apply();
            this.featureDef = Nil$.MODULE$;
            this.localOverrideDef = Nil$.MODULE$;
            this.featureDefPath = Nil$.MODULE$;
            this.localOverrideDefPath = Nil$.MODULE$;
            this.featureDefConfs = Nil$.MODULE$;
            this.dataPathHandlers = Nil$.MODULE$;
            this.mvelContext = None$.MODULE$;
            this.swaHandler = None$.MODULE$;
        }
    }
}

