/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchor;
import com.linkedin.feathr.offline.config.FeathrConfig;
import com.linkedin.feathr.offline.config.SeqTaggedDependency;
import com.linkedin.feathr.offline.config.TaggedDependency;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.source.DataSource;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class FeathrConfigLoader$ {
    public static FeathrConfigLoader$ MODULE$;

    static {
        new FeathrConfigLoader$();
    }

    public String resolveOverride(String configDoc, String overrideConfDoc) {
        Config conf = ConfigFactory.parseString((String)configDoc);
        Config overrideConf = ConfigFactory.parseString((String)overrideConfDoc);
        return overrideConf.withFallback((ConfigMergeable)conf).root().render();
    }

    public FeathrConfig apply() {
        return new FeathrConfig((Option<Map<String, DataSource>>)None$.MODULE$, (Map<String, FeatureAnchor>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Option<Map<String, DerivedFeature>>)None$.MODULE$, (Option<Seq<DerivedFeature>>)None$.MODULE$);
    }

    public Seq<String> extractStringList(JsonNode jsonNode) {
        Seq seq;
        if (jsonNode.isArray()) {
            seq = (Seq)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020iterableAsScalaIterable((Iterable)((ArrayNode)jsonNode)).toList().map((Function1 & Serializable & scala.Serializable)i -> i.textValue().trim(), List$.MODULE$.canBuildFrom());
        } else if (jsonNode.isTextual()) {
            seq = (Seq)new .colon.colon((Object)jsonNode.textValue().trim(), (List)Nil$.MODULE$);
        } else {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(37).append("No valid string list found for node ").append(jsonNode).append(".").toString());
        }
        return seq;
    }

    public Option<Seq<String>> extractStringListOpt(JsonNode jsonNode) {
        None$ none$;
        Option option = Option$.MODULE$.apply((Object)jsonNode);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode node = (JsonNode)some.value();
            none$ = new Some(this.extractStringList(node));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<TaggedDependency>, Option<Seq<String>>> extractTaggedDependency(JsonNode inputsNode, ObjectCodec codec) {
        Tuple2 tuple2;
        if (inputsNode.isObject()) {
            Seq fields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((ObjectNode)inputsNode).fields()).asScala()).toSeq();
            Seq inputs = (Seq)fields.map((Function1 & Serializable & scala.Serializable)item -> (TaggedDependency)codec.treeToValue((TreeNode)item.getValue(), TaggedDependency.class), Seq$.MODULE$.canBuildFrom());
            Seq parameterNames = (Seq)fields.map((Function1 & Serializable & scala.Serializable)item -> (String)item.getKey(), Seq$.MODULE$.canBuildFrom());
            tuple2 = new Tuple2((Object)inputs, (Object)new Some((Object)parameterNames));
            return tuple2;
        } else if (inputsNode.isArray()) {
            SeqTaggedDependency seqTaggedDependency = (SeqTaggedDependency)codec.treeToValue((TreeNode)inputsNode, SeqTaggedDependency.class);
            tuple2 = new Tuple2(seqTaggedDependency.dependencies(), (Object)None$.MODULE$);
            return tuple2;
        } else {
            if (!inputsNode.isTextual()) throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(87).append("Fail to extract inputs/dependency feature list for a derived feature since ").append(inputsNode).append(" is invalid.").toString());
            String string = inputsNode.textValue();
            String string2 = "PROVIDED_BY_CLASS";
            if (string != null ? !string.equals(string2) : string2 != null) throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(87).append("Fail to extract inputs/dependency feature list for a derived feature since ").append(inputsNode).append(" is invalid.").toString());
            tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)None$.MODULE$);
        }
        return tuple2;
    }

    private FeathrConfigLoader$() {
        MODULE$ = this;
    }
}

