/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.ConfigLoaderUtils$;
import com.linkedin.feathr.offline.config.FeatureDefinition;
import com.linkedin.feathr.offline.config.MVELFeatureDefinition;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M2Aa\u0001\u0003\u0001\u001f!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E\tib)Z1ukJ,G)\u001a4j]&$\u0018n\u001c8EKN,'/[1mSj,'O\u0003\u0002\u0006\r\u000511m\u001c8gS\u001eT!a\u0002\u0005\u0002\u000f=4g\r\\5oK*\u0011\u0011BC\u0001\u0007M\u0016\fG\u000f\u001b:\u000b\u0005-a\u0011\u0001\u00037j].,G-\u001b8\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0007EA\"$D\u0001\u0013\u0015\t\u0019B#\u0001\u0005eCR\f'-\u001b8e\u0015\t)b#A\u0004kC\u000e\\7o\u001c8\u000b\u0005]a\u0011!\u00034bgR,'\u000f_7m\u0013\tI\"C\u0001\tKg>tG)Z:fe&\fG.\u001b>feB\u00111\u0004H\u0007\u0002\t%\u0011Q\u0004\u0002\u0002\u0012\r\u0016\fG/\u001e:f\t\u00164\u0017N\\5uS>t\u0017A\u0002\u001fj]&$h\bF\u0001!!\tY\u0002!A\u0006eKN,'/[1mSj,GcA\u0012']A\u00111\u0004J\u0005\u0003K\u0011\u0011Q#\u0014,F\u0019\u001a+\u0017\r^;sK\u0012+g-\u001b8ji&|g\u000eC\u0003(\u0005\u0001\u0007\u0001&A\u0001q!\tIC&D\u0001+\u0015\tYC#\u0001\u0003d_J,\u0017BA\u0017+\u0005)Q5o\u001c8QCJ\u001cXM\u001d\u0005\u0006_\t\u0001\r\u0001M\u0001\u0005GRDH\u000f\u0005\u0002\u0012c%\u0011!G\u0005\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]\u000e{g\u000e^3yi\u0002")
public class FeatureDefinitionDeserializer
extends JsonDeserializer<FeatureDefinition> {
    public MVELFeatureDefinition deserialize(JsonParser p, DeserializationContext ctxt) {
        MVELFeatureDefinition mVELFeatureDefinition;
        ObjectCodec codec = p.getCodec();
        TreeNode node = codec.readTree(p);
        Option<FeatureTypeConfig> typeConfig = ConfigLoaderUtils$.MODULE$.getTypeConfig(node);
        TreeNode treeNode = node;
        if (treeNode instanceof TextNode) {
            mVELFeatureDefinition = new MVELFeatureDefinition(((TextNode)node).textValue(), (Option<FeatureTypeConfig>)None$.MODULE$);
        } else if (treeNode instanceof ObjectNode) {
            TreeNode treeNode2 = node.get("def");
            if (!(treeNode2 instanceof TextNode)) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(153).append("Trying to deserialize the config into FeatureDefinition.").append("Feature definition ").append(node).append(" is not correctly set as it doesn't have a def field.").append("Please provide def field.").toString());
            }
            TextNode textNode = (TextNode)treeNode2;
            String string = textNode.textValue();
            mVELFeatureDefinition = new MVELFeatureDefinition(string, typeConfig);
        } else {
            throw new MatchError((Object)treeNode);
        }
        return mVELFeatureDefinition;
    }
}

