/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config.datasource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.linkedin.feathr.offline.config.datasource.ADLSResourceInfoSetter$;
import com.linkedin.feathr.offline.config.datasource.BlobResourceInfoSetter$;
import com.linkedin.feathr.offline.config.datasource.DataSourceConfigs;
import com.linkedin.feathr.offline.config.datasource.FeathrStoreConfig;
import com.linkedin.feathr.offline.config.datasource.KafkaResourceInfoSetter$;
import com.linkedin.feathr.offline.config.datasource.MonitoringResourceInfoSetter$;
import com.linkedin.feathr.offline.config.datasource.RedisResourceInfoSetter$;
import com.linkedin.feathr.offline.config.datasource.Resource;
import com.linkedin.feathr.offline.config.datasource.S3ResourceInfoSetter$;
import com.linkedin.feathr.offline.config.datasource.SnowflakeResourceInfoSetter$;
import com.linkedin.feathr.offline.util.CmdLineParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import scala.io.Codec$;
import scala.io.Source$;

public final class DataSourceConfigUtils$ {
    public static DataSourceConfigUtils$ MODULE$;
    private final Logger logger;
    private final ObjectMapper yamlMapper;
    private final FeathrStoreConfig featureStoreConfig;

    static {
        new DataSourceConfigUtils$();
    }

    public Logger logger() {
        return this.logger;
    }

    private ObjectMapper yamlMapper() {
        return this.yamlMapper;
    }

    public FeathrStoreConfig featureStoreConfig() {
        return this.featureStoreConfig;
    }

    /*
     * WARNING - void declaration
     */
    private FeathrStoreConfig loadYamlConfig(String yamlPath) {
        FeathrStoreConfig feathrStoreConfig;
        try {
            void var3_3;
            String contents = Source$.MODULE$.fromFile(yamlPath, Codec$.MODULE$.fallbackSystemCodec()).mkString();
            this.yamlMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            FeathrStoreConfig config = (FeathrStoreConfig)this.yamlMapper().readValue(contents, FeathrStoreConfig.class);
            feathrStoreConfig = var3_3;
        }
        catch (Throwable throwable) {
            feathrStoreConfig = new FeathrStoreConfig(null);
        }
        return feathrStoreConfig;
    }

    public DataSourceConfigs getConfigs(CmdLineParser cmdParser) {
        return new DataSourceConfigs(cmdParser.extractOptionalValue("redis-config"), cmdParser.extractOptionalValue("s3-config"), cmdParser.extractOptionalValue("adls-config"), cmdParser.extractOptionalValue("blob-config"), cmdParser.extractOptionalValue("sql-config"), cmdParser.extractOptionalValue("snowflake-config"), cmdParser.extractOptionalValue("monitoring-config"), cmdParser.extractOptionalValue("kafka-config"));
    }

    public void setupHadoopConf(SparkSession ss, DataSourceConfigs configs) {
        Resource resource = this.featureStoreConfig().resource();
        ADLSResourceInfoSetter$.MODULE$.setup(ss, configs.adlsConfig(), resource);
        BlobResourceInfoSetter$.MODULE$.setup(ss, configs.blobConfig(), resource);
        S3ResourceInfoSetter$.MODULE$.setup(ss, configs.s3Config(), resource);
        SnowflakeResourceInfoSetter$.MODULE$.setup(ss, configs.snowflakeConfig(), resource);
        MonitoringResourceInfoSetter$.MODULE$.setup(ss, configs.monitoringConfig(), resource);
        KafkaResourceInfoSetter$.MODULE$.setup(ss, configs.kafkaConfig(), resource);
    }

    public void setupSparkConf(SparkConf sparkConf, DataSourceConfigs configs) {
        Resource resource = this.featureStoreConfig().resource();
        RedisResourceInfoSetter$.MODULE$.setup(sparkConf, configs.redisConfig(), resource);
    }

    private DataSourceConfigUtils$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
        this.yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.featureStoreConfig = this.loadYamlConfig("feathr_project/data/feathr_user_workspace/feathr_config.yaml");
    }
}

