/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.config.join.converters;

import com.linkedin.data.template.GetMode;
import com.linkedin.feathr.config.join.AbsoluteDateRange;
import com.linkedin.feathr.config.join.FrameFeatureJoinConfig;
import com.linkedin.feathr.config.join.JoiningFeature;
import com.linkedin.feathr.config.join.RelativeDateRange;
import com.linkedin.feathr.config.join.Settings;
import com.linkedin.feathr.config.join.TimeUnit;
import com.linkedin.feathr.exception.ErrorLabel;
import com.linkedin.feathr.exception.FeathrConfigException;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.KeyedFeatureList;
import com.linkedin.feathr.offline.config.join.converters.PegasusRecordDateTimeConverter$;
import com.linkedin.feathr.offline.config.join.converters.PegasusRecordSettingsConverter;
import com.linkedin.feathr.offline.util.datetime.OfflineDateTimeUtils$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3Qa\u0003\u0007\u0001%iA\u0001\"\t\u0001\u0003\u0006\u0004%Ia\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005I!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0003q\u0003BB\u001c\u0001A\u0003%q\u0006C\u00039\u0001\u0011\u0005\u0011\bC\u0003G\u0001\u0011%qiB\u0003Q\u0019!\u0005\u0011KB\u0003\f\u0019!\u0005!\u000bC\u0003*\u0013\u0011\u00051K\u0001\u0017QK\u001e\f7/^:SK\u000e|'\u000f\u001a$sC6,g)Z1ukJ,'j\\5o\u0007>tg-[4D_:4XM\u001d;fe*\u0011QBD\u0001\u000bG>tg/\u001a:uKJ\u001c(BA\b\u0011\u0003\u0011Qw.\u001b8\u000b\u0005E\u0011\u0012AB2p]\u001aLwM\u0003\u0002\u0014)\u00059qN\u001a4mS:,'BA\u000b\u0017\u0003\u00191W-\u0019;ie*\u0011q\u0003G\u0001\tY&t7.\u001a3j]*\t\u0011$A\u0002d_6\u001c\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003y\u0001XmZ1tkN\u0014VmY8sIN+G\u000f^5oON\u001cuN\u001c<feR,'o\u0001\u0001\u0016\u0003\u0011\u0002\"!\n\u0014\u000e\u00031I!a\n\u0007\u0003=A+w-Y:vgJ+7m\u001c:e'\u0016$H/\u001b8hg\u000e{gN^3si\u0016\u0014\u0018a\b9fO\u0006\u001cXo\u001d*fG>\u0014HmU3ui&twm]\"p]Z,'\u000f^3sA\u00051A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0005\u0015\u0002\u0001\"B\u0011\u0004\u0001\u0004!\u0013A\u0005$F\u0003R+&+R0H%>+\u0006k\u0018(B\u001b\u0016+\u0012a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\nA\u0001\\1oO*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005\u0019\u0019FO]5oO\u0006\u0019b)R!U+J+ul\u0012*P+B{f*Q'FA\u000591m\u001c8wKJ$HC\u0001\u001e?!\tYD(D\u0001\u0011\u0013\ti\u0004CA\tGK\u0006$XO]3K_&t7i\u001c8gS\u001eDQa\u0010\u0004A\u0002\u0001\u000baC\u001a:b[\u00164U-\u0019;ve\u0016Tu.\u001b8D_:4\u0017n\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u001f\rS!!\u0005\u000b\n\u0005\u0015\u0013%A\u0006$sC6,g)Z1ukJ,'j\\5o\u0007>tg-[4\u0002\u001d\r|gN^3si\u001a+\u0017\r^;sKR\u0011\u0001j\u0013\t\u0003w%K!A\u0013\t\u0003!-+\u00170\u001a3GK\u0006$XO]3MSN$\b\"\u0002'\b\u0001\u0004i\u0015a\u00024fCR,(/\u001a\t\u0003\u0003:K!a\u0014\"\u0003\u001d){\u0017N\\5oO\u001a+\u0017\r^;sK\u0006a\u0003+Z4bgV\u001c(+Z2pe\u00124%/Y7f\r\u0016\fG/\u001e:f\u0015>LgnQ8oM&<7i\u001c8wKJ$XM\u001d\t\u0003K%\u0019\"!C\u0016\u0015\u0003E\u0003")
public class PegasusRecordFrameFeatureJoinConfigConverter {
    private final PegasusRecordSettingsConverter pegasusRecordSettingsConverter;
    private final String FEATURE_GROUP_NAME;

    private PegasusRecordSettingsConverter pegasusRecordSettingsConverter() {
        return this.pegasusRecordSettingsConverter;
    }

    public String FEATURE_GROUP_NAME() {
        return this.FEATURE_GROUP_NAME;
    }

    public FeatureJoinConfig convert(FrameFeatureJoinConfig frameFeatureJoinConfig) {
        Buffer joiningFeatures = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)frameFeatureJoinConfig.getFeatures()).asScala();
        Buffer features = (Buffer)joiningFeatures.map((Function1 & Serializable & scala.Serializable)feature -> this.convertFeature((JoiningFeature)feature), Buffer$.MODULE$.canBuildFrom());
        Map groups = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FEATURE_GROUP_NAME()), (Object)features)}));
        Option settings2 = Option$.MODULE$.apply((Object)frameFeatureJoinConfig.getSettings(GetMode.DEFAULT)).map((Function1 & Serializable & scala.Serializable)settings -> this.pegasusRecordSettingsConverter().convert((Settings)settings));
        return new FeatureJoinConfig((Map<String, Seq<KeyedFeatureList>>)groups, (Option<JoinConfigSettings>)settings2);
    }

    private KeyedFeatureList convertFeature(JoiningFeature feature) {
        Buffer keys = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)feature.getKeys()).asScala();
        None$ startDate = None$.MODULE$;
        None$ endDate = None$.MODULE$;
        None$ numDays = None$.MODULE$;
        None$ dateOffset = None$.MODULE$;
        if (feature.hasDateRange()) {
            JoiningFeature.DateRange dateRange = feature.getDateRange();
            if (dateRange.isAbsoluteDateRange()) {
                AbsoluteDateRange absoluteRange = dateRange.getAbsoluteDateRange();
                startDate = new Some((Object)PegasusRecordDateTimeConverter$.MODULE$.convertDate(absoluteRange.getStartDate(), OfflineDateTimeUtils$.MODULE$.DEFAULT_TIME_FORMAT()));
                endDate = new Some((Object)PegasusRecordDateTimeConverter$.MODULE$.convertDate(absoluteRange.getEndDate(), OfflineDateTimeUtils$.MODULE$.DEFAULT_TIME_FORMAT()));
            } else if (dateRange.isRelativeDateRange()) {
                RelativeDateRange relativeRange = dateRange.getRelativeDateRange();
                numDays = new Some((Object)PegasusRecordDateTimeConverter$.MODULE$.convertDuration(Predef$.MODULE$.Long2long(relativeRange.getNumDays()), TimeUnit.DAY));
                dateOffset = new Some((Object)PegasusRecordDateTimeConverter$.MODULE$.convertDuration(Predef$.MODULE$.Long2long(relativeRange.getDateOffset()), TimeUnit.DAY));
            } else {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, new StringBuilder(78).append("RelativeTimeRange and AbsoluteTimeRange are not set in DateRange ").append(dateRange).append(" of feature ").append(feature).append(".").toString());
            }
        }
        Option featureAliasName = Option$.MODULE$.apply((Object)feature.getFeatureAlias());
        Option overrideTimeDelay = Option$.MODULE$.apply((Object)feature.getOverrideTimeDelay(GetMode.DEFAULT)).map((Function1 & Serializable & scala.Serializable)delay -> PegasusRecordDateTimeConverter$.MODULE$.convertDuration(Predef$.MODULE$.Long2long(delay.getLength()), delay.getUnit()));
        return new KeyedFeatureList((Seq<String>)keys, (Seq<String>)((Seq)new .colon.colon((Object)feature.getFrameFeatureName(), (List)Nil$.MODULE$)), (Option<String>)startDate, (Option<String>)endDate, (Option<String>)dateOffset, (Option<String>)numDays, (Option<String>)overrideTimeDelay, (Option<String>)featureAliasName);
    }

    public PegasusRecordFrameFeatureJoinConfigConverter(PegasusRecordSettingsConverter pegasusRecordSettingsConverter) {
        this.pegasusRecordSettingsConverter = pegasusRecordSettingsConverter;
        this.FEATURE_GROUP_NAME = "FeatureJoinConfigConverterGeneratedGroupName";
    }
}

