/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.evaluator;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.exception.ErrorLabel;
import com.linkedin.feathr.exception.FeathrException;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.derived.DerivedFeature;
import com.linkedin.feathr.offline.derived.DerivedFeatureEvaluator;
import com.linkedin.feathr.offline.evaluator.BaseDataFrameMetadata;
import com.linkedin.feathr.offline.evaluator.DerivedFeatureGenStage$;
import com.linkedin.feathr.offline.evaluator.StageEvaluator;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.logical.FeatureGroups;
import com.linkedin.feathr.offline.logical.MultiStageJoinPlan;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!\u0002\u0007\u000e\u0001=9\u0002\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\u0006\u001b\u0002!\tE\u0014\u0005\u0006S\u0002!\tA\u001b\u0005\u0006o\u0002!I\u0001_\u0004\t\u0003Oi\u0001\u0012A\b\u0002*\u00199A\"\u0004E\u0001\u001f\u0005-\u0002BB$\n\t\u0003\ti\u0003C\u0004\u00020%!\t!!\r\u0003-\u0011+'/\u001b<fI\u001a+\u0017\r^;sK\u001e+gn\u0015;bO\u0016T!AD\b\u0002\u0013\u00154\u0018\r\\;bi>\u0014(B\u0001\t\u0012\u0003\u001dygM\u001a7j]\u0016T!AE\n\u0002\r\u0019,\u0017\r\u001e5s\u0015\t!R#\u0001\u0005mS:\\W\rZ5o\u0015\u00051\u0012aA2p[N\u0019\u0001\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\u0011y\u0002E\t\u0012\u000e\u00035I!!I\u0007\u0003\u001dM#\u0018mZ3Fm\u0006dW/\u0019;peB\u00111E\r\b\u0003IAr!!J\u0018\u000f\u0005\u0019rcBA\u0014.\u001d\tAC&D\u0001*\u0015\tQ3&\u0001\u0004=e>|GOP\u0002\u0001\u0013\u00051\u0012B\u0001\u000b\u0016\u0013\t\u00112#\u0003\u0002\u0011#%\u0011\u0011gD\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019DGA\fGK\u0006$XO]3ECR\fw+\u001b;i\u0015>LgnS3zg*\u0011\u0011gD\u0001\u000eM\u0016\fG/\u001e:f\u000fJ|W\u000f]:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ez\u0011a\u00027pO&\u001c\u0017\r\\\u0005\u0003wa\u0012QBR3biV\u0014Xm\u0012:pkB\u001c\u0018a\u00037pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u000e \n\u0005}B$AE'vYRL7\u000b^1hK*{\u0017N\u001c)mC:\f1\u0003Z3sSZ,GMR3biV\u0014X-\u0016;jYN\u0004\"AQ#\u000e\u0003\rS!\u0001R\b\u0002\u000f\u0011,'/\u001b<fI&\u0011ai\u0011\u0002\u0018\t\u0016\u0014\u0018N^3e\r\u0016\fG/\u001e:f\u000bZ\fG.^1u_J\fa\u0001P5oSRtD\u0003B%K\u00172\u0003\"a\b\u0001\t\u000bU\"\u0001\u0019\u0001\u001c\t\u000bq\"\u0001\u0019A\u001f\t\u000b\u0001#\u0001\u0019A!\u0002\u0011\u00154\u0018\r\\;bi\u0016$BAI(bO\")\u0001+\u0002a\u0001#\u0006Aa-Z1ukJ,7\u000fE\u0002S-fs!aU+\u000f\u0005!\"\u0016\"A\u000e\n\u0005ER\u0012BA,Y\u0005\r\u0019V-\u001d\u0006\u0003ci\u0001\"A\u00170\u000f\u0005mc\u0006C\u0001\u0015\u001b\u0013\ti&$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/\u001b\u0011\u0015\u0011W\u00011\u0001d\u0003\u001dYW-\u001f+bON\u00042A\u0015,e!\tIR-\u0003\u0002g5\t\u0019\u0011J\u001c;\t\u000b!,\u0001\u0019\u0001\u0012\u0002\u000f\r|g\u000e^3yi\u0006\u0011SM^1mk\u0006$XMQ1tK\u0012\u000bG/\u0019$sC6,gi\u001c:EKJLg/\u0019;j_:$Ba\u001b8qkB\u0011q\u0004\\\u0005\u0003[6\u0011QCQ1tK\u0012\u000bG/\u0019$sC6,W*\u001a;bI\u0006$\u0018\rC\u0003p\r\u0001\u0007\u0011,\u0001\neKJLg/\u001a3GK\u0006$XO]3OC6,\u0007\"B9\u0007\u0001\u0004\u0011\u0018!\u00053fe&4X\r\u001a$fCR,(/\u001a*fMB\u0011!i]\u0005\u0003i\u000e\u0013a\u0002R3sSZ,GMR3biV\u0014X\rC\u0003w\r\u0001\u0007!%A\tfm\u0006dW/\u0019;fI\u001a+\u0017\r^;sKN\fA\u0004\u001a:pa\u001a\u0013\u0018-\\3UC\u001e\u001c\u0018I\u001c3SK:\fW.Z\"pYVlg\u000eF\u0003z\u0003?\t\u0019\u0003E\u0002{\u00033q1a_A\u000b\u001d\ra\u0018q\u0002\b\u0004{\u0006%ab\u0001@\u0002\u00049\u0011\u0001f`\u0005\u0003\u0003\u0003\t1a\u001c:h\u0013\u0011\t)!a\u0002\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t!\u0003\u0003\u0002\f\u00055\u0011!B:qCJ\\'\u0002BA\u0003\u0003\u000fIA!!\u0005\u0002\u0014\u0005\u00191/\u001d7\u000b\t\u0005-\u0011QB\u0005\u0004c\u0005]!\u0002BA\t\u0003'IA!a\u0007\u0002\u001e\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004c\u0005]\u0001BBA\u0011\u000f\u0001\u0007\u00110\u0001\u0002eM\"1\u0011QE\u0004A\u0002e\u000b1BZ3biV\u0014XMT1nK\u00061B)\u001a:jm\u0016$g)Z1ukJ,w)\u001a8Ti\u0006<W\r\u0005\u0002 \u0013M\u0011\u0011\u0002\u0007\u000b\u0003\u0003S\tQ!\u00199qYf$r!SA\u001a\u0003k\t9\u0004C\u00036\u0017\u0001\u0007a\u0007C\u0003=\u0017\u0001\u0007Q\bC\u0003A\u0017\u0001\u0007\u0011\t")
public class DerivedFeatureGenStage
implements StageEvaluator<Map<String, Tuple2<FeatureDataFrame, Seq<String>>>, Map<String, Tuple2<FeatureDataFrame, Seq<String>>>> {
    private final FeatureGroups featureGroups;
    private final MultiStageJoinPlan logicalPlan;
    private final DerivedFeatureEvaluator derivedFeatureUtils;

    public static DerivedFeatureGenStage apply(FeatureGroups featureGroups, MultiStageJoinPlan multiStageJoinPlan, DerivedFeatureEvaluator derivedFeatureEvaluator) {
        return DerivedFeatureGenStage$.MODULE$.apply(featureGroups, multiStageJoinPlan, derivedFeatureEvaluator);
    }

    @Override
    public Map<String, Tuple2<FeatureDataFrame, Seq<String>>> evaluate(Seq<String> features, Seq<Object> keyTags, Map<String, Tuple2<FeatureDataFrame, Seq<String>>> context) {
        Map featureToDerivationMap = ((TraversableOnce)features.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2($this.featureGroups.allDerivedFeatures().apply(f), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Map)featureToDerivationMap.foldLeft(context, (Function2 & Serializable & scala.Serializable)(accumulator, currFeatureDerivation) -> {
            Tuple2 tuple2 = currFeatureDerivation;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DerivedFeature derivation = (DerivedFeature)tuple2._1();
            String derivedFeatureName = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)derivation, (Object)derivedFeatureName);
            Tuple2 tuple23 = tuple22;
            DerivedFeature derivation2 = (DerivedFeature)tuple23._1();
            String derivedFeatureName2 = (String)tuple23._2();
            String featureColumnName = DataFrameColName$.MODULE$.genFeatureColumnName(derivedFeatureName2, DataFrameColName$.MODULE$.genFeatureColumnName$default$2());
            BaseDataFrameMetadata baseDataFrameMetadata = this.evaluateBaseDataFrameForDerivation(derivedFeatureName2, derivation2, (Map<String, Tuple2<FeatureDataFrame, Seq<String>>>)accumulator);
            if (baseDataFrameMetadata == null) {
                throw new MatchError((Object)baseDataFrameMetadata);
            }
            FeatureDataFrame baseFeatureDataFrame = baseDataFrameMetadata.featureDataFrame();
            Seq<String> joinKeys = baseDataFrameMetadata.joinKeys();
            Seq<String> featuresOnBaseDf = baseDataFrameMetadata.featureNames();
            Tuple3 tuple3 = new Tuple3((Object)baseFeatureDataFrame, joinKeys, featuresOnBaseDf);
            Tuple3 tuple32 = tuple3;
            FeatureDataFrame baseFeatureDataFrame2 = (FeatureDataFrame)tuple32._1();
            Seq joinKeys2 = (Seq)tuple32._2();
            Seq featuresOnBaseDf2 = (Seq)tuple32._3();
            FeatureDataFrame derivedFeatureDataFrame = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])baseFeatureDataFrame2.df().columns())).contains((Object)featureColumnName) ? baseFeatureDataFrame2 : $this.derivedFeatureUtils.evaluate(keyTags, $this.logicalPlan.keyTagIntsToStrings(), baseFeatureDataFrame2.df(), derivation2);
            Dataset<Row> columnRenamedDf = this.dropFrameTagsAndRenameColumn(derivedFeatureDataFrame.df(), featureColumnName);
            Map updatedFeatureTypeMap = baseFeatureDataFrame2.inferredFeatureType().$plus$plus(derivedFeatureDataFrame.inferredFeatureType());
            Seq updatedFeaturesOnDf = (Seq)featuresOnBaseDf2.$colon$plus((Object)derivedFeatureName2, Seq$.MODULE$.canBuildFrom());
            return accumulator.$plus$plus((GenTraversableOnce)((TraversableOnce)updatedFeaturesOnDf.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f), (Object)new Tuple2((Object)new FeatureDataFrame(columnRenamedDf, (Map<String, FeatureTypeConfig>)updatedFeatureTypeMap), (Object)joinKeys2)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        });
    }

    public BaseDataFrameMetadata evaluateBaseDataFrameForDerivation(String derivedFeatureName, DerivedFeature derivedFeatureRef, Map<String, Tuple2<FeatureDataFrame, Seq<String>>> evaluatedFeatures) {
        Map featuresGroupedByDf = evaluatedFeatures.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> ((FeatureDataFrame)((Tuple2)x$3._2())._1()).df()).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> x$4.keySet());
        Seq consumedFeatures = (Seq)derivedFeatureRef.consumedFeatureNames().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getFeatureName().toString(), Seq$.MODULE$.canBuildFrom());
        if (!consumedFeatures.forall((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)evaluatedFeatures.contains((Object)key)))) {
            throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(100).append("Error when processing derived feature ").append(derivedFeatureName).append(". ").append("Requires following features to be generated [").append(consumedFeatures.mkString(", ")).append("], ").append("but found [").append(evaluatedFeatures.keySet().mkString(", ")).append("]").toString());
        }
        Tuple2 tuple2 = (Tuple2)evaluatedFeatures.apply(consumedFeatures.head());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FeatureDataFrame headFeatureDataFrame = (FeatureDataFrame)tuple2._1();
        Seq joinKeys = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)headFeatureDataFrame, (Object)joinKeys);
        Tuple2 tuple23 = tuple22;
        FeatureDataFrame headFeatureDataFrame2 = (FeatureDataFrame)tuple23._1();
        Seq joinKeys2 = (Seq)tuple23._2();
        BaseDataFrameMetadata initialBaseDataFrame = new BaseDataFrameMetadata(headFeatureDataFrame2, (Seq<String>)joinKeys2, (Seq<String>)((SetLike)featuresGroupedByDf.apply(headFeatureDataFrame2.df())).toSeq());
        Set set = (Set)featuresGroupedByDf.apply(headFeatureDataFrame2.df());
        return consumedFeatures.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem))) ? initialBaseDataFrame : (BaseDataFrameMetadata)((TraversableOnce)consumedFeatures.tail()).foldLeft((Object)initialBaseDataFrame, (Function2 & Serializable & scala.Serializable)(accumulator, consumedFeature) -> {
            FeatureDataFrame featureDataFrame = accumulator.featureDataFrame();
            if (featureDataFrame == null) {
                throw new MatchError((Object)featureDataFrame);
            }
            Dataset<Row> leftDf = featureDataFrame.df();
            Map<String, FeatureTypeConfig> leftFeatureType = featureDataFrame.inferredFeatureType();
            Tuple2 tuple2 = new Tuple2(leftDf, leftFeatureType);
            Tuple2 tuple22 = tuple2;
            Dataset leftDf2 = (Dataset)tuple22._1();
            Map leftFeatureType2 = (Map)tuple22._2();
            Tuple2 tuple23 = (Tuple2)evaluatedFeatures.apply(consumedFeature);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            FeatureDataFrame currentFeatureDataFrame = (FeatureDataFrame)tuple23._1();
            Seq currentJoinKey = (Seq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)currentFeatureDataFrame, (Object)currentJoinKey);
            Tuple2 tuple25 = tuple24;
            FeatureDataFrame currentFeatureDataFrame2 = (FeatureDataFrame)tuple25._1();
            Seq currentJoinKey2 = (Seq)tuple25._2();
            FeatureDataFrame featureDataFrame2 = currentFeatureDataFrame2;
            if (featureDataFrame2 == null) {
                throw new MatchError((Object)featureDataFrame2);
            }
            Dataset<Row> currentDf = featureDataFrame2.df();
            Map<String, FeatureTypeConfig> currFeatureType = featureDataFrame2.inferredFeatureType();
            Tuple2 tuple26 = new Tuple2(currentDf, currFeatureType);
            Tuple2 tuple27 = tuple26;
            Dataset currentDf2 = (Dataset)tuple27._1();
            Map currFeatureType2 = (Map)tuple27._2();
            Seq featuresOnCurrentDf = ((SetLike)featuresGroupedByDf.apply((Object)currentDf2)).toSeq();
            if (joinKeys2.size() != currentJoinKey2.size()) {
                throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(127).append("Error when processing derived feature ").append(derivedFeatureName).append(". ").append("Join Keys for dependent feature do not match. ").append("Expected join key: [").append(joinKeys2.mkString(", ")).append("], Found join key: [").append(currentJoinKey2.mkString(", ")).append("]").toString());
            }
            Seq rightJoinKey = (Seq)currentJoinKey2.map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(10).append((String)k).append("_right_key").toString(), Seq$.MODULE$.canBuildFrom());
            Dataset rightDataFrame = (Dataset)((TraversableOnce)currentJoinKey2.zip((GenIterable)rightJoinKey, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)currentDf2, (Function2 & Serializable & scala.Serializable)(accumulatorDf, keyPair) -> accumulatorDf.withColumnRenamed((String)keyPair._1(), (String)keyPair._2()));
            Column joinConditions = (Column)((TraversableOnce)((TraversableLike)joinKeys2.zip((GenIterable)rightJoinKey, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String leftKey = (String)tuple2._1();
                String rightKey = (String)tuple2._2();
                Column column = leftDf2.apply(leftKey).$eq$eq$eq((Object)rightDataFrame.apply(rightKey));
                return column;
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$10, x$11) -> x$10.and(x$11));
            Dataset joinedDataFrame = leftDf2.join(rightDataFrame, joinConditions, "full_outer");
            return new BaseDataFrameMetadata(new FeatureDataFrame((Dataset<Row>)joinedDataFrame.drop(rightJoinKey), (Map<String, FeatureTypeConfig>)leftFeatureType2.$plus$plus((GenTraversableOnce)currFeatureType2)), (Seq<String>)joinKeys2, (Seq<String>)((Seq)((SeqLike)accumulator.featureNames().$plus$plus((GenTraversableOnce)featuresOnCurrentDf, Seq$.MODULE$.canBuildFrom())).distinct()));
        });
    }

    private Dataset<Row> dropFrameTagsAndRenameColumn(Dataset<Row> df, String featureName) {
        String[] columnsInDf = df.columns();
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnsInDf)).find((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.contains(featureName)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new FeathrException(ErrorLabel.FEATHR_ERROR, new StringBuilder(85).append("Unexpected Intenal Error: Could not find feature column ").append(featureName).append(" ").append("in DataFrame with columns [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnsInDf)).mkString(", ")).append("]").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String x = (String)some.value();
        String y = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.split(FeatureTransformation$.MODULE$.FEATURE_TAGS_PREFIX()))).head();
        Dataset dataset = df.withColumnRenamed(x, y);
        return dataset;
    }

    public DerivedFeatureGenStage(FeatureGroups featureGroups, MultiStageJoinPlan logicalPlan, DerivedFeatureEvaluator derivedFeatureUtils) {
        this.featureGroups = featureGroups;
        this.logicalPlan = logicalPlan;
        this.derivedFeatureUtils = derivedFeatureUtils;
    }
}

