/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.evaluator.transformation;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SimpleConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.config.MVELFeatureDefinition;
import com.linkedin.feathr.offline.config.PegasusRecordFeatureTypeConverter$;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationOperator;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationOperatorUtils$;
import com.linkedin.feathr.offline.graph.FCMGraphTraverser;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.transformation.DataFrameBasedRowEvaluator$;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class LookupMVELOperator$
implements TransformationOperator {
    public static LookupMVELOperator$ MODULE$;

    static {
        new LookupMVELOperator$();
    }

    @Override
    public Dataset<Row> compute(Transformation node, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        Dataset dataset;
        String featureName = node.getFeatureName() == null ? (String)graphTraverser.nodeIdToFeatureName().apply((Object)node.getId()) : node.getFeatureName();
        Option<FeatureTypeConfig> featureTypeConfig = PegasusRecordFeatureTypeConverter$.MODULE$.apply().convert(node.getFeatureVersion());
        String mvelExpr = (String)node.getFunction().getParameters().get((Object)"expression");
        SimpleConfigurableAnchorExtractor mvelExtractor = new SimpleConfigurableAnchorExtractor((Seq<String>)((Seq)Nil$.MODULE$), (Map<String, MVELFeatureDefinition>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)new MVELFeatureDefinition(mvelExpr, featureTypeConfig))}))));
        Dataset transformedDf = DataFrameBasedRowEvaluator$.MODULE$.transform(mvelExtractor, contextDf, (Seq<Tuple2<String, String>>)((Seq)new .colon.colon((Object)new Tuple2((Object)featureName, (Object)""), (List)Nil$.MODULE$)), (Map<String, FeatureTypeConfig>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), featureTypeConfig.get())}))), graphTraverser.mvelExpressionContext()).df();
        Object object = graphTraverser.nodeIdToFeatureName().apply((Object)node.getId());
        String string = node.getFeatureName();
        if (object == null ? string != null : !object.equals(string)) {
            String featureAlias = (String)graphTraverser.nodeIdToFeatureName().apply((Object)node.getId());
            graphTraverser.featureColumnFormatsMap().update((Object)featureAlias, (Object)FeatureColumnFormat$.MODULE$.RAW());
            dataset = transformedDf.withColumn(featureAlias, functions$.MODULE$.col(featureName));
        } else {
            dataset = transformedDf;
        }
        Dataset result = dataset;
        return TransformationOperatorUtils$.MODULE$.updateDataframeMapAndApplyDefaults((Seq<Transformation>)((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)), graphTraverser, result, (Seq<String>)((Seq)Nil$.MODULE$));
    }

    @Override
    public Dataset<Row> batchCompute(Seq<Transformation> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> contextDf, List<DataPathHandler> dataPathHandlers) {
        return (Dataset)nodes.foldLeft(contextDf, (Function2 & Serializable & scala.Serializable)(newContextDf, node) -> MODULE$.compute((Transformation)node, graphTraverser, (Dataset<Row>)newContextDf, dataPathHandlers));
    }

    private LookupMVELOperator$() {
        MODULE$ = this;
    }
}

