/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.evaluator.transformation;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata$;
import com.linkedin.feathr.offline.graph.FCMGraphTraverser;
import com.linkedin.feathr.offline.graph.NodeUtils$;
import com.linkedin.feathr.offline.join.algorithms.EqualityJoinConditionBuilder$;
import com.linkedin.feathr.offline.join.algorithms.JoinType$;
import com.linkedin.feathr.offline.join.algorithms.SparkJoinWithJoinCondition$;
import com.linkedin.feathr.offline.transformation.DataFrameDefaultValueSubstituter$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TransformationOperatorUtils$ {
    public static TransformationOperatorUtils$ MODULE$;

    static {
        new TransformationOperatorUtils$();
    }

    public Tuple2<Dataset<Row>, Seq<String>> dropAndRenameCols(Dataset<Row> df, Seq<String> keyCols, Seq<String> featureName) {
        String[] toDropCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).diff((GenSeq)keyCols.$plus$plus(featureName, Seq$.MODULE$.canBuildFrom()));
        Dataset modifiedDf = df.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])toDropCols));
        Seq renamedKeyColumns = (Seq)keyCols.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(22).append("__frame__key__column__").append((String)c).toString(), Seq$.MODULE$.canBuildFrom());
        Map oldKeyColToNewKeyCOl = ((TraversableOnce)keyCols.zip((GenIterable)renamedKeyColumns, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Dataset withRenamedColsDF = modifiedDf.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modifiedDf.columns())).map((Function1 & Serializable & scala.Serializable)c -> modifiedDf.apply(c).alias((String)oldKeyColToNewKeyCOl.getOrElse(c, (Function0 & Serializable & scala.Serializable)() -> c)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        return new Tuple2((Object)withRenamedColsDF, (Object)renamedKeyColumns);
    }

    public Dataset<Row> createFeatureDF(Dataset<Row> inputDf, Seq<Tuple2<String, Column>> featureColumnDefs) {
        String featureColumnNamePrefix = "_frame_sql_feature_prefix_";
        Dataset transformedDF = (Dataset)featureColumnDefs.foldLeft(inputDf, (Function2 & Serializable & scala.Serializable)(baseDF, columnWithName) -> {
            String columnName = new StringBuilder(0).append(featureColumnNamePrefix).append(columnWithName._1()).toString();
            return baseDF.withColumn(columnName, functions$.MODULE$.expr(((Column)columnWithName._2()).toString()));
        });
        Seq featureNames = (Seq)featureColumnDefs.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Seq$.MODULE$.canBuildFrom());
        Dataset withoutDupContextFieldDF = transformedDF.drop(featureNames);
        return (Dataset)((TraversableOnce)featureNames.zip((GenIterable)featureNames, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)withoutDupContextFieldDF, (Function2 & Serializable & scala.Serializable)(baseDF, namePair) -> baseDF.withColumnRenamed(new StringBuilder(0).append(featureColumnNamePrefix).append(namePair._1()).toString(), (String)namePair._2()));
    }

    public Dataset<Row> joinResultToContextDfAndApplyDefaults(Seq<Transformation> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> resultDf, Seq<String> resultKeyColumns, Dataset<Row> contextDf) {
        Dataset<Row> dataset;
        Seq featureNamesInBatch = (Seq)nodes.map((Function1 & Serializable & scala.Serializable)node -> (String)graphTraverser.nodeIdToFeatureName().apply((Object)node.getId()), Seq$.MODULE$.canBuildFrom());
        nodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
            TransformationOperatorUtils$.$anonfun$joinResultToContextDfAndApplyDefaults$2(graphTraverser, resultDf, resultKeyColumns, node);
            return BoxedUnit.UNIT;
        });
        Buffer concreteKeys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)((Transformation)nodes.head()).getConcreteKey().getKey()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x -> ((DataframeAndColumnMetadata)graphTraverser.nodeIdToDataframeAndColumnMetadataMap().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).featureColumn().isDefined() ? (Seq)new .colon.colon((Object)((String)((DataframeAndColumnMetadata)graphTraverser.nodeIdToDataframeAndColumnMetadataMap().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).featureColumn().get()), (List)Nil$.MODULE$) : ((DataframeAndColumnMetadata)graphTraverser.nodeIdToDataframeAndColumnMetadataMap().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).keyExpression(), Buffer$.MODULE$.canBuildFrom());
        Map<String, FeatureTypeConfig> featureTypeConfigs = NodeUtils$.MODULE$.getFeatureTypeConfigsMapForTransformationNodes(nodes);
        Map<String, FeatureValue> defaultConverter = NodeUtils$.MODULE$.getDefaultConverterForTransformationNodes(nodes);
        Buffer allLookupExpansionNodes = (Buffer)((TraversableLike)graphTraverser.nodes().filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)TransformationOperatorUtils$.$anonfun$joinResultToContextDfAndApplyDefaults$4(node)))).map((Function1 & Serializable & scala.Serializable)node -> node.getLookup().getLookupNode(), Buffer$.MODULE$.canBuildFrom());
        boolean isLookupExpansionGroup = nodes.forall((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)allLookupExpansionNodes.contains((Object)node.getId())));
        if (isLookupExpansionGroup) {
            Dataset<Row> withDefaultsDf = DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults(resultDf, (Seq<String>)featureNamesInBatch, defaultConverter, featureTypeConfigs, graphTraverser.ss(), DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults$default$6());
            nodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
                TransformationOperatorUtils$.$anonfun$joinResultToContextDfAndApplyDefaults$7(graphTraverser, withDefaultsDf, resultKeyColumns, node);
                return BoxedUnit.UNIT;
            });
            dataset = contextDf;
        } else {
            Dataset newContextDf = (Dataset)featureNamesInBatch.foldLeft(contextDf, (Function2 & Serializable & scala.Serializable)(currContextDf, featureName) -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currContextDf.columns())).contains(featureName) ? currContextDf.drop(featureName) : currContextDf);
            Dataset result = SparkJoinWithJoinCondition$.MODULE$.apply(EqualityJoinConditionBuilder$.MODULE$).join((Seq<String>)concreteKeys, (Dataset<Row>)newContextDf, resultKeyColumns, resultDf, JoinType$.MODULE$.left_outer()).drop(resultKeyColumns);
            dataset = DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults((Dataset<Row>)result, (Seq<String>)featureNamesInBatch, defaultConverter, featureTypeConfigs, graphTraverser.ss(), DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults$default$6());
        }
        return dataset;
    }

    public Dataset<Row> updateDataframeMapAndApplyDefaults(Seq<Transformation> nodes, FCMGraphTraverser graphTraverser, Dataset<Row> resultDf, Seq<String> resultKeyColumns) {
        nodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
            TransformationOperatorUtils$.$anonfun$updateDataframeMapAndApplyDefaults$1(graphTraverser, resultDf, resultKeyColumns, node);
            return BoxedUnit.UNIT;
        });
        Seq featureNamesInBatch = (Seq)nodes.map((Function1 & Serializable & scala.Serializable)node -> (String)graphTraverser.nodeIdToFeatureName().apply((Object)node.getId()), Seq$.MODULE$.canBuildFrom());
        Map<String, FeatureTypeConfig> featureTypeConfigs = NodeUtils$.MODULE$.getFeatureTypeConfigsMapForTransformationNodes(nodes);
        Map<String, FeatureValue> defaultConverter = NodeUtils$.MODULE$.getDefaultConverterForTransformationNodes(nodes);
        return DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults(resultDf, (Seq<String>)featureNamesInBatch, defaultConverter, featureTypeConfigs, graphTraverser.ss(), DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults$default$6());
    }

    public static final /* synthetic */ void $anonfun$joinResultToContextDfAndApplyDefaults$2(FCMGraphTraverser graphTraverser$1, Dataset resultDf$1, Seq resultKeyColumns$1, Transformation node) {
        graphTraverser$1.nodeIdToDataframeAndColumnMetadataMap().update((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(node.getId())), (Object)new DataframeAndColumnMetadata((Dataset<Row>)resultDf$1, (Seq<String>)resultKeyColumns$1, (Option<String>)new Some(graphTraverser$1.nodeIdToFeatureName().apply((Object)node.getId())), DataframeAndColumnMetadata$.MODULE$.apply$default$4(), DataframeAndColumnMetadata$.MODULE$.apply$default$5()));
    }

    public static final /* synthetic */ boolean $anonfun$joinResultToContextDfAndApplyDefaults$4(AnyNode node) {
        return node.getLookup() != null;
    }

    public static final /* synthetic */ void $anonfun$joinResultToContextDfAndApplyDefaults$7(FCMGraphTraverser graphTraverser$1, Dataset withDefaultsDf$1, Seq resultKeyColumns$1, Transformation node) {
        graphTraverser$1.nodeIdToDataframeAndColumnMetadataMap().update((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(node.getId())), (Object)new DataframeAndColumnMetadata((Dataset<Row>)withDefaultsDf$1, (Seq<String>)resultKeyColumns$1, (Option<String>)new Some(graphTraverser$1.nodeIdToFeatureName().apply((Object)node.getId())), DataframeAndColumnMetadata$.MODULE$.apply$default$4(), DataframeAndColumnMetadata$.MODULE$.apply$default$5()));
    }

    public static final /* synthetic */ void $anonfun$updateDataframeMapAndApplyDefaults$1(FCMGraphTraverser graphTraverser$2, Dataset resultDf$2, Seq resultKeyColumns$2, Transformation node) {
        graphTraverser$2.nodeIdToDataframeAndColumnMetadataMap().update((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(node.getId())), (Object)new DataframeAndColumnMetadata((Dataset<Row>)resultDf$2, (Seq<String>)resultKeyColumns$2, (Option<String>)new Some(graphTraverser$2.nodeIdToFeatureName().apply((Object)node.getId())), DataframeAndColumnMetadata$.MODULE$.apply$default$4(), DataframeAndColumnMetadata$.MODULE$.apply$default$5()));
    }

    private TransformationOperatorUtils$() {
        MODULE$ = this;
    }
}

