/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.generation;

import com.databricks.spark.avro.SchemaConverters$;
import com.linkedin.feathr.common.FeatureInfo;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.configObj.generation.OutputProcessorConfig;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.offline.generation.FeatureDataHDFSProcessUtils$;
import com.linkedin.feathr.offline.generation.RawDataWriterUtils$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.util.FeatureGenConstants$;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;

public final class FeatureDataHDFSProcessUtils$ {
    public static FeatureDataHDFSProcessUtils$ MODULE$;
    private final String useFloatInNTV;
    private final String valueSchemaFieldZName;
    private final String keySchemaFieldName;
    private final String featureNameField;

    static {
        new FeatureDataHDFSProcessUtils$();
    }

    public Tuple2<Dataset<Row>, Header> processFeatureDataHDFS(SparkSession ss, Map<TaggedFeatureName, Tuple2<Dataset<Row>, Header>> groupedFeatureToDF, String parentPath, OutputProcessorConfig config, boolean skipWrite, Option<String> endTimeOpt, Option<String> timestampOpt, List<DataLoaderHandler> dataLoaderHandlers) {
        Predef$.MODULE$.assert(((SeqLike)((TraversableOnce)groupedFeatureToDF.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)FeatureDataHDFSProcessUtils$.$anonfun$processFeatureDataHDFS$1(x$1)), Iterable$.MODULE$.canBuildFrom())).toSeq().distinct()).size() == 1);
        Predef$.MODULE$.assert(((SeqLike)((TraversableOnce)groupedFeatureToDF.map((Function1 & Serializable & scala.Serializable)x$2 -> (Dataset)((Tuple2)x$2._2())._1(), Iterable$.MODULE$.canBuildFrom())).toSeq().distinct()).size() == 1);
        Option<Number> outputParts = package$.MODULE$.RichConfig(config.getParams()).getNumberOpt("num-parts");
        boolean saveSchemaMeta = package$.MODULE$.RichConfig(config.getParams()).getBooleanWithDefault(FeatureGenConstants$.MODULE$.SAVE_SCHEMA_META(), false);
        Map featureHeaderMap = groupedFeatureToDF.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> (Header)x$3._2());
        Tuple2 tuple2 = (Tuple2)((Tuple2)groupedFeatureToDF.head())._2();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset df = (Dataset)tuple2._1();
        Header header = (Header)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)df, (Object)header);
        Tuple2 tuple23 = tuple22;
        Dataset df2 = (Dataset)tuple23._1();
        Header header2 = (Header)tuple23._2();
        return skipWrite ? new Tuple2<Dataset<Row>, Header>((Object)df2, (Object)header2) : RawDataWriterUtils$.MODULE$.writeFdsDataToDisk(ss, (Map<TaggedFeatureName, Header>)featureHeaderMap, parentPath, outputParts, endTimeOpt, saveSchemaMeta, (Dataset<Row>)df2, header2, dataLoaderHandlers);
    }

    public boolean processFeatureDataHDFS$default$5() {
        return false;
    }

    public Schema convertToAvroSchema(StructType sqlSchema, String recordName, String nameSpace) {
        SchemaBuilder.RecordBuilder build = (SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)recordName).namespace(nameSpace);
        Schema schema = (Schema)SchemaConverters$.MODULE$.convertStructToAvro(sqlSchema, build, nameSpace);
        return schema;
    }

    public String convertToAvroSchema$default$2() {
        return "topLevelRecord";
    }

    public String convertToAvroSchema$default$3() {
        return "";
    }

    public void writeSchemaToDisk(SparkSession ss, Schema schema, String path) {
        String outputSchemaString = schema.toString(false);
        RDD schemaFileRDD = ss.sparkContext().parallelize((Seq)new .colon.colon((Object)outputSchemaString, (List)Nil$.MODULE$), ss.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)).repartition(1, (Ordering)Ordering.String$.MODULE$);
        HdfsUtils$.MODULE$.deletePath(path, true, HdfsUtils$.MODULE$.deletePath$default$3());
        schemaFileRDD.saveAsTextFile(path);
    }

    public void writeHeaderDataToDF(SparkSession ss, Map<TaggedFeatureName, Header> featureHeaderMap, String metaPath) {
        String featuresList = ((TraversableOnce)featureHeaderMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaggedFeatureName taggedFeatureName = (TaggedFeatureName)tuple2._1();
            String string = taggedFeatureName.getFeatureName();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        String featureListOutputStr = new StringBuilder(12).append("features: [").append(featuresList).append("]").toString();
        Seq featureBasicInfo = ((TraversableOnce)featureHeaderMap.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaggedFeatureName taggedFeatureName = (TaggedFeatureName)tuple2._1();
            Header dataframeWithHeader = (Header)tuple2._2();
            FeatureInfo featureInfo = (FeatureInfo)dataframeWithHeader.featureInfoMap().apply((Object)taggedFeatureName);
            String featureInfoStr = featureInfo.toString();
            Tuple3 tuple3 = new Tuple3((Object)taggedFeatureName.toString(), (Object)featureInfoStr, (Object)featureListOutputStr);
            return tuple3;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_linkedin_feathr_offline_generation_FeatureDataHDFSProcessUtils$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Com_linkedin_feathr_offline_generation_FeatureDataHDFSProcessUtils$$typecreator5$1() {
            }
        }
        Dataset metaDF = ss.implicits().localSeqToDatasetHolder(featureBasicInfo, ss.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_linkedin_feathr_offline_generation_FeatureDataHDFSProcessUtils$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"taggedFeatureName", "header", "features"}));
        metaDF.write().mode("overwrite").format("com.databricks.spark.csv").option("header", "true").save(metaPath);
    }

    public String useFloatInNTV() {
        return this.useFloatInNTV;
    }

    public String valueSchemaFieldZName() {
        return this.valueSchemaFieldZName;
    }

    public String keySchemaFieldName() {
        return this.keySchemaFieldName;
    }

    public String featureNameField() {
        return this.featureNameField;
    }

    public final String metaHeaderColumnName() {
        return "taggedFeatureName";
    }

    public final String NUM_PARTS() {
        return "num-parts";
    }

    public static final /* synthetic */ int $anonfun$processFeatureDataHDFS$1(Tuple2 x$1) {
        return ((TaggedFeatureName)x$1._1()).getKeyTag().size();
    }

    private FeatureDataHDFSProcessUtils$() {
        MODULE$ = this;
        this.useFloatInNTV = "useFloatInNTV";
        this.valueSchemaFieldZName = "featureList";
        this.keySchemaFieldName = "key";
        this.featureNameField = "featureName";
    }
}

