/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.generation;

import com.linkedin.avroutil1.compatibility.AvroCompatibilityHelper;
import com.linkedin.feathr.common.Header;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrDataOutputException;
import com.linkedin.feathr.offline.generation.FeatureDataHDFSProcessUtils$;
import com.linkedin.feathr.offline.generation.FeatureGenUtils$;
import com.linkedin.feathr.offline.generation.FeatureGenerationPathName$;
import com.linkedin.feathr.offline.generation.SparkIOUtils$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.SourceUtils$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public final class RawDataWriterUtils$ {
    public static RawDataWriterUtils$ MODULE$;

    static {
        new RawDataWriterUtils$();
    }

    public Tuple2<Dataset<Row>, Header> writeFdsDataToDisk(SparkSession ss, Map<TaggedFeatureName, Header> featureHeaderMap, String parentPath, Option<Number> outputParts, Option<String> endTimeOpt, boolean saveSchemaMeta, Dataset<Row> df, Header header, List<DataLoaderHandler> dataLoaderHandlers) {
        String dataPath = FeatureGenerationPathName$.MODULE$.getDataPath(parentPath, endTimeOpt);
        String metaPath = FeatureGenerationPathName$.MODULE$.getMetaPath(parentPath, endTimeOpt);
        String schemaPath = FeatureGenerationPathName$.MODULE$.getSchemaPath(parentPath, endTimeOpt);
        String tempParentPath = new StringBuilder(7).append(parentPath).append("/_temp_").toString();
        String tempDataPath = FeatureGenerationPathName$.MODULE$.getDataPath(tempParentPath, endTimeOpt);
        Option numPartsParams = outputParts.map((Function1 & Serializable & scala.Serializable)numParts -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkIOUtils$.MODULE$.OUTPUT_PARALLELISM()), (Object)Integer.toString(numParts.intValue()))})));
        Map parameters = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkIOUtils$.MODULE$.OVERWRITE_MODE()), (Object)"ALL")}))).$plus$plus((GenTraversableOnce)numPartsParams.getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
        SourceUtils$.MODULE$.safeWriteDF(df, tempDataPath, (Map<String, String>)parameters, dataLoaderHandlers);
        Dataset<Row> outputDF = df;
        HdfsUtils$.MODULE$.hdfsCreateDirectoriesAsNeeded(dataPath, HdfsUtils$.MODULE$.hdfsCreateDirectoriesAsNeeded$default$2());
        HdfsUtils$.MODULE$.deletePath(dataPath, true, HdfsUtils$.MODULE$.deletePath$default$3());
        if (HdfsUtils$.MODULE$.exists(tempDataPath, HdfsUtils$.MODULE$.exists$default$2()) && !HdfsUtils$.MODULE$.renamePath(tempDataPath, dataPath, HdfsUtils$.MODULE$.renamePath$default$3())) {
            throw new FeathrDataOutputException(ErrorLabel.FEATHR_ERROR, new StringBuilder(104).append("Trying to rename temp path to target path.").append("Rename ").append(tempDataPath).append(" to ").append(dataPath).append(" failed").append("This is likely a system error. Please retry.").toString());
        }
        HdfsUtils$.MODULE$.deletePath(tempParentPath, true, HdfsUtils$.MODULE$.deletePath$default$3());
        if (saveSchemaMeta) {
            Seq<String> keyColumns = FeatureGenUtils$.MODULE$.getKeyColumnsFromHeader(header);
            StructType keySqlSchema = outputDF.select((String)keyColumns.head(), (Seq)keyColumns.tail()).schema();
            String[] valueColumns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputDF.columns())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RawDataWriterUtils$.$anonfun$writeFdsDataToDisk$3(keyColumns, x$1)));
            Schema keyAvroSchema = FeatureDataHDFSProcessUtils$.MODULE$.convertToAvroSchema(keySqlSchema, FeatureDataHDFSProcessUtils$.MODULE$.convertToAvroSchema$default$2(), FeatureDataHDFSProcessUtils$.MODULE$.convertToAvroSchema$default$3());
            StructType valueSqlSchema = outputDF.select((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])valueColumns)).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])valueColumns)).tail())).schema();
            Schema valueAvroSchema = FeatureDataHDFSProcessUtils$.MODULE$.convertToAvroSchema(valueSqlSchema, FeatureDataHDFSProcessUtils$.MODULE$.convertToAvroSchema$default$2(), FeatureDataHDFSProcessUtils$.MODULE$.convertToAvroSchema$default$3());
            Schema schema = this.makeOutputSchema(keyAvroSchema, valueAvroSchema);
            FeatureDataHDFSProcessUtils$.MODULE$.writeSchemaToDisk(ss, schema, schemaPath);
            FeatureDataHDFSProcessUtils$.MODULE$.writeHeaderDataToDF(ss, featureHeaderMap, metaPath);
        }
        return new Tuple2(outputDF, (Object)header);
    }

    /*
     * WARNING - void declaration
     */
    private Schema makeOutputSchema(Schema keySchema, Schema valueSchema) {
        void var3_3;
        Schema outputSchema = Schema.createRecord((String)new StringBuilder(11).append("AnonRecord_").append(Integer.toHexString(valueSchema.hashCode())).toString(), null, null, (boolean)false);
        Schema.Field outputKeySchemaField = this.makeSingleWrappedSchema(keySchema, "keyTags", FeatureDataHDFSProcessUtils$.MODULE$.keySchemaFieldName());
        Schema.Field outputValueSchemaField = this.makeSingleWrappedSchema(valueSchema, "features", FeatureDataHDFSProcessUtils$.MODULE$.valueSchemaFieldZName());
        outputSchema.setFields(package$.MODULE$.wrapAll().deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)outputKeySchemaField, (List)new .colon.colon((Object)outputValueSchemaField, (List)Nil$.MODULE$))));
        return var3_3;
    }

    private Schema.Field makeSingleWrappedSchema(Schema schema, String recordName, String wrapperName) {
        Buffer outputKeySchemaFields = (Buffer)((WrapAsScala)package$.MODULE$.wrapAll()).deprecated$u0020asScalaBuffer(schema.getFields()).map((Function1 & Serializable & scala.Serializable)f -> AvroCompatibilityHelper.createSchemaField((String)f.name(), (Schema)f.schema(), (String)f.doc(), (Object)SourceUtils$.MODULE$.getDefaultValueFromAvroRecord((Schema.Field)f), (Schema.Field.Order)f.order()), Buffer$.MODULE$.canBuildFrom());
        Schema outputKeySchema = Schema.createRecord((String)recordName, null, null, (boolean)false);
        outputKeySchema.setFields(package$.MODULE$.wrapAll().deprecated$u0020bufferAsJavaList(outputKeySchemaFields));
        return AvroCompatibilityHelper.createSchemaField((String)wrapperName, (Schema)outputKeySchema, null, null);
    }

    public static final /* synthetic */ boolean $anonfun$writeFdsDataToDisk$3(Seq keyColumns$1, String x$1) {
        return !keyColumns$1.contains((Object)x$1);
    }

    private RawDataWriterUtils$() {
        MODULE$ = this;
    }
}

