/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.graph;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.compute.ComputeGraph;
import com.linkedin.feathr.compute.Dependencies;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.client.IN_PROGRESS$;
import com.linkedin.feathr.offline.client.NOT_VISITED$;
import com.linkedin.feathr.offline.client.VISITED$;
import com.linkedin.feathr.offline.client.VisitedState;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.evaluator.aggregation.AggregationNodeEvaluator$;
import com.linkedin.feathr.offline.evaluator.datasource.DataSourceNodeEvaluator$;
import com.linkedin.feathr.offline.evaluator.lookup.LookupNodeEvaluator$;
import com.linkedin.feathr.offline.evaluator.transformation.TransformationNodeEvaluator$;
import com.linkedin.feathr.offline.graph.DataframeAndColumnMetadata;
import com.linkedin.feathr.offline.graph.NodeGrouper$;
import com.linkedin.feathr.offline.graph.NodeUtils$;
import com.linkedin.feathr.offline.graph.TimeConfigSettings;
import com.linkedin.feathr.offline.job.FeatureTransformation$;
import com.linkedin.feathr.offline.mvel.plugins.FeathrExpressionExecutionContext;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u000bi\u0004A\u0011A>\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\u000f\u0001\u0001\u0006I!!\u0004\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA \u0001\u0001\u0006I!a\t\t\u0013\u0005\u0005\u0003A1A\u0005\u0002\u0005\r\u0003\u0002CA?\u0001\u0001\u0006I!!\u0012\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005\u0005\u0005\u0002CAH\u0001\u0001\u0006I!a!\t\u0013\u0005E\u0005A1A\u0005\u0002\u0005M\u0005\u0002CAV\u0001\u0001\u0006I!!&\t\u0013\u00055\u0006A1A\u0005\u0002\u0005=\u0006bBAY\u0001\u0001\u0006Ia\u001c\u0005\n\u0003g\u0003!\u0019!C\u0001\u0003kC\u0001\"!0\u0001A\u0003%\u0011q\u0017\u0005\n\u0003\u007f\u0003!\u0019!C\u0001\u0003\u0003Dq!a1\u0001A\u0003%\u0001\u0007C\u0004\u0002F\u0002!I!!.\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAy\u0001\u0011\u0005\u00111\u001f\u0002\u0012\r\u000ekuI]1qQR\u0013\u0018M^3sg\u0016\u0014(B\u0001\u0010 \u0003\u00159'/\u00199i\u0015\t\u0001\u0013%A\u0004pM\u001ad\u0017N\\3\u000b\u0005\t\u001a\u0013A\u00024fCRD'O\u0003\u0002%K\u0005AA.\u001b8lK\u0012LgNC\u0001'\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0012S:\u0004X\u000f^*qCJ\\7+Z:tS>t\u0007CA\u0019;\u001b\u0005\u0011$BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\nQa\u001d9be.T!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO&\u00111H\r\u0002\r'B\f'o[*fgNLwN\\\u0001\u0012M\u0016\fG/\u001e:f\u0015>LgnQ8oM&<\u0007C\u0001 B\u001b\u0005y$B\u0001! \u0003\u0019\u0019wN\u001c4jO&\u0011!i\u0010\u0002\u0012\r\u0016\fG/\u001e:f\u0015>LgnQ8oM&<\u0017!\u0004:fg>dg/\u001a3He\u0006\u0004\b\u000e\u0005\u0002F\u00116\taI\u0003\u0002HC\u000591m\\7qkR,\u0017BA%G\u00051\u0019u.\u001c9vi\u0016<%/\u00199i\u00035y'm]3sm\u0006$\u0018n\u001c8EMB\u0011AJ\u0017\b\u0003\u001bbs!AT,\u000f\u0005=3fB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019v%\u0001\u0004=e>|GOP\u0005\u0002s%\u0011q\u0007O\u0005\u0003kYJ!a\r\u001b\n\u0005e\u0013\u0014a\u00029bG.\fw-Z\u0005\u00037r\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005e\u0013\u0014\u0001\u00053bi\u0006\u0004\u0016\r\u001e5IC:$G.\u001a:t!\ry6M\u001a\b\u0003A\nt!!U1\n\u00031J!!W\u0016\n\u0005\u0011,'\u0001\u0002'jgRT!!W\u0016\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001C1dG\u0016\u001c8o\u001c:\u000b\u0005-|\u0012AB:pkJ\u001cW-\u0003\u0002nQ\nyA)\u0019;b!\u0006$\b\u000eS1oI2,'/A\u0006nm\u0016d7i\u001c8uKb$\bc\u0001\u0016qe&\u0011\u0011o\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018a\u00029mk\u001eLgn\u001d\u0006\u0003o~\tA!\u001c<fY&\u0011\u0011\u0010\u001e\u0002!\r\u0016\fG\u000f\u001b:FqB\u0014Xm]:j_:,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\fyz|\u0018\u0011AA\u0002\u0003\u000b\t9\u0001\u0005\u0002~\u00015\tQ\u0004C\u00030\u000f\u0001\u0007\u0001\u0007C\u0003=\u000f\u0001\u0007Q\bC\u0003D\u000f\u0001\u0007A\tC\u0003K\u000f\u0001\u00071\nC\u0003^\u000f\u0001\u0007a\fC\u0003o\u000f\u0001\u0007q.A\u0002m_\u001e,\"!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005)An\\45U*\u0019\u0011q\u0003\u001c\u0002\u000f1|wmZ5oO&!\u00111DA\t\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u0015rw\u000eZ3JIR{G)\u0019;bMJ\fW.Z!oI\u000e{G.^7o\u001b\u0016$\u0018\rZ1uC6\u000b\u0007/\u0006\u0002\u0002$AA\u0011QEA\u0018\u0003g\tI$\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003\u001diW\u000f^1cY\u0016T1!!\f,\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\t9CA\u0004ICNDW*\u00199\u0011\u0007)\n)$C\u0002\u00028-\u00121!\u00138u!\ri\u00181H\u0005\u0004\u0003{i\"A\u0007#bi\u00064'/Y7f\u0003:$7i\u001c7v[:lU\r^1eCR\f\u0017A\n8pI\u0016LE\rV8ECR\fgM]1nK\u0006sGmQ8mk6tW*\u001a;bI\u0006$\u0018-T1qA\u00059b-Z1ukJ,7i\u001c7v[:4uN]7biNl\u0015\r]\u000b\u0003\u0003\u000b\u0002\u0002\"!\n\u00020\u0005\u001d\u0013q\u000b\t\u0005\u0003\u0013\n\tF\u0004\u0003\u0002L\u00055\u0003CA),\u0013\r\tyeK\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0013Q\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=3\u0006\u0005\u0003\u0002Z\u0005]d\u0002BA.\u0003crA!!\u0018\u0002n9!\u0011qLA6\u001d\u0011\t\t'!\u001b\u000f\t\u0005\r\u0014q\r\b\u0004#\u0006\u0015\u0014\"\u0001\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\t\u0001\u0013%C\u0002\u0002p}\ta\u0002\u001e:b]N4wN]7bi&|g.\u0003\u0003\u0002t\u0005U\u0014a\u0005$fCR,(/Z\"pYVlgNR8s[\u0006$(bAA8?%!\u0011\u0011PA>\u0005M1U-\u0019;ve\u0016\u001cu\u000e\\;n]\u001a{'/\\1u\u0015\u0011\t\u0019(!\u001e\u00021\u0019,\u0017\r^;sK\u000e{G.^7o\r>\u0014X.\u0019;t\u001b\u0006\u0004\b%A\u0003o_\u0012,7/\u0006\u0002\u0002\u0004B1\u0011QEAC\u0003\u0013KA!a\"\u0002(\t1!)\u001e4gKJ\u00042!RAF\u0013\r\tiI\u0012\u0002\b\u0003:Lhj\u001c3f\u0003\u0019qw\u000eZ3tA\u0005\u0019bn\u001c3f\u0013\u0012$vNR3biV\u0014XMT1nKV\u0011\u0011Q\u0013\t\t\u0003\u0013\n9*a'\u0002H%!\u0011\u0011TA+\u0005\ri\u0015\r\u001d\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0016\u0001\u00026bm\u0006LA!!+\u0002 \n9\u0011J\u001c;fO\u0016\u0014\u0018\u0001\u00068pI\u0016LE\rV8GK\u0006$XO]3OC6,\u0007%A\u000bnm\u0016dW\t\u001f9sKN\u001c\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003=\fa#\u001c<fY\u0016C\bO]3tg&|gnQ8oi\u0016DH\u000fI\u0001\u0013i&lWmQ8oM&<7+\u001a;uS:<7/\u0006\u0002\u00028B\u0019Q0!/\n\u0007\u0005mVD\u0001\nUS6,7i\u001c8gS\u001e\u001cV\r\u001e;j]\u001e\u001c\u0018a\u0005;j[\u0016\u001cuN\u001c4jON+G\u000f^5oON\u0004\u0013AA:t+\u0005\u0001\u0014aA:tA\u0005yq-\u001a;K_&t7+\u001a;uS:<7/A\rhKRtu\u000eZ3JIR{g)Z1ukJ,g*Y7f\u001b\u0006\u0004H\u0003BAK\u0003\u0017Dq!a \u001a\u0001\u0004\t\u0019)A\rhKR,fNZ5oSNDW\r\u001a#fa\u0016tG-\u001a8dS\u0016\u001cHCBAi\u0003/\fY\u000e\u0005\u0004\u0002J\u0005M\u00171T\u0005\u0005\u0003+\f)FA\u0002TKRDq!!7\u001b\u0001\u0004\tI)\u0001\u0003o_\u0012,\u0007bBAo5\u0001\u0007\u0011q\\\u0001\rm&\u001c\u0018\u000e^3e'R\fG/\u001a\t\u0006U\u0005\u0005\u0018Q]\u0005\u0004\u0003G\\#!B!se\u0006L\b\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-x$\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003_\fIO\u0001\u0007WSNLG/\u001a3Ti\u0006$X-A\u0007ue\u00064XM]:f\u000fJ\f\u0007\u000f\u001b\u000b\u0003\u0003k\u0004B!a>\u0002z6\tq$C\u0002\u0002|~\u0011\u0001CR3biV\u0014X\rR1uC\u001a\u0013\u0018-\\3")
public class FCMGraphTraverser {
    private final FeatureJoinConfig featureJoinConfig;
    private final ComputeGraph resolvedGraph;
    private final Dataset<Row> observationDf;
    private final List<DataPathHandler> dataPathHandlers;
    private final Logger log;
    private final HashMap<Object, DataframeAndColumnMetadata> nodeIdToDataframeAndColumnMetadataMap;
    private final HashMap<String, Enumeration.Value> featureColumnFormatsMap;
    private final Buffer<AnyNode> nodes;
    private final scala.collection.immutable.Map<Integer, String> nodeIdToFeatureName;
    private final Option<FeathrExpressionExecutionContext> mvelExpressionContext;
    private final TimeConfigSettings timeConfigSettings;
    private final SparkSession ss;

    private Logger log() {
        return this.log;
    }

    public HashMap<Object, DataframeAndColumnMetadata> nodeIdToDataframeAndColumnMetadataMap() {
        return this.nodeIdToDataframeAndColumnMetadataMap;
    }

    public HashMap<String, Enumeration.Value> featureColumnFormatsMap() {
        return this.featureColumnFormatsMap;
    }

    public Buffer<AnyNode> nodes() {
        return this.nodes;
    }

    public scala.collection.immutable.Map<Integer, String> nodeIdToFeatureName() {
        return this.nodeIdToFeatureName;
    }

    public Option<FeathrExpressionExecutionContext> mvelExpressionContext() {
        return this.mvelExpressionContext;
    }

    public TimeConfigSettings timeConfigSettings() {
        return this.timeConfigSettings;
    }

    public SparkSession ss() {
        return this.ss;
    }

    private TimeConfigSettings getJoinSettings() {
        DateTimeInterval obsTimeRange = this.featureJoinConfig.settings().isDefined() ? (DateTimeInterval)((Option)SlidingWindowFeatureUtils$.MODULE$.getObsSwaDataTimeRange(this.observationDf, this.featureJoinConfig.settings())._1()).get() : null;
        return new TimeConfigSettings(this.featureJoinConfig.settings(), this.featureJoinConfig.featuresToTimeDelayMap(), obsTimeRange);
    }

    private scala.collection.immutable.Map<Integer, String> getNodeIdToFeatureNameMap(Buffer<AnyNode> nodes) {
        scala.collection.immutable.Map derivedFeatureAliasMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._2()), x._1()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return ((TraversableOnce)((TraversableLike)nodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)FCMGraphTraverser.$anonfun$getNodeIdToFeatureNameMap$2(node)))).map((Function1 & Serializable & scala.Serializable)node -> node.isLookup() ? (derivedFeatureAliasMap.contains((Object)node.getLookup().getId()) ? new Tuple2((Object)node.getLookup().getId(), derivedFeatureAliasMap.apply((Object)node.getLookup().getId())) : new Tuple2((Object)node.getLookup().getId(), (Object)node.getLookup().getFeatureName())) : (node.isAggregation() ? (derivedFeatureAliasMap.contains((Object)node.getAggregation().getId()) ? new Tuple2((Object)node.getAggregation().getId(), derivedFeatureAliasMap.apply((Object)node.getAggregation().getId())) : new Tuple2((Object)node.getAggregation().getId(), (Object)node.getAggregation().getFeatureName())) : (derivedFeatureAliasMap.contains((Object)node.getTransformation().getId()) ? new Tuple2((Object)node.getTransformation().getId(), derivedFeatureAliasMap.apply((Object)node.getTransformation().getId())) : (node.getTransformation().hasFeatureName() ? new Tuple2((Object)node.getTransformation().getId(), (Object)node.getTransformation().getFeatureName()) : new Tuple2((Object)node.getTransformation().getId(), (Object)"__seq__join__feature")))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Set<Integer> getUnfinishedDependencies(AnyNode node, VisitedState[] visitedState) {
        Set dependencies = (Set)JavaConverters$.MODULE$.asScalaSetConverter(new Dependencies().getDependencies(node)).asScala();
        return ((TraversableOnce)dependencies.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FCMGraphTraverser.$anonfun$getUnfinishedDependencies$1(visitedState, x$1)))).toSet();
    }

    public FeatureDataFrame traverseGraph() {
        Stack stack = (Stack)Stack$.MODULE$.apply((Seq)Nil$.MODULE$);
        Dataset<Row> contextDf = this.observationDf;
        scala.collection.immutable.Map optimizedGroupingMap = NodeGrouper$.MODULE$.groupTransformationNodes(this.nodes()).$plus$plus(NodeGrouper$.MODULE$.groupAllSWANodes(this.nodes()));
        scala.collection.immutable.Map nodeRankingMap = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).values().map((Function1 & Serializable & scala.Serializable)x -> ((AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x))).isAggregation() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), (Object)BoxesRunTime.boxToInteger((int)1)) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), (Object)BoxesRunTime.boxToInteger((int)2)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        VisitedState[] visitedState = (VisitedState[])Array$.MODULE$.fill(this.nodes().length(), (Function0 & Serializable & scala.Serializable)() -> NOT_VISITED$.MODULE$, ClassTag$.MODULE$.apply(VisitedState.class));
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x -> stack.push((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x))));
        while (stack.nonEmpty()) {
            Dataset<Row> dataset;
            stack.sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> FCMGraphTraverser.$anonfun$traverseGraph$4(nodeRankingMap, BoxesRunTime.unboxToInt((Object)x0$1)), Ordering$.MODULE$.Option((Ordering)Ordering.Int$.MODULE$));
            int nodeId = BoxesRunTime.unboxToInt((Object)stack.pop());
            VisitedState visitedState2 = visitedState[nodeId];
            VISITED$ vISITED$ = VISITED$.MODULE$;
            if (!(visitedState2 == null ? vISITED$ != null : !visitedState2.equals(vISITED$))) continue;
            AnyNode node = (AnyNode)this.nodes().apply(nodeId);
            scala.collection.immutable.Set unfinishedDependencies = (scala.collection.immutable.Set)((TraversableOnce)optimizedGroupingMap.getOrElse((Object)Predef$.MODULE$.int2Integer(nodeId), (Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon((Object)new Integer(nodeId), (List)Nil$.MODULE$))).foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(unfinishedSet, currNodeId) -> (scala.collection.immutable.Set)unfinishedSet.$plus$plus(this.getUnfinishedDependencies((AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(currNodeId)), visitedState)));
            if (unfinishedDependencies.nonEmpty()) {
                VisitedState visitedState3 = visitedState[nodeId];
                IN_PROGRESS$ iN_PROGRESS$ = IN_PROGRESS$.MODULE$;
                if (!(visitedState3 != null ? !visitedState3.equals(iN_PROGRESS$) : iN_PROGRESS$ != null)) {
                    throw new RuntimeException(new StringBuilder(44).append("Encountered dependency cycle involving node ").append(nodeId).toString());
                }
                stack.push((Object)BoxesRunTime.boxToInteger((int)nodeId));
                unfinishedDependencies.foreach((Function1 & Serializable & scala.Serializable)x$2 -> stack.push((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))));
                visitedState[nodeId] = IN_PROGRESS$.MODULE$;
                continue;
            }
            Predef$.MODULE$.assert(!this.nodeIdToDataframeAndColumnMetadataMap().contains((Object)BoxesRunTime.boxToInteger((int)nodeId)));
            if (optimizedGroupingMap.contains((Object)Predef$.MODULE$.int2Integer(nodeId))) {
                Dataset<Row> dataset2;
                AnyNode anyNode = node;
                if (anyNode.isDataSource()) {
                    dataset2 = DataSourceNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$3 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$3)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isLookup()) {
                    dataset2 = LookupNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$4 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$4)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isTransformation()) {
                    dataset2 = TransformationNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$5 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$5)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isAggregation()) {
                    dataset2 = AggregationNodeEvaluator$.MODULE$.batchEvaluate((Seq<AnyNode>)((Seq)((TraversableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).map((Function1 & Serializable & scala.Serializable)x$6 -> (AnyNode)this.nodes().apply(Predef$.MODULE$.Integer2int(x$6)), Seq$.MODULE$.canBuildFrom())), this, contextDf, this.dataPathHandlers);
                } else {
                    if (anyNode.isExternal()) {
                        throw new RuntimeException(new StringBuilder(67).append("External node found in resolved graph traversal. Node information: ").append(anyNode).toString());
                    }
                    throw new MatchError((Object)anyNode);
                }
                dataset = dataset2;
            } else {
                Dataset<Row> dataset3;
                AnyNode anyNode = node;
                if (anyNode.isDataSource()) {
                    dataset3 = DataSourceNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isLookup()) {
                    dataset3 = LookupNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isTransformation()) {
                    dataset3 = TransformationNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else if (anyNode.isAggregation()) {
                    dataset3 = AggregationNodeEvaluator$.MODULE$.evaluate(anyNode, this, contextDf, this.dataPathHandlers);
                } else {
                    if (anyNode.isExternal()) {
                        throw new RuntimeException(new StringBuilder(67).append("External node found in resolved graph traversal. Node information: ").append(anyNode).toString());
                    }
                    throw new MatchError((Object)anyNode);
                }
                dataset = contextDf = dataset3;
            }
            if (optimizedGroupingMap.contains((Object)Predef$.MODULE$.int2Integer(nodeId))) {
                ((IterableLike)optimizedGroupingMap.apply((Object)Predef$.MODULE$.int2Integer(nodeId))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                    visitedState[Predef$.MODULE$.Integer2int((Integer)x$7)] = VISITED$.MODULE$;
                    return BoxedUnit.UNIT;
                });
                continue;
            }
            visitedState[nodeId] = VISITED$.MODULE$;
        }
        scala.collection.immutable.Map<String, FeatureTypeConfig> featureTypeConfigs = NodeUtils$.MODULE$.getFeatureTypeConfigsMap((Seq<AnyNode>)this.nodes());
        Iterable necessaryColumns = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).keys().$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.observationDf.columns())), Iterable$.MODULE$.canBuildFrom());
        String[] toDropCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contextDf.columns())).diff((GenSeq)necessaryColumns.toSeq());
        contextDf = contextDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])toDropCols));
        return FeatureTransformation$.MODULE$.convertFCMResultDFToFDS((Seq<String>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.resolvedGraph.getFeatureNames()).asScala()).keys().toSeq(), (scala.collection.immutable.Map<String, Enumeration.Value>)this.featureColumnFormatsMap().toMap(Predef$.MODULE$.$conforms()), contextDf, featureTypeConfigs);
    }

    public static final /* synthetic */ boolean $anonfun$getNodeIdToFeatureNameMap$2(AnyNode node) {
        return node.isLookup() || node.isAggregation() || node.isTransformation();
    }

    public static final /* synthetic */ boolean $anonfun$getUnfinishedDependencies$1(VisitedState[] visitedState$1, Integer x$1) {
        VisitedState visitedState = visitedState$1[Predef$.MODULE$.Integer2int(x$1)];
        VISITED$ vISITED$ = VISITED$.MODULE$;
        return visitedState == null ? vISITED$ != null : !visitedState.equals(vISITED$);
    }

    public static final /* synthetic */ Option $anonfun$traverseGraph$4(scala.collection.immutable.Map nodeRankingMap$1, int x0$1) {
        int n = x0$1;
        Option option = nodeRankingMap$1.get((Object)Predef$.MODULE$.int2Integer(n));
        return option;
    }

    public FCMGraphTraverser(SparkSession inputSparkSession, FeatureJoinConfig featureJoinConfig, ComputeGraph resolvedGraph, Dataset<Row> observationDf, List<DataPathHandler> dataPathHandlers, Option<FeathrExpressionExecutionContext> mvelContext) {
        this.featureJoinConfig = featureJoinConfig;
        this.resolvedGraph = resolvedGraph;
        this.observationDf = observationDf;
        this.dataPathHandlers = dataPathHandlers;
        this.log = LogManager.getLogger((String)this.getClass().getName());
        this.nodeIdToDataframeAndColumnMetadataMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.featureColumnFormatsMap = (HashMap)HashMap$.MODULE$.apply((Seq)featureJoinConfig.joinFeatures().map((Function1 & Serializable & scala.Serializable)joinFeature -> new Tuple2((Object)joinFeature.featureName(), (Object)FeatureColumnFormat$.MODULE$.RAW()), Seq$.MODULE$.canBuildFrom()));
        this.nodes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)resolvedGraph.getNodes()).asScala();
        this.nodeIdToFeatureName = this.getNodeIdToFeatureNameMap(this.nodes());
        this.mvelExpressionContext = mvelContext;
        this.timeConfigSettings = this.getJoinSettings();
        this.ss = inputSparkSession;
    }
}

