/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.graph;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.JoiningFeatureParams;
import com.linkedin.feathr.compute.AnyNode;
import com.linkedin.feathr.compute.FeatureVersion;
import com.linkedin.feathr.compute.Resolver;
import com.linkedin.feathr.compute.Transformation;
import com.linkedin.feathr.offline.anchored.WindowTimeUnit$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.PegasusRecordDefaultValueConverter$;
import com.linkedin.feathr.offline.config.PegasusRecordFeatureTypeConverter$;
import com.linkedin.feathr.offline.util.FCMUtils$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class NodeUtils$ {
    public static NodeUtils$ MODULE$;

    static {
        new NodeUtils$();
    }

    public List<Resolver.FeatureRequest> getFeatureRequestsFromJoinConfig(FeatureJoinConfig joinConfig) {
        Seq featureNames = (Seq)joinConfig.joinFeatures().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.featureName(), Seq$.MODULE$.canBuildFrom());
        Seq duplicateFeatureNames = (Seq)((SeqLike)featureNames.diff((GenSeq)featureNames.distinct())).distinct();
        return ((TraversableOnce)joinConfig.joinFeatures().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JoiningFeatureParams joiningFeatureParams = x0$1;
            if (joiningFeatureParams == null) {
                throw new MatchError((Object)joiningFeatureParams);
            }
            Seq<String> keyTags = joiningFeatureParams.keyTags();
            String featureName = joiningFeatureParams.featureName();
            Option<String> timeDelay = joiningFeatureParams.timeDelay();
            Option<String> featureAlias = joiningFeatureParams.featureAlias();
            Duration delay = timeDelay.isDefined() ? WindowTimeUnit$.MODULE$.parseWindowTime((String)timeDelay.get()) : (joinConfig.settings().isDefined() && ((JoinConfigSettings)joinConfig.settings().get()).joinTimeSetting().isDefined() && ((JoinTimeSetting)((JoinConfigSettings)joinConfig.settings().get()).joinTimeSetting().get()).simulateTimeDelay().isDefined() ? (Duration)((JoinTimeSetting)((JoinConfigSettings)joinConfig.settings().get()).joinTimeSetting().get()).simulateTimeDelay().get() : Duration.ZERO);
            Resolver.FeatureRequest featureRequest = duplicateFeatureNames.contains((Object)featureName) ? new Resolver.FeatureRequest(featureName, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)keyTags.toList()).asJava(), delay, FCMUtils$.MODULE$.makeFeatureNameForDuplicates(keyTags, featureName)) : new Resolver.FeatureRequest(featureName, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)keyTags.toList()).asJava(), delay, (String)featureAlias.orNull(Predef$.MODULE$.$conforms()));
            return featureRequest;
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    public Map<String, FeatureTypeConfig> getFeatureTypeConfigsMap(Seq<AnyNode> nodes) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)nodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)NodeUtils$.$anonfun$getFeatureTypeConfigsMap$1(node)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            AnyNode anyNode = x0$1;
            if (anyNode.isTransformation()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)anyNode.getTransformation().getFeatureName()), PegasusRecordFeatureTypeConverter$.MODULE$.apply().convert(anyNode.getTransformation().getFeatureVersion()));
            } else if (anyNode.isLookup()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)anyNode.getLookup().getFeatureName()), PegasusRecordFeatureTypeConverter$.MODULE$.apply().convert(anyNode.getLookup().getFeatureVersion()));
            } else if (anyNode.isAggregation()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)anyNode.getAggregation().getFeatureName()), PegasusRecordFeatureTypeConverter$.MODULE$.apply().convert(anyNode.getAggregation().getFeatureVersion()));
            } else {
                throw new MatchError((Object)anyNode);
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Option<FeatureTypeConfig>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FeatureTypeConfig value = (FeatureTypeConfig)some.value();
                        object = new Tuple2((Object)key, (Object)value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Option<FeatureTypeConfig>> x1) {
                Option option;
                Tuple2<String, Option<FeatureTypeConfig>> tuple2 = x1;
                boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, FeatureTypeConfig> getFeatureTypeConfigsMapForTransformationNodes(Seq<Transformation> nodes) {
        return ((TraversableOnce)((TraversableLike)nodes.map((Function1 & Serializable & scala.Serializable)n -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n.getFeatureName()), PegasusRecordFeatureTypeConverter$.MODULE$.apply().convert(n.getFeatureVersion())), Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Option<FeatureTypeConfig>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FeatureTypeConfig value = (FeatureTypeConfig)some.value();
                        object = new Tuple2((Object)key, (Object)value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Option<FeatureTypeConfig>> x1) {
                Option option;
                Tuple2<String, Option<FeatureTypeConfig>> tuple2 = x1;
                boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, FeatureValue> getDefaultConverter(Seq<AnyNode> nodes) {
        Map featureVersionMap = ((TraversableOnce)((TraversableLike)nodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)NodeUtils$.$anonfun$getDefaultConverter$1(node)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            AnyNode anyNode = x0$1;
            if (anyNode.isTransformation()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)anyNode.getTransformation().getFeatureName()), (Object)anyNode.getTransformation().getFeatureVersion());
            } else if (anyNode.isLookup()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)anyNode.getLookup().getFeatureName()), (Object)anyNode.getLookup().getFeatureVersion());
            } else if (anyNode.isAggregation()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)anyNode.getAggregation().getFeatureName()), (Object)anyNode.getAggregation().getFeatureVersion());
            } else {
                throw new MatchError((Object)anyNode);
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return PegasusRecordDefaultValueConverter$.MODULE$.apply().convert((Map<String, FeatureVersion>)featureVersionMap);
    }

    public Map<String, FeatureValue> getDefaultConverterForTransformationNodes(Seq<Transformation> nodes) {
        Map featureVersionMap = ((TraversableOnce)nodes.map((Function1 & Serializable & scala.Serializable)n -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n.getFeatureName()), (Object)n.getFeatureVersion()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return PegasusRecordDefaultValueConverter$.MODULE$.apply().convert((Map<String, FeatureVersion>)featureVersionMap);
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureTypeConfigsMap$1(AnyNode node) {
        return node.isLookup() || node.isAggregation() || node.isTransformation();
    }

    public static final /* synthetic */ boolean $anonfun$getDefaultConverter$1(AnyNode node) {
        return node.isLookup() || node.isAggregation() || node.isTransformation();
    }

    private NodeUtils$() {
        MODULE$ = this;
    }
}

