/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.job;

import com.linkedin.feathr.offline.job.BloomFilterContext;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.sketch.BloomFilter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0002\u0004\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u00044\u0001\u0011\u0005\u0001\u0002\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\u0006?\u0002!I\u0001\u0019\u0002\u0017\t\u0006$\u0018M\u0012:b[\u0016\u001cF/\u0019;Gk:\u001cG/[8og*\u0011q\u0001C\u0001\u0004U>\u0014'BA\u0005\u000b\u0003\u001dygM\u001a7j]\u0016T!a\u0003\u0007\u0002\r\u0019,\u0017\r\u001e5s\u0015\tia\"\u0001\u0005mS:\\W\rZ5o\u0015\u0005y\u0011aA2p[\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u0006\u0011AM\u001a\t\u00035Ar!aG\u0017\u000f\u0005qQcBA\u000f(\u001d\tqBE\u0004\u0002 E5\t\u0001E\u0003\u0002\"!\u00051AH]8pizJ\u0011aI\u0001\u0004_J<\u0017BA\u0013'\u0003\u0019\t\u0007/Y2iK*\t1%\u0003\u0002)S\u0005)1\u000f]1sW*\u0011QEJ\u0005\u0003W1\n1a]9m\u0015\tA\u0013&\u0003\u0002/_\u00059\u0001/Y2lC\u001e,'BA\u0016-\u0013\t\t$GA\u0005ECR\fgI]1nK*\u0011afL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U:\u0004C\u0001\u001c\u0001\u001b\u00051\u0001\"\u0002\r\u0003\u0001\u0004I\u0012A\u00062bi\u000eD7I]3bi\u0016\u0014En\\8n\r&dG/\u001a:\u0015\tiRUK\u0017\t\u0004w}\u0012eB\u0001\u001f?\u001d\tyR(C\u0001\u0016\u0013\tqC#\u0003\u0002A\u0003\n\u00191+Z9\u000b\u00059\"\u0002CA\"I\u001b\u0005!%BA#G\u0003\u0019\u00198.\u001a;dQ*\u0011q\tL\u0001\u0005kRLG.\u0003\u0002J\t\nY!\t\\8p[\u001aKG\u000e^3s\u0011\u0015Y5\u00011\u0001M\u0003-\u0019w\u000e\\;n]:\u000bW.Z:\u0011\u0007mzT\n\u0005\u0002O%:\u0011q\n\u0015\t\u0003?QI!!\u0015\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#RAQAV\u0002A\u0002]\u000b\u0001#\u001a=qK\u000e$X\r\u001a(v[&#X-\\:\u0011\u0005MA\u0016BA-\u0015\u0005\u0011auN\\4\t\u000bm\u001b\u0001\u0019\u0001/\u0002\u0007\u0019\u0004\b\u000f\u0005\u0002\u0014;&\u0011a\f\u0006\u0002\u0007\t>,(\r\\3\u0002+\t\fGo\u00195Ck&dGM\u00117p_64\u0015\u000e\u001c;feR\u0011!(\u0019\u0005\u0006E\u0012\u0001\raY\u0001\"S:LG/[1mSj,GM\u00117p_64\u0015\u000e\u001c;fe^KG\u000f[\"pYVlgn\u001d\t\u0004w}\"\u0007\u0003B\nf\u001b\nK!A\u001a\u000b\u0003\rQ+\b\u000f\\33\u0001")
public class DataFrameStatFunctions {
    private final Dataset<Row> df;

    public Seq<BloomFilter> batchCreateBloomFilter(Seq<String> columnNames, long expectedNumItems, double fpp) {
        Seq context = (Seq)columnNames.map((Function1 & Serializable & scala.Serializable)col -> new Tuple2(col, (Object)BloomFilter.create((long)expectedNumItems, (double)fpp)), Seq$.MODULE$.canBuildFrom());
        return this.batchBuildBloomFilter((Seq<Tuple2<String, BloomFilter>>)context);
    }

    private Seq<BloomFilter> batchBuildBloomFilter(Seq<Tuple2<String, BloomFilter>> initializedBloomFilterWithColumns) {
        Seq bloomFiltersContext;
        Seq columnNames = (Seq)initializedBloomFilterWithColumns.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Seq$.MODULE$.canBuildFrom());
        Dataset columns = this.df.select((String)columnNames.head(), (Seq)columnNames.tail());
        Seq colTypes = (Seq)columns.schema().map((Function1 & Serializable & scala.Serializable)field -> {
            void var1_1;
            DataType colType;
            DataType dataType = colType = field.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            Predef$.MODULE$.require(!(dataType == null ? stringType$ != null : !dataType.equals(stringType$)) || colType instanceof NumericType, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Bloom filter only supports string type and integral types, but got ").append(colType).append(".").toString());
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$12 = bloomFiltersContext = (Seq)((TraversableLike)colTypes.zip(initializedBloomFilterWithColumns, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            DataType dType;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    dType = (DataType)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String col = (String)tuple2._1();
            BloomFilter filter = (BloomFilter)tuple2._2();
            BloomFilterContext bloomFilterContext = new BloomFilterContext(dType, col, filter);
            return bloomFilterContext;
        }, Seq$.MODULE$.canBuildFrom());
        Function2 & Serializable & scala.Serializable x$22 = (Function2 & Serializable & scala.Serializable)(accBloomFiltersContext, row) -> {
            ((IterableLike)accBloomFiltersContext.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DataFrameStatFunctions.$anonfun$batchBuildBloomFilter$6(row, x0$2);
                return BoxedUnit.UNIT;
            });
            return accBloomFiltersContext;
        };
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(filterContexts1, filterContexts2) -> (Seq)((TraversableLike)filterContexts1.zip((GenIterable)filterContexts2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BloomFilterContext filterContext1 = (BloomFilterContext)tuple2._1();
            BloomFilterContext filterContext2 = (BloomFilterContext)tuple2._2();
            filterContext1.initializedFilter().mergeInPlace(filterContext2.initializedFilter());
            BloomFilterContext bloomFilterContext = filterContext1;
            return bloomFilterContext;
        }, Seq$.MODULE$.canBuildFrom());
        int x$4 = columns.queryExecution().toRdd().treeAggregate$default$4((Object)x$12);
        Seq filterContexts = (Seq)columns.queryExecution().toRdd().treeAggregate((Object)x$12, (Function2)x$22, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(Seq.class));
        return (Seq)filterContexts.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.initializedFilter(), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$batchBuildBloomFilter$6(InternalRow row$1, Tuple2 x0$2) {
        Function2 & Serializable & scala.Serializable intersect;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        BloomFilterContext bloomFilterContext = (BloomFilterContext)tuple2._1();
        int ordinal = tuple2._2$mcI$sp();
        DataType colType = bloomFilterContext.dataType();
        DataType dataType = colType;
        if (StringType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(filter, row) -> {
                filter.putBinary(row.getUTF8String(ordinal).getBytes());
                return BoxedUnit.UNIT;
            };
        } else if (ByteType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(filter, row) -> {
                filter.putLong((long)row.getByte(ordinal));
                return BoxedUnit.UNIT;
            };
        } else if (ShortType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(filter, row) -> {
                filter.putLong((long)row.getShort(ordinal));
                return BoxedUnit.UNIT;
            };
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(filter, row) -> {
                filter.putLong((long)row.getInt(ordinal));
                return BoxedUnit.UNIT;
            };
        } else {
            if (!LongType$.MODULE$.equals(dataType)) throw new IllegalArgumentException(new StringBuilder(86).append("Bloom filter only supports string type and integral types, ").append("and does not support type ").append(colType).append(".").toString());
            intersect = (Function2 & Serializable & scala.Serializable)(filter, row) -> {
                filter.putLong(row.getLong(ordinal));
                return BoxedUnit.UNIT;
            };
        }
        Function2 & Serializable & scala.Serializable updater = intersect;
        BloomFilter filter2 = bloomFilterContext.initializedFilter();
        BoxedUnit boxedUnit = (BoxedUnit)updater.apply((Object)filter2, (Object)row$1);
    }

    public DataFrameStatFunctions(Dataset<Row> df) {
        this.df = df;
    }
}

