/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.job;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.linkedin.feathr.common.TaggedFeatureName;
import com.linkedin.feathr.common.configObj.configbuilder.FeatureGenConfigBuilder;
import com.linkedin.feathr.common.configObj.generation.FeatureGenConfig;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.client.FeathrClient;
import com.linkedin.feathr.offline.client.FeathrClient$;
import com.linkedin.feathr.offline.config.FeathrConfigLoader$;
import com.linkedin.feathr.offline.config.datasource.DataSourceConfigUtils$;
import com.linkedin.feathr.offline.config.datasource.DataSourceConfigs;
import com.linkedin.feathr.offline.job.FeathrGenPreparationInfo;
import com.linkedin.feathr.offline.job.FeatureDefinitionsInput;
import com.linkedin.feathr.offline.job.FeatureGenJobContext;
import com.linkedin.feathr.offline.job.FeatureGenSpec;
import com.linkedin.feathr.offline.job.FeatureJoinJob$;
import com.linkedin.feathr.offline.job.PreprocessedDataFrameManager$;
import com.linkedin.feathr.offline.source.accessor.DataPathHandler;
import com.linkedin.feathr.offline.source.accessor.DataSourceAccessor;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import com.linkedin.feathr.offline.transformation.AnchorToDataSourceMapper;
import com.linkedin.feathr.offline.util.CmdLineParser;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.OptionParam;
import com.linkedin.feathr.offline.util.SparkFeaturizedDataset;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.io.Serializable;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class FeatureGenJob$ {
    public static FeatureGenJob$ MODULE$;
    private final Logger logger;

    static {
        new FeatureGenJob$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Tuple4<String, FeatureDefinitionsInput, FeatureGenJobContext, DataSourceConfigs> parseInputArguments(String[] args) {
        scala.collection.immutable.Map params2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feathr-config"), (Object)new OptionParam("lf", "Path of the feathr local config file", "FCONF", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature-config"), (Object)new OptionParam("f", "Names of the feathr feature config files", "EFCONF", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"local-override-all"), (Object)new OptionParam("loa", "Local config overrides all other configs", "LOCAL_OVERRIDE", "true")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"work-dir"), (Object)new OptionParam("wd", "work directory, used to store temporary results, etc.", "WORK_DIR", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generation-config"), (Object)new OptionParam("gc", "Path of the feature generation config file", "JCONF", null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"params-override"), (Object)new OptionParam("ac", "parameter to override in feature generation config", "PARAM_OVERRIDE", "[]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature-conf-override"), (Object)new OptionParam("fco", "parameter to override in feature definition config", "FEATURE_CONF_OVERRIDE", "[]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"redis-config"), (Object)new OptionParam("ac", "Authentication config for Redis", "REDIS_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"s3-config"), (Object)new OptionParam("sc", "Authentication config for S3", "S3_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"adls-config"), (Object)new OptionParam("adlc", "Authentication config for ADLS (abfs)", "ADLS_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blob-config"), (Object)new OptionParam("bc", "Authentication config for Azure Blob Storage (wasb)", "BLOB_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sql-config"), (Object)new OptionParam("sqlc", "Authentication config for Azure SQL Database (jdbc)", "SQL_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snowflake-config"), (Object)new OptionParam("sfc", "Authentication config for Snowflake Database (jdbc)", "SNOWFLAKE_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"monitoring-config"), (Object)new OptionParam("mc", "Feature monitoring related configs", "MONITORING_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kafka-config"), (Object)new OptionParam("kc", "Authentication config for Kafka", "KAFKA_CONFIG", "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"system-properties"), (Object)new OptionParam("sps", "Additional System Properties", "SYSTEM_PROPERTIES_CONFIG", ""))}));
        .colon.colon extraOptions = new .colon.colon((Object)new org.apache.commons.cli.Option("LOCALMODE", "local-mode", false, "Run in local mode"), (List)Nil$.MODULE$);
        CmdLineParser cmdParser = new CmdLineParser(args, (scala.collection.immutable.Map<String, OptionParam>)params2, (List<org.apache.commons.cli.Option>)extraOptions);
        String sps = (String)cmdParser.extractOptionalValue("system-properties").getOrElse((Function0 & Serializable & scala.Serializable)() -> "{}");
        HashMap props = (HashMap)new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).readValue(sps, HashMap.class);
        props.foreach((Function1 & Serializable & scala.Serializable)e -> Properties$.MODULE$.setProp((String)e._1(), (String)e._2()));
        String applicationConfigPath = cmdParser.extractRequiredValue("generation-config");
        FeatureDefinitionsInput featureDefinitionsInput = new FeatureDefinitionsInput(cmdParser.extractOptionalValue("feathr-config"), cmdParser.extractOptionalValue("feature-config"), cmdParser.extractRequiredValue("local-override-all"));
        Option<String> paramsOverride = cmdParser.extractOptionalValue("params-override");
        Option featureConfOverride = cmdParser.extractOptionalValue("feature-conf-override").map((Function1 & Serializable & scala.Serializable)params -> MODULE$.convertToHoconConfig((String)params));
        String workDir = cmdParser.extractRequiredValue("work-dir");
        DataSourceConfigs dataSourceConfigs = DataSourceConfigUtils$.MODULE$.getConfigs(cmdParser);
        FeatureGenJobContext featureGenJobContext = new FeatureGenJobContext(workDir, paramsOverride, (Option<String>)featureConfOverride);
        return new Tuple4((Object)applicationConfigPath, (Object)featureDefinitionsInput, (Object)featureGenJobContext, (Object)dataSourceConfigs);
    }

    public String convertToHoconConfig(String params) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(params)).stripPrefix("["))).stripSuffix("]");
    }

    public scala.collection.immutable.Map<TaggedFeatureName, SparkFeaturizedDataset> run(SparkSession ss, String featureGenConfigPath, FeatureDefinitionsInput featureDefInputs, FeatureGenJobContext jobContext) {
        Option localFeatureConfig;
        String applicationConfig = FeatureJoinJob$.MODULE$.hdfsFileReader(ss, featureGenConfigPath);
        Option featureConfig = featureDefInputs.feathrFeatureDefPaths().map((Function1 & Serializable & scala.Serializable)path -> FeatureJoinJob$.MODULE$.hdfsFileReader(ss, (String)path));
        Tuple2<Option<String>, Option<String>> tuple2 = this.overrideFeatureDefs((Option<String>)featureConfig, (Option<String>)(localFeatureConfig = featureDefInputs.feathrLocalFeatureDefPath().map((Function1 & Serializable & scala.Serializable)path -> FeatureJoinJob$.MODULE$.hdfsFileReader(ss, (String)path))), jobContext);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option featureConfigWithOverride = (Option)tuple2._1();
        Option localFeatureConfigWithOverride = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featureConfigWithOverride, (Object)localFeatureConfigWithOverride);
        Tuple2 tuple23 = tuple22;
        Option featureConfigWithOverride2 = (Option)tuple23._1();
        Option localFeatureConfigWithOverride2 = (Option)tuple23._2();
        return this.run(ss, applicationConfig, (Option<String>)featureConfigWithOverride2, (Option<String>)localFeatureConfigWithOverride2, jobContext, this.run$default$6());
    }

    public Tuple2<Option<String>, Option<String>> overrideFeatureDefs(Option<String> featureConfig, Option<String> localFeatureConfig, FeatureGenJobContext jobContext) {
        Some featureConfigWithOverride = featureConfig.isDefined() && jobContext.featureConfOverride().isDefined() ? new Some((Object)FeathrConfigLoader$.MODULE$.resolveOverride((String)featureConfig.get(), (String)jobContext.featureConfOverride().get())) : featureConfig;
        Some localFeatureConfigWithOverride = localFeatureConfig.isDefined() && jobContext.featureConfOverride().isDefined() ? new Some((Object)FeathrConfigLoader$.MODULE$.resolveOverride((String)localFeatureConfig.get(), (String)jobContext.featureConfOverride().get())) : localFeatureConfig;
        return new Tuple2((Object)featureConfigWithOverride, (Object)localFeatureConfigWithOverride);
    }

    public scala.collection.immutable.Map<TaggedFeatureName, SparkFeaturizedDataset> run(SparkSession ss, String featureGenConfig, Option<String> featureDefConfig, Option<String> localFeatureConfig, FeatureGenJobContext jobContext, List<DataPathHandler> dataPathHandlers) {
        this.logger().info(new StringBuilder(19).append("featureDefConfig : ").append(featureDefConfig).toString());
        this.logger().info(new StringBuilder(21).append("localFeatureConfig : ").append(localFeatureConfig).toString());
        FeathrClient feathrClient = FeathrClient$.MODULE$.builder(ss).addFeatureDef(featureDefConfig).addLocalOverrideDef(localFeatureConfig).addDataPathHandlers(dataPathHandlers).build();
        FeatureGenSpec featureGenSpec = this.parseFeatureGenApplicationConfig(featureGenConfig, jobContext, dataPathHandlers);
        return feathrClient.generateFeatures(featureGenSpec);
    }

    public List<DataPathHandler> run$default$6() {
        return Nil$.MODULE$;
    }

    public FeatureGenSpec parseFeatureGenApplicationConfig(String featureGenConfigStr, FeatureGenJobContext featureGenJobContext, List<DataPathHandler> dataPathHandlers) {
        String withParamsOverrideConfigStr = this.overrideFeatureGeneration(featureGenConfigStr, featureGenJobContext.paramsOverride());
        Config withParamsOverrideConfig = ConfigFactory.parseString((String)withParamsOverrideConfigStr);
        FeatureGenConfig featureGenConfig = FeatureGenConfigBuilder.build(withParamsOverrideConfig);
        List dataLoaderHandlers = (List)dataPathHandlers.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataLoaderHandler(), List$.MODULE$.canBuildFrom());
        return new FeatureGenSpec(featureGenConfig, (List<DataLoaderHandler>)dataLoaderHandlers);
    }

    public List<DataPathHandler> parseFeatureGenApplicationConfig$default$3() {
        return Nil$.MODULE$;
    }

    public String overrideFeatureGeneration(String featureGenConfigStr, Option<String> paramsOverride) {
        Config fullConfig = ConfigFactory.parseString((String)featureGenConfigStr);
        Config withParamsOverrideConfig = (Config)paramsOverride.map((Function1 & Serializable & scala.Serializable)configStr -> {
            String paramOverrideConfigStr = new StringBuilder(15).append("operational: {").append(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(configStr)).stripPrefix("["))).stripSuffix("]")).append("}").toString();
            Config paramOverrideConfig = ConfigFactory.parseString((String)paramOverrideConfigStr);
            String withOutputOverrideStr = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fullConfig.getConfigList("operational.output")).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Config output = (Config)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String key = new StringBuilder(20).append("operational.output(").append(idx).append(")").toString();
                Config withOverride = paramOverrideConfig.hasPath(key) ? paramOverrideConfig.getConfig(key).withFallback((ConfigMergeable)output) : output;
                String string = withOverride.root().render(ConfigRenderOptions.concise());
                return string;
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
            Config withOutputOverride = ConfigFactory.parseString((String)new StringBuilder(21).append("operational.output:[").append(withOutputOverrideStr).append("]").toString());
            return paramOverrideConfig.withFallback((ConfigMergeable)withOutputOverride).withFallback((ConfigMergeable)fullConfig);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> fullConfig);
        return withParamsOverrideConfig.root().render();
    }

    public java.util.Map<String, Dataset<Row>> loadSourceDataframe(String[] args, Set<String> featureNamesInAnchorSet) {
        this.logger().info(new StringBuilder(25).append("FeatureJoinJob args are: ").append(args).toString());
        this.logger().info("Feature join job: loadDataframe");
        this.logger().info(featureNamesInAnchorSet);
        FeathrGenPreparationInfo feathrGenPreparationInfo = this.prepareSparkSession(args);
        SparkSession sparkSession = feathrGenPreparationInfo.sparkSession();
        FeatureDefinitionsInput featureDefs = feathrGenPreparationInfo.featureDefs();
        FeatureGenJobContext jobContext = feathrGenPreparationInfo.jobContext();
        Option featureConfig = featureDefs.feathrFeatureDefPaths().map((Function1 & Serializable & scala.Serializable)path -> FeatureJoinJob$.MODULE$.hdfsFileReader(sparkSession, (String)path));
        Option localFeatureConfig = featureDefs.feathrLocalFeatureDefPath().map((Function1 & Serializable & scala.Serializable)path -> FeatureJoinJob$.MODULE$.hdfsFileReader(sparkSession, (String)path));
        Tuple2<Option<String>, Option<String>> tuple2 = this.overrideFeatureDefs((Option<String>)featureConfig, (Option<String>)localFeatureConfig, jobContext);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option featureConfigWithOverride = (Option)tuple2._1();
        Option localFeatureConfigWithOverride = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featureConfigWithOverride, (Object)localFeatureConfigWithOverride);
        Tuple2 tuple23 = tuple22;
        Option featureConfigWithOverride2 = (Option)tuple23._1();
        Option localFeatureConfigWithOverride2 = (Option)tuple23._2();
        FeathrClient feathrClient = FeathrClient$.MODULE$.builder(sparkSession).addFeatureDef((Option<String>)featureConfig).addLocalOverrideDef((Option<String>)localFeatureConfigWithOverride2).build();
        scala.collection.immutable.Map<String, FeatureAnchorWithSource> allAnchoredFeatures = feathrClient.allAnchoredFeatures();
        boolean failOnMissing = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(sparkSession, FeathrUtils$.MODULE$.FAIL_ON_MISSING_PARTITION()))).toBoolean();
        AnchorToDataSourceMapper anchorToDataSourceMapper = new AnchorToDataSourceMapper((List<DataPathHandler>)Nil$.MODULE$);
        scala.collection.immutable.Map<FeatureAnchorWithSource, Option<DataSourceAccessor>> anchorsWithSource = anchorToDataSourceMapper.getBasicAnchorDFMapForJoin(sparkSession, (Seq<FeatureAnchorWithSource>)allAnchoredFeatures.values().toSeq(), failOnMissing);
        scala.collection.immutable.Map updatedAnchorsWithSource = (scala.collection.immutable.Map)((TraversableLike)anchorsWithSource.filter((Function1 & Serializable & scala.Serializable)anchorEntry -> BoxesRunTime.boxToBoolean((boolean)FeatureGenJob$.$anonfun$loadSourceDataframe$3(anchorEntry)))).map((Function1 & Serializable & scala.Serializable)anchorEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(anchorEntry._1()), ((Option)anchorEntry._2()).get()), Map$.MODULE$.canBuildFrom());
        if (updatedAnchorsWithSource.isEmpty()) {
            return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(featureNamesInAnchorSet).asScala()).map((Function1 & Serializable & scala.Serializable)featureName -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(featureName), (Object)sparkSession.emptyDataFrame()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        }
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableLike)updatedAnchorsWithSource.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)featureNamesInAnchorSet.contains(((TraversableOnce)((FeatureAnchorWithSource)x._1()).featureAnchor().features().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(","))))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)((TraversableOnce)((FeatureAnchorWithSource)x._1()).featureAnchor().features().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(","), ((DataSourceAccessor)x._2()).get()), Map$.MODULE$.canBuildFrom())).asJava();
    }

    public FeathrGenPreparationInfo prepareSparkSession(String[] args) {
        Tuple4<String, FeatureDefinitionsInput, FeatureGenJobContext, DataSourceConfigs> tuple4 = this.parseInputArguments(args);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        String applicationConfigPath = (String)tuple4._1();
        FeatureDefinitionsInput featureDefs = (FeatureDefinitionsInput)tuple4._2();
        FeatureGenJobContext jobContext = (FeatureGenJobContext)tuple4._3();
        DataSourceConfigs dataSourceConfigs = (DataSourceConfigs)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)applicationConfigPath, (Object)featureDefs, (Object)jobContext, (Object)dataSourceConfigs);
        Tuple4 tuple43 = tuple42;
        String applicationConfigPath2 = (String)tuple43._1();
        FeatureDefinitionsInput featureDefs2 = (FeatureDefinitionsInput)tuple43._2();
        FeatureGenJobContext jobContext2 = (FeatureGenJobContext)tuple43._3();
        DataSourceConfigs dataSourceConfigs2 = (DataSourceConfigs)tuple43._4();
        SparkConf sparkConf = new SparkConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericRecord.class}));
        DataSourceConfigUtils$.MODULE$.setupSparkConf(sparkConf, dataSourceConfigs2);
        SparkSession.Builder sparkSessionBuilder = SparkSession$.MODULE$.builder().config(sparkConf).appName(this.getClass().getName()).enableHiveSupport();
        SparkSession ss = sparkSessionBuilder.getOrCreate();
        DataSourceConfigUtils$.MODULE$.setupHadoopConf(ss, dataSourceConfigs2);
        return new FeathrGenPreparationInfo(ss, applicationConfigPath2, featureDefs2, jobContext2);
    }

    public scala.collection.immutable.Map<TaggedFeatureName, SparkFeaturizedDataset> process(String[] params) {
        FeathrGenPreparationInfo feathrGenPreparationInfo = this.prepareSparkSession(params);
        return this.run(feathrGenPreparationInfo.sparkSession(), feathrGenPreparationInfo.applicationConfigPath(), feathrGenPreparationInfo.featureDefs(), feathrGenPreparationInfo.jobContext());
    }

    public void mainWithPreprocessedDataFrame(String[] args, java.util.Map<String, Dataset<Row>> preprocessedDfMap) {
        PreprocessedDataFrameManager$.MODULE$.preprocessedDfMap_$eq((scala.collection.immutable.Map<String, Dataset<Row>>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(preprocessedDfMap).asScala()).toMap(Predef$.MODULE$.$conforms()));
        this.main(args);
    }

    public void main(String[] args) {
        this.process(args);
    }

    public static final /* synthetic */ boolean $anonfun$loadSourceDataframe$3(Tuple2 anchorEntry) {
        return ((Option)anchorEntry._2()).isDefined();
    }

    private FeatureGenJob$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

