/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.swa;

import com.linkedin.feathr.common.ErasedEntityTaggedFeature;
import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureValue;
import com.linkedin.feathr.common.exception.ErrorLabel;
import com.linkedin.feathr.common.exception.FeathrConfigException;
import com.linkedin.feathr.offline.FeatureDataFrame;
import com.linkedin.feathr.offline.anchored.WindowTimeUnit$;
import com.linkedin.feathr.offline.anchored.anchorExtractor.TimeWindowConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.anchored.feature.FeatureAnchorWithSource;
import com.linkedin.feathr.offline.anchored.keyExtractor.MVELSourceKeyExtractor;
import com.linkedin.feathr.offline.anchored.keyExtractor.SQLSourceKeyExtractor;
import com.linkedin.feathr.offline.client.DataFrameColName$;
import com.linkedin.feathr.offline.config.FeatureJoinConfig;
import com.linkedin.feathr.offline.config.JoinConfigSettings;
import com.linkedin.feathr.offline.config.JoinTimeSetting;
import com.linkedin.feathr.offline.config.TimeWindowFeatureDefinition;
import com.linkedin.feathr.offline.exception.FeathrIllegalStateException;
import com.linkedin.feathr.offline.job.PreprocessedDataFrameManager$;
import com.linkedin.feathr.offline.join.DataFrameKeyCombiner;
import com.linkedin.feathr.offline.join.DataFrameKeyCombiner$;
import com.linkedin.feathr.offline.source.DataSource;
import com.linkedin.feathr.offline.swa.SWAHandler;
import com.linkedin.feathr.offline.swa.SlidingWindowFeatureUtils$;
import com.linkedin.feathr.offline.transformation.AnchorToDataSourceMapper;
import com.linkedin.feathr.offline.transformation.DataFrameDefaultValueSubstituter$;
import com.linkedin.feathr.offline.util.DataFrameUtils$;
import com.linkedin.feathr.offline.util.FeathrUtils$;
import com.linkedin.feathr.offline.util.datetime.DateTimeInterval;
import com.linkedin.feathr.sparkcommon.SourceKeyExtractor;
import com.linkedin.feathr.swj.FactData;
import com.linkedin.feathr.swj.LabelData;
import com.linkedin.feathr.swj.SlidingWindowJoin$;
import java.io.Serializable;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.sketch.BloomFilter;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}e!\u0002\u0005\n\u0001-\u0019\u0002\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\t\u0011I\u0002!\u0011!Q\u0001\nMBQ!\u000f\u0001\u0005\u0002iBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004N\u0001\u0001\u0006I!\u0011\u0005\u0006\u001d\u0002!\ta\u0014\u0005\b\u0003\u0017\u0003A\u0011AAG\u0005y\u0019F.\u001b3j]\u001e<\u0016N\u001c3po\u0006;wM]3hCRLwN\u001c&pS:,'O\u0003\u0002\u000b\u0017\u0005\u00191o^1\u000b\u00051i\u0011aB8gM2Lg.\u001a\u0006\u0003\u001d=\taAZ3bi\"\u0014(B\u0001\t\u0012\u0003!a\u0017N\\6fI&t'\"\u0001\n\u0002\u0007\r|Wn\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\fA#\u00197m/&tGm\\<BO\u001e4U-\u0019;ve\u0016\u001c8\u0001\u0001\t\u0005;\u0011:#F\u0004\u0002\u001fEA\u0011qDF\u0007\u0002A)\u0011\u0011eG\u0001\u0007yI|w\u000e\u001e \n\u0005\r2\u0012A\u0002)sK\u0012,g-\u0003\u0002&M\t\u0019Q*\u00199\u000b\u0005\r2\u0002CA\u000f)\u0013\tIcE\u0001\u0004TiJLgn\u001a\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nqAZ3biV\u0014XM\u0003\u00020\u0017\u0005A\u0011M\\2i_J,G-\u0003\u00022Y\t9b)Z1ukJ,\u0017I\\2i_J<\u0016\u000e\u001e5T_V\u00148-Z\u0001\u0019C:\u001c\u0007n\u001c:U_\u0012\u000bG/Y*pkJ\u001cW-T1qa\u0016\u0014\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c\f\u00039!(/\u00198tM>\u0014X.\u0019;j_:L!\u0001O\u001b\u00031\u0005s7\r[8s)>$\u0015\r^1T_V\u00148-Z'baB,'/\u0001\u0004=S:LGO\u0010\u000b\u0004wur\u0004C\u0001\u001f\u0001\u001b\u0005I\u0001\"\u0002\u000e\u0004\u0001\u0004a\u0002\"\u0002\u001a\u0004\u0001\u0004\u0019\u0014a\u00017pOV\t\u0011\t\u0005\u0002C\u00176\t1I\u0003\u0002E\u000b\u0006)An\\45U*\u0011aiR\u0001\bY><w-\u001b8h\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u001b%A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013!\u00076pS:<\u0016N\u001c3po\u0006;wMR3biV\u0014Xm]!t\t\u001a#\"\u0003\u00151ku\u0006\u0015\u0011\u0011BA\u0016\u0003{\t\t'!\u001e\u0002\u0000A!Q#U*X\u0013\t\u0011fC\u0001\u0004UkBdWM\r\t\u0003)Vk\u0011aC\u0005\u0003-.\u0011\u0001CR3biV\u0014X\rR1uC\u001a\u0013\u0018-\\3\u0011\u0007akvE\u0004\u0002Z7:\u0011qDW\u0005\u0002/%\u0011ALF\u0001\ba\u0006\u001c7.Y4f\u0013\tqvLA\u0002TKFT!\u0001\u0018\f\t\u000b\u00054\u0001\u0019\u00012\u0002\u0005M\u001c\bCA2i\u001b\u0005!'BA3g\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003O\u001e\u000bQa\u001d9be.L!!\u001b3\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b-4\u0001\u0019\u00017\u0002\u000b=\u00147\u000f\u0012$\u0011\u00055<hB\u00018w\u001d\tyWO\u0004\u0002qi:\u0011\u0011o\u001d\b\u0003?IL\u0011AS\u0005\u0003\u0011&K!aZ$\n\u0005\u00154\u0017B\u0001/e\u0013\tA\u0018PA\u0005ECR\fgI]1nK*\u0011A\f\u001a\u0005\u0006w\u001a\u0001\r\u0001`\u0001\u000bU>LgnQ8oM&<\u0007cA?\u0002\u00025\taP\u0003\u0002\u0000\u0017\u000511m\u001c8gS\u001eL1!a\u0001\u007f\u0005E1U-\u0019;ve\u0016Tu.\u001b8D_:4\u0017n\u001a\u0005\u0007\u0003\u000f1\u0001\u0019A,\u0002\u0015-,\u0017\u0010V1h\u0019&\u001cH\u000fC\u0004\u0002\f\u0019\u0001\r!!\u0004\u0002-]Lg\u000eZ8x\u0003\u001e<g)Z1ukJ,7\u000b^1hKN\u0004B\u0001W/\u0002\u0010A!\u0011\u0011CA\u0013\u001d\u0011\t\u0019\"a\t\u000f\t\u0005U\u0011\u0011\u0005\b\u0005\u0003/\tyB\u0004\u0003\u0002\u001a\u0005uabA\u0010\u0002\u001c%\t!#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!\u0001X\u0006\n\t\u0005\u001d\u0012\u0011\u0006\u0002\n\u0015>Lgn\u0015;bO\u0016T!\u0001X\u0006\t\u000f\u00055b\u00011\u0001\u00020\u0005I\"/Z9vSJ,GmV5oI><\u0018iZ4GK\u0006$XO]3t!\u0011AV,!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e\u000e\u0003\u0019\u0019w.\\7p]&!\u00111HA\u001b\u0005e)%/Y:fI\u0016sG/\u001b;z)\u0006<w-\u001a3GK\u0006$XO]3\t\u000f\u0005}b\u00011\u0001\u0002B\u0005a!\r\\8p[\u001aKG\u000e^3sgB)Q#a\u0011\u0002H%\u0019\u0011Q\t\f\u0003\r=\u0003H/[8o!\u0019iB%!\u0013\u0002RA!\u0001,XA&!\r)\u0012QJ\u0005\u0004\u0003\u001f2\"aA%oiB!\u00111KA/\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013AB:lKR\u001c\u0007NC\u0002\u0002\\\u0019\fA!\u001e;jY&!\u0011qLA+\u0005-\u0011En\\8n\r&dG/\u001a:\t\u000f\u0005\rd\u00011\u0001\u0002f\u0005i1o^1PEN$\u0016.\\3PaR\u0004R!FA\"\u0003O\u0002B!!\u001b\u0002r5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'\u0001\u0005eCR,G/[7f\u0015\r\tYfC\u0005\u0005\u0003g\nYG\u0001\tECR,G+[7f\u0013:$XM\u001d<bY\"9\u0011q\u000f\u0004A\u0002\u0005e\u0014A\u00064bS2|e.T5tg&tw\rU1si&$\u0018n\u001c8\u0011\u0007U\tY(C\u0002\u0002~Y\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0002\u001a\u0001\r!a!\u0002\u0015M<\u0018\rS1oI2,'\u000fE\u0003\u0016\u0003\u0007\n)\tE\u0002=\u0003\u000fK1!!#\n\u0005)\u0019v+\u0011%b]\u0012dWM]\u0001\u001egR\fg\u000eZ1sI&TXMR3biV\u0014XmQ8mk6tg*Y7fgRIA.a$\u0002\u0014\u0006]\u00151\u0014\u0005\u0007\u0003#;\u0001\u0019A,\u0002+=\u0014\u0018nZ\"p]R,\u0007\u0010^(cg\u000e{G.^7og\"1\u0011QS\u0004A\u00021\f\u0001c^5uQN;\u0016IR3biV\u0014X\r\u0012$\t\r\u0005eu\u00011\u0001X\u000311W-\u0019;ve\u0016t\u0015-\\3t\u0011\u0019\tij\u0002a\u0001/\u000691.Z=UC\u001e\u001c\b")
public class SlidingWindowAggregationJoiner {
    private final Map<String, FeatureAnchorWithSource> allWindowAggFeatures;
    private final AnchorToDataSourceMapper anchorToDataSourceMapper;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public Tuple2<FeatureDataFrame, Seq<String>> joinWindowAggFeaturesAsDF(SparkSession ss, Dataset<Row> obsDF, FeatureJoinConfig joinConfig, Seq<String> keyTagList, Seq<Tuple2<Seq<Object>, Seq<String>>> windowAggFeatureStages, Seq<ErasedEntityTaggedFeature> requiredWindowAggFeatures, Option<Map<Seq<Object>, BloomFilter>> bloomFilters, Option<DateTimeInterval> swaObsTimeOpt, boolean failOnMissingPartition, Option<SWAHandler> swaHandler) {
        Option<JoinConfigSettings> joinConfigSettings = joinConfig.settings();
        if (joinConfigSettings.isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "settings section are not defined in join config, cannot extract observation data time range");
        }
        if (((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "joinTimeSettings section is not defined in join config, cannot perform window aggregation operation");
        }
        JoinTimeSetting timeWindowJoinSettings = (JoinTimeSetting)((JoinConfigSettings)joinConfigSettings.get()).joinTimeSetting().get();
        Option<Duration> simulatedDelay = timeWindowJoinSettings.simulateTimeDelay();
        boolean shouldFilterNulls = new StringOps(Predef$.MODULE$.augmentString(FeathrUtils$.MODULE$.getFeathrJobParam(ss.sparkContext().getConf(), FeathrUtils$.MODULE$.FILTER_NULLS()))).toBoolean();
        if (simulatedDelay.isEmpty() && !joinConfig.featuresToTimeDelayMap().isEmpty()) {
            throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "overrideTimeDelay cannot be defined without setting a simulateTimeDelay in the joinTimeSettings");
        }
        Map featuresToDelayImmutableMap = joinConfig.featuresToTimeDelayMap().mapValues((Function1 & Serializable & scala.Serializable)timeWindowStr -> WindowTimeUnit$.MODULE$.parseWindowTime((String)timeWindowStr)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(simulatedDelay.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SlidingWindowFeatureUtils$.MODULE$.DEFAULT_TIME_DELAY()), x$1))).toMap(Predef$.MODULE$.$conforms()));
        scala.collection.immutable.IndexedSeq windowAggFeatureNames = ((TraversableOnce)requiredWindowAggFeatures.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getFeatureName(), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
        scala.collection.immutable.IndexedSeq windowAggAnchors = (scala.collection.immutable.IndexedSeq)windowAggFeatureNames.map(this.allWindowAggFeatures, IndexedSeq$.MODULE$.canBuildFrom());
        ObjectRef contextDF = ObjectRef.create(obsDF);
        DateTimeInterval swaObsTimeRange = (DateTimeInterval)swaObsTimeOpt.get();
        Map windowAggSourceToAnchor = (Map)((TraversableLike)windowAggAnchors.map((Function1 & Serializable & scala.Serializable)anchor -> {
            String featureNames = PreprocessedDataFrameManager$.MODULE$.getPreprocessingUniquenessForAnchor((FeatureAnchorWithSource)anchor);
            return new Tuple2((Object)new Tuple3((Object)anchor.source(), (Object)anchor.featureAnchor().sourceKeyExtractor().toString(), (Object)featureNames), anchor);
        }, IndexedSeq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (Tuple3)x$3._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 source = (Tuple3)tuple2._1();
            scala.collection.immutable.IndexedSeq grouped = (scala.collection.immutable.IndexedSeq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)source, grouped.map((Function1 & Serializable & scala.Serializable)x$4 -> (FeatureAnchorWithSource)x$4._2(), IndexedSeq$.MODULE$.canBuildFrom()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        HashSet notJoinedFeatures = new HashSet();
        Map windowAggAnchorDFMap = (Map)windowAggSourceToAnchor.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            scala.collection.immutable.IndexedSeq indexedSeq;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple3 sourceWithKeyExtractor = (Tuple3)tuple2._1();
                scala.collection.immutable.IndexedSeq anchors = (scala.collection.immutable.IndexedSeq)tuple2._2();
                Duration maxDurationPerSource = (Duration)((TraversableOnce)anchors.map((Function1 & Serializable & scala.Serializable)x$5 -> SlidingWindowFeatureUtils$.MODULE$.getMaxWindowDurationInAnchor((FeatureAnchorWithSource)x$5, (IndexedSeq<String>)windowAggFeatureNames), IndexedSeq$.MODULE$.canBuildFrom())).max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.log().info(new StringBuilder(60).append("Selected max window duration ").append(maxDurationPerSource).append(" across all anchors for source ").append(((DataSource)sourceWithKeyExtractor._1()).path()).toString());
                scala.collection.immutable.IndexedSeq res = (scala.collection.immutable.IndexedSeq)anchors.flatMap((Function1 & Serializable & scala.Serializable)x -> x.featureAnchor().features(), IndexedSeq$.MODULE$.canBuildFrom());
                String featureNames = ((TraversableOnce)res.toSet().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
                Option preprocessedDf = PreprocessedDataFrameManager$.MODULE$.preprocessedDfMap().get((Object)featureNames);
                Dataset originalSourceDf = $this.anchorToDataSourceMapper.getWindowAggAnchorDFMapForJoin(ss, (DataSource)sourceWithKeyExtractor._1(), swaObsTimeRange, maxDurationPerSource, (Duration[])featuresToDelayImmutableMap.values().toArray(ClassTag$.MODULE$.apply(Duration.class)), failOnMissingPartition);
                if (originalSourceDf.isEmpty()) {
                    res.map((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)notJoinedFeatures.add((Object)elem)), IndexedSeq$.MODULE$.canBuildFrom());
                    indexedSeq = (scala.collection.immutable.IndexedSeq)anchors.map((Function1 & Serializable & scala.Serializable)anchor -> new Tuple2(anchor, (Object)originalSourceDf), IndexedSeq$.MODULE$.canBuildFrom());
                } else {
                    Dataset<Row> dataset;
                    Dataset dataset2;
                    Option option = preprocessedDf;
                    if (option instanceof Some) {
                        Dataset existDf;
                        Some some = (Some)option;
                        dataset2 = existDf = (Dataset)some.value();
                    } else if (None$.MODULE$.equals(option)) {
                        dataset2 = originalSourceDf;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    Dataset sourceDF = dataset2;
                    SourceKeyExtractor sourceKeyExtractor = ((FeatureAnchorWithSource)anchors.head()).featureAnchor().sourceKeyExtractor();
                    if (sourceKeyExtractor instanceof SQLSourceKeyExtractor) {
                        SQLSourceKeyExtractor sQLSourceKeyExtractor = (SQLSourceKeyExtractor)sourceKeyExtractor;
                        dataset = sQLSourceKeyExtractor.appendKeyColumns((Dataset<Row>)sourceDF, false);
                    } else {
                        dataset = sourceKeyExtractor.appendKeyColumns((Dataset<Row>)sourceDF);
                    }
                    Dataset<Row> withKeyDF = dataset;
                    indexedSeq = (scala.collection.immutable.IndexedSeq)anchors.map((Function1 & Serializable & scala.Serializable)anchor -> new Tuple2(anchor, (Object)withKeyDF), IndexedSeq$.MODULE$.canBuildFrom());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.IndexedSeq indexedSeq2 = indexedSeq;
            return indexedSeq2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Map updatedWindowAggAnchorDFMap = (Map)windowAggAnchorDFMap.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SlidingWindowAggregationJoiner.$anonfun$joinWindowAggFeaturesAsDF$14(x)));
        scala.collection.mutable.Map allInferredFeatureTypes = Map$.MODULE$.empty();
        windowAggFeatureStages.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            SlidingWindowAggregationJoiner.$anonfun$joinWindowAggFeaturesAsDF$15(this, notJoinedFeatures, keyTagList, bloomFilters, timeWindowJoinSettings, shouldFilterNulls, contextDF, ss, updatedWindowAggAnchorDFMap, featuresToDelayImmutableMap, swaHandler, allInferredFeatureTypes, x0$3);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)new FeatureDataFrame((Dataset<Row>)((Dataset)contextDF.elem), (Map<String, FeatureTypeConfig>)allInferredFeatureTypes.toMap(Predef$.MODULE$.$conforms())), (Object)notJoinedFeatures.toSeq());
    }

    public Dataset<Row> standardizeFeatureColumnNames(Seq<String> origContextObsColumns, Dataset<Row> withSWAFeatureDF, Seq<String> featureNames, Seq<String> keyTags) {
        int inputColumnSize = origContextObsColumns.size();
        int outputColumnNum = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])withSWAFeatureDF.columns())).size();
        if (outputColumnNum != inputColumnSize + featureNames.size()) {
            throw new FeathrIllegalStateException(new StringBuilder(238).append("Number of columns (").append(outputColumnNum).append(") in the dataframe returned by ").append("sliding window aggregation does not equal to number of columns in the observation data (").append(inputColumnSize).append(") ").append("+ number of features (").append(featureNames.size()).append("). Columns in returned dataframe are ").append(withSWAFeatureDF.columns()).append(",").append(" columns in observation dataframe are ").append(origContextObsColumns).toString());
        }
        Seq renamingPairs = (Seq)featureNames.map((Function1 & Serializable & scala.Serializable)feature -> {
            String columnName = DataFrameColName$.MODULE$.genFeatureColumnName((String)feature, (Option<Seq<String>>)new Some((Object)keyTags));
            return new Tuple2(feature, (Object)columnName);
        }, Seq$.MODULE$.canBuildFrom());
        return (Dataset)renamingPairs.foldLeft(withSWAFeatureDF, (Function2 & Serializable & scala.Serializable)(baseDF, renamePair) -> baseDF.withColumnRenamed((String)renamePair._1(), (String)renamePair._2()));
    }

    public static final /* synthetic */ boolean $anonfun$joinWindowAggFeaturesAsDF$14(Tuple2 x) {
        Dataset df = (Dataset)x._2();
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.head(1))).isEmpty();
    }

    public static final /* synthetic */ FactData $anonfun$joinWindowAggFeaturesAsDF$18(Seq joinedFeatures$1, Option bloomFilter$1, Map featuresToDelayImmutableMap$1, Map anchorWithSourceToDFMap) {
        Dataset dataset;
        Set selectedFeatures = (Set)((TraversableLike)anchorWithSourceToDFMap.keySet().flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.selectedFeatures(), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)joinedFeatures$1.contains((Object)x$9)));
        Dataset factData = (Dataset)((Tuple2)anchorWithSourceToDFMap.head())._2();
        FeatureAnchorWithSource anchor = (FeatureAnchorWithSource)((Tuple2)anchorWithSourceToDFMap.head())._1();
        Seq<String> keyColumnsList = anchor.featureAnchor().sourceKeyExtractor().getKeyColumnNames((Option<Object>)None$.MODULE$);
        Option option = bloomFilter$1;
        if (None$.MODULE$.equals(option)) {
            dataset = factData;
        } else if (option instanceof Some) {
            boolean x$3;
            Seq<String> x$2;
            Dataset x$1;
            Some some = (Some)option;
            BloomFilter filter = (BloomFilter)some.value();
            if (anchor.featureAnchor().sourceKeyExtractor() instanceof MVELSourceKeyExtractor) {
                throw new FeathrConfigException(ErrorLabel.FEATHR_USER_ERROR, "MVELSourceKeyExtractor is not supported in sliding window aggregation");
            }
            DataFrameKeyCombiner qual$1 = DataFrameKeyCombiner$.MODULE$.apply();
            Tuple2<String, Dataset<Row>> tuple2 = qual$1.combine((Dataset<Row>)(x$1 = factData), x$2 = keyColumnsList, x$3 = qual$1.combine$default$3());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String bfFactKeyColName = (String)tuple2._1();
            Dataset factDataWithKeys = (Dataset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)bfFactKeyColName, (Object)factDataWithKeys);
            Tuple2 tuple23 = tuple22;
            String bfFactKeyColName2 = (String)tuple23._1();
            Dataset factDataWithKeys2 = (Dataset)tuple23._2();
            Dataset filtered = factDataWithKeys2.filter(SlidingWindowFeatureUtils$.MODULE$.mightContain(filter).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(bfFactKeyColName2)})));
            dataset = filtered.drop(functions$.MODULE$.col(bfFactKeyColName2));
        } else {
            throw new MatchError((Object)option);
        }
        Dataset filteredFactData = dataset;
        return SlidingWindowFeatureUtils$.MODULE$.getFactDataDef((Dataset<Row>)filteredFactData, (Seq<FeatureAnchorWithSource>)anchorWithSourceToDFMap.keySet().toSeq(), (Map<String, Duration>)featuresToDelayImmutableMap$1, (Set<String>)selectedFeatures);
    }

    public static final /* synthetic */ void $anonfun$joinWindowAggFeaturesAsDF$26(SlidingWindowAggregationJoiner $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FactData factDataDef = (FactData)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        $this.log().debug(new StringBuilder(35).append("First 3 rows in feature dataset ").append(idx).append(":\n ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])factDataDef.dataSource().collect())).take(3))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n ")).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$joinWindowAggFeaturesAsDF$15(SlidingWindowAggregationJoiner $this, HashSet notJoinedFeatures$1, Seq keyTagList$1, Option bloomFilters$1, JoinTimeSetting timeWindowJoinSettings$1, boolean shouldFilterNulls$1, ObjectRef contextDF$1, SparkSession ss$1, Map updatedWindowAggAnchorDFMap$1, Map featuresToDelayImmutableMap$1, Option swaHandler$1, scala.collection.mutable.Map allInferredFeatureTypes$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq keyTags = (Seq)tuple2._1();
        Seq featureNames = (Seq)tuple2._2();
        if (keyTags == null) throw new MatchError((Object)tuple2);
        Seq seq = keyTags;
        if (featureNames == null) throw new MatchError((Object)tuple2);
        Seq seq2 = featureNames;
        Seq joinedFeatures = (Seq)seq2.diff((GenSeq)notJoinedFeatures$1.toSeq());
        if (joinedFeatures.nonEmpty()) {
            Dataset dataset;
            Tuple2 tuple22;
            None$ none$;
            $this.log().warn(new StringBuilder(37).append("----SKIPPED ADDING FEATURES : ").append(notJoinedFeatures$1).append(" ------").toString());
            Seq stringKeyTags = (Seq)((TraversableLike)seq.map((Function1)keyTagList$1, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(17).append("CAST (").append((String)k).append(" AS string)").toString(), Seq$.MODULE$.canBuildFrom());
            Option option = bloomFilters$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Map filters = (Map)some.value();
                none$ = Option$.MODULE$.apply(filters.apply((Object)seq));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                none$ = None$.MODULE$;
            }
            None$ bloomFilter = none$;
            String timeStampExpr = !timeWindowJoinSettings$1.useLatestFeatureData() ? SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr(timeWindowJoinSettings$1.timestampColumn().name(), timeWindowJoinSettings$1.timestampColumn().format(), SlidingWindowFeatureUtils$.MODULE$.constructTimeStampExpr$default$3()) : "unix_timestamp()";
            Tuple2 tuple23 = tuple22 = shouldFilterNulls$1 ? new Tuple2(DataFrameUtils$.MODULE$.filterNulls((Dataset<Row>)((Dataset)contextDF$1.elem), (Seq<String>)((Seq)seq.map((Function1)keyTagList$1, Seq$.MODULE$.canBuildFrom()))), DataFrameUtils$.MODULE$.filterNonNulls((Dataset<Row>)((Dataset)contextDF$1.elem), (Seq<String>)((Seq)seq.map((Function1)keyTagList$1, Seq$.MODULE$.canBuildFrom())))) : new Tuple2((Object)((Dataset)contextDF$1.elem), (Object)ss$1.emptyDataFrame());
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Dataset nullFilteredLabelData = (Dataset)tuple22._1();
            Dataset factDataRowsWithNulls = (Dataset)tuple22._2();
            Tuple2 tuple24 = new Tuple2((Object)nullFilteredLabelData, (Object)factDataRowsWithNulls);
            Tuple2 tuple25 = tuple24;
            Dataset nullFilteredLabelData2 = (Dataset)tuple25._1();
            Dataset factDataRowsWithNulls2 = (Dataset)tuple25._2();
            LabelData labelDataDef = new LabelData((Dataset<Row>)nullFilteredLabelData2, (Seq<String>)stringKeyTags, timeStampExpr);
            if (ss$1.sparkContext().isLocal() && $this.log().isDebugEnabled()) {
                $this.log().debug(new StringBuilder(87).append("*********Sliding window aggregation feature join stage with key: ").append(stringKeyTags).append(" for feature ").append(joinedFeatures.mkString(",")).append("*********").toString());
                $this.log().debug(new StringBuilder(39).append("First 3 rows in observation dataset :\n ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labelDataDef.dataSource().collect())).take(3))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n ")).toString());
            }
            Seq windowAggAnchorsThisStage = (Seq)joinedFeatures.map($this.allWindowAggFeatures, Seq$.MODULE$.canBuildFrom());
            Map windowAggAnchorDFThisStage = updatedWindowAggAnchorDFMap$1.filterKeys((Function1)windowAggAnchorsThisStage.toSet());
            Seq factDataDefs = (Seq)SlidingWindowFeatureUtils$.MODULE$.getSWAAnchorGroups((Map<FeatureAnchorWithSource, Dataset<Row>>)windowAggAnchorDFThisStage).map(arg_0 -> SlidingWindowAggregationJoiner.$anonfun$joinWindowAggFeaturesAsDF$18(joinedFeatures, (Option)bloomFilter, featuresToDelayImmutableMap$1, arg_0), Seq$.MODULE$.canBuildFrom());
            String[] origContextObsColumns = labelDataDef.dataSource().columns();
            Dataset dataset2 = contextDF$1.elem = swaHandler$1.isDefined() ? (Dataset)((SWAHandler)swaHandler$1.get()).join().apply((Object)labelDataDef, (Object)factDataDefs.toList()) : SlidingWindowJoin$.MODULE$.join(labelDataDef, (List<FactData>)factDataDefs.toList(), SlidingWindowJoin$.MODULE$.join$default$3());
            if (shouldFilterNulls$1 && !factDataRowsWithNulls2.isEmpty()) {
                Dataset nullDfWithFeatureCols = (Dataset)joinedFeatures.foldLeft((Object)factDataRowsWithNulls2, (Function2 & Serializable & scala.Serializable)(s, x) -> s.withColumn(x, functions$.MODULE$.lit(null)));
                dataset = ((Dataset)contextDF$1.elem).union(nullDfWithFeatureCols);
            } else {
                dataset = (Dataset)contextDF$1.elem;
            }
            contextDF$1.elem = dataset;
            Map defaults = (Map)windowAggAnchorDFThisStage.flatMap((Function1 & Serializable & scala.Serializable)s -> ((FeatureAnchorWithSource)s._1()).featureAnchor().defaults(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            Map userSpecifiedTypesConfig = (Map)windowAggAnchorDFThisStage.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> ((FeatureAnchorWithSource)x$11._1()).featureAnchor().featureTypeConfigs(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            Map featureNameToColumnFormat = (Map)$this.allWindowAggFeatures.map((Function1 & Serializable & scala.Serializable)nameToFeatureAnchor -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nameToFeatureAnchor._1()), (Object)((TimeWindowFeatureDefinition)((TimeWindowConfigurableAnchorExtractor)((FeatureAnchorWithSource)nameToFeatureAnchor._2()).featureAnchor().extractor()).features().apply(nameToFeatureAnchor._1())).columnFormat()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            FeatureDataFrame featureDataFrame = SlidingWindowFeatureUtils$.MODULE$.convertSWADFToFDS((Dataset<Row>)((Dataset)contextDF$1.elem), (Set<String>)joinedFeatures.toSet(), (Map<String, Enumeration.Value>)featureNameToColumnFormat, (Map<String, FeatureTypeConfig>)userSpecifiedTypesConfig);
            if (featureDataFrame == null) {
                throw new MatchError((Object)featureDataFrame);
            }
            Dataset<Row> withFDSFeatureDF = featureDataFrame.df();
            Map<String, FeatureTypeConfig> inferredTypes = featureDataFrame.inferredFeatureType();
            Tuple2 tuple26 = new Tuple2(withFDSFeatureDF, inferredTypes);
            Tuple2 tuple27 = tuple26;
            Dataset withFDSFeatureDF2 = (Dataset)tuple27._1();
            Map inferredTypes2 = (Map)tuple27._2();
            Dataset<Row> withFeatureContextDF = DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults((Dataset<Row>)withFDSFeatureDF2, (Seq<String>)((TraversableOnce)defaults.keys().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)joinedFeatures.contains(elem)))).toSeq(), (Map<String, FeatureValue>)defaults, (Map<String, FeatureTypeConfig>)userSpecifiedTypesConfig, ss$1, DataFrameDefaultValueSubstituter$.MODULE$.substituteDefaults$default$6());
            allInferredFeatureTypes$1.$plus$plus$eq((TraversableOnce)inferredTypes2);
            contextDF$1.elem = $this.standardizeFeatureColumnNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])origContextObsColumns), withFeatureContextDF, (Seq<String>)joinedFeatures, (Seq<String>)((Seq)seq.map((Function1)keyTagList$1, Seq$.MODULE$.canBuildFrom())));
            if (FeathrUtils$.MODULE$.shouldCheckPoint(ss$1)) {
                contextDF$1.elem = ((Dataset)contextDF$1.elem).checkpoint(true);
            }
            if (ss$1.sparkContext().isLocal() && $this.log().isDebugEnabled()) {
                ((IterableLike)factDataDefs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    SlidingWindowAggregationJoiner.$anonfun$joinWindowAggFeaturesAsDF$26($this, x0$4);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public SlidingWindowAggregationJoiner(Map<String, FeatureAnchorWithSource> allWindowAggFeatures, AnchorToDataSourceMapper anchorToDataSourceMapper) {
        this.allWindowAggFeatures = allWindowAggFeatures;
        this.anchorToDataSourceMapper = anchorToDataSourceMapper;
        this.log = LogManager.getLogger(this.getClass());
    }
}

