/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.transformation;

import com.linkedin.feathr.common.FeatureTypeConfig;
import com.linkedin.feathr.common.FeatureTypes;
import com.linkedin.feathr.common.package$;
import com.linkedin.feathr.common.tensor.TensorType;
import com.linkedin.feathr.offline.anchored.anchorExtractor.SQLConfigurableAnchorExtractor;
import com.linkedin.feathr.offline.job.TransformedResult;
import com.linkedin.feathr.offline.transformation.FeatureColumnFormat$;
import com.linkedin.feathr.offline.util.FeaturizedDatasetUtils$;
import com.linkedin.feathr.sparkcommon.SimpleAnchorExtractorSpark;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;

public final class DataFrameBasedSqlEvaluator$ {
    public static DataFrameBasedSqlEvaluator$ MODULE$;

    static {
        new DataFrameBasedSqlEvaluator$();
    }

    public TransformedResult transform(SimpleAnchorExtractorSpark transformer, Dataset<Row> inputDf, Seq<Tuple2<String, String>> requestedFeatureNameAndPrefix, Map<String, FeatureTypeConfig> featureTypeConfigs) {
        Seq requestedFeatureName = (Seq)requestedFeatureNameAndPrefix.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Seq$.MODULE$.canBuildFrom());
        transformer.setInternalParams(package$.MODULE$.SELECTED_FEATURES(), new StringBuilder(2).append("[").append(requestedFeatureName.mkString(",")).append("]").toString());
        Map featureSchemas = ((TraversableOnce)requestedFeatureName.map((Function1 & Serializable & scala.Serializable)featureName -> {
            TensorType tensorType = FeaturizedDatasetUtils$.MODULE$.lookupTensorTypeForFeatureRef((String)featureName, (Option<DataType>)None$.MODULE$, (FeatureTypeConfig)featureTypeConfigs.getOrElse(featureName, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG));
            DataType schema = FeaturizedDatasetUtils$.MODULE$.tensorTypeToDataFrameSchema(tensorType);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(featureName), (Object)schema);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map transformedColsAndFormats = transformer instanceof SQLConfigurableAnchorExtractor ? ((SQLConfigurableAnchorExtractor)transformer).getTensorFeatures(inputDf, (Map<String, DataType>)featureSchemas) : ((TraversableOnce)transformer.transformAsColumns(inputDf).map((Function1 & Serializable & scala.Serializable)c -> new Tuple2(c, (Object)FeatureColumnFormat$.MODULE$.RAW()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Dataset<Row> transformedDF = this.createFeatureDF(inputDf, (Seq<Tuple2<String, Column>>)transformedColsAndFormats.keys().toSeq());
        Seq inferredFeatureTypeConfigs = (Seq)requestedFeatureName.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FeatureTypeConfig featureTypeConfig;
            String string = x0$1;
            FeatureTypeConfig featureTypeConfig2 = (FeatureTypeConfig)featureTypeConfigs.getOrElse((Object)string, (Function0 & Serializable & scala.Serializable)() -> FeatureTypeConfig.UNDEFINED_TYPE_CONFIG);
            String colName = string;
            FeatureTypes featureTypes = featureTypeConfig2.getFeatureType();
            FeatureTypes featureTypes2 = FeatureTypes.UNSPECIFIED;
            if (!(featureTypes != null ? !((Object)((Object)featureTypes)).equals((Object)featureTypes2) : featureTypes2 != null)) {
                DataType dataType = transformedDF.schema().fields()[transformedDF.schema().fieldIndex(colName)].dataType();
                FeatureTypes inferredFeatureType = FeaturizedDatasetUtils$.MODULE$.inferFeatureTypeFromColumnDataType(dataType);
                featureTypeConfig = new FeatureTypeConfig(inferredFeatureType);
            } else {
                featureTypeConfig = featureTypeConfig2;
            }
            FeatureTypeConfig inferredFeatureTypeConfig = featureTypeConfig;
            Tuple2 tuple2 = new Tuple2((Object)string, (Object)inferredFeatureTypeConfig);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        return new TransformedResult(requestedFeatureNameAndPrefix, transformedDF, (Map<String, Enumeration.Value>)((Map)transformedColsAndFormats.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((Tuple2)e._1())._1()), e._2()), Map$.MODULE$.canBuildFrom())), (Map<String, FeatureTypeConfig>)inferredFeatureTypeConfigs.toMap(Predef$.MODULE$.$conforms()));
    }

    private Dataset<Row> createFeatureDF(Dataset<Row> inputDf, Seq<Tuple2<String, Column>> featureColumnDefs) {
        String featureColumnNamePrefix = "_feathr_sql_feature_prefix_";
        Dataset transformedDF = (Dataset)featureColumnDefs.foldLeft(inputDf, (Function2 & Serializable & scala.Serializable)(baseDF, columnWithName) -> {
            String columnName = new StringBuilder(0).append(featureColumnNamePrefix).append(columnWithName._1()).toString();
            return baseDF.withColumn(columnName, (Column)columnWithName._2());
        });
        Seq featureNames = (Seq)featureColumnDefs.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), Seq$.MODULE$.canBuildFrom());
        Dataset withoutDupContextFieldDF = transformedDF.drop(featureNames);
        return (Dataset)((TraversableOnce)featureNames.zip((GenIterable)featureNames, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)withoutDupContextFieldDF, (Function2 & Serializable & scala.Serializable)(baseDF, namePair) -> baseDF.withColumnRenamed(new StringBuilder(0).append(featureColumnNamePrefix).append(namePair._1()).toString(), (String)namePair._2()));
    }

    private DataFrameBasedSqlEvaluator$() {
        MODULE$ = this;
    }
}

