/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.linkedin.feathr.offline.config.location.SimplePath;
import com.linkedin.feathr.offline.generation.SparkIOUtils$;
import com.linkedin.feathr.offline.source.dataloader.DataLoaderHandler;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class FeathrUtils$ {
    public static FeathrUtils$ MODULE$;
    private transient Logger log;
    private final String ENVIRONMENT;
    private final String ENABLE_DEBUG_OUTPUT;
    private final String DEBUG_FEATURE_NAMES;
    private final String DEBUG_OUTPUT_PATH;
    private final String DEBUG_OUTPUT_PART_NUM;
    private final String FEATHR_PARAMS_PREFIX;
    private final String FAIL_ON_MISSING_PARTITION;
    private final String SEQ_JOIN_ARRAY_EXPLODE_ENABLED;
    private final String ENABLE_SALTED_JOIN;
    private final String SKIP_MISSING_FEATURE;
    private final String SALTED_JOIN_FREQ_ITEM_THRESHOLD;
    private final String SALTED_JOIN_FREQ_ITEM_ESTIMATOR;
    private final String SALTED_JOIN_PERSIST;
    private final String SALTED_JOIN_REPLICATION_FACTOR_HIGH;
    private final String ENABLE_SLICK_JOIN;
    private final String ENABLE_METRICS;
    private final String ENABLE_CHECKPOINT;
    private final String CHECKPOINT_FREQUENCY;
    private final String ROW_BLOOMFILTER_MAX_THRESHOLD;
    private final String SPARK_JOIN_MAX_PARALLELISM;
    private final String CHECKPOINT_OUTPUT_PATH;
    private final String SPARK_JOIN_MIN_PARALLELISM;
    private final String MAX_DATA_LOAD_RETRY;
    private final String DATA_LOAD_WAIT_IN_MS;
    private final String ENABLE_SANITY_CHECK_MODE;
    private final String SANITY_CHECK_MODE_ROW_COUNT;
    private final String FILTER_NULLS;
    private final String STRING_PARAMETER_DELIMITER;
    private final AtomicLong checkPointSequenceNumber;
    private final Map<String, Tuple2<OptionalConfigEntry<String>, String>> sqlConfsWithDefaultParam;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FeathrUtils$();
    }

    public String ENVIRONMENT() {
        return this.ENVIRONMENT;
    }

    public String ENABLE_DEBUG_OUTPUT() {
        return this.ENABLE_DEBUG_OUTPUT;
    }

    public String DEBUG_FEATURE_NAMES() {
        return this.DEBUG_FEATURE_NAMES;
    }

    public String DEBUG_OUTPUT_PATH() {
        return this.DEBUG_OUTPUT_PATH;
    }

    public String DEBUG_OUTPUT_PART_NUM() {
        return this.DEBUG_OUTPUT_PART_NUM;
    }

    public String FEATHR_PARAMS_PREFIX() {
        return this.FEATHR_PARAMS_PREFIX;
    }

    public String FAIL_ON_MISSING_PARTITION() {
        return this.FAIL_ON_MISSING_PARTITION;
    }

    public String SEQ_JOIN_ARRAY_EXPLODE_ENABLED() {
        return this.SEQ_JOIN_ARRAY_EXPLODE_ENABLED;
    }

    public String ENABLE_SALTED_JOIN() {
        return this.ENABLE_SALTED_JOIN;
    }

    public String SKIP_MISSING_FEATURE() {
        return this.SKIP_MISSING_FEATURE;
    }

    public String SALTED_JOIN_FREQ_ITEM_THRESHOLD() {
        return this.SALTED_JOIN_FREQ_ITEM_THRESHOLD;
    }

    public String SALTED_JOIN_FREQ_ITEM_ESTIMATOR() {
        return this.SALTED_JOIN_FREQ_ITEM_ESTIMATOR;
    }

    public String SALTED_JOIN_PERSIST() {
        return this.SALTED_JOIN_PERSIST;
    }

    public String SALTED_JOIN_REPLICATION_FACTOR_HIGH() {
        return this.SALTED_JOIN_REPLICATION_FACTOR_HIGH;
    }

    public String ENABLE_SLICK_JOIN() {
        return this.ENABLE_SLICK_JOIN;
    }

    public String ENABLE_METRICS() {
        return this.ENABLE_METRICS;
    }

    public String ENABLE_CHECKPOINT() {
        return this.ENABLE_CHECKPOINT;
    }

    public String CHECKPOINT_FREQUENCY() {
        return this.CHECKPOINT_FREQUENCY;
    }

    public String ROW_BLOOMFILTER_MAX_THRESHOLD() {
        return this.ROW_BLOOMFILTER_MAX_THRESHOLD;
    }

    public String SPARK_JOIN_MAX_PARALLELISM() {
        return this.SPARK_JOIN_MAX_PARALLELISM;
    }

    public String CHECKPOINT_OUTPUT_PATH() {
        return this.CHECKPOINT_OUTPUT_PATH;
    }

    public String SPARK_JOIN_MIN_PARALLELISM() {
        return this.SPARK_JOIN_MIN_PARALLELISM;
    }

    public String MAX_DATA_LOAD_RETRY() {
        return this.MAX_DATA_LOAD_RETRY;
    }

    public String DATA_LOAD_WAIT_IN_MS() {
        return this.DATA_LOAD_WAIT_IN_MS;
    }

    public String ENABLE_SANITY_CHECK_MODE() {
        return this.ENABLE_SANITY_CHECK_MODE;
    }

    public String SANITY_CHECK_MODE_ROW_COUNT() {
        return this.SANITY_CHECK_MODE_ROW_COUNT;
    }

    public String FILTER_NULLS() {
        return this.FILTER_NULLS;
    }

    public String STRING_PARAMETER_DELIMITER() {
        return this.STRING_PARAMETER_DELIMITER;
    }

    public AtomicLong checkPointSequenceNumber() {
        return this.checkPointSequenceNumber;
    }

    public Map<String, Tuple2<OptionalConfigEntry<String>, String>> sqlConfsWithDefaultParam() {
        return this.sqlConfsWithDefaultParam;
    }

    public String feathrVersion() {
        Properties versionProperties = new Properties();
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream("metric.properties");
        versionProperties.load(resourceStream);
        return versionProperties.getProperty("version");
    }

    public String getFeathrJobParam(SparkSession ss, String paramName) {
        SparkConf sparkConf = ss.sparkContext().getConf();
        return this.getFeathrJobParam(sparkConf, paramName);
    }

    public String getFeathrJobParam(SparkConf sparkConf, String paramName) {
        String string;
        String key = this.getFullConfigKeyName(paramName);
        Option conf = this.sqlConfsWithDefaultParam().get((Object)paramName);
        if (conf.isDefined()) {
            Option sqlConfValue = SQLConf$.MODULE$.get().getConf((OptionalConfigEntry)((Tuple2)conf.get())._1());
            string = (String)sqlConfValue.getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkConf.get(key, (String)((Tuple2)conf.get())._2()));
        } else {
            string = sparkConf.get(key);
        }
        return string;
    }

    public void setFeathrJobParam(String paramName, String value) {
        Option conf = this.sqlConfsWithDefaultParam().get((Object)paramName);
        if (conf.isDefined()) {
            String key = this.getFullConfigKeyName(paramName);
            SQLConf$.MODULE$.get().setConfString(key, value);
        } else {
            this.log().warn(new StringBuilder(52).append("Unsupported parameter ").append(paramName).append(". Please check parameter name.").toString());
        }
    }

    public String getFullConfigKeyName(String paramName) {
        return new StringBuilder(0).append(this.FEATHR_PARAMS_PREFIX()).append(paramName).toString();
    }

    public void enableDebugLogging(SparkConf sparkConf) {
        block0: {
            boolean enableDebugLog = this.isDebugOutputEnabled(sparkConf);
            if (!enableDebugLog) break block0;
            org.apache.log4j.Logger.getRootLogger().setLevel(Level.DEBUG);
        }
    }

    public String readFileFromHDFS(SparkSession ss, String path) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ss.sparkContext().textFile(path, ss.sparkContext().textFile$default$2()).collect())).mkString("\n");
    }

    private boolean isDebugOutputEnabled(SparkConf sparkConf) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getFeathrJobParam(sparkConf, this.ENABLE_DEBUG_OUTPUT()))).toBoolean();
    }

    public void dumpDebugInfo(SparkSession ss, Dataset<Row> df, Set<String> features, String tag, String pathSuffix) {
        block2: {
            if (!this.isDebugMode(ss)) break block2;
            String basePath = this.getFeathrJobParam(ss.sparkContext().getConf(), this.DEBUG_OUTPUT_PATH());
            Set debugFeatureNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getFeathrJobParam(ss.sparkContext().getConf(), this.DEBUG_FEATURE_NAMES()).split(this.STRING_PARAMETER_DELIMITER()))).toSet();
            String outputNumParts = this.getFeathrJobParam(ss.sparkContext().getConf(), this.DEBUG_OUTPUT_PART_NUM());
            String featureNames = new StringBuilder(10).append("features_").append(features.mkString("_")).append("_").toString();
            if (debugFeatureNames.isEmpty() || ((TraversableOnce)features.intersect((GenSet)debugFeatureNames)).nonEmpty()) {
                SimplePath savePath = new SimplePath(new StringBuilder(1).append(basePath).append("/").append(featureNames).append(pathSuffix).toString());
                this.log().info(new StringBuilder(25).append(tag).append(", Start dumping data ").append(featureNames).append(" to ").append(savePath).toString());
                Dataset<Row> dataset = !df.isEmpty() ? SparkIOUtils$.MODULE$.writeDataFrame(df, savePath, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DEBUG_OUTPUT_PART_NUM()), (Object)outputNumParts)}))), (List<DataLoaderHandler>)Nil$.MODULE$) : BoxedUnit.UNIT;
                this.log().info(new StringBuilder(31).append("{tag}. Finish dumping data ").append(featureNames).append(" to ").append(savePath).toString());
            } else {
                this.log().info(new StringBuilder(95).append("{tag}. Skipping dumping data as feature names to debug are ").append(debugFeatureNames).append(", ").append("and current dataframe has feature ").append(featureNames).toString());
            }
        }
    }

    public boolean isDebugMode(SparkSession ss) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getFeathrJobParam(ss.sparkContext().getConf(), this.ENABLE_DEBUG_OUTPUT()))).toBoolean();
    }

    public boolean shouldCheckPoint(SparkSession ss) {
        int checkpoint_frequency;
        long currentCount;
        boolean enableCheckPoint = new StringOps(Predef$.MODULE$.augmentString(this.getFeathrJobParam(ss, this.ENABLE_CHECKPOINT()))).toBoolean();
        return enableCheckPoint ? (currentCount = this.checkPointSequenceNumber().getAndIncrement()) % (long)(checkpoint_frequency = new StringOps(Predef$.MODULE$.augmentString(this.getFeathrJobParam(ss, this.CHECKPOINT_FREQUENCY()))).toInt()) == 0L : false;
    }

    private Logger log$lzycompute() {
        FeathrUtils$ feathrUtils$ = this;
        synchronized (feathrUtils$) {
            if (!this.bitmap$trans$0) {
                this.log = LogManager.getLogger((String)this.getClass().getName());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private FeathrUtils$() {
        MODULE$ = this;
        this.ENVIRONMENT = "offline";
        this.ENABLE_DEBUG_OUTPUT = "debug.enabled";
        this.DEBUG_FEATURE_NAMES = "debug.feature.names";
        this.DEBUG_OUTPUT_PATH = "debug.output.path";
        this.DEBUG_OUTPUT_PART_NUM = "debug.output.num.parts";
        this.FEATHR_PARAMS_PREFIX = "spark.feathr.";
        this.FAIL_ON_MISSING_PARTITION = "fail.on.missing.partition";
        this.SEQ_JOIN_ARRAY_EXPLODE_ENABLED = "seq.join.array.explode.enabled";
        this.ENABLE_SALTED_JOIN = "enable.salted.join";
        this.SKIP_MISSING_FEATURE = "skip.missing.feature";
        this.SALTED_JOIN_FREQ_ITEM_THRESHOLD = "salted.join.freq.item.threshold";
        this.SALTED_JOIN_FREQ_ITEM_ESTIMATOR = "salted.join.freq.item.estimator";
        this.SALTED_JOIN_PERSIST = "salted.join.persist";
        this.SALTED_JOIN_REPLICATION_FACTOR_HIGH = "salted.join.replication.factor.high";
        this.ENABLE_SLICK_JOIN = "enable.slickJoin";
        this.ENABLE_METRICS = "enable.metrics";
        this.ENABLE_CHECKPOINT = "enable.checkpoint";
        this.CHECKPOINT_FREQUENCY = "checkpoint.frequency";
        this.ROW_BLOOMFILTER_MAX_THRESHOLD = "row.bloomfilter.maxThreshold";
        this.SPARK_JOIN_MAX_PARALLELISM = "max.parallelism";
        this.CHECKPOINT_OUTPUT_PATH = "checkpoint.dir";
        this.SPARK_JOIN_MIN_PARALLELISM = "min.parallelism";
        this.MAX_DATA_LOAD_RETRY = "max.data.load.retry";
        this.DATA_LOAD_WAIT_IN_MS = "data.load.wait.in.ms";
        this.ENABLE_SANITY_CHECK_MODE = "enable.sanity.check.mode";
        this.SANITY_CHECK_MODE_ROW_COUNT = "sanity.check.row.count";
        this.FILTER_NULLS = "filter.nulls";
        this.STRING_PARAMETER_DELIMITER = ",";
        this.checkPointSequenceNumber = new AtomicLong(0L);
        this.sqlConfsWithDefaultParam = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_DEBUG_OUTPUT()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.ENABLE_DEBUG_OUTPUT())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DEBUG_FEATURE_NAMES()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.DEBUG_FEATURE_NAMES())).stringConf().createOptional(), (Object)"")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DEBUG_OUTPUT_PATH()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.DEBUG_OUTPUT_PATH())).stringConf().createOptional(), (Object)"/tmp/debug/feathr/output")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CHECKPOINT_OUTPUT_PATH()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.CHECKPOINT_OUTPUT_PATH())).stringConf().createOptional(), (Object)"/tmp/feathr/checkpoints")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_CHECKPOINT()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.ENABLE_CHECKPOINT())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CHECKPOINT_FREQUENCY()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.CHECKPOINT_FREQUENCY())).stringConf().createOptional(), (Object)"10")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DEBUG_OUTPUT_PART_NUM()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.DEBUG_OUTPUT_PART_NUM())).stringConf().createOptional(), (Object)"200")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FAIL_ON_MISSING_PARTITION()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.FAIL_ON_MISSING_PARTITION())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SEQ_JOIN_ARRAY_EXPLODE_ENABLED()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SEQ_JOIN_ARRAY_EXPLODE_ENABLED())).stringConf().createOptional(), (Object)"true")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_SALTED_JOIN()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.ENABLE_SALTED_JOIN())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SKIP_MISSING_FEATURE()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SKIP_MISSING_FEATURE())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MAX_DATA_LOAD_RETRY()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.MAX_DATA_LOAD_RETRY())).stringConf().createOptional(), (Object)"0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DATA_LOAD_WAIT_IN_MS()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.DATA_LOAD_WAIT_IN_MS())).stringConf().createOptional(), (Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_FREQ_ITEM_THRESHOLD()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SALTED_JOIN_FREQ_ITEM_THRESHOLD())).stringConf().createOptional(), (Object)"0.0002")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_REPLICATION_FACTOR_HIGH()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SALTED_JOIN_REPLICATION_FACTOR_HIGH())).stringConf().createOptional(), (Object)"10")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_FREQ_ITEM_ESTIMATOR()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SALTED_JOIN_FREQ_ITEM_ESTIMATOR())).stringConf().createOptional(), (Object)"spark")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_SLICK_JOIN()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.ENABLE_SLICK_JOIN())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SALTED_JOIN_PERSIST()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SALTED_JOIN_PERSIST())).stringConf().createOptional(), (Object)"true")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ROW_BLOOMFILTER_MAX_THRESHOLD()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.ROW_BLOOMFILTER_MAX_THRESHOLD())).stringConf().createOptional(), (Object)"-1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_METRICS()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.ENABLE_METRICS())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SPARK_JOIN_MAX_PARALLELISM()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SPARK_JOIN_MAX_PARALLELISM())).stringConf().createOptional(), (Object)"10000")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SPARK_JOIN_MIN_PARALLELISM()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SPARK_JOIN_MIN_PARALLELISM())).stringConf().createOptional(), (Object)"10")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ENABLE_SANITY_CHECK_MODE()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.ENABLE_SANITY_CHECK_MODE())).stringConf().createOptional(), (Object)"false")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SANITY_CHECK_MODE_ROW_COUNT()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.SANITY_CHECK_MODE_ROW_COUNT())).stringConf().createOptional(), (Object)"10")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FILTER_NULLS()), (Object)new Tuple2((Object)SQLConf$.MODULE$.buildConf(this.getFullConfigKeyName(this.FILTER_NULLS())).stringConf().createOptional(), (Object)"false"))}));
    }
}

