/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.feathr.offline.util;

import com.linkedin.feathr.offline.util.HdfsUtils$;
import com.linkedin.feathr.offline.util.HdfsUtils$TemporalPathFormats$Daily$;
import com.linkedin.feathr.offline.util.HdfsUtils$TemporalPathFormats$Hourly$;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class HdfsUtils$ {
    public static HdfsUtils$ MODULE$;
    private final Configuration conf;
    private final DateTimeFormatter dateStampFormatter;
    private final DateTimeFormatter timeStampFormatter;
    private final ZoneId pstZoneId;
    private final DateTimeFormatter dailyDirFormatter;
    private final String latestSubdirectory;
    private final String timestampIdentifier;
    private final int maxAttempts;

    static {
        new HdfsUtils$();
    }

    private Configuration conf() {
        return this.conf;
    }

    public DateTimeFormatter dateStampFormatter() {
        return this.dateStampFormatter;
    }

    public DateTimeFormatter timeStampFormatter() {
        return this.timeStampFormatter;
    }

    public ZoneId pstZoneId() {
        return this.pstZoneId;
    }

    public DateTimeFormatter dailyDirFormatter() {
        return this.dailyDirFormatter;
    }

    public String latestSubdirectory() {
        return this.latestSubdirectory;
    }

    public String timestampIdentifier() {
        return this.timestampIdentifier;
    }

    public int maxAttempts() {
        return this.maxAttempts;
    }

    public PrintStream getPrintStream(String path) {
        Path p = new Path(path);
        return new PrintStream((OutputStream)new BufferedOutputStream((OutputStream)p.getFileSystem(this.conf()).create(p)), false, "UTF-8");
    }

    public String createStringPath(Seq<String> pathParts) {
        return new File(((TraversableOnce)pathParts.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Seq$.MODULE$.canBuildFrom())).mkString("/")).toString();
    }

    private void validatePath(String inputPath, String identifier) {
        Predef$.MODULE$.require(inputPath != null, (Function0 & Serializable & scala.Serializable)() -> "The path to resolve cannot be null");
        Predef$.MODULE$.require(!inputPath.trim().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "The path to resolve cannot be empty or contain only white spaces");
        Predef$.MODULE$.require(!inputPath.startsWith(identifier), (Function0 & Serializable & scala.Serializable)() -> "The path to resolve cannot start with the identifier as the first element");
        Predef$.MODULE$.require(!inputPath.startsWith(new StringBuilder(1).append("/").append(identifier).toString()), (Function0 & Serializable & scala.Serializable)() -> "The path to resolve cannot start with the identifier as the first element");
        Predef$.MODULE$.require(!inputPath.contains(new StringBuilder(0).append(identifier).append(identifier).toString()), (Function0 & Serializable & scala.Serializable)() -> "The path to resolve cannot contain two consecutive identifiers with no characters in between");
    }

    public String getLatestPath(String inputPath, Configuration conf) {
        this.validatePath(inputPath, this.latestSubdirectory());
        String workingPath = new StringBuilder(1).append(inputPath).append("/").toString();
        String[] pathParts = workingPath.split(this.latestSubdirectory());
        ObjectRef resultPath = ObjectRef.create((Object)pathParts[0]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), pathParts.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partIdx -> {
            String x$1 = (String)resultPath$1.elem;
            Configuration x$2 = conf;
            Seq<String> x$3 = MODULE$.getSortedSubfolderPaths$default$2();
            Option latestPath = MODULE$.getSortedSubfolderPaths(x$1, x$3, x$2).headOption();
            if (!latestPath.isDefined()) {
                throw new RuntimeException(new StringBuilder(42).append((String)resultPath$1.elem).append(" does not contain any valid subdirectories").toString());
            }
            resultPath$1.elem = MODULE$.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)latestPath.get(), pathParts[partIdx]}));
        });
        return this.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)resultPath.elem}));
    }

    public Configuration getLatestPath$default$2() {
        return this.conf();
    }

    public String replaceTimestamp(String inputPath, LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatterPattern) {
        this.validatePath(inputPath, this.timestampIdentifier());
        String dateTimeString = localDateTime.format(dateTimeFormatterPattern);
        String resultPath = inputPath.replaceAll(this.timestampIdentifier(), new StringBuilder(2).append("/").append(dateTimeString).append("/").toString());
        return this.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resultPath}));
    }

    public LocalDateTime replaceTimestamp$default$2() {
        return LocalDateTime.now(ZoneOffset.UTC);
    }

    public DateTimeFormatter replaceTimestamp$default$3() {
        return this.timeStampFormatter();
    }

    public Seq<String> getPaths(String basePath, LocalDateTime startInclusive, LocalDateTime endExclusive, ChronoUnit unit) {
        DateTimeFormatter dateTimeFormatter;
        ChronoUnit chronoUnit = unit;
        if (ChronoUnit.DAYS.equals(chronoUnit)) {
            dateTimeFormatter = HdfsUtils$TemporalPathFormats$Daily$.MODULE$.formatter();
        } else if (ChronoUnit.HOURS.equals(chronoUnit)) {
            dateTimeFormatter = HdfsUtils$TemporalPathFormats$Hourly$.MODULE$.formatter();
        } else {
            throw new IllegalArgumentException(new StringBuilder(34).append("Unsupported path resolution unit: ").append(unit).toString());
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return this.getPaths(basePath, startInclusive, endExclusive, unit, formatter);
    }

    public Seq<String> getPaths(String basePath, LocalDateTime startInclusive, LocalDateTime endExclusive, ChronoUnit unit, DateTimeFormatter formatter) {
        return (Seq)this.getTemporalRange(startInclusive, endExclusive, unit).map((Function1 & Serializable & scala.Serializable)time -> MODULE$.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{basePath, formatter.format((TemporalAccessor)time)})), Seq$.MODULE$.canBuildFrom());
    }

    public String stripPrefix(String prefixedPath, String basePath) {
        if (prefixedPath.isEmpty() || basePath.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(66).append("At least one of the paths prefixedPath (").append(prefixedPath).append(") ").append("or basePath (").append(basePath).append(") is empty.").toString());
        }
        return prefixedPath.substring(new StringOps(Predef$.MODULE$.augmentString(prefixedPath)).indexOfSlice((GenSeq)Predef$.MODULE$.wrapString(basePath)));
    }

    public boolean filterPath(String path, Seq<String> excludeFilesPrefixList) {
        String lastComponent = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).last();
        return excludeFilesPrefixList.exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)lastComponent.startsWith(prefix)));
    }

    public Seq<String> filterPath$default$2() {
        return new .colon.colon((Object)".", (List)new .colon.colon((Object)"_", (List)Nil$.MODULE$));
    }

    public Seq<String> listFiles(String path, boolean recursive, Seq<String> excludeFilesPrefixList, Configuration conf) {
        RemoteIterator iter = FileSystem.get((Configuration)conf).listFiles(new Path(path), recursive);
        return this.traverseIterator$1(path, iter, List$.MODULE$.empty(), conf, excludeFilesPrefixList);
    }

    public boolean listFiles$default$2() {
        return true;
    }

    public Seq<String> listFiles$default$3() {
        return new .colon.colon((Object)".", (List)new .colon.colon((Object)"_", (List)Nil$.MODULE$));
    }

    public Configuration listFiles$default$4() {
        return this.conf();
    }

    public Seq<String> getAllFilesOfGivenType(String path, String fileType, boolean recursive, boolean errorOnMissingFiles, Seq<String> excludeFilesPrefixList, Configuration conf) {
        Seq files = (Seq)this.listFiles(path, recursive, excludeFilesPrefixList, conf).filter((Function1 & Serializable & scala.Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.filterFileName$1(fileName, fileType)));
        if (errorOnMissingFiles && files.isEmpty()) {
            throw new FileNotFoundException(new StringBuilder(44).append("There are no files of type ").append(fileType).append(" under the path ").append(path).append(".").toString());
        }
        return files;
    }

    public String getAllFilesOfGivenType$default$2() {
        return "";
    }

    public boolean getAllFilesOfGivenType$default$3() {
        return true;
    }

    public boolean getAllFilesOfGivenType$default$4() {
        return true;
    }

    public Seq<String> getAllFilesOfGivenType$default$5() {
        return new .colon.colon((Object)".", (List)new .colon.colon((Object)"_", (List)Nil$.MODULE$));
    }

    public Configuration getAllFilesOfGivenType$default$6() {
        return this.conf();
    }

    private Seq<LocalDateTime> getTemporalRange(LocalDateTime startInclusive, LocalDateTime endExclusive, ChronoUnit unit) {
        LocalDateTime localDateTime = startInclusive.truncatedTo(unit);
        LocalDateTime localDateTime2 = startInclusive;
        if (localDateTime == null ? localDateTime2 != null : !((Object)localDateTime).equals(localDateTime2)) {
            throw new IllegalArgumentException(new StringBuilder(79).append("Invalid argument: The startInclusive (").append(startInclusive).append("}) ").append("should be at the boundary of unit (").append(unit).append("}).").toString());
        }
        LocalDateTime localDateTime3 = endExclusive.truncatedTo(unit);
        LocalDateTime localDateTime4 = endExclusive;
        if (localDateTime3 == null ? localDateTime4 != null : !((Object)localDateTime3).equals(localDateTime4)) {
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid argument: The endExclusive (").append(endExclusive).append("}) ").append("should be at the boundary of unit (").append(unit).append("}).").toString());
        }
        if (!endExclusive.isAfter(startInclusive)) {
            throw new IllegalArgumentException(new StringBuilder(76).append("Invalid arguments: The startInclusive (").append(startInclusive).append("}) ").append("should be before endExclusive (").append(endExclusive).append("}).").toString());
        }
        IndexedSeq temporalRange = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)unit.between(startInclusive, endExclusive)).map((Function1 & Serializable & scala.Serializable)step -> startInclusive.plus(BoxesRunTime.unboxToInt((Object)step), unit), IndexedSeq$.MODULE$.canBuildFrom());
        if (temporalRange.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(47).append("Invalid config: The temporalRange (").append(temporalRange).append("}) ").append("is empty.").toString());
        }
        if (((SeqLike)temporalRange.distinct()).length() != temporalRange.length()) {
            throw new IllegalArgumentException(new StringBuilder(59).append("Invalid config: The temporalRange (").append(temporalRange).append("}) ").append("has duplicate values.").toString());
        }
        return temporalRange;
    }

    public String createDailyOutputPath(String outputPath, LocalDateTime localDateTime) {
        return this.appendDateFormatted(outputPath, this.dailyDirFormatter(), localDateTime);
    }

    public LocalDateTime createDailyOutputPath$default$2() {
        return LocalDateTime.now();
    }

    public String createLatestOutputPath(String outputPath, LocalDateTime localDateTime) {
        return this.appendDateFormatted(outputPath, this.timeStampFormatter(), localDateTime);
    }

    public LocalDateTime createLatestOutputPath$default$2() {
        return LocalDateTime.now();
    }

    public String appendDateFormatted(String outputPath, DateTimeFormatter dateTimeFormatter, LocalDateTime localDateTime) {
        String dateFormattedExtension = dateTimeFormatter.format(localDateTime);
        return this.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{outputPath, dateFormattedExtension}));
    }

    public void deleteOlderPaths(String basePath, int maxPathsToKeep, Configuration conf) {
        Predef$.MODULE$.require(maxPathsToKeep > 0, (Function0 & Serializable & scala.Serializable)() -> "maxPathToKeep must be greater than 0");
        Seq<String> dirs = this.getSortedSubfolderPaths(basePath, this.getSortedSubfolderPaths$default$2(), this.getSortedSubfolderPaths$default$3());
        ((IterableLike)dirs.drop(maxPathsToKeep)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.MODULE$.deletePath(x$3, HdfsUtils$.MODULE$.deletePath$default$2(), HdfsUtils$.MODULE$.deletePath$default$3())));
    }

    public Configuration deleteOlderPaths$default$3() {
        return this.conf();
    }

    private Seq<String> getSortedSubfolderPaths(String basePath, Seq<String> excludeDirsPrefixList, Configuration conf) {
        FileSystem fs = FileSystem.get((Configuration)conf);
        WrappedArray directories = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(basePath)))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)dirName -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.$anonfun$getSortedSubfolderPaths$3(excludeDirsPrefixList, dirName))))).map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{basePath, x$6})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$))).reverse());
        return directories;
    }

    private Seq<String> getSortedSubfolderPaths$default$2() {
        return new .colon.colon((Object)".", (List)new .colon.colon((Object)"_", (List)Nil$.MODULE$));
    }

    private Configuration getSortedSubfolderPaths$default$3() {
        return this.conf();
    }

    public boolean deletePath(String path, boolean recursive, Configuration conf) {
        return FileSystem.get((Configuration)conf).delete(new Path(path), recursive);
    }

    public boolean deletePath$default$2() {
        return true;
    }

    public Configuration deletePath$default$3() {
        return this.conf();
    }

    public boolean renamePath(String src, String dst, Configuration conf) {
        return FileSystem.get((Configuration)conf).rename(new Path(src), new Path(dst));
    }

    public Configuration renamePath$default$3() {
        return this.conf();
    }

    public boolean exists(String path, Configuration conf) {
        return FileSystem.get((Configuration)conf).exists(new Path(path));
    }

    public Configuration exists$default$2() {
        return this.conf();
    }

    public String[] hdfsSubdir(String inputPath, Seq<String> excludePathsPrefixList, Configuration conf) {
        PathFilter filter = new PathFilter(excludePathsPrefixList){
            private final Seq excludePathsPrefixList$1;

            public boolean accept(Path path) {
                return !this.excludePathsPrefixList$1.exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$accept$1(path, prefix)));
            }

            public static final /* synthetic */ boolean $anonfun$accept$1(Path path$1, String prefix) {
                return path$1.getName().startsWith(prefix);
            }
            {
                this.excludePathsPrefixList$1 = excludePathsPrefixList$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1$adapted(org.apache.hadoop.fs.Path java.lang.String )}, serializedLambda);
            }
        };
        FileSystem fs = FileSystem.get((Configuration)conf);
        String[] subDirs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(inputPath), filter))).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subDirs)).nonEmpty() ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subDirs)).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HdfsUtils$.MODULE$.hdfsSubdir(new StringBuilder(0).append(inputPath).append('/').append(dir).toString(), (Seq<String>)excludePathsPrefixList, conf))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])((Object[])new String[]{inputPath});
    }

    public Seq<String> hdfsSubdir$default$2() {
        return new .colon.colon((Object)".", (List)new .colon.colon((Object)"_", (List)Nil$.MODULE$));
    }

    public Configuration hdfsSubdir$default$3() {
        return this.conf();
    }

    public boolean nonEmpty(String inputPath, Configuration conf) {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path path = new Path(inputPath);
        if (!this.exists(inputPath, this.exists$default$2())) {
            return false;
        }
        return fs.getFileStatus(path).isDirectory() ? fs.listStatus(path).length > 0 : fs.getFileStatus(path).getLen() > 0L;
    }

    public Configuration nonEmpty$default$2() {
        return this.conf();
    }

    public void hdfsCreateDirectoriesAsNeeded(String dir, Configuration conf) {
        block0: {
            Path path;
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (fs.exists(path = new Path(dir))) break block0;
            fs.mkdirs(path);
        }
    }

    public Configuration hdfsCreateDirectoriesAsNeeded$default$2() {
        return this.conf();
    }

    public Option<String> hdfsCreateTempFile(String User, String tempDir, String prefix, String suffix, int attempts, Configuration conf) {
        None$ none$;
        String usePrefix = new StringOps(Predef$.MODULE$.augmentString(prefix)).nonEmpty() ? prefix : "file";
        String useSuffix = new StringOps(Predef$.MODULE$.augmentString(suffix)).nonEmpty() ? suffix : "tmp";
        FileSystem fs = FileSystem.get((Configuration)conf);
        Range availableFiles = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), attempts).dropWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)index -> {
            String tempFileName = HdfsUtils$.getTempFileName$1(index, User, usePrefix, useSuffix);
            Path path = new Path(MODULE$.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tempDir, tempFileName})));
            return fs.exists(path) || !fs.createNewFile(path);
        });
        if (availableFiles.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String tempFileName = HdfsUtils$.getTempFileName$1(availableFiles.head(), User, usePrefix, useSuffix);
            String tempFilePath = this.createStringPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tempDir, tempFileName}));
            fs.deleteOnExit(new Path(tempFilePath));
            none$ = new Some((Object)tempFilePath);
        }
        return none$;
    }

    public int hdfsCreateTempFile$default$5() {
        return this.maxAttempts();
    }

    public Configuration hdfsCreateTempFile$default$6() {
        return this.conf();
    }

    public Option<InputStream> hdfsConvertIteratorToInputStream(String User, String tempDirPrefix, Iterator<String> iter, int attempts, Configuration conf) {
        None$ none$;
        Option<String> tempPathOpt = this.hdfsCreateTempFile(User, tempDirPrefix, "iter", "tmp", attempts, this.hdfsCreateTempFile$default$6());
        Option<String> option = tempPathOpt;
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String tempPath = (String)some.value();
            PrintStream printStream = this.getPrintStream(tempPath);
            iter.foreach((Function1 & Serializable & scala.Serializable)s -> {
                printStream.println(s);
                return BoxedUnit.UNIT;
            });
            printStream.close();
            none$ = new Some((Object)FileSystem.get((Configuration)conf).open(new Path(tempPath)));
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public int hdfsConvertIteratorToInputStream$default$4() {
        return this.maxAttempts();
    }

    public Configuration hdfsConvertIteratorToInputStream$default$5() {
        return this.conf();
    }

    public void setupLoggerForHDFS(Configuration conf, Logger logger, String path) {
        PatternLayout simpleLogLayout = new PatternLayout("%m%n");
        FSDataOutputStream logStream = FileSystem.get((Configuration)conf).create(new Path(path), true);
        WriterAppender hdfsWriter = new WriterAppender((Layout)simpleLogLayout, (Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)logStream)));
        logger.addAppender((Appender)hdfsWriter);
    }

    private final Seq traverseIterator$1(String path, RemoteIterator iter, List accumulator, Configuration conf, Seq excludeFilesPrefixList$1) {
        while (iter.hasNext()) {
            Path file = ((FileStatus)iter.next()).getPath();
            if (this.filterPath(file.toString(), (Seq<String>)excludeFilesPrefixList$1)) continue;
            String string = this.stripPrefix(file.toString(), path);
            accumulator = accumulator.$colon$colon((Object)string);
        }
        return accumulator;
    }

    private static final Configuration traverseIterator$default$4$1(Configuration conf$2) {
        return conf$2;
    }

    private static final boolean filterFileName$1(String fileName, String fileType$1) {
        String lastComponent = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileName.split("/"))).last();
        return fileName.endsWith(fileType$1);
    }

    public static final /* synthetic */ boolean $anonfun$getSortedSubfolderPaths$3(Seq excludeDirsPrefixList$1, String dirName) {
        return !excludeDirsPrefixList$1.exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)dirName.startsWith(prefix)));
    }

    private static final String getTempFileName$1(int index, String User$1, String usePrefix$1, String useSuffix$1) {
        return new StringBuilder(3).append(User$1).append("-").append(usePrefix$1).append("-").append(index).append(".").append(useSuffix$1).toString();
    }

    private HdfsUtils$() {
        MODULE$ = this;
        this.conf = new Configuration();
        this.dateStampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        this.timeStampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm");
        this.pstZoneId = ZoneId.of("America/Los_Angeles");
        this.dailyDirFormatter = DateTimeFormatter.ofPattern("'daily'/yyyy/MM/dd");
        this.latestSubdirectory = "#LATEST";
        this.timestampIdentifier = "#TIMESTAMP";
        this.maxAttempts = 3;
    }
}

